# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudsearch_service.R
NULL

#' Indexes the search suggestions
#'
#' Indexes the search suggestions. For more information, see [Configuring
#' Suggesters](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html#configuring-suggesters)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_build_suggesters(DomainName)
#'
#' @param DomainName &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$build_suggesters(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_build_suggesters
cloudsearch_build_suggesters <- function(DomainName) {
  op <- new_operation(
    name = "BuildSuggesters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$build_suggesters_input(DomainName = DomainName)
  output <- .cloudsearch$build_suggesters_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$build_suggesters <- cloudsearch_build_suggesters

#' Creates a new search domain
#'
#' Creates a new search domain. For more information, see [Creating a
#' Search
#' Domain](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_create_domain(DomainName)
#'
#' @param DomainName &#91;required&#93; A name for the domain you are creating. Allowed characters are a-z
#' (lower-case letters), 0-9, and hyphen (-). Domain names must start with
#' a letter or number and be at least 3 and no more than 28 characters
#' long.
#'
#' @section Request syntax:
#' ```
#' svc$create_domain(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_create_domain
cloudsearch_create_domain <- function(DomainName) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$create_domain_input(DomainName = DomainName)
  output <- .cloudsearch$create_domain_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$create_domain <- cloudsearch_create_domain

#' Configures an analysis scheme that can be applied to a text or
#' text-array field to define language-specific text processing options
#'
#' Configures an analysis scheme that can be applied to a `text` or
#' `text-array` field to define language-specific text processing options.
#' For more information, see [Configuring Analysis
#' Schemes](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_define_analysis_scheme(DomainName, AnalysisScheme)
#'
#' @param DomainName &#91;required&#93; 
#' @param AnalysisScheme &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$define_analysis_scheme(
#'   DomainName = "string",
#'   AnalysisScheme = list(
#'     AnalysisSchemeName = "string",
#'     AnalysisSchemeLanguage = "ar"|"bg"|"ca"|"cs"|"da"|"de"|"el"|"en"|"es"|"eu"|"fa"|"fi"|"fr"|"ga"|"gl"|"he"|"hi"|"hu"|"hy"|"id"|"it"|"ja"|"ko"|"lv"|"mul"|"nl"|"no"|"pt"|"ro"|"ru"|"sv"|"th"|"tr"|"zh-Hans"|"zh-Hant",
#'     AnalysisOptions = list(
#'       Synonyms = "string",
#'       Stopwords = "string",
#'       StemmingDictionary = "string",
#'       JapaneseTokenizationDictionary = "string",
#'       AlgorithmicStemming = "none"|"minimal"|"light"|"full"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_define_analysis_scheme
cloudsearch_define_analysis_scheme <- function(DomainName, AnalysisScheme) {
  op <- new_operation(
    name = "DefineAnalysisScheme",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$define_analysis_scheme_input(DomainName = DomainName, AnalysisScheme = AnalysisScheme)
  output <- .cloudsearch$define_analysis_scheme_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$define_analysis_scheme <- cloudsearch_define_analysis_scheme

#' Configures an Expression for the search domain
#'
#' Configures an `<a>Expression</a>` for the search domain. Used to create
#' new expressions and modify existing ones. If the expression exists, the
#' new configuration replaces the old one. For more information, see
#' [Configuring
#' Expressions](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_define_expression(DomainName, Expression)
#'
#' @param DomainName &#91;required&#93; 
#' @param Expression &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$define_expression(
#'   DomainName = "string",
#'   Expression = list(
#'     ExpressionName = "string",
#'     ExpressionValue = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_define_expression
cloudsearch_define_expression <- function(DomainName, Expression) {
  op <- new_operation(
    name = "DefineExpression",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$define_expression_input(DomainName = DomainName, Expression = Expression)
  output <- .cloudsearch$define_expression_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$define_expression <- cloudsearch_define_expression

#' Configures an IndexField for the search domain
#'
#' Configures an `<a>IndexField</a>` for the search domain. Used to create
#' new fields and modify existing ones. You must specify the name of the
#' domain you are configuring and an index field configuration. The index
#' field configuration specifies a unique name, the index field type, and
#' the options you want to configure for the field. The options you can
#' specify depend on the `<a>IndexFieldType</a>`. If the field exists, the
#' new configuration replaces the old one. For more information, see
#' [Configuring Index
#' Fields](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_define_index_field(DomainName, IndexField)
#'
#' @param DomainName &#91;required&#93; 
#' @param IndexField &#91;required&#93; The index field and field options you want to configure.
#'
#' @section Request syntax:
#' ```
#' svc$define_index_field(
#'   DomainName = "string",
#'   IndexField = list(
#'     IndexFieldName = "string",
#'     IndexFieldType = "int"|"double"|"literal"|"text"|"date"|"latlon"|"int-array"|"double-array"|"literal-array"|"text-array"|"date-array",
#'     IntOptions = list(
#'       DefaultValue = 123,
#'       SourceField = "string",
#'       FacetEnabled = TRUE|FALSE,
#'       SearchEnabled = TRUE|FALSE,
#'       ReturnEnabled = TRUE|FALSE,
#'       SortEnabled = TRUE|FALSE
#'     ),
#'     DoubleOptions = list(
#'       DefaultValue = 123.0,
#'       SourceField = "string",
#'       FacetEnabled = TRUE|FALSE,
#'       SearchEnabled = TRUE|FALSE,
#'       ReturnEnabled = TRUE|FALSE,
#'       SortEnabled = TRUE|FALSE
#'     ),
#'     LiteralOptions = list(
#'       DefaultValue = "string",
#'       SourceField = "string",
#'       FacetEnabled = TRUE|FALSE,
#'       SearchEnabled = TRUE|FALSE,
#'       ReturnEnabled = TRUE|FALSE,
#'       SortEnabled = TRUE|FALSE
#'     ),
#'     TextOptions = list(
#'       DefaultValue = "string",
#'       SourceField = "string",
#'       ReturnEnabled = TRUE|FALSE,
#'       SortEnabled = TRUE|FALSE,
#'       HighlightEnabled = TRUE|FALSE,
#'       AnalysisScheme = "string"
#'     ),
#'     DateOptions = list(
#'       DefaultValue = "string",
#'       SourceField = "string",
#'       FacetEnabled = TRUE|FALSE,
#'       SearchEnabled = TRUE|FALSE,
#'       ReturnEnabled = TRUE|FALSE,
#'       SortEnabled = TRUE|FALSE
#'     ),
#'     LatLonOptions = list(
#'       DefaultValue = "string",
#'       SourceField = "string",
#'       FacetEnabled = TRUE|FALSE,
#'       SearchEnabled = TRUE|FALSE,
#'       ReturnEnabled = TRUE|FALSE,
#'       SortEnabled = TRUE|FALSE
#'     ),
#'     IntArrayOptions = list(
#'       DefaultValue = 123,
#'       SourceFields = "string",
#'       FacetEnabled = TRUE|FALSE,
#'       SearchEnabled = TRUE|FALSE,
#'       ReturnEnabled = TRUE|FALSE
#'     ),
#'     DoubleArrayOptions = list(
#'       DefaultValue = 123.0,
#'       SourceFields = "string",
#'       FacetEnabled = TRUE|FALSE,
#'       SearchEnabled = TRUE|FALSE,
#'       ReturnEnabled = TRUE|FALSE
#'     ),
#'     LiteralArrayOptions = list(
#'       DefaultValue = "string",
#'       SourceFields = "string",
#'       FacetEnabled = TRUE|FALSE,
#'       SearchEnabled = TRUE|FALSE,
#'       ReturnEnabled = TRUE|FALSE
#'     ),
#'     TextArrayOptions = list(
#'       DefaultValue = "string",
#'       SourceFields = "string",
#'       ReturnEnabled = TRUE|FALSE,
#'       HighlightEnabled = TRUE|FALSE,
#'       AnalysisScheme = "string"
#'     ),
#'     DateArrayOptions = list(
#'       DefaultValue = "string",
#'       SourceFields = "string",
#'       FacetEnabled = TRUE|FALSE,
#'       SearchEnabled = TRUE|FALSE,
#'       ReturnEnabled = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_define_index_field
cloudsearch_define_index_field <- function(DomainName, IndexField) {
  op <- new_operation(
    name = "DefineIndexField",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$define_index_field_input(DomainName = DomainName, IndexField = IndexField)
  output <- .cloudsearch$define_index_field_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$define_index_field <- cloudsearch_define_index_field

#' Configures a suggester for a domain
#'
#' Configures a suggester for a domain. A suggester enables you to display
#' possible matches before users finish typing their queries. When you
#' configure a suggester, you must specify the name of the text field you
#' want to search for possible matches and a unique name for the suggester.
#' For more information, see [Getting Search
#' Suggestions](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_define_suggester(DomainName, Suggester)
#'
#' @param DomainName &#91;required&#93; 
#' @param Suggester &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$define_suggester(
#'   DomainName = "string",
#'   Suggester = list(
#'     SuggesterName = "string",
#'     DocumentSuggesterOptions = list(
#'       SourceField = "string",
#'       FuzzyMatching = "none"|"low"|"high",
#'       SortExpression = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_define_suggester
cloudsearch_define_suggester <- function(DomainName, Suggester) {
  op <- new_operation(
    name = "DefineSuggester",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$define_suggester_input(DomainName = DomainName, Suggester = Suggester)
  output <- .cloudsearch$define_suggester_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$define_suggester <- cloudsearch_define_suggester

#' Deletes an analysis scheme
#'
#' Deletes an analysis scheme. For more information, see [Configuring
#' Analysis
#' Schemes](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_delete_analysis_scheme(DomainName, AnalysisSchemeName)
#'
#' @param DomainName &#91;required&#93; 
#' @param AnalysisSchemeName &#91;required&#93; The name of the analysis scheme you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_analysis_scheme(
#'   DomainName = "string",
#'   AnalysisSchemeName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_delete_analysis_scheme
cloudsearch_delete_analysis_scheme <- function(DomainName, AnalysisSchemeName) {
  op <- new_operation(
    name = "DeleteAnalysisScheme",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$delete_analysis_scheme_input(DomainName = DomainName, AnalysisSchemeName = AnalysisSchemeName)
  output <- .cloudsearch$delete_analysis_scheme_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$delete_analysis_scheme <- cloudsearch_delete_analysis_scheme

#' Permanently deletes a search domain and all of its data
#'
#' Permanently deletes a search domain and all of its data. Once a domain
#' has been deleted, it cannot be recovered. For more information, see
#' [Deleting a Search
#' Domain](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_delete_domain(DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the domain you want to permanently delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_domain(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_delete_domain
cloudsearch_delete_domain <- function(DomainName) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$delete_domain_input(DomainName = DomainName)
  output <- .cloudsearch$delete_domain_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$delete_domain <- cloudsearch_delete_domain

#' Removes an Expression from the search domain
#'
#' Removes an `<a>Expression</a>` from the search domain. For more
#' information, see [Configuring
#' Expressions](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_delete_expression(DomainName, ExpressionName)
#'
#' @param DomainName &#91;required&#93; 
#' @param ExpressionName &#91;required&#93; The name of the `<a>Expression</a>` to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_expression(
#'   DomainName = "string",
#'   ExpressionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_delete_expression
cloudsearch_delete_expression <- function(DomainName, ExpressionName) {
  op <- new_operation(
    name = "DeleteExpression",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$delete_expression_input(DomainName = DomainName, ExpressionName = ExpressionName)
  output <- .cloudsearch$delete_expression_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$delete_expression <- cloudsearch_delete_expression

#' Removes an IndexField from the search domain
#'
#' Removes an `<a>IndexField</a>` from the search domain. For more
#' information, see [Configuring Index
#' Fields](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_delete_index_field(DomainName, IndexFieldName)
#'
#' @param DomainName &#91;required&#93; 
#' @param IndexFieldName &#91;required&#93; The name of the index field your want to remove from the domain\'s
#' indexing options.
#'
#' @section Request syntax:
#' ```
#' svc$delete_index_field(
#'   DomainName = "string",
#'   IndexFieldName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_delete_index_field
cloudsearch_delete_index_field <- function(DomainName, IndexFieldName) {
  op <- new_operation(
    name = "DeleteIndexField",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$delete_index_field_input(DomainName = DomainName, IndexFieldName = IndexFieldName)
  output <- .cloudsearch$delete_index_field_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$delete_index_field <- cloudsearch_delete_index_field

#' Deletes a suggester
#'
#' Deletes a suggester. For more information, see [Getting Search
#' Suggestions](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_delete_suggester(DomainName, SuggesterName)
#'
#' @param DomainName &#91;required&#93; 
#' @param SuggesterName &#91;required&#93; Specifies the name of the suggester you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_suggester(
#'   DomainName = "string",
#'   SuggesterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_delete_suggester
cloudsearch_delete_suggester <- function(DomainName, SuggesterName) {
  op <- new_operation(
    name = "DeleteSuggester",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$delete_suggester_input(DomainName = DomainName, SuggesterName = SuggesterName)
  output <- .cloudsearch$delete_suggester_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$delete_suggester <- cloudsearch_delete_suggester

#' Gets the analysis schemes configured for a domain
#'
#' Gets the analysis schemes configured for a domain. An analysis scheme
#' defines language-specific text processing options for a `text` field.
#' Can be limited to specific analysis schemes by name. By default, shows
#' all analysis schemes and includes any pending changes to the
#' configuration. Set the `Deployed` option to `true` to show the active
#' configuration and exclude pending changes. For more information, see
#' [Configuring Analysis
#' Schemes](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_describe_analysis_schemes(DomainName, AnalysisSchemeNames,
#'   Deployed)
#'
#' @param DomainName &#91;required&#93; The name of the domain you want to describe.
#' @param AnalysisSchemeNames The analysis schemes you want to describe.
#' @param Deployed Whether to display the deployed configuration (`true`) or include any
#' pending changes (`false`). Defaults to `false`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_analysis_schemes(
#'   DomainName = "string",
#'   AnalysisSchemeNames = list(
#'     "string"
#'   ),
#'   Deployed = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_describe_analysis_schemes
cloudsearch_describe_analysis_schemes <- function(DomainName, AnalysisSchemeNames = NULL, Deployed = NULL) {
  op <- new_operation(
    name = "DescribeAnalysisSchemes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$describe_analysis_schemes_input(DomainName = DomainName, AnalysisSchemeNames = AnalysisSchemeNames, Deployed = Deployed)
  output <- .cloudsearch$describe_analysis_schemes_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$describe_analysis_schemes <- cloudsearch_describe_analysis_schemes

#' Gets the availability options configured for a domain
#'
#' Gets the availability options configured for a domain. By default, shows
#' the configuration with any pending changes. Set the `Deployed` option to
#' `true` to show the active configuration and exclude pending changes. For
#' more information, see [Configuring Availability
#' Options](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_describe_availability_options(DomainName, Deployed)
#'
#' @param DomainName &#91;required&#93; The name of the domain you want to describe.
#' @param Deployed Whether to display the deployed configuration (`true`) or include any
#' pending changes (`false`). Defaults to `false`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_availability_options(
#'   DomainName = "string",
#'   Deployed = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_describe_availability_options
cloudsearch_describe_availability_options <- function(DomainName, Deployed = NULL) {
  op <- new_operation(
    name = "DescribeAvailabilityOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$describe_availability_options_input(DomainName = DomainName, Deployed = Deployed)
  output <- .cloudsearch$describe_availability_options_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$describe_availability_options <- cloudsearch_describe_availability_options

#' Gets information about the search domains owned by this account
#'
#' Gets information about the search domains owned by this account. Can be
#' limited to specific domains. Shows all domains by default. To get the
#' number of searchable documents in a domain, use the console or submit a
#' `matchall` request to your domain\'s search endpoint:
#' `q=matchall&amp;amp;q.parser=structured&amp;amp;size=0`. For more
#' information, see [Getting Information about a Search
#' Domain](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_describe_domains(DomainNames)
#'
#' @param DomainNames The names of the domains you want to include in the response.
#'
#' @section Request syntax:
#' ```
#' svc$describe_domains(
#'   DomainNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_describe_domains
cloudsearch_describe_domains <- function(DomainNames = NULL) {
  op <- new_operation(
    name = "DescribeDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$describe_domains_input(DomainNames = DomainNames)
  output <- .cloudsearch$describe_domains_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$describe_domains <- cloudsearch_describe_domains

#' Gets the expressions configured for the search domain
#'
#' Gets the expressions configured for the search domain. Can be limited to
#' specific expressions by name. By default, shows all expressions and
#' includes any pending changes to the configuration. Set the `Deployed`
#' option to `true` to show the active configuration and exclude pending
#' changes. For more information, see [Configuring
#' Expressions](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_describe_expressions(DomainName, ExpressionNames, Deployed)
#'
#' @param DomainName &#91;required&#93; The name of the domain you want to describe.
#' @param ExpressionNames Limits the `<a>DescribeExpressions</a>` response to the specified
#' expressions. If not specified, all expressions are shown.
#' @param Deployed Whether to display the deployed configuration (`true`) or include any
#' pending changes (`false`). Defaults to `false`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_expressions(
#'   DomainName = "string",
#'   ExpressionNames = list(
#'     "string"
#'   ),
#'   Deployed = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_describe_expressions
cloudsearch_describe_expressions <- function(DomainName, ExpressionNames = NULL, Deployed = NULL) {
  op <- new_operation(
    name = "DescribeExpressions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$describe_expressions_input(DomainName = DomainName, ExpressionNames = ExpressionNames, Deployed = Deployed)
  output <- .cloudsearch$describe_expressions_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$describe_expressions <- cloudsearch_describe_expressions

#' Gets information about the index fields configured for the search domain
#'
#' Gets information about the index fields configured for the search
#' domain. Can be limited to specific fields by name. By default, shows all
#' fields and includes any pending changes to the configuration. Set the
#' `Deployed` option to `true` to show the active configuration and exclude
#' pending changes. For more information, see [Getting Domain
#' Information](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_describe_index_fields(DomainName, FieldNames, Deployed)
#'
#' @param DomainName &#91;required&#93; The name of the domain you want to describe.
#' @param FieldNames A list of the index fields you want to describe. If not specified,
#' information is returned for all configured index fields.
#' @param Deployed Whether to display the deployed configuration (`true`) or include any
#' pending changes (`false`). Defaults to `false`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_index_fields(
#'   DomainName = "string",
#'   FieldNames = list(
#'     "string"
#'   ),
#'   Deployed = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_describe_index_fields
cloudsearch_describe_index_fields <- function(DomainName, FieldNames = NULL, Deployed = NULL) {
  op <- new_operation(
    name = "DescribeIndexFields",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$describe_index_fields_input(DomainName = DomainName, FieldNames = FieldNames, Deployed = Deployed)
  output <- .cloudsearch$describe_index_fields_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$describe_index_fields <- cloudsearch_describe_index_fields

#' Gets the scaling parameters configured for a domain
#'
#' Gets the scaling parameters configured for a domain. A domain\'s scaling
#' parameters specify the desired search instance type and replication
#' count. For more information, see [Configuring Scaling
#' Options](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_describe_scaling_parameters(DomainName)
#'
#' @param DomainName &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$describe_scaling_parameters(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_describe_scaling_parameters
cloudsearch_describe_scaling_parameters <- function(DomainName) {
  op <- new_operation(
    name = "DescribeScalingParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$describe_scaling_parameters_input(DomainName = DomainName)
  output <- .cloudsearch$describe_scaling_parameters_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$describe_scaling_parameters <- cloudsearch_describe_scaling_parameters

#' Gets information about the access policies that control access to the
#' domain's document and search endpoints
#'
#' Gets information about the access policies that control access to the
#' domain\'s document and search endpoints. By default, shows the
#' configuration with any pending changes. Set the `Deployed` option to
#' `true` to show the active configuration and exclude pending changes. For
#' more information, see [Configuring Access for a Search
#' Domain](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_describe_service_access_policies(DomainName, Deployed)
#'
#' @param DomainName &#91;required&#93; The name of the domain you want to describe.
#' @param Deployed Whether to display the deployed configuration (`true`) or include any
#' pending changes (`false`). Defaults to `false`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_service_access_policies(
#'   DomainName = "string",
#'   Deployed = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_describe_service_access_policies
cloudsearch_describe_service_access_policies <- function(DomainName, Deployed = NULL) {
  op <- new_operation(
    name = "DescribeServiceAccessPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$describe_service_access_policies_input(DomainName = DomainName, Deployed = Deployed)
  output <- .cloudsearch$describe_service_access_policies_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$describe_service_access_policies <- cloudsearch_describe_service_access_policies

#' Gets the suggesters configured for a domain
#'
#' Gets the suggesters configured for a domain. A suggester enables you to
#' display possible matches before users finish typing their queries. Can
#' be limited to specific suggesters by name. By default, shows all
#' suggesters and includes any pending changes to the configuration. Set
#' the `Deployed` option to `true` to show the active configuration and
#' exclude pending changes. For more information, see [Getting Search
#' Suggestions](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_describe_suggesters(DomainName, SuggesterNames, Deployed)
#'
#' @param DomainName &#91;required&#93; The name of the domain you want to describe.
#' @param SuggesterNames The suggesters you want to describe.
#' @param Deployed Whether to display the deployed configuration (`true`) or include any
#' pending changes (`false`). Defaults to `false`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_suggesters(
#'   DomainName = "string",
#'   SuggesterNames = list(
#'     "string"
#'   ),
#'   Deployed = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_describe_suggesters
cloudsearch_describe_suggesters <- function(DomainName, SuggesterNames = NULL, Deployed = NULL) {
  op <- new_operation(
    name = "DescribeSuggesters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$describe_suggesters_input(DomainName = DomainName, SuggesterNames = SuggesterNames, Deployed = Deployed)
  output <- .cloudsearch$describe_suggesters_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$describe_suggesters <- cloudsearch_describe_suggesters

#' Tells the search domain to start indexing its documents using the latest
#' indexing options
#'
#' Tells the search domain to start indexing its documents using the latest
#' indexing options. This operation must be invoked to activate options
#' whose OptionStatus is `RequiresIndexDocuments`.
#'
#' @usage
#' cloudsearch_index_documents(DomainName)
#'
#' @param DomainName &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$index_documents(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_index_documents
cloudsearch_index_documents <- function(DomainName) {
  op <- new_operation(
    name = "IndexDocuments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$index_documents_input(DomainName = DomainName)
  output <- .cloudsearch$index_documents_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$index_documents <- cloudsearch_index_documents

#' Lists all search domains owned by an account
#'
#' Lists all search domains owned by an account.
#'
#' @usage
#' cloudsearch_list_domain_names()
#'

#'

#'
#' @keywords internal
#'
#' @rdname cloudsearch_list_domain_names
cloudsearch_list_domain_names <- function() {
  op <- new_operation(
    name = "ListDomainNames",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$list_domain_names_input()
  output <- .cloudsearch$list_domain_names_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$list_domain_names <- cloudsearch_list_domain_names

#' Configures the availability options for a domain
#'
#' Configures the availability options for a domain. Enabling the Multi-AZ
#' option expands an Amazon CloudSearch domain to an additional
#' Availability Zone in the same Region to increase fault tolerance in the
#' event of a service disruption. Changes to the Multi-AZ option can take
#' about half an hour to become active. For more information, see
#' [Configuring Availability
#' Options](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_update_availability_options(DomainName, MultiAZ)
#'
#' @param DomainName &#91;required&#93; 
#' @param MultiAZ &#91;required&#93; You expand an existing search domain to a second Availability Zone by
#' setting the Multi-AZ option to true. Similarly, you can turn off the
#' Multi-AZ option to downgrade the domain to a single Availability Zone by
#' setting the Multi-AZ option to `false`.
#'
#' @section Request syntax:
#' ```
#' svc$update_availability_options(
#'   DomainName = "string",
#'   MultiAZ = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_update_availability_options
cloudsearch_update_availability_options <- function(DomainName, MultiAZ) {
  op <- new_operation(
    name = "UpdateAvailabilityOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$update_availability_options_input(DomainName = DomainName, MultiAZ = MultiAZ)
  output <- .cloudsearch$update_availability_options_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$update_availability_options <- cloudsearch_update_availability_options

#' Configures scaling parameters for a domain
#'
#' Configures scaling parameters for a domain. A domain\'s scaling
#' parameters specify the desired search instance type and replication
#' count. Amazon CloudSearch will still automatically scale your domain
#' based on the volume of data and traffic, but not below the desired
#' instance type and replication count. If the Multi-AZ option is enabled,
#' these values control the resources used per Availability Zone. For more
#' information, see [Configuring Scaling
#' Options](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html)
#' in the *Amazon CloudSearch Developer Guide*.
#'
#' @usage
#' cloudsearch_update_scaling_parameters(DomainName, ScalingParameters)
#'
#' @param DomainName &#91;required&#93; 
#' @param ScalingParameters &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_scaling_parameters(
#'   DomainName = "string",
#'   ScalingParameters = list(
#'     DesiredInstanceType = "search.m1.small"|"search.m1.large"|"search.m2.xlarge"|"search.m2.2xlarge"|"search.m3.medium"|"search.m3.large"|"search.m3.xlarge"|"search.m3.2xlarge",
#'     DesiredReplicationCount = 123,
#'     DesiredPartitionCount = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_update_scaling_parameters
cloudsearch_update_scaling_parameters <- function(DomainName, ScalingParameters) {
  op <- new_operation(
    name = "UpdateScalingParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$update_scaling_parameters_input(DomainName = DomainName, ScalingParameters = ScalingParameters)
  output <- .cloudsearch$update_scaling_parameters_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$update_scaling_parameters <- cloudsearch_update_scaling_parameters

#' Configures the access rules that control access to the domain's document
#' and search endpoints
#'
#' Configures the access rules that control access to the domain\'s
#' document and search endpoints. For more information, see [Configuring
#' Access for an Amazon CloudSearch
#' Domain](http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html).
#'
#' @usage
#' cloudsearch_update_service_access_policies(DomainName, AccessPolicies)
#'
#' @param DomainName &#91;required&#93; 
#' @param AccessPolicies &#91;required&#93; The access rules you want to configure. These rules replace any existing
#' rules.
#'
#' @section Request syntax:
#' ```
#' svc$update_service_access_policies(
#'   DomainName = "string",
#'   AccessPolicies = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudsearch_update_service_access_policies
cloudsearch_update_service_access_policies <- function(DomainName, AccessPolicies) {
  op <- new_operation(
    name = "UpdateServiceAccessPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudsearch$update_service_access_policies_input(DomainName = DomainName, AccessPolicies = AccessPolicies)
  output <- .cloudsearch$update_service_access_policies_output()
  config <- get_config()
  svc <- .cloudsearch$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudsearch$operations$update_service_access_policies <- cloudsearch_update_service_access_policies
