% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_create_delivery_stream}
\alias{firehose_create_delivery_stream}
\title{Creates a Kinesis Data Firehose delivery stream}
\usage{
firehose_create_delivery_stream(DeliveryStreamName, DeliveryStreamType,
  KinesisStreamSourceConfiguration,
  DeliveryStreamEncryptionConfigurationInput, S3DestinationConfiguration,
  ExtendedS3DestinationConfiguration, RedshiftDestinationConfiguration,
  ElasticsearchDestinationConfiguration, SplunkDestinationConfiguration,
  Tags)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream. This name must be unique per AWS
account in the same AWS Region. If the delivery streams are in different
accounts or different Regions, you can have multiple delivery streams
with the same name.}

\item{DeliveryStreamType}{The delivery stream type. This parameter can be one of the following
values:
\itemize{
\item \code{DirectPut}: Provider applications access the delivery stream
directly.
\item \code{KinesisStreamAsSource}: The delivery stream uses a Kinesis data
stream as a source.
}}

\item{KinesisStreamSourceConfiguration}{When a Kinesis data stream is used as the source for the delivery
stream, a KinesisStreamSourceConfiguration containing the Kinesis data
stream Amazon Resource Name (ARN) and the role ARN for the source
stream.}

\item{DeliveryStreamEncryptionConfigurationInput}{Used to specify the type and Amazon Resource Name (ARN) of the KMS key
needed for Server-Side Encryption (SSE).}

\item{S3DestinationConfiguration}{[Deprecated] The destination in Amazon S3. You can specify only one
destination.}

\item{ExtendedS3DestinationConfiguration}{The destination in Amazon S3. You can specify only one destination.}

\item{RedshiftDestinationConfiguration}{The destination in Amazon Redshift. You can specify only one
destination.}

\item{ElasticsearchDestinationConfiguration}{The destination in Amazon ES. You can specify only one destination.}

\item{SplunkDestinationConfiguration}{The destination in Splunk. You can specify only one destination.}

\item{Tags}{A set of tags to assign to the delivery stream. A tag is a key-value
pair that you can define and assign to AWS resources. Tags are metadata.
For example, you can add friendly names and descriptions or other types
of information that can help you distinguish the delivery stream. For
more information about tags, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html}{Using Cost Allocation Tags}
in the AWS Billing and Cost Management User Guide.

You can specify up to 50 tags when creating a delivery stream.}
}
\description{
Creates a Kinesis Data Firehose delivery stream.
}
\details{
By default, you can create up to 50 delivery streams per AWS Region.

This is an asynchronous operation that immediately returns. The initial
status of the delivery stream is \code{CREATING}. After the delivery stream
is created, its status is \code{ACTIVE} and it now accepts data. If the
delivery stream creation fails, the status transitions to
\code{CREATING_FAILED}. Attempts to send data to a delivery stream that is
not in the \code{ACTIVE} state cause an exception. To check the state of a
delivery stream, use DescribeDeliveryStream.

If the status of a delivery stream is \code{CREATING_FAILED}, this status
doesn\'t change, and you can\'t invoke \code{CreateDeliveryStream} again on
it. However, you can invoke the DeleteDeliveryStream operation to delete
it.

A Kinesis Data Firehose delivery stream can be configured to receive
records directly from providers using PutRecord or PutRecordBatch, or it
can be configured to use an existing Kinesis stream as its source. To
specify a Kinesis data stream as input, set the \code{DeliveryStreamType}
parameter to \code{KinesisStreamAsSource}, and provide the Kinesis stream
Amazon Resource Name (ARN) and role ARN in the
\code{KinesisStreamSourceConfiguration} parameter.

To create a delivery stream with server-side encryption (SSE) enabled,
include DeliveryStreamEncryptionConfigurationInput in your request. This
is optional. You can also invoke StartDeliveryStreamEncryption to turn
on SSE for an existing delivery stream that doesn\'t have SSE enabled.

A delivery stream is configured with a single destination: Amazon S3,
Amazon ES, Amazon Redshift, or Splunk. You must specify only one of the
following destination configuration parameters:
\code{ExtendedS3DestinationConfiguration}, \code{S3DestinationConfiguration},
\code{ElasticsearchDestinationConfiguration},
\code{RedshiftDestinationConfiguration}, or \code{SplunkDestinationConfiguration}.

When you specify \code{S3DestinationConfiguration}, you can also provide the
following optional values: BufferingHints, \code{EncryptionConfiguration},
and \code{CompressionFormat}. By default, if no \code{BufferingHints} value is
provided, Kinesis Data Firehose buffers data up to 5 MB or for 5
minutes, whichever condition is satisfied first. \code{BufferingHints} is a
hint, so there are some cases where the service cannot adhere to these
conditions strictly. For example, record boundaries might be such that
the size is a little over or under the configured buffering size. By
default, no encryption is performed. We strongly recommend that you
enable encryption to ensure secure data storage in Amazon S3.

A few notes about Amazon Redshift as a destination:
\itemize{
\item An Amazon Redshift destination requires an S3 bucket as intermediate
location. Kinesis Data Firehose first delivers data to Amazon S3 and
then uses \code{COPY} syntax to load data into an Amazon Redshift table.
This is specified in the
\code{RedshiftDestinationConfiguration.S3Configuration} parameter.
\item The compression formats \code{SNAPPY} or \code{ZIP} cannot be specified in
\code{RedshiftDestinationConfiguration.S3Configuration} because the
Amazon Redshift \code{COPY} operation that reads from the S3 bucket
doesn\'t support these compression formats.
\item We strongly recommend that you use the user name and password you
provide exclusively with Kinesis Data Firehose, and that the
permissions for the account are restricted for Amazon Redshift
\code{INSERT} permissions.
}

Kinesis Data Firehose assumes the IAM role that is configured as part of
the destination. The role should allow the Kinesis Data Firehose
principal to assume the role, and the role should have permissions that
allow the service to deliver the data. For more information, see \href{https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3}{Grant Kinesis Data Firehose Access to an Amazon S3 Destination}
in the \emph{Amazon Kinesis Data Firehose Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_delivery_stream(
  DeliveryStreamName = "string",
  DeliveryStreamType = "DirectPut"|"KinesisStreamAsSource",
  KinesisStreamSourceConfiguration = list(
    KinesisStreamARN = "string",
    RoleARN = "string"
  ),
  DeliveryStreamEncryptionConfigurationInput = list(
    KeyARN = "string",
    KeyType = "AWS_OWNED_CMK"|"CUSTOMER_MANAGED_CMK"
  ),
  S3DestinationConfiguration = list(
    RoleARN = "string",
    BucketARN = "string",
    Prefix = "string",
    ErrorOutputPrefix = "string",
    BufferingHints = list(
      SizeInMBs = 123,
      IntervalInSeconds = 123
    ),
    CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy",
    EncryptionConfiguration = list(
      NoEncryptionConfig = "NoEncryption",
      KMSEncryptionConfig = list(
        AWSKMSKeyARN = "string"
      )
    ),
    CloudWatchLoggingOptions = list(
      Enabled = TRUE|FALSE,
      LogGroupName = "string",
      LogStreamName = "string"
    )
  ),
  ExtendedS3DestinationConfiguration = list(
    RoleARN = "string",
    BucketARN = "string",
    Prefix = "string",
    ErrorOutputPrefix = "string",
    BufferingHints = list(
      SizeInMBs = 123,
      IntervalInSeconds = 123
    ),
    CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy",
    EncryptionConfiguration = list(
      NoEncryptionConfig = "NoEncryption",
      KMSEncryptionConfig = list(
        AWSKMSKeyARN = "string"
      )
    ),
    CloudWatchLoggingOptions = list(
      Enabled = TRUE|FALSE,
      LogGroupName = "string",
      LogStreamName = "string"
    ),
    ProcessingConfiguration = list(
      Enabled = TRUE|FALSE,
      Processors = list(
        list(
          Type = "Lambda",
          Parameters = list(
            list(
              ParameterName = "LambdaArn"|"NumberOfRetries"|"RoleArn"|"BufferSizeInMBs"|"BufferIntervalInSeconds",
              ParameterValue = "string"
            )
          )
        )
      )
    ),
    S3BackupMode = "Disabled"|"Enabled",
    S3BackupConfiguration = list(
      RoleARN = "string",
      BucketARN = "string",
      Prefix = "string",
      ErrorOutputPrefix = "string",
      BufferingHints = list(
        SizeInMBs = 123,
        IntervalInSeconds = 123
      ),
      CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy",
      EncryptionConfiguration = list(
        NoEncryptionConfig = "NoEncryption",
        KMSEncryptionConfig = list(
          AWSKMSKeyARN = "string"
        )
      ),
      CloudWatchLoggingOptions = list(
        Enabled = TRUE|FALSE,
        LogGroupName = "string",
        LogStreamName = "string"
      )
    ),
    DataFormatConversionConfiguration = list(
      SchemaConfiguration = list(
        RoleARN = "string",
        CatalogId = "string",
        DatabaseName = "string",
        TableName = "string",
        Region = "string",
        VersionId = "string"
      ),
      InputFormatConfiguration = list(
        Deserializer = list(
          OpenXJsonSerDe = list(
            ConvertDotsInJsonKeysToUnderscores = TRUE|FALSE,
            CaseInsensitive = TRUE|FALSE,
            ColumnToJsonKeyMappings = list(
              "string"
            )
          ),
          HiveJsonSerDe = list(
            TimestampFormats = list(
              "string"
            )
          )
        )
      ),
      OutputFormatConfiguration = list(
        Serializer = list(
          ParquetSerDe = list(
            BlockSizeBytes = 123,
            PageSizeBytes = 123,
            Compression = "UNCOMPRESSED"|"GZIP"|"SNAPPY",
            EnableDictionaryCompression = TRUE|FALSE,
            MaxPaddingBytes = 123,
            WriterVersion = "V1"|"V2"
          ),
          OrcSerDe = list(
            StripeSizeBytes = 123,
            BlockSizeBytes = 123,
            RowIndexStride = 123,
            EnablePadding = TRUE|FALSE,
            PaddingTolerance = 123.0,
            Compression = "NONE"|"ZLIB"|"SNAPPY",
            BloomFilterColumns = list(
              "string"
            ),
            BloomFilterFalsePositiveProbability = 123.0,
            DictionaryKeyThreshold = 123.0,
            FormatVersion = "V0_11"|"V0_12"
          )
        )
      ),
      Enabled = TRUE|FALSE
    )
  ),
  RedshiftDestinationConfiguration = list(
    RoleARN = "string",
    ClusterJDBCURL = "string",
    CopyCommand = list(
      DataTableName = "string",
      DataTableColumns = "string",
      CopyOptions = "string"
    ),
    Username = "string",
    Password = "string",
    RetryOptions = list(
      DurationInSeconds = 123
    ),
    S3Configuration = list(
      RoleARN = "string",
      BucketARN = "string",
      Prefix = "string",
      ErrorOutputPrefix = "string",
      BufferingHints = list(
        SizeInMBs = 123,
        IntervalInSeconds = 123
      ),
      CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy",
      EncryptionConfiguration = list(
        NoEncryptionConfig = "NoEncryption",
        KMSEncryptionConfig = list(
          AWSKMSKeyARN = "string"
        )
      ),
      CloudWatchLoggingOptions = list(
        Enabled = TRUE|FALSE,
        LogGroupName = "string",
        LogStreamName = "string"
      )
    ),
    ProcessingConfiguration = list(
      Enabled = TRUE|FALSE,
      Processors = list(
        list(
          Type = "Lambda",
          Parameters = list(
            list(
              ParameterName = "LambdaArn"|"NumberOfRetries"|"RoleArn"|"BufferSizeInMBs"|"BufferIntervalInSeconds",
              ParameterValue = "string"
            )
          )
        )
      )
    ),
    S3BackupMode = "Disabled"|"Enabled",
    S3BackupConfiguration = list(
      RoleARN = "string",
      BucketARN = "string",
      Prefix = "string",
      ErrorOutputPrefix = "string",
      BufferingHints = list(
        SizeInMBs = 123,
        IntervalInSeconds = 123
      ),
      CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy",
      EncryptionConfiguration = list(
        NoEncryptionConfig = "NoEncryption",
        KMSEncryptionConfig = list(
          AWSKMSKeyARN = "string"
        )
      ),
      CloudWatchLoggingOptions = list(
        Enabled = TRUE|FALSE,
        LogGroupName = "string",
        LogStreamName = "string"
      )
    ),
    CloudWatchLoggingOptions = list(
      Enabled = TRUE|FALSE,
      LogGroupName = "string",
      LogStreamName = "string"
    )
  ),
  ElasticsearchDestinationConfiguration = list(
    RoleARN = "string",
    DomainARN = "string",
    ClusterEndpoint = "string",
    IndexName = "string",
    TypeName = "string",
    IndexRotationPeriod = "NoRotation"|"OneHour"|"OneDay"|"OneWeek"|"OneMonth",
    BufferingHints = list(
      IntervalInSeconds = 123,
      SizeInMBs = 123
    ),
    RetryOptions = list(
      DurationInSeconds = 123
    ),
    S3BackupMode = "FailedDocumentsOnly"|"AllDocuments",
    S3Configuration = list(
      RoleARN = "string",
      BucketARN = "string",
      Prefix = "string",
      ErrorOutputPrefix = "string",
      BufferingHints = list(
        SizeInMBs = 123,
        IntervalInSeconds = 123
      ),
      CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy",
      EncryptionConfiguration = list(
        NoEncryptionConfig = "NoEncryption",
        KMSEncryptionConfig = list(
          AWSKMSKeyARN = "string"
        )
      ),
      CloudWatchLoggingOptions = list(
        Enabled = TRUE|FALSE,
        LogGroupName = "string",
        LogStreamName = "string"
      )
    ),
    ProcessingConfiguration = list(
      Enabled = TRUE|FALSE,
      Processors = list(
        list(
          Type = "Lambda",
          Parameters = list(
            list(
              ParameterName = "LambdaArn"|"NumberOfRetries"|"RoleArn"|"BufferSizeInMBs"|"BufferIntervalInSeconds",
              ParameterValue = "string"
            )
          )
        )
      )
    ),
    CloudWatchLoggingOptions = list(
      Enabled = TRUE|FALSE,
      LogGroupName = "string",
      LogStreamName = "string"
    )
  ),
  SplunkDestinationConfiguration = list(
    HECEndpoint = "string",
    HECEndpointType = "Raw"|"Event",
    HECToken = "string",
    HECAcknowledgmentTimeoutInSeconds = 123,
    RetryOptions = list(
      DurationInSeconds = 123
    ),
    S3BackupMode = "FailedEventsOnly"|"AllEvents",
    S3Configuration = list(
      RoleARN = "string",
      BucketARN = "string",
      Prefix = "string",
      ErrorOutputPrefix = "string",
      BufferingHints = list(
        SizeInMBs = 123,
        IntervalInSeconds = 123
      ),
      CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy",
      EncryptionConfiguration = list(
        NoEncryptionConfig = "NoEncryption",
        KMSEncryptionConfig = list(
          AWSKMSKeyARN = "string"
        )
      ),
      CloudWatchLoggingOptions = list(
        Enabled = TRUE|FALSE,
        LogGroupName = "string",
        LogStreamName = "string"
      )
    ),
    ProcessingConfiguration = list(
      Enabled = TRUE|FALSE,
      Processors = list(
        list(
          Type = "Lambda",
          Parameters = list(
            list(
              ParameterName = "LambdaArn"|"NumberOfRetries"|"RoleArn"|"BufferSizeInMBs"|"BufferIntervalInSeconds",
              ParameterValue = "string"
            )
          )
        )
      )
    ),
    CloudWatchLoggingOptions = list(
      Enabled = TRUE|FALSE,
      LogGroupName = "string",
      LogStreamName = "string"
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
