# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include mturk_service.R
NULL

#' The AcceptQualificationRequest operation approves a Worker's request for
#' a Qualification
#'
#' The `AcceptQualificationRequest` operation approves a Worker\'s request
#' for a Qualification.
#' 
#' Only the owner of the Qualification type can grant a Qualification
#' request for that type.
#' 
#' A successful request for the `AcceptQualificationRequest` operation
#' returns with no errors and an empty body.
#'
#' @usage
#' mturk_accept_qualification_request(QualificationRequestId, IntegerValue)
#'
#' @param QualificationRequestId &#91;required&#93; The ID of the Qualification request, as returned by the
#' `GetQualificationRequests` operation.
#' @param IntegerValue The value of the Qualification. You can omit this value if you are using
#' the presence or absence of the Qualification as the basis for a HIT
#' requirement.
#'
#' @section Request syntax:
#' ```
#' svc$accept_qualification_request(
#'   QualificationRequestId = "string",
#'   IntegerValue = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_accept_qualification_request
mturk_accept_qualification_request <- function(QualificationRequestId, IntegerValue = NULL) {
  op <- new_operation(
    name = "AcceptQualificationRequest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$accept_qualification_request_input(QualificationRequestId = QualificationRequestId, IntegerValue = IntegerValue)
  output <- .mturk$accept_qualification_request_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$accept_qualification_request <- mturk_accept_qualification_request

#' The ApproveAssignment operation approves the results of a completed
#' assignment
#'
#' The `ApproveAssignment` operation approves the results of a completed
#' assignment.
#' 
#' Approving an assignment initiates two payments from the Requester\'s
#' Amazon.com account
#' 
#' -   The Worker who submitted the results is paid the reward specified in
#'     the HIT.
#' 
#' -   Amazon Mechanical Turk fees are debited.
#' 
#' If the Requester\'s account does not have adequate funds for these
#' payments, the call to ApproveAssignment returns an exception, and the
#' approval is not processed. You can include an optional feedback message
#' with the approval, which the Worker can see in the Status section of the
#' web site.
#' 
#' You can also call this operation for assignments that were previous
#' rejected and approve them by explicitly overriding the previous
#' rejection. This only works on rejected assignments that were submitted
#' within the previous 30 days and only if the assignment\'s related HIT
#' has not been deleted.
#'
#' @usage
#' mturk_approve_assignment(AssignmentId, RequesterFeedback,
#'   OverrideRejection)
#'
#' @param AssignmentId &#91;required&#93; The ID of the assignment. The assignment must correspond to a HIT
#' created by the Requester.
#' @param RequesterFeedback A message for the Worker, which the Worker can see in the Status section
#' of the web site.
#' @param OverrideRejection A flag indicating that an assignment should be approved even if it was
#' previously rejected. Defaults to `False`.
#'
#' @section Request syntax:
#' ```
#' svc$approve_assignment(
#'   AssignmentId = "string",
#'   RequesterFeedback = "string",
#'   OverrideRejection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_approve_assignment
mturk_approve_assignment <- function(AssignmentId, RequesterFeedback = NULL, OverrideRejection = NULL) {
  op <- new_operation(
    name = "ApproveAssignment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$approve_assignment_input(AssignmentId = AssignmentId, RequesterFeedback = RequesterFeedback, OverrideRejection = OverrideRejection)
  output <- .mturk$approve_assignment_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$approve_assignment <- mturk_approve_assignment

#' The AssociateQualificationWithWorker operation gives a Worker a
#' Qualification
#'
#' The `AssociateQualificationWithWorker` operation gives a Worker a
#' Qualification. `AssociateQualificationWithWorker` does not require that
#' the Worker submit a Qualification request. It gives the Qualification
#' directly to the Worker.
#' 
#' You can only assign a Qualification of a Qualification type that you
#' created (using the `CreateQualificationType` operation).
#' 
#' Note: `AssociateQualificationWithWorker` does not affect any pending
#' Qualification requests for the Qualification by the Worker. If you
#' assign a Qualification to a Worker, then later grant a Qualification
#' request made by the Worker, the granting of the request may modify the
#' Qualification score. To resolve a pending Qualification request without
#' affecting the Qualification the Worker already has, reject the request
#' with the `RejectQualificationRequest` operation.
#'
#' @usage
#' mturk_associate_qualification_with_worker(QualificationTypeId, WorkerId,
#'   IntegerValue, SendNotification)
#'
#' @param QualificationTypeId &#91;required&#93; The ID of the Qualification type to use for the assigned Qualification.
#' @param WorkerId &#91;required&#93; The ID of the Worker to whom the Qualification is being assigned. Worker
#' IDs are included with submitted HIT assignments and Qualification
#' requests.
#' @param IntegerValue The value of the Qualification to assign.
#' @param SendNotification Specifies whether to send a notification email message to the Worker
#' saying that the qualification was assigned to the Worker. Note: this is
#' true by default.
#'
#' @section Request syntax:
#' ```
#' svc$associate_qualification_with_worker(
#'   QualificationTypeId = "string",
#'   WorkerId = "string",
#'   IntegerValue = 123,
#'   SendNotification = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_associate_qualification_with_worker
mturk_associate_qualification_with_worker <- function(QualificationTypeId, WorkerId, IntegerValue = NULL, SendNotification = NULL) {
  op <- new_operation(
    name = "AssociateQualificationWithWorker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$associate_qualification_with_worker_input(QualificationTypeId = QualificationTypeId, WorkerId = WorkerId, IntegerValue = IntegerValue, SendNotification = SendNotification)
  output <- .mturk$associate_qualification_with_worker_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$associate_qualification_with_worker <- mturk_associate_qualification_with_worker

#' The CreateAdditionalAssignmentsForHIT operation increases the maximum
#' number of assignments of an existing HIT
#'
#' The `CreateAdditionalAssignmentsForHIT` operation increases the maximum
#' number of assignments of an existing HIT.
#' 
#' To extend the maximum number of assignments, specify the number of
#' additional assignments.
#' 
#' -   HITs created with fewer than 10 assignments cannot be extended to
#'     have 10 or more assignments. Attempting to add assignments in a way
#'     that brings the total number of assignments for a HIT from fewer
#'     than 10 assignments to 10 or more assignments will result in an
#'     `AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease` exception.
#' 
#' -   HITs that were created before July 22, 2015 cannot be extended.
#'     Attempting to extend HITs that were created before July 22, 2015
#'     will result in an `AWS.MechanicalTurk.HITTooOldForExtension`
#'     exception.
#'
#' @usage
#' mturk_create_additional_assignments_for_hit(HITId,
#'   NumberOfAdditionalAssignments, UniqueRequestToken)
#'
#' @param HITId &#91;required&#93; The ID of the HIT to extend.
#' @param NumberOfAdditionalAssignments &#91;required&#93; The number of additional assignments to request for this HIT.
#' @param UniqueRequestToken A unique identifier for this request, which allows you to retry the call
#' on error without extending the HIT multiple times. This is useful in
#' cases such as network timeouts where it is unclear whether or not the
#' call succeeded on the server. If the extend HIT already exists in the
#' system from a previous call using the same `UniqueRequestToken`,
#' subsequent calls will return an error with a message containing the
#' request ID.
#'
#' @section Request syntax:
#' ```
#' svc$create_additional_assignments_for_hit(
#'   HITId = "string",
#'   NumberOfAdditionalAssignments = 123,
#'   UniqueRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_create_additional_assignments_for_hit
mturk_create_additional_assignments_for_hit <- function(HITId, NumberOfAdditionalAssignments, UniqueRequestToken = NULL) {
  op <- new_operation(
    name = "CreateAdditionalAssignmentsForHIT",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$create_additional_assignments_for_hit_input(HITId = HITId, NumberOfAdditionalAssignments = NumberOfAdditionalAssignments, UniqueRequestToken = UniqueRequestToken)
  output <- .mturk$create_additional_assignments_for_hit_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$create_additional_assignments_for_hit <- mturk_create_additional_assignments_for_hit

#' The CreateHIT operation creates a new Human Intelligence Task (HIT)
#'
#' The `CreateHIT` operation creates a new Human Intelligence Task (HIT).
#' The new HIT is made available for Workers to find and accept on the
#' Amazon Mechanical Turk website.
#' 
#' This operation allows you to specify a new HIT by passing in values for
#' the properties of the HIT, such as its title, reward amount and number
#' of assignments. When you pass these values to `CreateHIT`, a new HIT is
#' created for you, with a new `HITTypeID`. The HITTypeID can be used to
#' create additional HITs in the future without needing to specify common
#' parameters such as the title, description and reward amount each time.
#' 
#' An alternative way to create HITs is to first generate a HITTypeID using
#' the `CreateHITType` operation and then call the `CreateHITWithHITType`
#' operation. This is the recommended best practice for Requesters who are
#' creating large numbers of HITs.
#' 
#' CreateHIT also supports several ways to provide question data: by
#' providing a value for the `Question` parameter that fully specifies the
#' contents of the HIT, or by providing a `HitLayoutId` and associated
#' `HitLayoutParameters`.
#' 
#' If a HIT is created with 10 or more maximum assignments, there is an
#' additional fee. For more information, see [Amazon Mechanical Turk
#' Pricing](https://requester.mturk.com/pricing).
#'
#' @usage
#' mturk_create_hit(MaxAssignments, AutoApprovalDelayInSeconds,
#'   LifetimeInSeconds, AssignmentDurationInSeconds, Reward, Title, Keywords,
#'   Description, Question, RequesterAnnotation, QualificationRequirements,
#'   UniqueRequestToken, AssignmentReviewPolicy, HITReviewPolicy,
#'   HITLayoutId, HITLayoutParameters)
#'
#' @param MaxAssignments The number of times the HIT can be accepted and completed before the HIT
#' becomes unavailable.
#' @param AutoApprovalDelayInSeconds The number of seconds after an assignment for the HIT has been
#' submitted, after which the assignment is considered Approved
#' automatically unless the Requester explicitly rejects it.
#' @param LifetimeInSeconds &#91;required&#93; An amount of time, in seconds, after which the HIT is no longer
#' available for users to accept. After the lifetime of the HIT elapses,
#' the HIT no longer appears in HIT searches, even if not all of the
#' assignments for the HIT have been accepted.
#' @param AssignmentDurationInSeconds &#91;required&#93; The amount of time, in seconds, that a Worker has to complete the HIT
#' after accepting it. If a Worker does not complete the assignment within
#' the specified duration, the assignment is considered abandoned. If the
#' HIT is still active (that is, its lifetime has not elapsed), the
#' assignment becomes available for other users to find and accept.
#' @param Reward &#91;required&#93; The amount of money the Requester will pay a Worker for successfully
#' completing the HIT.
#' @param Title &#91;required&#93; The title of the HIT. A title should be short and descriptive about the
#' kind of task the HIT contains. On the Amazon Mechanical Turk web site,
#' the HIT title appears in search results, and everywhere the HIT is
#' mentioned.
#' @param Keywords One or more words or phrases that describe the HIT, separated by commas.
#' These words are used in searches to find HITs.
#' @param Description &#91;required&#93; A general description of the HIT. A description includes detailed
#' information about the kind of task the HIT contains. On the Amazon
#' Mechanical Turk web site, the HIT description appears in the expanded
#' view of search results, and in the HIT and assignment screens. A good
#' description gives the user enough information to evaluate the HIT before
#' accepting it.
#' @param Question The data the person completing the HIT uses to produce the results.
#' 
#' Constraints: Must be a QuestionForm data structure, an ExternalQuestion
#' data structure, or an HTMLQuestion data structure. The XML question data
#' must not be larger than 64 kilobytes (65,535 bytes) in size, including
#' whitespace.
#' 
#' Either a Question parameter or a HITLayoutId parameter must be provided.
#' @param RequesterAnnotation An arbitrary data field. The RequesterAnnotation parameter lets your
#' application attach arbitrary data to the HIT for tracking purposes. For
#' example, this parameter could be an identifier internal to the
#' Requester\'s application that corresponds with the HIT.
#' 
#' The RequesterAnnotation parameter for a HIT is only visible to the
#' Requester who created the HIT. It is not shown to the Worker, or any
#' other Requester.
#' 
#' The RequesterAnnotation parameter may be different for each HIT you
#' submit. It does not affect how your HITs are grouped.
#' @param QualificationRequirements Conditions that a Worker\'s Qualifications must meet in order to accept
#' the HIT. A HIT can have between zero and ten Qualification requirements.
#' All requirements must be met in order for a Worker to accept the HIT.
#' Additionally, other actions can be restricted using the `ActionsGuarded`
#' field on each `QualificationRequirement` structure.
#' @param UniqueRequestToken A unique identifier for this request which allows you to retry the call
#' on error without creating duplicate HITs. This is useful in cases such
#' as network timeouts where it is unclear whether or not the call
#' succeeded on the server. If the HIT already exists in the system from a
#' previous call using the same UniqueRequestToken, subsequent calls will
#' return a AWS.MechanicalTurk.HitAlreadyExists error with a message
#' containing the HITId.
#' 
#' Note: It is your responsibility to ensure uniqueness of the token. The
#' unique token expires after 24 hours. Subsequent calls using the same
#' UniqueRequestToken made after the 24 hour limit could create duplicate
#' HITs.
#' @param AssignmentReviewPolicy The Assignment-level Review Policy applies to the assignments under the
#' HIT. You can specify for Mechanical Turk to take various actions based
#' on the policy.
#' @param HITReviewPolicy The HIT-level Review Policy applies to the HIT. You can specify for
#' Mechanical Turk to take various actions based on the policy.
#' @param HITLayoutId The HITLayoutId allows you to use a pre-existing HIT design with
#' placeholder values and create an additional HIT by providing those
#' values as HITLayoutParameters.
#' 
#' Constraints: Either a Question parameter or a HITLayoutId parameter must
#' be provided.
#' @param HITLayoutParameters If the HITLayoutId is provided, any placeholder values must be filled in
#' with values using the HITLayoutParameter structure. For more
#' information, see HITLayout.
#'
#' @section Request syntax:
#' ```
#' svc$create_hit(
#'   MaxAssignments = 123,
#'   AutoApprovalDelayInSeconds = 123,
#'   LifetimeInSeconds = 123,
#'   AssignmentDurationInSeconds = 123,
#'   Reward = "string",
#'   Title = "string",
#'   Keywords = "string",
#'   Description = "string",
#'   Question = "string",
#'   RequesterAnnotation = "string",
#'   QualificationRequirements = list(
#'     list(
#'       QualificationTypeId = "string",
#'       Comparator = "LessThan"|"LessThanOrEqualTo"|"GreaterThan"|"GreaterThanOrEqualTo"|"EqualTo"|"NotEqualTo"|"Exists"|"DoesNotExist"|"In"|"NotIn",
#'       IntegerValues = list(
#'         123
#'       ),
#'       LocaleValues = list(
#'         list(
#'           Country = "string",
#'           Subdivision = "string"
#'         )
#'       ),
#'       RequiredToPreview = TRUE|FALSE,
#'       ActionsGuarded = "Accept"|"PreviewAndAccept"|"DiscoverPreviewAndAccept"
#'     )
#'   ),
#'   UniqueRequestToken = "string",
#'   AssignmentReviewPolicy = list(
#'     PolicyName = "string",
#'     Parameters = list(
#'       list(
#'         Key = "string",
#'         Values = list(
#'           "string"
#'         ),
#'         MapEntries = list(
#'           list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   HITReviewPolicy = list(
#'     PolicyName = "string",
#'     Parameters = list(
#'       list(
#'         Key = "string",
#'         Values = list(
#'           "string"
#'         ),
#'         MapEntries = list(
#'           list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   HITLayoutId = "string",
#'   HITLayoutParameters = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_create_hit
mturk_create_hit <- function(MaxAssignments = NULL, AutoApprovalDelayInSeconds = NULL, LifetimeInSeconds, AssignmentDurationInSeconds, Reward, Title, Keywords = NULL, Description, Question = NULL, RequesterAnnotation = NULL, QualificationRequirements = NULL, UniqueRequestToken = NULL, AssignmentReviewPolicy = NULL, HITReviewPolicy = NULL, HITLayoutId = NULL, HITLayoutParameters = NULL) {
  op <- new_operation(
    name = "CreateHIT",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$create_hit_input(MaxAssignments = MaxAssignments, AutoApprovalDelayInSeconds = AutoApprovalDelayInSeconds, LifetimeInSeconds = LifetimeInSeconds, AssignmentDurationInSeconds = AssignmentDurationInSeconds, Reward = Reward, Title = Title, Keywords = Keywords, Description = Description, Question = Question, RequesterAnnotation = RequesterAnnotation, QualificationRequirements = QualificationRequirements, UniqueRequestToken = UniqueRequestToken, AssignmentReviewPolicy = AssignmentReviewPolicy, HITReviewPolicy = HITReviewPolicy, HITLayoutId = HITLayoutId, HITLayoutParameters = HITLayoutParameters)
  output <- .mturk$create_hit_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$create_hit <- mturk_create_hit

#' The CreateHITType operation creates a new HIT type
#'
#' The `CreateHITType` operation creates a new HIT type. This operation
#' allows you to define a standard set of HIT properties to use when
#' creating HITs. If you register a HIT type with values that match an
#' existing HIT type, the HIT type ID of the existing type will be
#' returned.
#'
#' @usage
#' mturk_create_hit_type(AutoApprovalDelayInSeconds,
#'   AssignmentDurationInSeconds, Reward, Title, Keywords, Description,
#'   QualificationRequirements)
#'
#' @param AutoApprovalDelayInSeconds The number of seconds after an assignment for the HIT has been
#' submitted, after which the assignment is considered Approved
#' automatically unless the Requester explicitly rejects it.
#' @param AssignmentDurationInSeconds &#91;required&#93; The amount of time, in seconds, that a Worker has to complete the HIT
#' after accepting it. If a Worker does not complete the assignment within
#' the specified duration, the assignment is considered abandoned. If the
#' HIT is still active (that is, its lifetime has not elapsed), the
#' assignment becomes available for other users to find and accept.
#' @param Reward &#91;required&#93; The amount of money the Requester will pay a Worker for successfully
#' completing the HIT.
#' @param Title &#91;required&#93; The title of the HIT. A title should be short and descriptive about the
#' kind of task the HIT contains. On the Amazon Mechanical Turk web site,
#' the HIT title appears in search results, and everywhere the HIT is
#' mentioned.
#' @param Keywords One or more words or phrases that describe the HIT, separated by commas.
#' These words are used in searches to find HITs.
#' @param Description &#91;required&#93; A general description of the HIT. A description includes detailed
#' information about the kind of task the HIT contains. On the Amazon
#' Mechanical Turk web site, the HIT description appears in the expanded
#' view of search results, and in the HIT and assignment screens. A good
#' description gives the user enough information to evaluate the HIT before
#' accepting it.
#' @param QualificationRequirements Conditions that a Worker\'s Qualifications must meet in order to accept
#' the HIT. A HIT can have between zero and ten Qualification requirements.
#' All requirements must be met in order for a Worker to accept the HIT.
#' Additionally, other actions can be restricted using the `ActionsGuarded`
#' field on each `QualificationRequirement` structure.
#'
#' @section Request syntax:
#' ```
#' svc$create_hit_type(
#'   AutoApprovalDelayInSeconds = 123,
#'   AssignmentDurationInSeconds = 123,
#'   Reward = "string",
#'   Title = "string",
#'   Keywords = "string",
#'   Description = "string",
#'   QualificationRequirements = list(
#'     list(
#'       QualificationTypeId = "string",
#'       Comparator = "LessThan"|"LessThanOrEqualTo"|"GreaterThan"|"GreaterThanOrEqualTo"|"EqualTo"|"NotEqualTo"|"Exists"|"DoesNotExist"|"In"|"NotIn",
#'       IntegerValues = list(
#'         123
#'       ),
#'       LocaleValues = list(
#'         list(
#'           Country = "string",
#'           Subdivision = "string"
#'         )
#'       ),
#'       RequiredToPreview = TRUE|FALSE,
#'       ActionsGuarded = "Accept"|"PreviewAndAccept"|"DiscoverPreviewAndAccept"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_create_hit_type
mturk_create_hit_type <- function(AutoApprovalDelayInSeconds = NULL, AssignmentDurationInSeconds, Reward, Title, Keywords = NULL, Description, QualificationRequirements = NULL) {
  op <- new_operation(
    name = "CreateHITType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$create_hit_type_input(AutoApprovalDelayInSeconds = AutoApprovalDelayInSeconds, AssignmentDurationInSeconds = AssignmentDurationInSeconds, Reward = Reward, Title = Title, Keywords = Keywords, Description = Description, QualificationRequirements = QualificationRequirements)
  output <- .mturk$create_hit_type_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$create_hit_type <- mturk_create_hit_type

#' The CreateHITWithHITType operation creates a new Human Intelligence Task
#' (HIT) using an existing HITTypeID generated by the CreateHITType
#' operation
#'
#' The `CreateHITWithHITType` operation creates a new Human Intelligence
#' Task (HIT) using an existing HITTypeID generated by the `CreateHITType`
#' operation.
#' 
#' This is an alternative way to create HITs from the `CreateHIT`
#' operation. This is the recommended best practice for Requesters who are
#' creating large numbers of HITs.
#' 
#' CreateHITWithHITType also supports several ways to provide question
#' data: by providing a value for the `Question` parameter that fully
#' specifies the contents of the HIT, or by providing a `HitLayoutId` and
#' associated `HitLayoutParameters`.
#' 
#' If a HIT is created with 10 or more maximum assignments, there is an
#' additional fee. For more information, see [Amazon Mechanical Turk
#' Pricing](https://requester.mturk.com/pricing).
#'
#' @usage
#' mturk_create_hit_with_hit_type(HITTypeId, MaxAssignments,
#'   LifetimeInSeconds, Question, RequesterAnnotation, UniqueRequestToken,
#'   AssignmentReviewPolicy, HITReviewPolicy, HITLayoutId,
#'   HITLayoutParameters)
#'
#' @param HITTypeId &#91;required&#93; The HIT type ID you want to create this HIT with.
#' @param MaxAssignments The number of times the HIT can be accepted and completed before the HIT
#' becomes unavailable.
#' @param LifetimeInSeconds &#91;required&#93; An amount of time, in seconds, after which the HIT is no longer
#' available for users to accept. After the lifetime of the HIT elapses,
#' the HIT no longer appears in HIT searches, even if not all of the
#' assignments for the HIT have been accepted.
#' @param Question The data the person completing the HIT uses to produce the results.
#' 
#' Constraints: Must be a QuestionForm data structure, an ExternalQuestion
#' data structure, or an HTMLQuestion data structure. The XML question data
#' must not be larger than 64 kilobytes (65,535 bytes) in size, including
#' whitespace.
#' 
#' Either a Question parameter or a HITLayoutId parameter must be provided.
#' @param RequesterAnnotation An arbitrary data field. The RequesterAnnotation parameter lets your
#' application attach arbitrary data to the HIT for tracking purposes. For
#' example, this parameter could be an identifier internal to the
#' Requester\'s application that corresponds with the HIT.
#' 
#' The RequesterAnnotation parameter for a HIT is only visible to the
#' Requester who created the HIT. It is not shown to the Worker, or any
#' other Requester.
#' 
#' The RequesterAnnotation parameter may be different for each HIT you
#' submit. It does not affect how your HITs are grouped.
#' @param UniqueRequestToken A unique identifier for this request which allows you to retry the call
#' on error without creating duplicate HITs. This is useful in cases such
#' as network timeouts where it is unclear whether or not the call
#' succeeded on the server. If the HIT already exists in the system from a
#' previous call using the same UniqueRequestToken, subsequent calls will
#' return a AWS.MechanicalTurk.HitAlreadyExists error with a message
#' containing the HITId.
#' 
#' Note: It is your responsibility to ensure uniqueness of the token. The
#' unique token expires after 24 hours. Subsequent calls using the same
#' UniqueRequestToken made after the 24 hour limit could create duplicate
#' HITs.
#' @param AssignmentReviewPolicy The Assignment-level Review Policy applies to the assignments under the
#' HIT. You can specify for Mechanical Turk to take various actions based
#' on the policy.
#' @param HITReviewPolicy The HIT-level Review Policy applies to the HIT. You can specify for
#' Mechanical Turk to take various actions based on the policy.
#' @param HITLayoutId The HITLayoutId allows you to use a pre-existing HIT design with
#' placeholder values and create an additional HIT by providing those
#' values as HITLayoutParameters.
#' 
#' Constraints: Either a Question parameter or a HITLayoutId parameter must
#' be provided.
#' @param HITLayoutParameters If the HITLayoutId is provided, any placeholder values must be filled in
#' with values using the HITLayoutParameter structure. For more
#' information, see HITLayout.
#'
#' @section Request syntax:
#' ```
#' svc$create_hit_with_hit_type(
#'   HITTypeId = "string",
#'   MaxAssignments = 123,
#'   LifetimeInSeconds = 123,
#'   Question = "string",
#'   RequesterAnnotation = "string",
#'   UniqueRequestToken = "string",
#'   AssignmentReviewPolicy = list(
#'     PolicyName = "string",
#'     Parameters = list(
#'       list(
#'         Key = "string",
#'         Values = list(
#'           "string"
#'         ),
#'         MapEntries = list(
#'           list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   HITReviewPolicy = list(
#'     PolicyName = "string",
#'     Parameters = list(
#'       list(
#'         Key = "string",
#'         Values = list(
#'           "string"
#'         ),
#'         MapEntries = list(
#'           list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   HITLayoutId = "string",
#'   HITLayoutParameters = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_create_hit_with_hit_type
mturk_create_hit_with_hit_type <- function(HITTypeId, MaxAssignments = NULL, LifetimeInSeconds, Question = NULL, RequesterAnnotation = NULL, UniqueRequestToken = NULL, AssignmentReviewPolicy = NULL, HITReviewPolicy = NULL, HITLayoutId = NULL, HITLayoutParameters = NULL) {
  op <- new_operation(
    name = "CreateHITWithHITType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$create_hit_with_hit_type_input(HITTypeId = HITTypeId, MaxAssignments = MaxAssignments, LifetimeInSeconds = LifetimeInSeconds, Question = Question, RequesterAnnotation = RequesterAnnotation, UniqueRequestToken = UniqueRequestToken, AssignmentReviewPolicy = AssignmentReviewPolicy, HITReviewPolicy = HITReviewPolicy, HITLayoutId = HITLayoutId, HITLayoutParameters = HITLayoutParameters)
  output <- .mturk$create_hit_with_hit_type_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$create_hit_with_hit_type <- mturk_create_hit_with_hit_type

#' The CreateQualificationType operation creates a new Qualification type,
#' which is represented by a QualificationType data structure
#'
#' The `CreateQualificationType` operation creates a new Qualification
#' type, which is represented by a `QualificationType` data structure.
#'
#' @usage
#' mturk_create_qualification_type(Name, Keywords, Description,
#'   QualificationTypeStatus, RetryDelayInSeconds, Test, AnswerKey,
#'   TestDurationInSeconds, AutoGranted, AutoGrantedValue)
#'
#' @param Name &#91;required&#93; The name you give to the Qualification type. The type name is used to
#' represent the Qualification to Workers, and to find the type using a
#' Qualification type search. It must be unique across all of your
#' Qualification types.
#' @param Keywords One or more words or phrases that describe the Qualification type,
#' separated by commas. The keywords of a type make the type easier to find
#' during a search.
#' @param Description &#91;required&#93; A long description for the Qualification type. On the Amazon Mechanical
#' Turk website, the long description is displayed when a Worker examines a
#' Qualification type.
#' @param QualificationTypeStatus &#91;required&#93; The initial status of the Qualification type.
#' 
#' Constraints: Valid values are: Active \\| Inactive
#' @param RetryDelayInSeconds The number of seconds that a Worker must wait after requesting a
#' Qualification of the Qualification type before the worker can retry the
#' Qualification request.
#' 
#' Constraints: None. If not specified, retries are disabled and Workers
#' can request a Qualification of this type only once, even if the Worker
#' has not been granted the Qualification. It is not possible to disable
#' retries for a Qualification type after it has been created with retries
#' enabled. If you want to disable retries, you must delete existing
#' retry-enabled Qualification type and then create a new Qualification
#' type with retries disabled.
#' @param Test The questions for the Qualification test a Worker must answer correctly
#' to obtain a Qualification of this type. If this parameter is specified,
#' `TestDurationInSeconds` must also be specified.
#' 
#' Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm
#' data structure. This parameter cannot be specified if AutoGranted is
#' true.
#' 
#' Constraints: None. If not specified, the Worker may request the
#' Qualification without answering any questions.
#' @param AnswerKey The answers to the Qualification test specified in the Test parameter,
#' in the form of an AnswerKey data structure.
#' 
#' Constraints: Must not be longer than 65535 bytes.
#' 
#' Constraints: None. If not specified, you must process Qualification
#' requests manually.
#' @param TestDurationInSeconds The number of seconds the Worker has to complete the Qualification test,
#' starting from the time the Worker requests the Qualification.
#' @param AutoGranted Specifies whether requests for the Qualification type are granted
#' immediately, without prompting the Worker with a Qualification test.
#' 
#' Constraints: If the Test parameter is specified, this parameter cannot
#' be true.
#' @param AutoGrantedValue The Qualification value to use for automatically granted Qualifications.
#' This parameter is used only if the AutoGranted parameter is true.
#'
#' @section Request syntax:
#' ```
#' svc$create_qualification_type(
#'   Name = "string",
#'   Keywords = "string",
#'   Description = "string",
#'   QualificationTypeStatus = "Active"|"Inactive",
#'   RetryDelayInSeconds = 123,
#'   Test = "string",
#'   AnswerKey = "string",
#'   TestDurationInSeconds = 123,
#'   AutoGranted = TRUE|FALSE,
#'   AutoGrantedValue = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_create_qualification_type
mturk_create_qualification_type <- function(Name, Keywords = NULL, Description, QualificationTypeStatus, RetryDelayInSeconds = NULL, Test = NULL, AnswerKey = NULL, TestDurationInSeconds = NULL, AutoGranted = NULL, AutoGrantedValue = NULL) {
  op <- new_operation(
    name = "CreateQualificationType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$create_qualification_type_input(Name = Name, Keywords = Keywords, Description = Description, QualificationTypeStatus = QualificationTypeStatus, RetryDelayInSeconds = RetryDelayInSeconds, Test = Test, AnswerKey = AnswerKey, TestDurationInSeconds = TestDurationInSeconds, AutoGranted = AutoGranted, AutoGrantedValue = AutoGrantedValue)
  output <- .mturk$create_qualification_type_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$create_qualification_type <- mturk_create_qualification_type

#' The CreateWorkerBlock operation allows you to prevent a Worker from
#' working on your HITs
#'
#' The `CreateWorkerBlock` operation allows you to prevent a Worker from
#' working on your HITs. For example, you can block a Worker who is
#' producing poor quality work. You can block up to 100,000 Workers.
#'
#' @usage
#' mturk_create_worker_block(WorkerId, Reason)
#'
#' @param WorkerId &#91;required&#93; The ID of the Worker to block.
#' @param Reason &#91;required&#93; A message explaining the reason for blocking the Worker. This parameter
#' enables you to keep track of your Workers. The Worker does not see this
#' message.
#'
#' @section Request syntax:
#' ```
#' svc$create_worker_block(
#'   WorkerId = "string",
#'   Reason = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_create_worker_block
mturk_create_worker_block <- function(WorkerId, Reason) {
  op <- new_operation(
    name = "CreateWorkerBlock",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$create_worker_block_input(WorkerId = WorkerId, Reason = Reason)
  output <- .mturk$create_worker_block_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$create_worker_block <- mturk_create_worker_block

#' The DeleteHIT operation is used to delete HIT that is no longer needed
#'
#' The `DeleteHIT` operation is used to delete HIT that is no longer
#' needed. Only the Requester who created the HIT can delete it.
#' 
#' You can only dispose of HITs that are in the `Reviewable` state, with
#' all of their submitted assignments already either approved or rejected.
#' If you call the DeleteHIT operation on a HIT that is not in the
#' `Reviewable` state (for example, that has not expired, or still has
#' active assignments), or on a HIT that is Reviewable but without all of
#' its submitted assignments already approved or rejected, the service will
#' return an error.
#' 
#' -   HITs are automatically disposed of after 120 days.
#' 
#' -   After you dispose of a HIT, you can no longer approve the HIT\'s
#'     rejected assignments.
#' 
#' -   Disposed HITs are not returned in results for the ListHITs
#'     operation.
#' 
#' -   Disposing HITs can improve the performance of operations such as
#'     ListReviewableHITs and ListHITs.
#'
#' @usage
#' mturk_delete_hit(HITId)
#'
#' @param HITId &#91;required&#93; The ID of the HIT to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_hit(
#'   HITId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_delete_hit
mturk_delete_hit <- function(HITId) {
  op <- new_operation(
    name = "DeleteHIT",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$delete_hit_input(HITId = HITId)
  output <- .mturk$delete_hit_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$delete_hit <- mturk_delete_hit

#' The DeleteQualificationType deletes a Qualification type and deletes any
#' HIT types that are associated with the Qualification type
#'
#' The `DeleteQualificationType` deletes a Qualification type and deletes
#' any HIT types that are associated with the Qualification type.
#' 
#' This operation does not revoke Qualifications already assigned to
#' Workers because the Qualifications might be needed for active HITs. If
#' there are any pending requests for the Qualification type, Amazon
#' Mechanical Turk rejects those requests. After you delete a Qualification
#' type, you can no longer use it to create HITs or HIT types.
#' 
#' DeleteQualificationType must wait for all the HITs that use the deleted
#' Qualification type to be deleted before completing. It may take up to 48
#' hours before DeleteQualificationType completes and the unique name of
#' the Qualification type is available for reuse with
#' CreateQualificationType.
#'
#' @usage
#' mturk_delete_qualification_type(QualificationTypeId)
#'
#' @param QualificationTypeId &#91;required&#93; The ID of the QualificationType to dispose.
#'
#' @section Request syntax:
#' ```
#' svc$delete_qualification_type(
#'   QualificationTypeId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_delete_qualification_type
mturk_delete_qualification_type <- function(QualificationTypeId) {
  op <- new_operation(
    name = "DeleteQualificationType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$delete_qualification_type_input(QualificationTypeId = QualificationTypeId)
  output <- .mturk$delete_qualification_type_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$delete_qualification_type <- mturk_delete_qualification_type

#' The DeleteWorkerBlock operation allows you to reinstate a blocked Worker
#' to work on your HITs
#'
#' The `DeleteWorkerBlock` operation allows you to reinstate a blocked
#' Worker to work on your HITs. This operation reverses the effects of the
#' CreateWorkerBlock operation. You need the Worker ID to use this
#' operation. If the Worker ID is missing or invalid, this operation fails
#' and returns the message "WorkerId is invalid." If the specified Worker
#' is not blocked, this operation returns successfully.
#'
#' @usage
#' mturk_delete_worker_block(WorkerId, Reason)
#'
#' @param WorkerId &#91;required&#93; The ID of the Worker to unblock.
#' @param Reason A message that explains the reason for unblocking the Worker. The Worker
#' does not see this message.
#'
#' @section Request syntax:
#' ```
#' svc$delete_worker_block(
#'   WorkerId = "string",
#'   Reason = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_delete_worker_block
mturk_delete_worker_block <- function(WorkerId, Reason = NULL) {
  op <- new_operation(
    name = "DeleteWorkerBlock",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$delete_worker_block_input(WorkerId = WorkerId, Reason = Reason)
  output <- .mturk$delete_worker_block_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$delete_worker_block <- mturk_delete_worker_block

#' The DisassociateQualificationFromWorker revokes a previously granted
#' Qualification from a user
#'
#' The `DisassociateQualificationFromWorker` revokes a previously granted
#' Qualification from a user.
#' 
#' You can provide a text message explaining why the Qualification was
#' revoked. The user who had the Qualification can see this message.
#'
#' @usage
#' mturk_disassociate_qualification_from_worker(WorkerId,
#'   QualificationTypeId, Reason)
#'
#' @param WorkerId &#91;required&#93; The ID of the Worker who possesses the Qualification to be revoked.
#' @param QualificationTypeId &#91;required&#93; The ID of the Qualification type of the Qualification to be revoked.
#' @param Reason A text message that explains why the Qualification was revoked. The user
#' who had the Qualification sees this message.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_qualification_from_worker(
#'   WorkerId = "string",
#'   QualificationTypeId = "string",
#'   Reason = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_disassociate_qualification_from_worker
mturk_disassociate_qualification_from_worker <- function(WorkerId, QualificationTypeId, Reason = NULL) {
  op <- new_operation(
    name = "DisassociateQualificationFromWorker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$disassociate_qualification_from_worker_input(WorkerId = WorkerId, QualificationTypeId = QualificationTypeId, Reason = Reason)
  output <- .mturk$disassociate_qualification_from_worker_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$disassociate_qualification_from_worker <- mturk_disassociate_qualification_from_worker

#' The GetAccountBalance operation retrieves the amount of money in your
#' Amazon Mechanical Turk account
#'
#' The `GetAccountBalance` operation retrieves the amount of money in your
#' Amazon Mechanical Turk account.
#'
#' @usage
#' mturk_get_account_balance()
#'
#' @section Request syntax:
#' ```
#' svc$get_account_balance()
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_get_account_balance
mturk_get_account_balance <- function() {
  op <- new_operation(
    name = "GetAccountBalance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$get_account_balance_input()
  output <- .mturk$get_account_balance_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$get_account_balance <- mturk_get_account_balance

#' The GetAssignment operation retrieves the details of the specified
#' Assignment
#'
#' The `GetAssignment` operation retrieves the details of the specified
#' Assignment.
#'
#' @usage
#' mturk_get_assignment(AssignmentId)
#'
#' @param AssignmentId &#91;required&#93; The ID of the Assignment to be retrieved.
#'
#' @section Request syntax:
#' ```
#' svc$get_assignment(
#'   AssignmentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_get_assignment
mturk_get_assignment <- function(AssignmentId) {
  op <- new_operation(
    name = "GetAssignment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$get_assignment_input(AssignmentId = AssignmentId)
  output <- .mturk$get_assignment_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$get_assignment <- mturk_get_assignment

#' The GetFileUploadURL operation generates and returns a temporary URL
#'
#' The `GetFileUploadURL` operation generates and returns a temporary URL.
#' You use the temporary URL to retrieve a file uploaded by a Worker as an
#' answer to a FileUploadAnswer question for a HIT. The temporary URL is
#' generated the instant the GetFileUploadURL operation is called, and is
#' valid for 60 seconds. You can get a temporary file upload URL any time
#' until the HIT is disposed. After the HIT is disposed, any uploaded files
#' are deleted, and cannot be retrieved. Pending Deprecation on December
#' 12, 2017. The Answer Specification structure will no longer support the
#' `FileUploadAnswer` element to be used for the QuestionForm data
#' structure. Instead, we recommend that Requesters who want to create HITs
#' asking Workers to upload files to use Amazon S3.
#'
#' @usage
#' mturk_get_file_upload_url(AssignmentId, QuestionIdentifier)
#'
#' @param AssignmentId &#91;required&#93; The ID of the assignment that contains the question with a
#' FileUploadAnswer.
#' @param QuestionIdentifier &#91;required&#93; The identifier of the question with a FileUploadAnswer, as specified in
#' the QuestionForm of the HIT.
#'
#' @section Request syntax:
#' ```
#' svc$get_file_upload_url(
#'   AssignmentId = "string",
#'   QuestionIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_get_file_upload_url
mturk_get_file_upload_url <- function(AssignmentId, QuestionIdentifier) {
  op <- new_operation(
    name = "GetFileUploadURL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$get_file_upload_url_input(AssignmentId = AssignmentId, QuestionIdentifier = QuestionIdentifier)
  output <- .mturk$get_file_upload_url_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$get_file_upload_url <- mturk_get_file_upload_url

#' The GetHIT operation retrieves the details of the specified HIT
#'
#' The `GetHIT` operation retrieves the details of the specified HIT.
#'
#' @usage
#' mturk_get_hit(HITId)
#'
#' @param HITId &#91;required&#93; The ID of the HIT to be retrieved.
#'
#' @section Request syntax:
#' ```
#' svc$get_hit(
#'   HITId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_get_hit
mturk_get_hit <- function(HITId) {
  op <- new_operation(
    name = "GetHIT",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$get_hit_input(HITId = HITId)
  output <- .mturk$get_hit_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$get_hit <- mturk_get_hit

#' The GetQualificationScore operation returns the value of a Worker's
#' Qualification for a given Qualification type
#'
#' The `GetQualificationScore` operation returns the value of a Worker\'s
#' Qualification for a given Qualification type.
#' 
#' To get a Worker\'s Qualification, you must know the Worker\'s ID. The
#' Worker\'s ID is included in the assignment data returned by the
#' `ListAssignmentsForHIT` operation.
#' 
#' Only the owner of a Qualification type can query the value of a
#' Worker\'s Qualification of that type.
#'
#' @usage
#' mturk_get_qualification_score(QualificationTypeId, WorkerId)
#'
#' @param QualificationTypeId &#91;required&#93; The ID of the QualificationType.
#' @param WorkerId &#91;required&#93; The ID of the Worker whose Qualification is being updated.
#'
#' @section Request syntax:
#' ```
#' svc$get_qualification_score(
#'   QualificationTypeId = "string",
#'   WorkerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_get_qualification_score
mturk_get_qualification_score <- function(QualificationTypeId, WorkerId) {
  op <- new_operation(
    name = "GetQualificationScore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$get_qualification_score_input(QualificationTypeId = QualificationTypeId, WorkerId = WorkerId)
  output <- .mturk$get_qualification_score_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$get_qualification_score <- mturk_get_qualification_score

#' The GetQualificationTypeoperation retrieves information about a
#' Qualification type using its ID
#'
#' The `GetQualificationType`operation retrieves information about a
#' Qualification type using its ID.
#'
#' @usage
#' mturk_get_qualification_type(QualificationTypeId)
#'
#' @param QualificationTypeId &#91;required&#93; The ID of the QualificationType.
#'
#' @section Request syntax:
#' ```
#' svc$get_qualification_type(
#'   QualificationTypeId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_get_qualification_type
mturk_get_qualification_type <- function(QualificationTypeId) {
  op <- new_operation(
    name = "GetQualificationType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$get_qualification_type_input(QualificationTypeId = QualificationTypeId)
  output <- .mturk$get_qualification_type_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$get_qualification_type <- mturk_get_qualification_type

#' The ListAssignmentsForHIT operation retrieves completed assignments for
#' a HIT
#'
#' The `ListAssignmentsForHIT` operation retrieves completed assignments
#' for a HIT. You can use this operation to retrieve the results for a HIT.
#' 
#' You can get assignments for a HIT at any time, even if the HIT is not
#' yet Reviewable. If a HIT requested multiple assignments, and has
#' received some results but has not yet become Reviewable, you can still
#' retrieve the partial results with this operation.
#' 
#' Use the AssignmentStatus parameter to control which set of assignments
#' for a HIT are returned. The ListAssignmentsForHIT operation can return
#' submitted assignments awaiting approval, or it can return assignments
#' that have already been approved or rejected. You can set
#' AssignmentStatus=Approved,Rejected to get assignments that have already
#' been approved and rejected together in one result set.
#' 
#' Only the Requester who created the HIT can retrieve the assignments for
#' that HIT.
#' 
#' Results are sorted and divided into numbered pages and the operation
#' returns a single page of results. You can use the parameters of the
#' operation to control sorting and pagination.
#'
#' @usage
#' mturk_list_assignments_for_hit(HITId, NextToken, MaxResults,
#'   AssignmentStatuses)
#'
#' @param HITId &#91;required&#93; The ID of the HIT.
#' @param NextToken Pagination token
#' @param MaxResults 
#' @param AssignmentStatuses The status of the assignments to return: Submitted \\| Approved \\|
#' Rejected
#'
#' @section Request syntax:
#' ```
#' svc$list_assignments_for_hit(
#'   HITId = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   AssignmentStatuses = list(
#'     "Submitted"|"Approved"|"Rejected"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_list_assignments_for_hit
mturk_list_assignments_for_hit <- function(HITId, NextToken = NULL, MaxResults = NULL, AssignmentStatuses = NULL) {
  op <- new_operation(
    name = "ListAssignmentsForHIT",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$list_assignments_for_hit_input(HITId = HITId, NextToken = NextToken, MaxResults = MaxResults, AssignmentStatuses = AssignmentStatuses)
  output <- .mturk$list_assignments_for_hit_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$list_assignments_for_hit <- mturk_list_assignments_for_hit

#' The ListBonusPayments operation retrieves the amounts of bonuses you
#' have paid to Workers for a given HIT or assignment
#'
#' The `ListBonusPayments` operation retrieves the amounts of bonuses you
#' have paid to Workers for a given HIT or assignment.
#'
#' @usage
#' mturk_list_bonus_payments(HITId, AssignmentId, NextToken, MaxResults)
#'
#' @param HITId The ID of the HIT associated with the bonus payments to retrieve. If not
#' specified, all bonus payments for all assignments for the given HIT are
#' returned. Either the HITId parameter or the AssignmentId parameter must
#' be specified
#' @param AssignmentId The ID of the assignment associated with the bonus payments to retrieve.
#' If specified, only bonus payments for the given assignment are returned.
#' Either the HITId parameter or the AssignmentId parameter must be
#' specified
#' @param NextToken Pagination token
#' @param MaxResults 
#'
#' @section Request syntax:
#' ```
#' svc$list_bonus_payments(
#'   HITId = "string",
#'   AssignmentId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_list_bonus_payments
mturk_list_bonus_payments <- function(HITId = NULL, AssignmentId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListBonusPayments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$list_bonus_payments_input(HITId = HITId, AssignmentId = AssignmentId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .mturk$list_bonus_payments_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$list_bonus_payments <- mturk_list_bonus_payments

#' The ListHITs operation returns all of a Requester's HITs
#'
#' The `ListHITs` operation returns all of a Requester\'s HITs. The
#' operation returns HITs of any status, except for HITs that have been
#' deleted of with the DeleteHIT operation or that have been auto-deleted.
#'
#' @usage
#' mturk_list_hi_ts(NextToken, MaxResults)
#'
#' @param NextToken Pagination token
#' @param MaxResults 
#'
#' @section Request syntax:
#' ```
#' svc$list_hi_ts(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_list_hi_ts
mturk_list_hi_ts <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHITs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$list_hi_ts_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .mturk$list_hi_ts_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$list_hi_ts <- mturk_list_hi_ts

#' The ListHITsForQualificationType operation returns the HITs that use the
#' given Qualification type for a Qualification requirement
#'
#' The `ListHITsForQualificationType` operation returns the HITs that use
#' the given Qualification type for a Qualification requirement. The
#' operation returns HITs of any status, except for HITs that have been
#' deleted with the `DeleteHIT` operation or that have been auto-deleted.
#'
#' @usage
#' mturk_list_hi_ts_for_qualification_type(QualificationTypeId, NextToken,
#'   MaxResults)
#'
#' @param QualificationTypeId &#91;required&#93; The ID of the Qualification type to use when querying HITs.
#' @param NextToken Pagination Token
#' @param MaxResults Limit the number of results returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_hi_ts_for_qualification_type(
#'   QualificationTypeId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_list_hi_ts_for_qualification_type
mturk_list_hi_ts_for_qualification_type <- function(QualificationTypeId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHITsForQualificationType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$list_hi_ts_for_qualification_type_input(QualificationTypeId = QualificationTypeId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .mturk$list_hi_ts_for_qualification_type_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$list_hi_ts_for_qualification_type <- mturk_list_hi_ts_for_qualification_type

#' The ListQualificationRequests operation retrieves requests for
#' Qualifications of a particular Qualification type
#'
#' The `ListQualificationRequests` operation retrieves requests for
#' Qualifications of a particular Qualification type. The owner of the
#' Qualification type calls this operation to poll for pending requests,
#' and accepts them using the AcceptQualification operation.
#'
#' @usage
#' mturk_list_qualification_requests(QualificationTypeId, NextToken,
#'   MaxResults)
#'
#' @param QualificationTypeId The ID of the QualificationType.
#' @param NextToken 
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @section Request syntax:
#' ```
#' svc$list_qualification_requests(
#'   QualificationTypeId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_list_qualification_requests
mturk_list_qualification_requests <- function(QualificationTypeId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListQualificationRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$list_qualification_requests_input(QualificationTypeId = QualificationTypeId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .mturk$list_qualification_requests_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$list_qualification_requests <- mturk_list_qualification_requests

#' The ListQualificationTypes operation returns a list of Qualification
#' types, filtered by an optional search term
#'
#' The `ListQualificationTypes` operation returns a list of Qualification
#' types, filtered by an optional search term.
#'
#' @usage
#' mturk_list_qualification_types(Query, MustBeRequestable,
#'   MustBeOwnedByCaller, NextToken, MaxResults)
#'
#' @param Query A text query against all of the searchable attributes of Qualification
#' types.
#' @param MustBeRequestable &#91;required&#93; Specifies that only Qualification types that a user can request through
#' the Amazon Mechanical Turk web site, such as by taking a Qualification
#' test, are returned as results of the search. Some Qualification types,
#' such as those assigned automatically by the system, cannot be requested
#' directly by users. If false, all Qualification types, including those
#' managed by the system, are considered. Valid values are True \\| False.
#' @param MustBeOwnedByCaller Specifies that only Qualification types that the Requester created are
#' returned. If false, the operation returns all Qualification types.
#' @param NextToken 
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @section Request syntax:
#' ```
#' svc$list_qualification_types(
#'   Query = "string",
#'   MustBeRequestable = TRUE|FALSE,
#'   MustBeOwnedByCaller = TRUE|FALSE,
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_list_qualification_types
mturk_list_qualification_types <- function(Query = NULL, MustBeRequestable, MustBeOwnedByCaller = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListQualificationTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$list_qualification_types_input(Query = Query, MustBeRequestable = MustBeRequestable, MustBeOwnedByCaller = MustBeOwnedByCaller, NextToken = NextToken, MaxResults = MaxResults)
  output <- .mturk$list_qualification_types_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$list_qualification_types <- mturk_list_qualification_types

#' The ListReviewPolicyResultsForHIT operation retrieves the computed
#' results and the actions taken in the course of executing your Review
#' Policies for a given HIT
#'
#' The `ListReviewPolicyResultsForHIT` operation retrieves the computed
#' results and the actions taken in the course of executing your Review
#' Policies for a given HIT. For information about how to specify Review
#' Policies when you call CreateHIT, see Review Policies. The
#' ListReviewPolicyResultsForHIT operation can return results for both
#' Assignment-level and HIT-level review results.
#'
#' @usage
#' mturk_list_review_policy_results_for_hit(HITId, PolicyLevels,
#'   RetrieveActions, RetrieveResults, NextToken, MaxResults)
#'
#' @param HITId &#91;required&#93; The unique identifier of the HIT to retrieve review results for.
#' @param PolicyLevels The Policy Level(s) to retrieve review results for - HIT or Assignment.
#' If omitted, the default behavior is to retrieve all data for both policy
#' levels. For a list of all the described policies, see Review Policies.
#' @param RetrieveActions Specify if the operation should retrieve a list of the actions taken
#' executing the Review Policies and their outcomes.
#' @param RetrieveResults Specify if the operation should retrieve a list of the results computed
#' by the Review Policies.
#' @param NextToken Pagination token
#' @param MaxResults Limit the number of results returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_review_policy_results_for_hit(
#'   HITId = "string",
#'   PolicyLevels = list(
#'     "Assignment"|"HIT"
#'   ),
#'   RetrieveActions = TRUE|FALSE,
#'   RetrieveResults = TRUE|FALSE,
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_list_review_policy_results_for_hit
mturk_list_review_policy_results_for_hit <- function(HITId, PolicyLevels = NULL, RetrieveActions = NULL, RetrieveResults = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListReviewPolicyResultsForHIT",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$list_review_policy_results_for_hit_input(HITId = HITId, PolicyLevels = PolicyLevels, RetrieveActions = RetrieveActions, RetrieveResults = RetrieveResults, NextToken = NextToken, MaxResults = MaxResults)
  output <- .mturk$list_review_policy_results_for_hit_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$list_review_policy_results_for_hit <- mturk_list_review_policy_results_for_hit

#' The ListReviewableHITs operation retrieves the HITs with Status equal to
#' Reviewable or Status equal to Reviewing that belong to the Requester
#' calling the operation
#'
#' The `ListReviewableHITs` operation retrieves the HITs with Status equal
#' to Reviewable or Status equal to Reviewing that belong to the Requester
#' calling the operation.
#'
#' @usage
#' mturk_list_reviewable_hi_ts(HITTypeId, Status, NextToken, MaxResults)
#'
#' @param HITTypeId The ID of the HIT type of the HITs to consider for the query. If not
#' specified, all HITs for the Reviewer are considered
#' @param Status Can be either `Reviewable` or `Reviewing`. Reviewable is the default
#' value.
#' @param NextToken Pagination Token
#' @param MaxResults Limit the number of results returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_reviewable_hi_ts(
#'   HITTypeId = "string",
#'   Status = "Reviewable"|"Reviewing",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_list_reviewable_hi_ts
mturk_list_reviewable_hi_ts <- function(HITTypeId = NULL, Status = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListReviewableHITs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$list_reviewable_hi_ts_input(HITTypeId = HITTypeId, Status = Status, NextToken = NextToken, MaxResults = MaxResults)
  output <- .mturk$list_reviewable_hi_ts_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$list_reviewable_hi_ts <- mturk_list_reviewable_hi_ts

#' The ListWorkersBlocks operation retrieves a list of Workers who are
#' blocked from working on your HITs
#'
#' The `ListWorkersBlocks` operation retrieves a list of Workers who are
#' blocked from working on your HITs.
#'
#' @usage
#' mturk_list_worker_blocks(NextToken, MaxResults)
#'
#' @param NextToken Pagination token
#' @param MaxResults 
#'
#' @section Request syntax:
#' ```
#' svc$list_worker_blocks(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_list_worker_blocks
mturk_list_worker_blocks <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkerBlocks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$list_worker_blocks_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .mturk$list_worker_blocks_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$list_worker_blocks <- mturk_list_worker_blocks

#' The ListWorkersWithQualificationType operation returns all of the
#' Workers that have been associated with a given Qualification type
#'
#' The `ListWorkersWithQualificationType` operation returns all of the
#' Workers that have been associated with a given Qualification type.
#'
#' @usage
#' mturk_list_workers_with_qualification_type(QualificationTypeId, Status,
#'   NextToken, MaxResults)
#'
#' @param QualificationTypeId &#91;required&#93; The ID of the Qualification type of the Qualifications to return.
#' @param Status The status of the Qualifications to return. Can be `Granted | Revoked`.
#' @param NextToken Pagination Token
#' @param MaxResults Limit the number of results returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_workers_with_qualification_type(
#'   QualificationTypeId = "string",
#'   Status = "Granted"|"Revoked",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_list_workers_with_qualification_type
mturk_list_workers_with_qualification_type <- function(QualificationTypeId, Status = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkersWithQualificationType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$list_workers_with_qualification_type_input(QualificationTypeId = QualificationTypeId, Status = Status, NextToken = NextToken, MaxResults = MaxResults)
  output <- .mturk$list_workers_with_qualification_type_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$list_workers_with_qualification_type <- mturk_list_workers_with_qualification_type

#' The NotifyWorkers operation sends an email to one or more Workers that
#' you specify with the Worker ID
#'
#' The `NotifyWorkers` operation sends an email to one or more Workers that
#' you specify with the Worker ID. You can specify up to 100 Worker IDs to
#' send the same message with a single call to the NotifyWorkers operation.
#' The NotifyWorkers operation will send a notification email to a Worker
#' only if you have previously approved or rejected work from the Worker.
#'
#' @usage
#' mturk_notify_workers(Subject, MessageText, WorkerIds)
#'
#' @param Subject &#91;required&#93; The subject line of the email message to send. Can include up to 200
#' characters.
#' @param MessageText &#91;required&#93; The text of the email message to send. Can include up to 4,096
#' characters
#' @param WorkerIds &#91;required&#93; A list of Worker IDs you wish to notify. You can notify upto 100 Workers
#' at a time.
#'
#' @section Request syntax:
#' ```
#' svc$notify_workers(
#'   Subject = "string",
#'   MessageText = "string",
#'   WorkerIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_notify_workers
mturk_notify_workers <- function(Subject, MessageText, WorkerIds) {
  op <- new_operation(
    name = "NotifyWorkers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$notify_workers_input(Subject = Subject, MessageText = MessageText, WorkerIds = WorkerIds)
  output <- .mturk$notify_workers_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$notify_workers <- mturk_notify_workers

#' The RejectAssignment operation rejects the results of a completed
#' assignment
#'
#' The `RejectAssignment` operation rejects the results of a completed
#' assignment.
#' 
#' You can include an optional feedback message with the rejection, which
#' the Worker can see in the Status section of the web site. When you
#' include a feedback message with the rejection, it helps the Worker
#' understand why the assignment was rejected, and can improve the quality
#' of the results the Worker submits in the future.
#' 
#' Only the Requester who created the HIT can reject an assignment for the
#' HIT.
#'
#' @usage
#' mturk_reject_assignment(AssignmentId, RequesterFeedback)
#'
#' @param AssignmentId &#91;required&#93; The ID of the assignment. The assignment must correspond to a HIT
#' created by the Requester.
#' @param RequesterFeedback &#91;required&#93; A message for the Worker, which the Worker can see in the Status section
#' of the web site.
#'
#' @section Request syntax:
#' ```
#' svc$reject_assignment(
#'   AssignmentId = "string",
#'   RequesterFeedback = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_reject_assignment
mturk_reject_assignment <- function(AssignmentId, RequesterFeedback) {
  op <- new_operation(
    name = "RejectAssignment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$reject_assignment_input(AssignmentId = AssignmentId, RequesterFeedback = RequesterFeedback)
  output <- .mturk$reject_assignment_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$reject_assignment <- mturk_reject_assignment

#' The RejectQualificationRequest operation rejects a user's request for a
#' Qualification
#'
#' The `RejectQualificationRequest` operation rejects a user\'s request for
#' a Qualification.
#' 
#' You can provide a text message explaining why the request was rejected.
#' The Worker who made the request can see this message.
#'
#' @usage
#' mturk_reject_qualification_request(QualificationRequestId, Reason)
#'
#' @param QualificationRequestId &#91;required&#93; The ID of the Qualification request, as returned by the
#' `ListQualificationRequests` operation.
#' @param Reason A text message explaining why the request was rejected, to be shown to
#' the Worker who made the request.
#'
#' @section Request syntax:
#' ```
#' svc$reject_qualification_request(
#'   QualificationRequestId = "string",
#'   Reason = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_reject_qualification_request
mturk_reject_qualification_request <- function(QualificationRequestId, Reason = NULL) {
  op <- new_operation(
    name = "RejectQualificationRequest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$reject_qualification_request_input(QualificationRequestId = QualificationRequestId, Reason = Reason)
  output <- .mturk$reject_qualification_request_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$reject_qualification_request <- mturk_reject_qualification_request

#' The SendBonus operation issues a payment of money from your account to a
#' Worker
#'
#' The `SendBonus` operation issues a payment of money from your account to
#' a Worker. This payment happens separately from the reward you pay to the
#' Worker when you approve the Worker\'s assignment. The SendBonus
#' operation requires the Worker\'s ID and the assignment ID as parameters
#' to initiate payment of the bonus. You must include a message that
#' explains the reason for the bonus payment, as the Worker may not be
#' expecting the payment. Amazon Mechanical Turk collects a fee for bonus
#' payments, similar to the HIT listing fee. This operation fails if your
#' account does not have enough funds to pay for both the bonus and the
#' fees.
#'
#' @usage
#' mturk_send_bonus(WorkerId, BonusAmount, AssignmentId, Reason,
#'   UniqueRequestToken)
#'
#' @param WorkerId &#91;required&#93; The ID of the Worker being paid the bonus.
#' @param BonusAmount &#91;required&#93; The Bonus amount is a US Dollar amount specified using a string (for
#' example, \"5\" represents \\$5.00 USD and \"101.42\" represents \\$101.42
#' USD). Do not include currency symbols or currency codes.
#' @param AssignmentId &#91;required&#93; The ID of the assignment for which this bonus is paid.
#' @param Reason &#91;required&#93; A message that explains the reason for the bonus payment. The Worker
#' receiving the bonus can see this message.
#' @param UniqueRequestToken A unique identifier for this request, which allows you to retry the call
#' on error without granting multiple bonuses. This is useful in cases such
#' as network timeouts where it is unclear whether or not the call
#' succeeded on the server. If the bonus already exists in the system from
#' a previous call using the same UniqueRequestToken, subsequent calls will
#' return an error with a message containing the request ID.
#'
#' @section Request syntax:
#' ```
#' svc$send_bonus(
#'   WorkerId = "string",
#'   BonusAmount = "string",
#'   AssignmentId = "string",
#'   Reason = "string",
#'   UniqueRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_send_bonus
mturk_send_bonus <- function(WorkerId, BonusAmount, AssignmentId, Reason, UniqueRequestToken = NULL) {
  op <- new_operation(
    name = "SendBonus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$send_bonus_input(WorkerId = WorkerId, BonusAmount = BonusAmount, AssignmentId = AssignmentId, Reason = Reason, UniqueRequestToken = UniqueRequestToken)
  output <- .mturk$send_bonus_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$send_bonus <- mturk_send_bonus

#' The SendTestEventNotification operation causes Amazon Mechanical Turk to
#' send a notification message as if a HIT event occurred, according to the
#' provided notification specification
#'
#' The `SendTestEventNotification` operation causes Amazon Mechanical Turk
#' to send a notification message as if a HIT event occurred, according to
#' the provided notification specification. This allows you to test
#' notifications without setting up notifications for a real HIT type and
#' trying to trigger them using the website. When you call this operation,
#' the service attempts to send the test notification immediately.
#'
#' @usage
#' mturk_send_test_event_notification(Notification, TestEventType)
#'
#' @param Notification &#91;required&#93; The notification specification to test. This value is identical to the
#' value you would provide to the UpdateNotificationSettings operation when
#' you establish the notification specification for a HIT type.
#' @param TestEventType &#91;required&#93; The event to simulate to test the notification specification. This event
#' is included in the test message even if the notification specification
#' does not include the event type. The notification specification does not
#' filter out the test event.
#'
#' @section Request syntax:
#' ```
#' svc$send_test_event_notification(
#'   Notification = list(
#'     Destination = "string",
#'     Transport = "Email"|"SQS"|"SNS",
#'     Version = "string",
#'     EventTypes = list(
#'       "AssignmentAccepted"|"AssignmentAbandoned"|"AssignmentReturned"|"AssignmentSubmitted"|"AssignmentRejected"|"AssignmentApproved"|"HITCreated"|"HITExpired"|"HITReviewable"|"HITExtended"|"HITDisposed"|"Ping"
#'     )
#'   ),
#'   TestEventType = "AssignmentAccepted"|"AssignmentAbandoned"|"AssignmentReturned"|"AssignmentSubmitted"|"AssignmentRejected"|"AssignmentApproved"|"HITCreated"|"HITExpired"|"HITReviewable"|"HITExtended"|"HITDisposed"|"Ping"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_send_test_event_notification
mturk_send_test_event_notification <- function(Notification, TestEventType) {
  op <- new_operation(
    name = "SendTestEventNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$send_test_event_notification_input(Notification = Notification, TestEventType = TestEventType)
  output <- .mturk$send_test_event_notification_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$send_test_event_notification <- mturk_send_test_event_notification

#' The UpdateExpirationForHIT operation allows you update the expiration
#' time of a HIT
#'
#' The `UpdateExpirationForHIT` operation allows you update the expiration
#' time of a HIT. If you update it to a time in the past, the HIT will be
#' immediately expired.
#'
#' @usage
#' mturk_update_expiration_for_hit(HITId, ExpireAt)
#'
#' @param HITId &#91;required&#93; The HIT to update.
#' @param ExpireAt &#91;required&#93; The date and time at which you want the HIT to expire
#'
#' @section Request syntax:
#' ```
#' svc$update_expiration_for_hit(
#'   HITId = "string",
#'   ExpireAt = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_update_expiration_for_hit
mturk_update_expiration_for_hit <- function(HITId, ExpireAt) {
  op <- new_operation(
    name = "UpdateExpirationForHIT",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$update_expiration_for_hit_input(HITId = HITId, ExpireAt = ExpireAt)
  output <- .mturk$update_expiration_for_hit_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$update_expiration_for_hit <- mturk_update_expiration_for_hit

#' The UpdateHITReviewStatus operation updates the status of a HIT
#'
#' The `UpdateHITReviewStatus` operation updates the status of a HIT. If
#' the status is Reviewable, this operation can update the status to
#' Reviewing, or it can revert a Reviewing HIT back to the Reviewable
#' status.
#'
#' @usage
#' mturk_update_hit_review_status(HITId, Revert)
#'
#' @param HITId &#91;required&#93; The ID of the HIT to update.
#' @param Revert Specifies how to update the HIT status. Default is `False`.
#' 
#' -   Setting this to false will only transition a HIT from `Reviewable`
#'     to `Reviewing`
#' 
#' -   Setting this to true will only transition a HIT from `Reviewing` to
#'     `Reviewable`
#'
#' @section Request syntax:
#' ```
#' svc$update_hit_review_status(
#'   HITId = "string",
#'   Revert = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_update_hit_review_status
mturk_update_hit_review_status <- function(HITId, Revert = NULL) {
  op <- new_operation(
    name = "UpdateHITReviewStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$update_hit_review_status_input(HITId = HITId, Revert = Revert)
  output <- .mturk$update_hit_review_status_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$update_hit_review_status <- mturk_update_hit_review_status

#' The UpdateHITTypeOfHIT operation allows you to change the HITType
#' properties of a HIT
#'
#' The `UpdateHITTypeOfHIT` operation allows you to change the HITType
#' properties of a HIT. This operation disassociates the HIT from its old
#' HITType properties and associates it with the new HITType properties.
#' The HIT takes on the properties of the new HITType in place of the old
#' ones.
#'
#' @usage
#' mturk_update_hit_type_of_hit(HITId, HITTypeId)
#'
#' @param HITId &#91;required&#93; The HIT to update.
#' @param HITTypeId &#91;required&#93; The ID of the new HIT type.
#'
#' @section Request syntax:
#' ```
#' svc$update_hit_type_of_hit(
#'   HITId = "string",
#'   HITTypeId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_update_hit_type_of_hit
mturk_update_hit_type_of_hit <- function(HITId, HITTypeId) {
  op <- new_operation(
    name = "UpdateHITTypeOfHIT",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$update_hit_type_of_hit_input(HITId = HITId, HITTypeId = HITTypeId)
  output <- .mturk$update_hit_type_of_hit_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$update_hit_type_of_hit <- mturk_update_hit_type_of_hit

#' The UpdateNotificationSettings operation creates, updates, disables or
#' re-enables notifications for a HIT type
#'
#' The `UpdateNotificationSettings` operation creates, updates, disables or
#' re-enables notifications for a HIT type. If you call the
#' UpdateNotificationSettings operation for a HIT type that already has a
#' notification specification, the operation replaces the old specification
#' with a new one. You can call the UpdateNotificationSettings operation to
#' enable or disable notifications for the HIT type, without having to
#' modify the notification specification itself by providing updates to the
#' Active status without specifying a new notification specification. To
#' change the Active status of a HIT type\'s notifications, the HIT type
#' must already have a notification specification, or one must be provided
#' in the same call to `UpdateNotificationSettings`.
#'
#' @usage
#' mturk_update_notification_settings(HITTypeId, Notification, Active)
#'
#' @param HITTypeId &#91;required&#93; The ID of the HIT type whose notification specification is being
#' updated.
#' @param Notification The notification specification for the HIT type.
#' @param Active Specifies whether notifications are sent for HITs of this HIT type,
#' according to the notification specification. You must specify either the
#' Notification parameter or the Active parameter for the call to
#' UpdateNotificationSettings to succeed.
#'
#' @section Request syntax:
#' ```
#' svc$update_notification_settings(
#'   HITTypeId = "string",
#'   Notification = list(
#'     Destination = "string",
#'     Transport = "Email"|"SQS"|"SNS",
#'     Version = "string",
#'     EventTypes = list(
#'       "AssignmentAccepted"|"AssignmentAbandoned"|"AssignmentReturned"|"AssignmentSubmitted"|"AssignmentRejected"|"AssignmentApproved"|"HITCreated"|"HITExpired"|"HITReviewable"|"HITExtended"|"HITDisposed"|"Ping"
#'     )
#'   ),
#'   Active = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_update_notification_settings
mturk_update_notification_settings <- function(HITTypeId, Notification = NULL, Active = NULL) {
  op <- new_operation(
    name = "UpdateNotificationSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$update_notification_settings_input(HITTypeId = HITTypeId, Notification = Notification, Active = Active)
  output <- .mturk$update_notification_settings_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$update_notification_settings <- mturk_update_notification_settings

#' The UpdateQualificationType operation modifies the attributes of an
#' existing Qualification type, which is represented by a QualificationType
#' data structure
#'
#' The `UpdateQualificationType` operation modifies the attributes of an
#' existing Qualification type, which is represented by a QualificationType
#' data structure. Only the owner of a Qualification type can modify its
#' attributes.
#' 
#' Most attributes of a Qualification type can be changed after the type
#' has been created. However, the Name and Keywords fields cannot be
#' modified. The RetryDelayInSeconds parameter can be modified or added to
#' change the delay or to enable retries, but RetryDelayInSeconds cannot be
#' used to disable retries.
#' 
#' You can use this operation to update the test for a Qualification type.
#' The test is updated based on the values specified for the Test,
#' TestDurationInSeconds and AnswerKey parameters. All three parameters
#' specify the updated test. If you are updating the test for a type, you
#' must specify the Test and TestDurationInSeconds parameters. The
#' AnswerKey parameter is optional; omitting it specifies that the updated
#' test does not have an answer key.
#' 
#' If you omit the Test parameter, the test for the Qualification type is
#' unchanged. There is no way to remove a test from a Qualification type
#' that has one. If the type already has a test, you cannot update it to be
#' AutoGranted. If the Qualification type does not have a test and one is
#' provided by an update, the type will henceforth have a test.
#' 
#' If you want to update the test duration or answer key for an existing
#' test without changing the questions, you must specify a Test parameter
#' with the original questions, along with the updated values.
#' 
#' If you provide an updated Test but no AnswerKey, the new test will not
#' have an answer key. Requests for such Qualifications must be granted
#' manually.
#' 
#' You can also update the AutoGranted and AutoGrantedValue attributes of
#' the Qualification type.
#'
#' @usage
#' mturk_update_qualification_type(QualificationTypeId, Description,
#'   QualificationTypeStatus, Test, AnswerKey, TestDurationInSeconds,
#'   RetryDelayInSeconds, AutoGranted, AutoGrantedValue)
#'
#' @param QualificationTypeId &#91;required&#93; The ID of the Qualification type to update.
#' @param Description The new description of the Qualification type.
#' @param QualificationTypeStatus The new status of the Qualification type - Active \\| Inactive
#' @param Test The questions for the Qualification test a Worker must answer correctly
#' to obtain a Qualification of this type. If this parameter is specified,
#' `TestDurationInSeconds` must also be specified.
#' 
#' Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm
#' data structure. This parameter cannot be specified if AutoGranted is
#' true.
#' 
#' Constraints: None. If not specified, the Worker may request the
#' Qualification without answering any questions.
#' @param AnswerKey The answers to the Qualification test specified in the Test parameter,
#' in the form of an AnswerKey data structure.
#' @param TestDurationInSeconds The number of seconds the Worker has to complete the Qualification test,
#' starting from the time the Worker requests the Qualification.
#' @param RetryDelayInSeconds The amount of time, in seconds, that Workers must wait after requesting
#' a Qualification of the specified Qualification type before they can
#' retry the Qualification request. It is not possible to disable retries
#' for a Qualification type after it has been created with retries enabled.
#' If you want to disable retries, you must dispose of the existing
#' retry-enabled Qualification type using DisposeQualificationType and then
#' create a new Qualification type with retries disabled using
#' CreateQualificationType.
#' @param AutoGranted Specifies whether requests for the Qualification type are granted
#' immediately, without prompting the Worker with a Qualification test.
#' 
#' Constraints: If the Test parameter is specified, this parameter cannot
#' be true.
#' @param AutoGrantedValue The Qualification value to use for automatically granted Qualifications.
#' This parameter is used only if the AutoGranted parameter is true.
#'
#' @section Request syntax:
#' ```
#' svc$update_qualification_type(
#'   QualificationTypeId = "string",
#'   Description = "string",
#'   QualificationTypeStatus = "Active"|"Inactive",
#'   Test = "string",
#'   AnswerKey = "string",
#'   TestDurationInSeconds = 123,
#'   RetryDelayInSeconds = 123,
#'   AutoGranted = TRUE|FALSE,
#'   AutoGrantedValue = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mturk_update_qualification_type
mturk_update_qualification_type <- function(QualificationTypeId, Description = NULL, QualificationTypeStatus = NULL, Test = NULL, AnswerKey = NULL, TestDurationInSeconds = NULL, RetryDelayInSeconds = NULL, AutoGranted = NULL, AutoGrantedValue = NULL) {
  op <- new_operation(
    name = "UpdateQualificationType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .mturk$update_qualification_type_input(QualificationTypeId = QualificationTypeId, Description = Description, QualificationTypeStatus = QualificationTypeStatus, Test = Test, AnswerKey = AnswerKey, TestDurationInSeconds = TestDurationInSeconds, RetryDelayInSeconds = RetryDelayInSeconds, AutoGranted = AutoGranted, AutoGrantedValue = AutoGrantedValue)
  output <- .mturk$update_qualification_type_output()
  config <- get_config()
  svc <- .mturk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mturk$operations$update_qualification_type <- mturk_update_qualification_type
