% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_data_source}
\alias{quicksight_create_data_source}
\title{Creates a data source}
\usage{
quicksight_create_data_source(AwsAccountId, DataSourceId, Name, Type,
  DataSourceParameters, Credentials, Permissions, VpcConnectionProperties,
  SslProperties, Tags)
}
\arguments{
\item{AwsAccountId}{[required] The AWS account ID.}

\item{DataSourceId}{[required] An ID for the data source. This ID is unique per AWS Region for each AWS
account.}

\item{Name}{[required] A display name for the data source.}

\item{Type}{[required] The type of the data source. Currently, the supported types for this
operation are:
\verb{ATHENA, AURORA, AURORA_POSTGRESQL, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA}.
Use \code{ListDataSources} to return a list of all data sources.}

\item{DataSourceParameters}{The parameters that QuickSight uses to connect to your underlying
source.}

\item{Credentials}{The credentials QuickSight that uses to connect to your underlying
source. Currently, only credentials based on user name and password are
supported.}

\item{Permissions}{A list of resource permissions on the data source.}

\item{VpcConnectionProperties}{Use this parameter only when you want QuickSight to use a VPC connection
when connecting to your underlying source.}

\item{SslProperties}{Secure Socket Layer (SSL) properties that apply when QuickSight connects
to your underlying source.}

\item{Tags}{Contains a map of the key-value pairs for the resource tag or tags
assigned to the data source.}
}
\description{
Creates a data source.
}
\section{Request syntax}{
\preformatted{svc$create_data_source(
  AwsAccountId = "string",
  DataSourceId = "string",
  Name = "string",
  Type = "ADOBE_ANALYTICS"|"AMAZON_ELASTICSEARCH"|"ATHENA"|"AURORA"|"AURORA_POSTGRESQL"|"AWS_IOT_ANALYTICS"|"GITHUB"|"JIRA"|"MARIADB"|"MYSQL"|"POSTGRESQL"|"PRESTO"|"REDSHIFT"|"S3"|"SALESFORCE"|"SERVICENOW"|"SNOWFLAKE"|"SPARK"|"SQLSERVER"|"TERADATA"|"TWITTER",
  DataSourceParameters = list(
    AmazonElasticsearchParameters = list(
      Domain = "string"
    ),
    AthenaParameters = list(
      WorkGroup = "string"
    ),
    AuroraParameters = list(
      Host = "string",
      Port = 123,
      Database = "string"
    ),
    AuroraPostgreSqlParameters = list(
      Host = "string",
      Port = 123,
      Database = "string"
    ),
    AwsIotAnalyticsParameters = list(
      DataSetName = "string"
    ),
    JiraParameters = list(
      SiteBaseUrl = "string"
    ),
    MariaDbParameters = list(
      Host = "string",
      Port = 123,
      Database = "string"
    ),
    MySqlParameters = list(
      Host = "string",
      Port = 123,
      Database = "string"
    ),
    PostgreSqlParameters = list(
      Host = "string",
      Port = 123,
      Database = "string"
    ),
    PrestoParameters = list(
      Host = "string",
      Port = 123,
      Catalog = "string"
    ),
    RdsParameters = list(
      InstanceId = "string",
      Database = "string"
    ),
    RedshiftParameters = list(
      Host = "string",
      Port = 123,
      Database = "string",
      ClusterId = "string"
    ),
    S3Parameters = list(
      ManifestFileLocation = list(
        Bucket = "string",
        Key = "string"
      )
    ),
    ServiceNowParameters = list(
      SiteBaseUrl = "string"
    ),
    SnowflakeParameters = list(
      Host = "string",
      Database = "string",
      Warehouse = "string"
    ),
    SparkParameters = list(
      Host = "string",
      Port = 123
    ),
    SqlServerParameters = list(
      Host = "string",
      Port = 123,
      Database = "string"
    ),
    TeradataParameters = list(
      Host = "string",
      Port = 123,
      Database = "string"
    ),
    TwitterParameters = list(
      Query = "string",
      MaxRows = 123
    )
  ),
  Credentials = list(
    CredentialPair = list(
      Username = "string",
      Password = "string"
    )
  ),
  Permissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  ),
  VpcConnectionProperties = list(
    VpcConnectionArn = "string"
  ),
  SslProperties = list(
    DisableSsl = TRUE|FALSE
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
