% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_put_record}
\alias{firehose_put_record}
\title{Writes a single data record into an Amazon Kinesis Data Firehose
delivery stream}
\usage{
firehose_put_record(DeliveryStreamName, Record)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream.}

\item{Record}{[required] The record.}
}
\description{
Writes a single data record into an Amazon Kinesis Data Firehose
delivery stream. To write multiple data records into a delivery stream,
use PutRecordBatch. Applications using these operations are referred to
as producers.
}
\details{
By default, each delivery stream can take in up to 2,000 transactions
per second, 5,000 records per second, or 5 MB per second. If you use
PutRecord and PutRecordBatch, the limits are an aggregate across these
two operations for each delivery stream. For more information about
limits and how to request an increase, see \href{https://docs.aws.amazon.com/firehose/latest/dev/limits.html}{Amazon Kinesis Data Firehose Limits}.

You must specify the name of the delivery stream and the data record
when using PutRecord. The data record consists of a data blob that can
be up to 1,000 KB in size, and any kind of data. For example, it can be
a segment from a log file, geographic location data, website clickstream
data, and so on.

Kinesis Data Firehose buffers records before delivering them to the
destination. To disambiguate the data blobs at the destination, a common
solution is to use delimiters in the data, such as a newline (\verb{\\\\n}) or
some other character unique within the data. This allows the consumer
application to parse individual data items when reading the data from
the destination.

The \code{PutRecord} operation returns a \code{RecordId}, which is a unique string
assigned to each record. Producer applications can use this ID for
purposes such as auditability and investigation.

If the \code{PutRecord} operation throws a \code{ServiceUnavailableException},
back off and retry. If the exception persists, it is possible that the
throughput limits have been exceeded for the delivery stream.

Data records sent to Kinesis Data Firehose are stored for 24 hours from
the time they are added to a delivery stream as it tries to send the
records to the destination. If the destination is unreachable for more
than 24 hours, the data is no longer available.

Don\'t concatenate two or more base64 strings to form the data fields of
your records. Instead, concatenate the raw data, then perform base64
encoding.
}
\section{Request syntax}{
\preformatted{svc$put_record(
  DeliveryStreamName = "string",
  Record = list(
    Data = raw
  )
)
}
}

\keyword{internal}
