# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include athena_service.R
NULL

#' Returns the details of a single named query or a list of up to 50
#' queries, which you provide as an array of query ID strings
#'
#' @description
#' Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Requires you to have access to the workgroup in which the queries were saved. Use ListNamedQueriesInput to get the list of named query IDs in the specified workgroup. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under UnprocessedNamedQueryId. Named queries differ from executed queries. Use BatchGetQueryExecutionInput to get details about each unique query execution, and ListQueryExecutionsInput to get a list of query execution IDs.
#'
#' See [https://paws-r.github.io/docs/athena/batch_get_named_query.html](https://paws-r.github.io/docs/athena/batch_get_named_query.html) for full documentation.
#'
#' @param NamedQueryIds &#91;required&#93; An array of query IDs.
#'
#' @keywords internal
#'
#' @rdname athena_batch_get_named_query
athena_batch_get_named_query <- function(NamedQueryIds) {
  op <- new_operation(
    name = "BatchGetNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$batch_get_named_query_input(NamedQueryIds = NamedQueryIds)
  output <- .athena$batch_get_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$batch_get_named_query <- athena_batch_get_named_query

#' Returns the details of a single prepared statement or a list of up to
#' 256 prepared statements for the array of prepared statement names that
#' you provide
#'
#' @description
#' Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in `UnprocessedPreparedStatementNames`.
#'
#' See [https://paws-r.github.io/docs/athena/batch_get_prepared_statement.html](https://paws-r.github.io/docs/athena/batch_get_prepared_statement.html) for full documentation.
#'
#' @param PreparedStatementNames &#91;required&#93; A list of prepared statement names to return.
#' @param WorkGroup &#91;required&#93; The name of the workgroup to which the prepared statements belong.
#'
#' @keywords internal
#'
#' @rdname athena_batch_get_prepared_statement
athena_batch_get_prepared_statement <- function(PreparedStatementNames, WorkGroup) {
  op <- new_operation(
    name = "BatchGetPreparedStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$batch_get_prepared_statement_input(PreparedStatementNames = PreparedStatementNames, WorkGroup = WorkGroup)
  output <- .athena$batch_get_prepared_statement_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$batch_get_prepared_statement <- athena_batch_get_prepared_statement

#' Returns the details of a single query execution or a list of up to 50
#' query executions, which you provide as an array of query execution ID
#' strings
#'
#' @description
#' Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup. Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput to get details about named queries.
#'
#' See [https://paws-r.github.io/docs/athena/batch_get_query_execution.html](https://paws-r.github.io/docs/athena/batch_get_query_execution.html) for full documentation.
#'
#' @param QueryExecutionIds &#91;required&#93; An array of query execution IDs.
#'
#' @keywords internal
#'
#' @rdname athena_batch_get_query_execution
athena_batch_get_query_execution <- function(QueryExecutionIds) {
  op <- new_operation(
    name = "BatchGetQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$batch_get_query_execution_input(QueryExecutionIds = QueryExecutionIds)
  output <- .athena$batch_get_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$batch_get_query_execution <- athena_batch_get_query_execution

#' Creates (registers) a data catalog with the specified name and
#' properties
#'
#' @description
#' Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/athena/create_data_catalog.html](https://paws-r.github.io/docs/athena/create_data_catalog.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the data catalog to create. The catalog name must be unique
#' for the Amazon Web Services account and can use a maximum of 127
#' alphanumeric, underscore, at sign, or hyphen characters. The remainder
#' of the length constraint of 256 is reserved for use by Athena.
#' @param Type &#91;required&#93; The type of data catalog to create: `LAMBDA` for a federated catalog,
#' `HIVE` for an external hive metastore, or `GLUE` for an Glue Data
#' Catalog.
#' @param Description A description of the data catalog to be created.
#' @param Parameters Specifies the Lambda function or functions to use for creating the data
#' catalog. This is a mapping whose values depend on the catalog type.
#' 
#' -   For the `HIVE` data catalog type, use the following syntax. The
#'     `metadata-function` parameter is required. `The sdk-version`
#'     parameter is optional and defaults to the currently supported
#'     version.
#' 
#'     `metadata-function=lambda_arn, sdk-version=version_number `
#' 
#' -   For the `LAMBDA` data catalog type, use one of the following sets of
#'     required parameters, but not both.
#' 
#'     -   If you have one Lambda function that processes metadata and
#'         another for reading the actual data, use the following syntax.
#'         Both parameters are required.
#' 
#'         `metadata-function=lambda_arn, record-function=lambda_arn `
#' 
#'     -   If you have a composite Lambda function that processes both
#'         metadata and data, use the following syntax to specify your
#'         Lambda function.
#' 
#'         `function=lambda_arn `
#' 
#' -   The `GLUE` type takes a catalog ID parameter and is required. The
#'     ` catalog_id ` is the account ID of the Amazon Web Services account
#'     to which the Glue Data Catalog belongs.
#' 
#'     `catalog-id=catalog_id `
#' 
#'     -   The `GLUE` data catalog type also applies to the default
#'         `AwsDataCatalog` that already exists in your account, of which
#'         you can have only one and cannot modify.
#' 
#'     -   Queries that specify a Glue Data Catalog other than the default
#'         `AwsDataCatalog` must be run on Athena engine version 2.
#' 
#'     -   In Regions where Athena engine version 2 is not available,
#'         creating new Glue data catalogs results in an `INVALID_INPUT`
#'         error.
#' @param Tags A list of comma separated tags to add to the data catalog that is
#' created.
#'
#' @keywords internal
#'
#' @rdname athena_create_data_catalog
athena_create_data_catalog <- function(Name, Type, Description = NULL, Parameters = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_data_catalog_input(Name = Name, Type = Type, Description = Description, Parameters = Parameters, Tags = Tags)
  output <- .athena$create_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_data_catalog <- athena_create_data_catalog

#' Creates a named query in the specified workgroup
#'
#' @description
#' Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
#'
#' See [https://paws-r.github.io/docs/athena/create_named_query.html](https://paws-r.github.io/docs/athena/create_named_query.html) for full documentation.
#'
#' @param Name &#91;required&#93; The query name.
#' @param Description The query description.
#' @param Database &#91;required&#93; The database to which the query belongs.
#' @param QueryString &#91;required&#93; The contents of the query with all query statements.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' query is idempotent (executes only once). If another
#' [`create_named_query`][athena_create_named_query] request is received,
#' the same response is returned and another query is not created. If a
#' parameter has changed, for example, the `QueryString`, an error is
#' returned.
#' 
#' This token is listed as not required because Amazon Web Services SDKs
#' (for example the Amazon Web Services SDK for Java) auto-generate the
#' token for users. If you are not using the Amazon Web Services SDK or the
#' Amazon Web Services CLI, you must provide this token or the action will
#' fail.
#' @param WorkGroup The name of the workgroup in which the named query is being created.
#'
#' @keywords internal
#'
#' @rdname athena_create_named_query
athena_create_named_query <- function(Name, Description = NULL, Database, QueryString, ClientRequestToken = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "CreateNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_named_query_input(Name = Name, Description = Description, Database = Database, QueryString = QueryString, ClientRequestToken = ClientRequestToken, WorkGroup = WorkGroup)
  output <- .athena$create_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_named_query <- athena_create_named_query

#' Creates a prepared statement for use with SQL queries in Athena
#'
#' @description
#' Creates a prepared statement for use with SQL queries in Athena.
#'
#' See [https://paws-r.github.io/docs/athena/create_prepared_statement.html](https://paws-r.github.io/docs/athena/create_prepared_statement.html) for full documentation.
#'
#' @param StatementName &#91;required&#93; The name of the prepared statement.
#' @param WorkGroup &#91;required&#93; The name of the workgroup to which the prepared statement belongs.
#' @param QueryStatement &#91;required&#93; The query string for the prepared statement.
#' @param Description The description of the prepared statement.
#'
#' @keywords internal
#'
#' @rdname athena_create_prepared_statement
athena_create_prepared_statement <- function(StatementName, WorkGroup, QueryStatement, Description = NULL) {
  op <- new_operation(
    name = "CreatePreparedStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_prepared_statement_input(StatementName = StatementName, WorkGroup = WorkGroup, QueryStatement = QueryStatement, Description = Description)
  output <- .athena$create_prepared_statement_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_prepared_statement <- athena_create_prepared_statement

#' Creates a workgroup with the specified name
#'
#' @description
#' Creates a workgroup with the specified name.
#'
#' See [https://paws-r.github.io/docs/athena/create_work_group.html](https://paws-r.github.io/docs/athena/create_work_group.html) for full documentation.
#'
#' @param Name &#91;required&#93; The workgroup name.
#' @param Configuration The configuration for the workgroup, which includes the location in
#' Amazon S3 where query results are stored, the encryption configuration,
#' if any, used for encrypting query results, whether the Amazon CloudWatch
#' Metrics are enabled for the workgroup, the limit for the amount of bytes
#' scanned (cutoff) per query, if it is specified, and whether workgroup's
#' settings (specified with `EnforceWorkGroupConfiguration`) in the
#' `WorkGroupConfiguration` override client-side settings. See
#' WorkGroupConfiguration$EnforceWorkGroupConfiguration.
#' @param Description The workgroup description.
#' @param Tags A list of comma separated tags to add to the workgroup that is created.
#'
#' @keywords internal
#'
#' @rdname athena_create_work_group
athena_create_work_group <- function(Name, Configuration = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_work_group_input(Name = Name, Configuration = Configuration, Description = Description, Tags = Tags)
  output <- .athena$create_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_work_group <- athena_create_work_group

#' Deletes a data catalog
#'
#' @description
#' Deletes a data catalog.
#'
#' See [https://paws-r.github.io/docs/athena/delete_data_catalog.html](https://paws-r.github.io/docs/athena/delete_data_catalog.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the data catalog to delete.
#'
#' @keywords internal
#'
#' @rdname athena_delete_data_catalog
athena_delete_data_catalog <- function(Name) {
  op <- new_operation(
    name = "DeleteDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_data_catalog_input(Name = Name)
  output <- .athena$delete_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_data_catalog <- athena_delete_data_catalog

#' Deletes the named query if you have access to the workgroup in which the
#' query was saved
#'
#' @description
#' Deletes the named query if you have access to the workgroup in which the query was saved.
#'
#' See [https://paws-r.github.io/docs/athena/delete_named_query.html](https://paws-r.github.io/docs/athena/delete_named_query.html) for full documentation.
#'
#' @param NamedQueryId &#91;required&#93; The unique ID of the query to delete.
#'
#' @keywords internal
#'
#' @rdname athena_delete_named_query
athena_delete_named_query <- function(NamedQueryId) {
  op <- new_operation(
    name = "DeleteNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_named_query_input(NamedQueryId = NamedQueryId)
  output <- .athena$delete_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_named_query <- athena_delete_named_query

#' Deletes the prepared statement with the specified name from the
#' specified workgroup
#'
#' @description
#' Deletes the prepared statement with the specified name from the specified workgroup.
#'
#' See [https://paws-r.github.io/docs/athena/delete_prepared_statement.html](https://paws-r.github.io/docs/athena/delete_prepared_statement.html) for full documentation.
#'
#' @param StatementName &#91;required&#93; The name of the prepared statement to delete.
#' @param WorkGroup &#91;required&#93; The workgroup to which the statement to be deleted belongs.
#'
#' @keywords internal
#'
#' @rdname athena_delete_prepared_statement
athena_delete_prepared_statement <- function(StatementName, WorkGroup) {
  op <- new_operation(
    name = "DeletePreparedStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_prepared_statement_input(StatementName = StatementName, WorkGroup = WorkGroup)
  output <- .athena$delete_prepared_statement_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_prepared_statement <- athena_delete_prepared_statement

#' Deletes the workgroup with the specified name
#'
#' @description
#' Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
#'
#' See [https://paws-r.github.io/docs/athena/delete_work_group.html](https://paws-r.github.io/docs/athena/delete_work_group.html) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The unique name of the workgroup to delete.
#' @param RecursiveDeleteOption The option to delete the workgroup and its contents even if the
#' workgroup contains any named queries or query executions.
#'
#' @keywords internal
#'
#' @rdname athena_delete_work_group
athena_delete_work_group <- function(WorkGroup, RecursiveDeleteOption = NULL) {
  op <- new_operation(
    name = "DeleteWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_work_group_input(WorkGroup = WorkGroup, RecursiveDeleteOption = RecursiveDeleteOption)
  output <- .athena$delete_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_work_group <- athena_delete_work_group

#' Returns the specified data catalog
#'
#' @description
#' Returns the specified data catalog.
#'
#' See [https://paws-r.github.io/docs/athena/get_data_catalog.html](https://paws-r.github.io/docs/athena/get_data_catalog.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the data catalog to return.
#'
#' @keywords internal
#'
#' @rdname athena_get_data_catalog
athena_get_data_catalog <- function(Name) {
  op <- new_operation(
    name = "GetDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_data_catalog_input(Name = Name)
  output <- .athena$get_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_data_catalog <- athena_get_data_catalog

#' Returns a database object for the specified database and data catalog
#'
#' @description
#' Returns a database object for the specified database and data catalog.
#'
#' See [https://paws-r.github.io/docs/athena/get_database.html](https://paws-r.github.io/docs/athena/get_database.html) for full documentation.
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog that contains the database to return.
#' @param DatabaseName &#91;required&#93; The name of the database to return.
#'
#' @keywords internal
#'
#' @rdname athena_get_database
athena_get_database <- function(CatalogName, DatabaseName) {
  op <- new_operation(
    name = "GetDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_database_input(CatalogName = CatalogName, DatabaseName = DatabaseName)
  output <- .athena$get_database_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_database <- athena_get_database

#' Returns information about a single query
#'
#' @description
#' Returns information about a single query. Requires that you have access to the workgroup in which the query was saved.
#'
#' See [https://paws-r.github.io/docs/athena/get_named_query.html](https://paws-r.github.io/docs/athena/get_named_query.html) for full documentation.
#'
#' @param NamedQueryId &#91;required&#93; The unique ID of the query. Use
#' [`list_named_queries`][athena_list_named_queries] to get query IDs.
#'
#' @keywords internal
#'
#' @rdname athena_get_named_query
athena_get_named_query <- function(NamedQueryId) {
  op <- new_operation(
    name = "GetNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_named_query_input(NamedQueryId = NamedQueryId)
  output <- .athena$get_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_named_query <- athena_get_named_query

#' Retrieves the prepared statement with the specified name from the
#' specified workgroup
#'
#' @description
#' Retrieves the prepared statement with the specified name from the specified workgroup.
#'
#' See [https://paws-r.github.io/docs/athena/get_prepared_statement.html](https://paws-r.github.io/docs/athena/get_prepared_statement.html) for full documentation.
#'
#' @param StatementName &#91;required&#93; The name of the prepared statement to retrieve.
#' @param WorkGroup &#91;required&#93; The workgroup to which the statement to be retrieved belongs.
#'
#' @keywords internal
#'
#' @rdname athena_get_prepared_statement
athena_get_prepared_statement <- function(StatementName, WorkGroup) {
  op <- new_operation(
    name = "GetPreparedStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_prepared_statement_input(StatementName = StatementName, WorkGroup = WorkGroup)
  output <- .athena$get_prepared_statement_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_prepared_statement <- athena_get_prepared_statement

#' Returns information about a single execution of a query if you have
#' access to the workgroup in which the query ran
#'
#' @description
#' Returns information about a single execution of a query if you have access to the workgroup in which the query ran. Each time a query executes, information about the query execution is saved with a unique ID.
#'
#' See [https://paws-r.github.io/docs/athena/get_query_execution.html](https://paws-r.github.io/docs/athena/get_query_execution.html) for full documentation.
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution.
#'
#' @keywords internal
#'
#' @rdname athena_get_query_execution
athena_get_query_execution <- function(QueryExecutionId) {
  op <- new_operation(
    name = "GetQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_query_execution_input(QueryExecutionId = QueryExecutionId)
  output <- .athena$get_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_query_execution <- athena_get_query_execution

#' Streams the results of a single query execution specified by
#' QueryExecutionId from the Athena query results location in Amazon S3
#'
#' @description
#' Streams the results of a single query execution specified by `QueryExecutionId` from the Athena query results location in Amazon S3. For more information, see [Query Results](https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the *Amazon Athena User Guide*. This request does not execute the query but returns results. Use [`start_query_execution`][athena_start_query_execution] to run a query.
#'
#' See [https://paws-r.github.io/docs/athena/get_query_results.html](https://paws-r.github.io/docs/athena/get_query_results.html) for full documentation.
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of results (rows) to return in this request.
#'
#' @keywords internal
#'
#' @rdname athena_get_query_results
athena_get_query_results <- function(QueryExecutionId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetQueryResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_query_results_input(QueryExecutionId = QueryExecutionId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$get_query_results_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_query_results <- athena_get_query_results

#' Returns query execution runtime statistics related to a single execution
#' of a query if you have access to the workgroup in which the query ran
#'
#' @description
#' Returns query execution runtime statistics related to a single execution of a query if you have access to the workgroup in which the query ran. The query execution runtime statistics is returned only when QueryExecutionStatus$State is in a SUCCEEDED or FAILED state.
#'
#' See [https://paws-r.github.io/docs/athena/get_query_runtime_statistics.html](https://paws-r.github.io/docs/athena/get_query_runtime_statistics.html) for full documentation.
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution.
#'
#' @keywords internal
#'
#' @rdname athena_get_query_runtime_statistics
athena_get_query_runtime_statistics <- function(QueryExecutionId) {
  op <- new_operation(
    name = "GetQueryRuntimeStatistics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_query_runtime_statistics_input(QueryExecutionId = QueryExecutionId)
  output <- .athena$get_query_runtime_statistics_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_query_runtime_statistics <- athena_get_query_runtime_statistics

#' Returns table metadata for the specified catalog, database, and table
#'
#' @description
#' Returns table metadata for the specified catalog, database, and table.
#'
#' See [https://paws-r.github.io/docs/athena/get_table_metadata.html](https://paws-r.github.io/docs/athena/get_table_metadata.html) for full documentation.
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog that contains the database and table
#' metadata to return.
#' @param DatabaseName &#91;required&#93; The name of the database that contains the table metadata to return.
#' @param TableName &#91;required&#93; The name of the table for which metadata is returned.
#'
#' @keywords internal
#'
#' @rdname athena_get_table_metadata
athena_get_table_metadata <- function(CatalogName, DatabaseName, TableName) {
  op <- new_operation(
    name = "GetTableMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_table_metadata_input(CatalogName = CatalogName, DatabaseName = DatabaseName, TableName = TableName)
  output <- .athena$get_table_metadata_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_table_metadata <- athena_get_table_metadata

#' Returns information about the workgroup with the specified name
#'
#' @description
#' Returns information about the workgroup with the specified name.
#'
#' See [https://paws-r.github.io/docs/athena/get_work_group.html](https://paws-r.github.io/docs/athena/get_work_group.html) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The name of the workgroup.
#'
#' @keywords internal
#'
#' @rdname athena_get_work_group
athena_get_work_group <- function(WorkGroup) {
  op <- new_operation(
    name = "GetWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_work_group_input(WorkGroup = WorkGroup)
  output <- .athena$get_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_work_group <- athena_get_work_group

#' Lists the data catalogs in the current Amazon Web Services account
#'
#' @description
#' Lists the data catalogs in the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/athena/list_data_catalogs.html](https://paws-r.github.io/docs/athena/list_data_catalogs.html) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the NextToken from the response object of the previous
#' page call.
#' @param MaxResults Specifies the maximum number of data catalogs to return.
#'
#' @keywords internal
#'
#' @rdname athena_list_data_catalogs
athena_list_data_catalogs <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDataCatalogs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_data_catalogs_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_data_catalogs_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_data_catalogs <- athena_list_data_catalogs

#' Lists the databases in the specified data catalog
#'
#' @description
#' Lists the databases in the specified data catalog.
#'
#' See [https://paws-r.github.io/docs/athena/list_databases.html](https://paws-r.github.io/docs/athena/list_databases.html) for full documentation.
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog that contains the databases to return.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults Specifies the maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname athena_list_databases
athena_list_databases <- function(CatalogName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDatabases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_databases_input(CatalogName = CatalogName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_databases_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_databases <- athena_list_databases

#' Returns a list of engine versions that are available to choose from,
#' including the Auto option
#'
#' @description
#' Returns a list of engine versions that are available to choose from, including the Auto option.
#'
#' See [https://paws-r.github.io/docs/athena/list_engine_versions.html](https://paws-r.github.io/docs/athena/list_engine_versions.html) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of engine versions to return in this request.
#'
#' @keywords internal
#'
#' @rdname athena_list_engine_versions
athena_list_engine_versions <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEngineVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_engine_versions_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_engine_versions_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_engine_versions <- athena_list_engine_versions

#' Provides a list of available query IDs only for queries saved in the
#' specified workgroup
#'
#' @description
#' Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary workgroup.
#'
#' See [https://paws-r.github.io/docs/athena/list_named_queries.html](https://paws-r.github.io/docs/athena/list_named_queries.html) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of queries to return in this request.
#' @param WorkGroup The name of the workgroup from which the named queries are being
#' returned. If a workgroup is not specified, the saved queries for the
#' primary workgroup are returned.
#'
#' @keywords internal
#'
#' @rdname athena_list_named_queries
athena_list_named_queries <- function(NextToken = NULL, MaxResults = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "ListNamedQueries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_named_queries_input(NextToken = NextToken, MaxResults = MaxResults, WorkGroup = WorkGroup)
  output <- .athena$list_named_queries_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_named_queries <- athena_list_named_queries

#' Lists the prepared statements in the specified workgroup
#'
#' @description
#' Lists the prepared statements in the specified workgroup.
#'
#' See [https://paws-r.github.io/docs/athena/list_prepared_statements.html](https://paws-r.github.io/docs/athena/list_prepared_statements.html) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The workgroup to list the prepared statements for.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname athena_list_prepared_statements
athena_list_prepared_statements <- function(WorkGroup, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPreparedStatements",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_prepared_statements_input(WorkGroup = WorkGroup, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_prepared_statements_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_prepared_statements <- athena_list_prepared_statements

#' Provides a list of available query execution IDs for the queries in the
#' specified workgroup
#'
#' @description
#' Provides a list of available query execution IDs for the queries in the specified workgroup. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran.
#'
#' See [https://paws-r.github.io/docs/athena/list_query_executions.html](https://paws-r.github.io/docs/athena/list_query_executions.html) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of query executions to return in this request.
#' @param WorkGroup The name of the workgroup from which queries are being returned. If a
#' workgroup is not specified, a list of available query execution IDs for
#' the queries in the primary workgroup is returned.
#'
#' @keywords internal
#'
#' @rdname athena_list_query_executions
athena_list_query_executions <- function(NextToken = NULL, MaxResults = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "ListQueryExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_query_executions_input(NextToken = NextToken, MaxResults = MaxResults, WorkGroup = WorkGroup)
  output <- .athena$list_query_executions_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_query_executions <- athena_list_query_executions

#' Lists the metadata for the tables in the specified data catalog database
#'
#' @description
#' Lists the metadata for the tables in the specified data catalog database.
#'
#' See [https://paws-r.github.io/docs/athena/list_table_metadata.html](https://paws-r.github.io/docs/athena/list_table_metadata.html) for full documentation.
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog for which table metadata should be
#' returned.
#' @param DatabaseName &#91;required&#93; The name of the database for which table metadata should be returned.
#' @param Expression A regex filter that pattern-matches table names. If no expression is
#' supplied, metadata for all tables are listed.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the NextToken from the response object of the previous
#' page call.
#' @param MaxResults Specifies the maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname athena_list_table_metadata
athena_list_table_metadata <- function(CatalogName, DatabaseName, Expression = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTableMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_table_metadata_input(CatalogName = CatalogName, DatabaseName = DatabaseName, Expression = Expression, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_table_metadata_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_table_metadata <- athena_list_table_metadata

#' Lists the tags associated with an Athena workgroup or data catalog
#' resource
#'
#' @description
#' Lists the tags associated with an Athena workgroup or data catalog resource.
#'
#' See [https://paws-r.github.io/docs/athena/list_tags_for_resource.html](https://paws-r.github.io/docs/athena/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; Lists the tags for the resource with the specified ARN.
#' @param NextToken The token for the next set of results, or null if there are no
#' additional results for this request, where the request lists the tags
#' for the resource with the specified ARN.
#' @param MaxResults The maximum number of results to be returned per request that lists the
#' tags for the resource.
#'
#' @keywords internal
#'
#' @rdname athena_list_tags_for_resource
athena_list_tags_for_resource <- function(ResourceARN, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_tags_for_resource_input(ResourceARN = ResourceARN, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_tags_for_resource_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_tags_for_resource <- athena_list_tags_for_resource

#' Lists available workgroups for the account
#'
#' @description
#' Lists available workgroups for the account.
#'
#' See [https://paws-r.github.io/docs/athena/list_work_groups.html](https://paws-r.github.io/docs/athena/list_work_groups.html) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of workgroups to return in this request.
#'
#' @keywords internal
#'
#' @rdname athena_list_work_groups
athena_list_work_groups <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_work_groups_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_work_groups_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_work_groups <- athena_list_work_groups

#' Runs the SQL query statements contained in the Query
#'
#' @description
#' Runs the SQL query statements contained in the `Query`. Requires you to have access to the workgroup in which the query ran. Running queries against an external catalog requires [`get_data_catalog`][athena_get_data_catalog] permission to the catalog. For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](https://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
#'
#' See [https://paws-r.github.io/docs/athena/start_query_execution.html](https://paws-r.github.io/docs/athena/start_query_execution.html) for full documentation.
#'
#' @param QueryString &#91;required&#93; The SQL query statements to be executed.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' query is idempotent (executes only once). If another
#' [`start_query_execution`][athena_start_query_execution] request is
#' received, the same response is returned and another query is not
#' created. If a parameter has changed, for example, the `QueryString`, an
#' error is returned.
#' 
#' This token is listed as not required because Amazon Web Services SDKs
#' (for example the Amazon Web Services SDK for Java) auto-generate the
#' token for users. If you are not using the Amazon Web Services SDK or the
#' Amazon Web Services CLI, you must provide this token or the action will
#' fail.
#' @param QueryExecutionContext The database within which the query executes.
#' @param ResultConfiguration Specifies information about where and how to save the results of the
#' query execution. If the query runs in a workgroup, then workgroup's
#' settings may override query settings. This affects the query results
#' location. The workgroup settings override is specified in
#' EnforceWorkGroupConfiguration (true/false) in the
#' WorkGroupConfiguration. See
#' WorkGroupConfiguration$EnforceWorkGroupConfiguration.
#' @param WorkGroup The name of the workgroup in which the query is being started.
#' @param ExecutionParameters A list of values for the parameters in a query. The values are applied
#' sequentially to the parameters in the query in the order in which the
#' parameters occur.
#'
#' @keywords internal
#'
#' @rdname athena_start_query_execution
athena_start_query_execution <- function(QueryString, ClientRequestToken = NULL, QueryExecutionContext = NULL, ResultConfiguration = NULL, WorkGroup = NULL, ExecutionParameters = NULL) {
  op <- new_operation(
    name = "StartQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$start_query_execution_input(QueryString = QueryString, ClientRequestToken = ClientRequestToken, QueryExecutionContext = QueryExecutionContext, ResultConfiguration = ResultConfiguration, WorkGroup = WorkGroup, ExecutionParameters = ExecutionParameters)
  output <- .athena$start_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$start_query_execution <- athena_start_query_execution

#' Stops a query execution
#'
#' @description
#' Stops a query execution. Requires you to have access to the workgroup in which the query ran.
#'
#' See [https://paws-r.github.io/docs/athena/stop_query_execution.html](https://paws-r.github.io/docs/athena/stop_query_execution.html) for full documentation.
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution to stop.
#'
#' @keywords internal
#'
#' @rdname athena_stop_query_execution
athena_stop_query_execution <- function(QueryExecutionId) {
  op <- new_operation(
    name = "StopQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$stop_query_execution_input(QueryExecutionId = QueryExecutionId)
  output <- .athena$stop_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$stop_query_execution <- athena_stop_query_execution

#' Adds one or more tags to an Athena resource
#'
#' @description
#' Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. In Athena, a resource can be a workgroup or data catalog. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups or data catalogs by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter workgroups or data catalogs in your account. For best practices, see [Tagging Best Practices](https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf). Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @@. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas.
#'
#' See [https://paws-r.github.io/docs/athena/tag_resource.html](https://paws-r.github.io/docs/athena/tag_resource.html) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; Specifies the ARN of the Athena resource (workgroup or data catalog) to
#' which tags are to be added.
#' @param Tags &#91;required&#93; A collection of one or more tags, separated by commas, to be added to an
#' Athena workgroup or data catalog resource.
#'
#' @keywords internal
#'
#' @rdname athena_tag_resource
athena_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .athena$tag_resource_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$tag_resource <- athena_tag_resource

#' Removes one or more tags from a data catalog or workgroup resource
#'
#' @description
#' Removes one or more tags from a data catalog or workgroup resource.
#'
#' See [https://paws-r.github.io/docs/athena/untag_resource.html](https://paws-r.github.io/docs/athena/untag_resource.html) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; Specifies the ARN of the resource from which tags are to be removed.
#' @param TagKeys &#91;required&#93; A comma-separated list of one or more tag keys whose tags are to be
#' removed from the specified resource.
#'
#' @keywords internal
#'
#' @rdname athena_untag_resource
athena_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .athena$untag_resource_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$untag_resource <- athena_untag_resource

#' Updates the data catalog that has the specified name
#'
#' @description
#' Updates the data catalog that has the specified name.
#'
#' See [https://paws-r.github.io/docs/athena/update_data_catalog.html](https://paws-r.github.io/docs/athena/update_data_catalog.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the data catalog to update. The catalog name must be unique
#' for the Amazon Web Services account and can use a maximum of 127
#' alphanumeric, underscore, at sign, or hyphen characters. The remainder
#' of the length constraint of 256 is reserved for use by Athena.
#' @param Type &#91;required&#93; Specifies the type of data catalog to update. Specify `LAMBDA` for a
#' federated catalog, `HIVE` for an external hive metastore, or `GLUE` for
#' an Glue Data Catalog.
#' @param Description New or modified text that describes the data catalog.
#' @param Parameters Specifies the Lambda function or functions to use for updating the data
#' catalog. This is a mapping whose values depend on the catalog type.
#' 
#' -   For the `HIVE` data catalog type, use the following syntax. The
#'     `metadata-function` parameter is required. `The sdk-version`
#'     parameter is optional and defaults to the currently supported
#'     version.
#' 
#'     `metadata-function=lambda_arn, sdk-version=version_number `
#' 
#' -   For the `LAMBDA` data catalog type, use one of the following sets of
#'     required parameters, but not both.
#' 
#'     -   If you have one Lambda function that processes metadata and
#'         another for reading the actual data, use the following syntax.
#'         Both parameters are required.
#' 
#'         `metadata-function=lambda_arn, record-function=lambda_arn `
#' 
#'     -   If you have a composite Lambda function that processes both
#'         metadata and data, use the following syntax to specify your
#'         Lambda function.
#' 
#'         `function=lambda_arn `
#'
#' @keywords internal
#'
#' @rdname athena_update_data_catalog
athena_update_data_catalog <- function(Name, Type, Description = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "UpdateDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_data_catalog_input(Name = Name, Type = Type, Description = Description, Parameters = Parameters)
  output <- .athena$update_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_data_catalog <- athena_update_data_catalog

#' Updates a NamedQuery object
#'
#' @description
#' Updates a NamedQuery object. The database or workgroup cannot be updated.
#'
#' See [https://paws-r.github.io/docs/athena/update_named_query.html](https://paws-r.github.io/docs/athena/update_named_query.html) for full documentation.
#'
#' @param NamedQueryId &#91;required&#93; The unique identifier (UUID) of the query.
#' @param Name &#91;required&#93; The name of the query.
#' @param Description The query description.
#' @param QueryString &#91;required&#93; The contents of the query with all query statements.
#'
#' @keywords internal
#'
#' @rdname athena_update_named_query
athena_update_named_query <- function(NamedQueryId, Name, Description = NULL, QueryString) {
  op <- new_operation(
    name = "UpdateNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_named_query_input(NamedQueryId = NamedQueryId, Name = Name, Description = Description, QueryString = QueryString)
  output <- .athena$update_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_named_query <- athena_update_named_query

#' Updates a prepared statement
#'
#' @description
#' Updates a prepared statement.
#'
#' See [https://paws-r.github.io/docs/athena/update_prepared_statement.html](https://paws-r.github.io/docs/athena/update_prepared_statement.html) for full documentation.
#'
#' @param StatementName &#91;required&#93; The name of the prepared statement.
#' @param WorkGroup &#91;required&#93; The workgroup for the prepared statement.
#' @param QueryStatement &#91;required&#93; The query string for the prepared statement.
#' @param Description The description of the prepared statement.
#'
#' @keywords internal
#'
#' @rdname athena_update_prepared_statement
athena_update_prepared_statement <- function(StatementName, WorkGroup, QueryStatement, Description = NULL) {
  op <- new_operation(
    name = "UpdatePreparedStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_prepared_statement_input(StatementName = StatementName, WorkGroup = WorkGroup, QueryStatement = QueryStatement, Description = Description)
  output <- .athena$update_prepared_statement_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_prepared_statement <- athena_update_prepared_statement

#' Updates the workgroup with the specified name
#'
#' @description
#' Updates the workgroup with the specified name. The workgroup's name cannot be changed.
#'
#' See [https://paws-r.github.io/docs/athena/update_work_group.html](https://paws-r.github.io/docs/athena/update_work_group.html) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The specified workgroup that will be updated.
#' @param Description The workgroup description.
#' @param ConfigurationUpdates The workgroup configuration that will be updated for the given
#' workgroup.
#' @param State The workgroup state that will be updated for the given workgroup.
#'
#' @keywords internal
#'
#' @rdname athena_update_work_group
athena_update_work_group <- function(WorkGroup, Description = NULL, ConfigurationUpdates = NULL, State = NULL) {
  op <- new_operation(
    name = "UpdateWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_work_group_input(WorkGroup = WorkGroup, Description = Description, ConfigurationUpdates = ConfigurationUpdates, State = State)
  output <- .athena$update_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_work_group <- athena_update_work_group
