% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_describe_expressions}
\alias{cloudsearch_describe_expressions}
\title{Gets the expressions configured for the search domain}
\usage{
cloudsearch_describe_expressions(
  DomainName,
  ExpressionNames = NULL,
  Deployed = NULL
)
}
\arguments{
\item{DomainName}{[required] The name of the domain you want to describe.}

\item{ExpressionNames}{Limits the \code{\link[=cloudsearch_describe_expressions]{describe_expressions}}
response to the specified expressions. If not specified, all expressions
are shown.}

\item{Deployed}{Whether to display the deployed configuration (\code{true}) or include any
pending changes (\code{false}). Defaults to \code{false}.}
}
\description{
Gets the expressions configured for the search domain. Can be limited to specific expressions by name. By default, shows all expressions and includes any pending changes to the configuration. Set the \code{Deployed} option to \code{true} to show the active configuration and exclude pending changes. For more information, see <a href="https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html" target="_blank">Configuring Expressions</a> in the \emph{Amazon CloudSearch Developer Guide}.

See \url{https://paws-r.github.io/docs/cloudsearch/describe_expressions.html} for full documentation.
}
\keyword{internal}
