% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_ml_transform}
\alias{glue_update_ml_transform}
\title{Updates an existing machine learning transform}
\usage{
glue_update_ml_transform(
  TransformId,
  Name = NULL,
  Description = NULL,
  Parameters = NULL,
  Role = NULL,
  GlueVersion = NULL,
  MaxCapacity = NULL,
  WorkerType = NULL,
  NumberOfWorkers = NULL,
  Timeout = NULL,
  MaxRetries = NULL
)
}
\arguments{
\item{TransformId}{[required] A unique identifier that was generated when the transform was created.}

\item{Name}{The unique name that you gave the transform when you created it.}

\item{Description}{A description of the transform. The default is an empty string.}

\item{Parameters}{The configuration parameters that are specific to the transform type
(algorithm) used. Conditionally dependent on the transform type.}

\item{Role}{The name or Amazon Resource Name (ARN) of the IAM role with the required
permissions.}

\item{GlueVersion}{This value determines which version of Glue this machine learning
transform is compatible with. Glue 1.0 is recommended for most
customers. If the value is not set, the Glue compatibility defaults to
Glue 0.9. For more information, see \href{https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions}{Glue Versions}
in the developer guide.}

\item{MaxCapacity}{The number of Glue data processing units (DPUs) that are allocated to
task runs for this transform. You can allocate from 2 to 100 DPUs; the
default is 10. A DPU is a relative measure of processing power that
consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
information, see the \href{https://aws.amazon.com/glue/pricing/}{Glue pricing page}.

When the \code{WorkerType} field is set to a value other than \code{Standard}, the
\code{MaxCapacity} field is set automatically and becomes read-only.}

\item{WorkerType}{The type of predefined worker that is allocated when this task runs.
Accepts a value of Standard, G.1X, or G.2X.
\itemize{
\item For the \code{Standard} worker type, each worker provides 4 vCPU, 16 GB
of memory and a 50GB disk, and 2 executors per worker.
\item For the \code{G.1X} worker type, each worker provides 4 vCPU, 16 GB of
memory and a 64GB disk, and 1 executor per worker.
\item For the \code{G.2X} worker type, each worker provides 8 vCPU, 32 GB of
memory and a 128GB disk, and 1 executor per worker.
}}

\item{NumberOfWorkers}{The number of workers of a defined \code{workerType} that are allocated when
this task runs.}

\item{Timeout}{The timeout for a task run for this transform in minutes. This is the
maximum time that a task run for this transform can consume resources
before it is terminated and enters \code{TIMEOUT} status. The default is
2,880 minutes (48 hours).}

\item{MaxRetries}{The maximum number of times to retry a task for this transform after a
task run fails.}
}
\description{
Updates an existing machine learning transform. Call this operation to tune the algorithm parameters to achieve better results.

See \url{https://paws-r.github.io/docs/glue/update_ml_transform.html} for full documentation.
}
\keyword{internal}
