% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_get_query_suggestions}
\alias{kendra_get_query_suggestions}
\title{Fetches the queries that are suggested to your users}
\usage{
kendra_get_query_suggestions(IndexId, QueryText, MaxSuggestionsCount = NULL)
}
\arguments{
\item{IndexId}{[required] The identifier of the index you want to get query suggestions from.}

\item{QueryText}{[required] The text of a user's query to generate query suggestions.

A query is suggested if the query prefix matches what a user starts to
type as their query.

Amazon Kendra does not show any suggestions if a user types fewer than
two characters or more than 60 characters. A query must also have at
least one search result and contain at least one word of more than four
characters.}

\item{MaxSuggestionsCount}{The maximum number of query suggestions you want to show to your users.}
}
\description{
Fetches the queries that are suggested to your users.

See \url{https://paws-r.github.io/docs/kendra/get_query_suggestions.html} for full documentation.
}
\keyword{internal}
