% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_add_application_vpc_configuration}
\alias{kinesisanalyticsv2_add_application_vpc_configuration}
\title{Adds a Virtual Private Cloud (VPC) configuration to the application}
\usage{
kinesisanalyticsv2_add_application_vpc_configuration(
  ApplicationName,
  CurrentApplicationVersionId = NULL,
  VpcConfiguration,
  ConditionalToken = NULL
)
}
\arguments{
\item{ApplicationName}{[required] The name of an existing application.}

\item{CurrentApplicationVersionId}{The version of the application to which you want to add the VPC
configuration. You must provide the \code{CurrentApplicationVersionId} or the
\code{ConditionalToken}. You can use the
\code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}
operation to get the current application version. If the version
specified is not the current version, the
\code{ConcurrentModificationException} is returned. For better concurrency
support, use the \code{ConditionalToken} parameter instead of
\code{CurrentApplicationVersionId}.}

\item{VpcConfiguration}{[required] Description of the VPC to add to the application.}

\item{ConditionalToken}{A value you use to implement strong concurrency for application updates.
You must provide the \code{ApplicationVersionID} or the \code{ConditionalToken}.
You get the application's current \code{ConditionalToken} using
\code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}. For
better concurrency support, use the \code{ConditionalToken} parameter instead
of \code{CurrentApplicationVersionId}.}
}
\description{
Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use VPCs to store and access resources securely.

See \url{https://paws-r.github.io/docs/kinesisanalyticsv2/add_application_vpc_configuration.html} for full documentation.
}
\keyword{internal}
