% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_describe_group_membership}
\alias{quicksight_describe_group_membership}
\title{Use the DescribeGroupMembership operation to determine if a user is a
member of the specified group}
\usage{
quicksight_describe_group_membership(
  MemberName,
  GroupName,
  AwsAccountId,
  Namespace
)
}
\arguments{
\item{MemberName}{[required] The user name of the user that you want to search for.}

\item{GroupName}{[required] The name of the group that you want to search.}

\item{AwsAccountId}{[required] The ID for the Amazon Web Services account that the group is in.
Currently, you use the ID for the Amazon Web Services account that
contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace that includes the group you are searching within.}
}
\description{
Use the \code{\link[=quicksight_describe_group_membership]{describe_group_membership}} operation to determine if a user is a member of the specified group. If the user exists and is a member of the specified group, an associated \code{GroupMember} object is returned.

See \url{https://paws-r.github.io/docs/quicksight/describe_group_membership.html} for full documentation.
}
\keyword{internal}
