% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_table}
\alias{glue_create_table}
\title{Creates a new table definition in the Data Catalog}
\usage{
glue_create_table(
  CatalogId = NULL,
  DatabaseName,
  TableInput,
  PartitionIndexes = NULL,
  TransactionId = NULL
)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog in which to create the \code{Table}. If none is
supplied, the Amazon Web Services account ID is used by default.}

\item{DatabaseName}{[required] The catalog database in which to create the new table. For Hive
compatibility, this name is entirely lowercase.}

\item{TableInput}{[required] The \code{TableInput} object that defines the metadata table to create in the
catalog.}

\item{PartitionIndexes}{A list of partition indexes, \code{PartitionIndex} structures, to create in
the table.}

\item{TransactionId}{The ID of the transaction.}
}
\description{
Creates a new table definition in the Data Catalog.

See \url{https://www.paws-r-sdk.com/docs/glue_create_table/} for full documentation.
}
\keyword{internal}
