% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/healthlake_operations.R
\name{healthlake_list_fhir_import_jobs}
\alias{healthlake_list_fhir_import_jobs}
\title{Lists all FHIR import jobs associated with an account and their statuses}
\usage{
healthlake_list_fhir_import_jobs(
  DatastoreId,
  NextToken = NULL,
  MaxResults = NULL,
  JobName = NULL,
  JobStatus = NULL,
  SubmittedBefore = NULL,
  SubmittedAfter = NULL
)
}
\arguments{
\item{DatastoreId}{[required] This parameter limits the response to the import job with the specified
Data Store ID.}

\item{NextToken}{A pagination token used to identify the next page of results to return
for a ListFHIRImportJobs query.}

\item{MaxResults}{This parameter limits the number of results returned for a
ListFHIRImportJobs to a maximum quantity specified by the user.}

\item{JobName}{This parameter limits the response to the import job with the specified
job name.}

\item{JobStatus}{This parameter limits the response to the import job with the specified
job status.}

\item{SubmittedBefore}{This parameter limits the response to FHIR import jobs submitted before
a user specified date.}

\item{SubmittedAfter}{This parameter limits the response to FHIR import jobs submitted after a
user specified date.}
}
\description{
Lists all FHIR import jobs associated with an account and their statuses.

See \url{https://www.paws-r-sdk.com/docs/healthlake_list_fhir_import_jobs/} for full documentation.
}
\keyword{internal}
