% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_register_user}
\alias{quicksight_register_user}
\title{Creates an Amazon QuickSight user whose identity is associated with the
Identity and Access Management (IAM) identity or role specified in the
request}
\usage{
quicksight_register_user(
  IdentityType,
  Email,
  UserRole,
  IamArn = NULL,
  SessionName = NULL,
  AwsAccountId,
  Namespace,
  UserName = NULL,
  CustomPermissionsName = NULL,
  ExternalLoginFederationProviderType = NULL,
  CustomFederationProviderUrl = NULL,
  ExternalLoginId = NULL
)
}
\arguments{
\item{IdentityType}{[required] Amazon QuickSight supports several ways of managing the identity of
users. This parameter accepts two values:
\itemize{
\item \code{IAM}: A user whose identity maps to an existing IAM user or role.
\item \code{QUICKSIGHT}: A user whose identity is owned and managed internally
by Amazon QuickSight.
}}

\item{Email}{[required] The email address of the user that you want to register.}

\item{UserRole}{[required] The Amazon QuickSight role for the user. The user role can be one of the
following:
\itemize{
\item \code{READER}: A user who has read-only access to dashboards.
\item \code{AUTHOR}: A user who can create data sources, datasets, analyses,
and dashboards.
\item \code{ADMIN}: A user who is an author, who can also manage Amazon
QuickSight settings.
\item \code{RESTRICTED_READER}: This role isn't currently available for use.
\item \code{RESTRICTED_AUTHOR}: This role isn't currently available for use.
}}

\item{IamArn}{The ARN of the IAM user or role that you are registering with Amazon
QuickSight.}

\item{SessionName}{You need to use this parameter only when you register one or more users
using an assumed IAM role. You don't need to provide the session name
for other scenarios, for example when you are registering an IAM user or
an Amazon QuickSight user. You can register multiple users using the
same IAM role if each user has a different session name. For more
information on assuming IAM roles, see
\href{https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html}{\code{assume-role}}
in the \emph{CLI Reference.}}

\item{AwsAccountId}{[required] The ID for the Amazon Web Services account that the user is in.
Currently, you use the ID for the Amazon Web Services account that
contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}

\item{UserName}{The Amazon QuickSight user name that you want to create for the user you
are registering.}

\item{CustomPermissionsName}{(Enterprise edition only) The name of the custom permissions profile
that you want to assign to this user. Customized permissions allows you
to control a user's access by restricting access the following
operations:
\itemize{
\item Create and update data sources
\item Create and update datasets
\item Create and update email reports
\item Subscribe to email reports
}

To add custom permissions to an existing user, use
\code{\link[=quicksight_update_user]{update_user}} instead.

A set of custom permissions includes any combination of these
restrictions. Currently, you need to create the profile names for custom
permission sets by using the Amazon QuickSight console. Then, you use
the \code{\link[=quicksight_register_user]{register_user}} API operation to assign
the named set of permissions to a Amazon QuickSight user.

Amazon QuickSight custom permissions are applied through IAM policies.
Therefore, they override the permissions typically granted by assigning
Amazon QuickSight users to one of the default security cohorts in Amazon
QuickSight (admin, author, reader).

This feature is available only to Amazon QuickSight Enterprise edition
subscriptions.}

\item{ExternalLoginFederationProviderType}{The type of supported external login provider that provides identity to
let a user federate into Amazon QuickSight with an associated Identity
and Access Management(IAM) role. The type of supported external login
provider can be one of the following.
\itemize{
\item \code{COGNITO}: Amazon Cognito. The provider URL is
cognito-identity.amazonaws.com. When choosing the \code{COGNITO} provider
type, don’t use the "CustomFederationProviderUrl" parameter which is
only needed when the external provider is custom.
\item \code{CUSTOM_OIDC}: Custom OpenID Connect (OIDC) provider. When choosing
\code{CUSTOM_OIDC} type, use the \code{CustomFederationProviderUrl} parameter
to provide the custom OIDC provider URL.
}}

\item{CustomFederationProviderUrl}{The URL of the custom OpenID Connect (OIDC) provider that provides
identity to let a user federate into Amazon QuickSight with an
associated Identity and Access Management(IAM) role. This parameter
should only be used when \code{ExternalLoginFederationProviderType} parameter
is set to \code{CUSTOM_OIDC}.}

\item{ExternalLoginId}{The identity ID for a user in the external login provider.}
}
\description{
Creates an Amazon QuickSight user whose identity is associated with the Identity and Access Management (IAM) identity or role specified in the request. When you register a new user from the Amazon QuickSight API, Amazon QuickSight generates a registration URL. The user accesses this registration URL to create their account. Amazon QuickSight doesn't send a registration email to users who are registered from the Amazon QuickSight API. If you want new users to receive a registration email, then add those users in the Amazon QuickSight console. For more information on registering a new user in the Amazon QuickSight console, see \href{https://docs.aws.amazon.com/quicksight/latest/user/managing-users.html#inviting-users}{Inviting users to access Amazon QuickSight}.

See \url{https://www.paws-r-sdk.com/docs/quicksight_register_user/} for full documentation.
}
\keyword{internal}
