# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon DataZone
#'
#' @description
#' Amazon DataZone is a data management service that enables you to
#' catalog, discover, govern, share, and analyze your data. With Amazon
#' DataZone, you can share and access your data across accounts and
#' supported regions. Amazon DataZone simplifies your experience across
#' Amazon Web Services services, including, but not limited to, Amazon
#' Redshift, Amazon Athena, Amazon Web Services Glue, and Amazon Web
#' Services Lake Formation.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- datazone(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- datazone()
#' svc$accept_predictions(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=datazone_accept_predictions]{accept_predictions} \tab Accepts automatically generated business-friendly metadata for your Amazon DataZone assets\cr
#'  \link[=datazone_accept_subscription_request]{accept_subscription_request} \tab Accepts a subscription request to a specific asset\cr
#'  \link[=datazone_add_entity_owner]{add_entity_owner} \tab Adds the owner of an entity (a domain unit)\cr
#'  \link[=datazone_add_policy_grant]{add_policy_grant} \tab Adds a policy grant (an authorization policy) to a specified entity, including domain units, environment blueprint configurations, or environment profiles\cr
#'  \link[=datazone_associate_environment_role]{associate_environment_role} \tab Associates the environment role in Amazon DataZone\cr
#'  \link[=datazone_cancel_metadata_generation_run]{cancel_metadata_generation_run} \tab Cancels the metadata generation run\cr
#'  \link[=datazone_cancel_subscription]{cancel_subscription} \tab Cancels the subscription to the specified asset\cr
#'  \link[=datazone_create_asset]{create_asset} \tab Creates an asset in Amazon DataZone catalog\cr
#'  \link[=datazone_create_asset_filter]{create_asset_filter} \tab Creates a data asset filter\cr
#'  \link[=datazone_create_asset_revision]{create_asset_revision} \tab Creates a revision of the asset\cr
#'  \link[=datazone_create_asset_type]{create_asset_type} \tab Creates a custom asset type\cr
#'  \link[=datazone_create_data_product]{create_data_product} \tab Creates a data product\cr
#'  \link[=datazone_create_data_product_revision]{create_data_product_revision} \tab Creates a data product revision\cr
#'  \link[=datazone_create_data_source]{create_data_source} \tab Creates an Amazon DataZone data source\cr
#'  \link[=datazone_create_domain]{create_domain} \tab Creates an Amazon DataZone domain\cr
#'  \link[=datazone_create_domain_unit]{create_domain_unit} \tab Creates a domain unit in Amazon DataZone\cr
#'  \link[=datazone_create_environment]{create_environment} \tab Create an Amazon DataZone environment\cr
#'  \link[=datazone_create_environment_action]{create_environment_action} \tab Creates an action for the environment, for example, creates a console link for an analytics tool that is available in this environment\cr
#'  \link[=datazone_create_environment_profile]{create_environment_profile} \tab Creates an Amazon DataZone environment profile\cr
#'  \link[=datazone_create_form_type]{create_form_type} \tab Creates a metadata form type\cr
#'  \link[=datazone_create_glossary]{create_glossary} \tab Creates an Amazon DataZone business glossary\cr
#'  \link[=datazone_create_glossary_term]{create_glossary_term} \tab Creates a business glossary term\cr
#'  \link[=datazone_create_group_profile]{create_group_profile} \tab Creates a group profile in Amazon DataZone\cr
#'  \link[=datazone_create_listing_change_set]{create_listing_change_set} \tab Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog\cr
#'  \link[=datazone_create_project]{create_project} \tab Creates an Amazon DataZone project\cr
#'  \link[=datazone_create_project_membership]{create_project_membership} \tab Creates a project membership in Amazon DataZone\cr
#'  \link[=datazone_create_subscription_grant]{create_subscription_grant} \tab Creates a subsscription grant in Amazon DataZone\cr
#'  \link[=datazone_create_subscription_request]{create_subscription_request} \tab Creates a subscription request in Amazon DataZone\cr
#'  \link[=datazone_create_subscription_target]{create_subscription_target} \tab Creates a subscription target in Amazon DataZone\cr
#'  \link[=datazone_create_user_profile]{create_user_profile} \tab Creates a user profile in Amazon DataZone\cr
#'  \link[=datazone_delete_asset]{delete_asset} \tab Deletes an asset in Amazon DataZone\cr
#'  \link[=datazone_delete_asset_filter]{delete_asset_filter} \tab Deletes an asset filter\cr
#'  \link[=datazone_delete_asset_type]{delete_asset_type} \tab Deletes an asset type in Amazon DataZone\cr
#'  \link[=datazone_delete_data_product]{delete_data_product} \tab Deletes a data product in Amazon DataZone\cr
#'  \link[=datazone_delete_data_source]{delete_data_source} \tab Deletes a data source in Amazon DataZone\cr
#'  \link[=datazone_delete_domain]{delete_domain} \tab Deletes a Amazon DataZone domain\cr
#'  \link[=datazone_delete_domain_unit]{delete_domain_unit} \tab Deletes a domain unit\cr
#'  \link[=datazone_delete_environment]{delete_environment} \tab Deletes an environment in Amazon DataZone\cr
#'  \link[=datazone_delete_environment_action]{delete_environment_action} \tab Deletes an action for the environment, for example, deletes a console link for an analytics tool that is available in this environment\cr
#'  \link[=datazone_delete_environment_blueprint_configuration]{delete_environment_blueprint_configuration} \tab Deletes the blueprint configuration in Amazon DataZone\cr
#'  \link[=datazone_delete_environment_profile]{delete_environment_profile} \tab Deletes an environment profile in Amazon DataZone\cr
#'  \link[=datazone_delete_form_type]{delete_form_type} \tab Delets and metadata form type in Amazon DataZone\cr
#'  \link[=datazone_delete_glossary]{delete_glossary} \tab Deletes a business glossary in Amazon DataZone\cr
#'  \link[=datazone_delete_glossary_term]{delete_glossary_term} \tab Deletes a business glossary term in Amazon DataZone\cr
#'  \link[=datazone_delete_listing]{delete_listing} \tab Deletes a listing (a record of an asset at a given time)\cr
#'  \link[=datazone_delete_project]{delete_project} \tab Deletes a project in Amazon DataZone\cr
#'  \link[=datazone_delete_project_membership]{delete_project_membership} \tab Deletes project membership in Amazon DataZone\cr
#'  \link[=datazone_delete_subscription_grant]{delete_subscription_grant} \tab Deletes and subscription grant in Amazon DataZone\cr
#'  \link[=datazone_delete_subscription_request]{delete_subscription_request} \tab Deletes a subscription request in Amazon DataZone\cr
#'  \link[=datazone_delete_subscription_target]{delete_subscription_target} \tab Deletes a subscription target in Amazon DataZone\cr
#'  \link[=datazone_delete_time_series_data_points]{delete_time_series_data_points} \tab Deletes the specified time series form for the specified asset\cr
#'  \link[=datazone_disassociate_environment_role]{disassociate_environment_role} \tab Disassociates the environment role in Amazon DataZone\cr
#'  \link[=datazone_get_asset]{get_asset} \tab Gets an Amazon DataZone asset\cr
#'  \link[=datazone_get_asset_filter]{get_asset_filter} \tab Gets an asset filter\cr
#'  \link[=datazone_get_asset_type]{get_asset_type} \tab Gets an Amazon DataZone asset type\cr
#'  \link[=datazone_get_data_product]{get_data_product} \tab Gets the data product\cr
#'  \link[=datazone_get_data_source]{get_data_source} \tab Gets an Amazon DataZone data source\cr
#'  \link[=datazone_get_data_source_run]{get_data_source_run} \tab Gets an Amazon DataZone data source run\cr
#'  \link[=datazone_get_domain]{get_domain} \tab Gets an Amazon DataZone domain\cr
#'  \link[=datazone_get_domain_unit]{get_domain_unit} \tab Gets the details of the specified domain unit\cr
#'  \link[=datazone_get_environment]{get_environment} \tab Gets an Amazon DataZone environment\cr
#'  \link[=datazone_get_environment_action]{get_environment_action} \tab Gets the specified environment action\cr
#'  \link[=datazone_get_environment_blueprint]{get_environment_blueprint} \tab Gets an Amazon DataZone blueprint\cr
#'  \link[=datazone_get_environment_blueprint_configuration]{get_environment_blueprint_configuration} \tab Gets the blueprint configuration in Amazon DataZone\cr
#'  \link[=datazone_get_environment_credentials]{get_environment_credentials} \tab Gets the credentials of an environment in Amazon DataZone\cr
#'  \link[=datazone_get_environment_profile]{get_environment_profile} \tab Gets an evinronment profile in Amazon DataZone\cr
#'  \link[=datazone_get_form_type]{get_form_type} \tab Gets a metadata form type in Amazon DataZone\cr
#'  \link[=datazone_get_glossary]{get_glossary} \tab Gets a business glossary in Amazon DataZone\cr
#'  \link[=datazone_get_glossary_term]{get_glossary_term} \tab Gets a business glossary term in Amazon DataZone\cr
#'  \link[=datazone_get_group_profile]{get_group_profile} \tab Gets a group profile in Amazon DataZone\cr
#'  \link[=datazone_get_iam_portal_login_url]{get_iam_portal_login_url} \tab Gets the data portal URL for the specified Amazon DataZone domain\cr
#'  \link[=datazone_get_lineage_node]{get_lineage_node} \tab Gets the data lineage node\cr
#'  \link[=datazone_get_listing]{get_listing} \tab Gets a listing (a record of an asset at a given time)\cr
#'  \link[=datazone_get_metadata_generation_run]{get_metadata_generation_run} \tab Gets a metadata generation run in Amazon DataZone\cr
#'  \link[=datazone_get_project]{get_project} \tab Gets a project in Amazon DataZone\cr
#'  \link[=datazone_get_subscription]{get_subscription} \tab Gets a subscription in Amazon DataZone\cr
#'  \link[=datazone_get_subscription_grant]{get_subscription_grant} \tab Gets the subscription grant in Amazon DataZone\cr
#'  \link[=datazone_get_subscription_request_details]{get_subscription_request_details} \tab Gets the details of the specified subscription request\cr
#'  \link[=datazone_get_subscription_target]{get_subscription_target} \tab Gets the subscription target in Amazon DataZone\cr
#'  \link[=datazone_get_time_series_data_point]{get_time_series_data_point} \tab Gets the existing data point for the asset\cr
#'  \link[=datazone_get_user_profile]{get_user_profile} \tab Gets a user profile in Amazon DataZone\cr
#'  \link[=datazone_list_asset_filters]{list_asset_filters} \tab Lists asset filters\cr
#'  \link[=datazone_list_asset_revisions]{list_asset_revisions} \tab Lists the revisions for the asset\cr
#'  \link[=datazone_list_data_product_revisions]{list_data_product_revisions} \tab Lists data product revisions\cr
#'  \link[=datazone_list_data_source_run_activities]{list_data_source_run_activities} \tab Lists data source run activities\cr
#'  \link[=datazone_list_data_source_runs]{list_data_source_runs} \tab Lists data source runs in Amazon DataZone\cr
#'  \link[=datazone_list_data_sources]{list_data_sources} \tab Lists data sources in Amazon DataZone\cr
#'  \link[=datazone_list_domains]{list_domains} \tab Lists Amazon DataZone domains\cr
#'  \link[=datazone_list_domain_units_for_parent]{list_domain_units_for_parent} \tab Lists child domain units for the specified parent domain unit\cr
#'  \link[=datazone_list_entity_owners]{list_entity_owners} \tab Lists the entity (domain units) owners\cr
#'  \link[=datazone_list_environment_actions]{list_environment_actions} \tab Lists existing environment actions\cr
#'  \link[=datazone_list_environment_blueprint_configurations]{list_environment_blueprint_configurations} \tab Lists blueprint configurations for a Amazon DataZone environment\cr
#'  \link[=datazone_list_environment_blueprints]{list_environment_blueprints} \tab Lists blueprints in an Amazon DataZone environment\cr
#'  \link[=datazone_list_environment_profiles]{list_environment_profiles} \tab Lists Amazon DataZone environment profiles\cr
#'  \link[=datazone_list_environments]{list_environments} \tab Lists Amazon DataZone environments\cr
#'  \link[=datazone_list_lineage_node_history]{list_lineage_node_history} \tab Lists the history of the specified data lineage node\cr
#'  \link[=datazone_list_metadata_generation_runs]{list_metadata_generation_runs} \tab Lists all metadata generation runs\cr
#'  \link[=datazone_list_notifications]{list_notifications} \tab Lists all Amazon DataZone notifications\cr
#'  \link[=datazone_list_policy_grants]{list_policy_grants} \tab Lists policy grants\cr
#'  \link[=datazone_list_project_memberships]{list_project_memberships} \tab Lists all members of the specified project\cr
#'  \link[=datazone_list_projects]{list_projects} \tab Lists Amazon DataZone projects\cr
#'  \link[=datazone_list_subscription_grants]{list_subscription_grants} \tab Lists subscription grants\cr
#'  \link[=datazone_list_subscription_requests]{list_subscription_requests} \tab Lists Amazon DataZone subscription requests\cr
#'  \link[=datazone_list_subscriptions]{list_subscriptions} \tab Lists subscriptions in Amazon DataZone\cr
#'  \link[=datazone_list_subscription_targets]{list_subscription_targets} \tab Lists subscription targets in Amazon DataZone\cr
#'  \link[=datazone_list_tags_for_resource]{list_tags_for_resource} \tab Lists tags for the specified resource in Amazon DataZone\cr
#'  \link[=datazone_list_time_series_data_points]{list_time_series_data_points} \tab Lists time series data points\cr
#'  \link[=datazone_post_lineage_event]{post_lineage_event} \tab Posts a data lineage event\cr
#'  \link[=datazone_post_time_series_data_points]{post_time_series_data_points} \tab Posts time series data points to Amazon DataZone for the specified asset\cr
#'  \link[=datazone_put_environment_blueprint_configuration]{put_environment_blueprint_configuration} \tab Writes the configuration for the specified environment blueprint in Amazon DataZone\cr
#'  \link[=datazone_reject_predictions]{reject_predictions} \tab Rejects automatically generated business-friendly metadata for your Amazon DataZone assets\cr
#'  \link[=datazone_reject_subscription_request]{reject_subscription_request} \tab Rejects the specified subscription request\cr
#'  \link[=datazone_remove_entity_owner]{remove_entity_owner} \tab Removes an owner from an entity\cr
#'  \link[=datazone_remove_policy_grant]{remove_policy_grant} \tab Removes a policy grant\cr
#'  \link[=datazone_revoke_subscription]{revoke_subscription} \tab Revokes a specified subscription in Amazon DataZone\cr
#'  \link[=datazone_search]{search} \tab Searches for assets in Amazon DataZone\cr
#'  \link[=datazone_search_group_profiles]{search_group_profiles} \tab Searches group profiles in Amazon DataZone\cr
#'  \link[=datazone_search_listings]{search_listings} \tab Searches listings (records of an asset at a given time) in Amazon DataZone\cr
#'  \link[=datazone_search_types]{search_types} \tab Searches for types in Amazon DataZone\cr
#'  \link[=datazone_search_user_profiles]{search_user_profiles} \tab Searches user profiles in Amazon DataZone\cr
#'  \link[=datazone_start_data_source_run]{start_data_source_run} \tab Start the run of the specified data source in Amazon DataZone\cr
#'  \link[=datazone_start_metadata_generation_run]{start_metadata_generation_run} \tab Starts the metadata generation run\cr
#'  \link[=datazone_tag_resource]{tag_resource} \tab Tags a resource in Amazon DataZone\cr
#'  \link[=datazone_untag_resource]{untag_resource} \tab Untags a resource in Amazon DataZone\cr
#'  \link[=datazone_update_asset_filter]{update_asset_filter} \tab Updates an asset filter\cr
#'  \link[=datazone_update_data_source]{update_data_source} \tab Updates the specified data source in Amazon DataZone\cr
#'  \link[=datazone_update_domain]{update_domain} \tab Updates a Amazon DataZone domain\cr
#'  \link[=datazone_update_domain_unit]{update_domain_unit} \tab Updates the domain unit\cr
#'  \link[=datazone_update_environment]{update_environment} \tab Updates the specified environment in Amazon DataZone\cr
#'  \link[=datazone_update_environment_action]{update_environment_action} \tab Updates an environment action\cr
#'  \link[=datazone_update_environment_profile]{update_environment_profile} \tab Updates the specified environment profile in Amazon DataZone\cr
#'  \link[=datazone_update_glossary]{update_glossary} \tab Updates the business glossary in Amazon DataZone\cr
#'  \link[=datazone_update_glossary_term]{update_glossary_term} \tab Updates a business glossary term in Amazon DataZone\cr
#'  \link[=datazone_update_group_profile]{update_group_profile} \tab Updates the specified group profile in Amazon DataZone\cr
#'  \link[=datazone_update_project]{update_project} \tab Updates the specified project in Amazon DataZone\cr
#'  \link[=datazone_update_subscription_grant_status]{update_subscription_grant_status} \tab Updates the status of the specified subscription grant status in Amazon DataZone\cr
#'  \link[=datazone_update_subscription_request]{update_subscription_request} \tab Updates a specified subscription request in Amazon DataZone\cr
#'  \link[=datazone_update_subscription_target]{update_subscription_target} \tab Updates the specified subscription target in Amazon DataZone\cr
#'  \link[=datazone_update_user_profile]{update_user_profile} \tab Updates the specified user profile in Amazon DataZone
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname datazone
#' @export
datazone <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .datazone$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.datazone <- list()

.datazone$operations <- list()

.datazone$metadata <- list(
  service_name = "datazone",
  endpoints = list("*" = list(endpoint = "datazone.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "datazone.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "datazone.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "datazone.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "datazone.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "datazone.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "DataZone",
  api_version = "2018-05-10",
  signing_name = "datazone",
  json_version = "1.1",
  target_prefix = ""
)

.datazone$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.datazone$metadata, handlers, config, op)
}
