# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kinesis_service.R
NULL

#' Adds or updates tags for the specified Kinesis data stream
#'
#' @description
#' Adds or updates tags for the specified Kinesis data stream. You can assign up to 50 tags to a data stream.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_add_tags_to_stream/](https://www.paws-r-sdk.com/docs/kinesis_add_tags_to_stream/) for full documentation.
#'
#' @param StreamName The name of the stream.
#' @param Tags &#91;required&#93; A set of up to 10 key-value pairs to use to create the tags.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_add_tags_to_stream
kinesis_add_tags_to_stream <- function(StreamName = NULL, Tags, StreamARN = NULL) {
  op <- new_operation(
    name = "AddTagsToStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$add_tags_to_stream_input(StreamName = StreamName, Tags = Tags, StreamARN = StreamARN)
  output <- .kinesis$add_tags_to_stream_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$add_tags_to_stream <- kinesis_add_tags_to_stream

#' Creates a Kinesis data stream
#'
#' @description
#' Creates a Kinesis data stream. A stream captures and transports data records that are continuously emitted from different data sources or *producers*. Scale-out within a stream is explicitly supported by means of shards, which are uniquely identified groups of data records in a stream.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_create_stream/](https://www.paws-r-sdk.com/docs/kinesis_create_stream/) for full documentation.
#'
#' @param StreamName &#91;required&#93; A name to identify the stream. The stream name is scoped to the Amazon
#' Web Services account used by the application that creates the stream. It
#' is also scoped by Amazon Web Services Region. That is, two streams in
#' two different Amazon Web Services accounts can have the same name. Two
#' streams in the same Amazon Web Services account but in two different
#' Regions can also have the same name.
#' @param ShardCount The number of shards that the stream will use. The throughput of the
#' stream is a function of the number of shards; more shards are required
#' for greater provisioned throughput.
#' @param StreamModeDetails Indicates the capacity mode of the data stream. Currently, in Kinesis
#' Data Streams, you can choose between an **on-demand** capacity mode and
#' a **provisioned** capacity mode for your data streams.
#'
#' @keywords internal
#'
#' @rdname kinesis_create_stream
kinesis_create_stream <- function(StreamName, ShardCount = NULL, StreamModeDetails = NULL) {
  op <- new_operation(
    name = "CreateStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$create_stream_input(StreamName = StreamName, ShardCount = ShardCount, StreamModeDetails = StreamModeDetails)
  output <- .kinesis$create_stream_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$create_stream <- kinesis_create_stream

#' Decreases the Kinesis data stream's retention period, which is the
#' length of time data records are accessible after they are added to the
#' stream
#'
#' @description
#' Decreases the Kinesis data stream's retention period, which is the length of time data records are accessible after they are added to the stream. The minimum value of a stream's retention period is 24 hours.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_decrease_stream_retention_period/](https://www.paws-r-sdk.com/docs/kinesis_decrease_stream_retention_period/) for full documentation.
#'
#' @param StreamName The name of the stream to modify.
#' @param RetentionPeriodHours &#91;required&#93; The new retention period of the stream, in hours. Must be less than the
#' current retention period.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_decrease_stream_retention_period
kinesis_decrease_stream_retention_period <- function(StreamName = NULL, RetentionPeriodHours, StreamARN = NULL) {
  op <- new_operation(
    name = "DecreaseStreamRetentionPeriod",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$decrease_stream_retention_period_input(StreamName = StreamName, RetentionPeriodHours = RetentionPeriodHours, StreamARN = StreamARN)
  output <- .kinesis$decrease_stream_retention_period_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$decrease_stream_retention_period <- kinesis_decrease_stream_retention_period

#' Delete a policy for the specified data stream or consumer
#'
#' @description
#' Delete a policy for the specified data stream or consumer. Request patterns can be one of the following:
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_delete_resource_policy/](https://www.paws-r-sdk.com/docs/kinesis_delete_resource_policy/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the data stream or consumer.
#'
#' @keywords internal
#'
#' @rdname kinesis_delete_resource_policy
kinesis_delete_resource_policy <- function(ResourceARN) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$delete_resource_policy_input(ResourceARN = ResourceARN)
  output <- .kinesis$delete_resource_policy_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$delete_resource_policy <- kinesis_delete_resource_policy

#' Deletes a Kinesis data stream and all its shards and data
#'
#' @description
#' Deletes a Kinesis data stream and all its shards and data. You must shut down any applications that are operating on the stream before you delete the stream. If an application attempts to operate on a deleted stream, it receives the exception `ResourceNotFoundException`.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_delete_stream/](https://www.paws-r-sdk.com/docs/kinesis_delete_stream/) for full documentation.
#'
#' @param StreamName The name of the stream to delete.
#' @param EnforceConsumerDeletion If this parameter is unset (`null`) or if you set it to `false`, and the
#' stream has registered consumers, the call to
#' [`delete_stream`][kinesis_delete_stream] fails with a
#' `ResourceInUseException`.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_delete_stream
kinesis_delete_stream <- function(StreamName = NULL, EnforceConsumerDeletion = NULL, StreamARN = NULL) {
  op <- new_operation(
    name = "DeleteStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$delete_stream_input(StreamName = StreamName, EnforceConsumerDeletion = EnforceConsumerDeletion, StreamARN = StreamARN)
  output <- .kinesis$delete_stream_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$delete_stream <- kinesis_delete_stream

#' To deregister a consumer, provide its ARN
#'
#' @description
#' To deregister a consumer, provide its ARN. Alternatively, you can provide the ARN of the data stream and the name you gave the consumer when you registered it. You may also provide all three parameters, as long as they don't conflict with each other. If you don't know the name or ARN of the consumer that you want to deregister, you can use the [`list_stream_consumers`][kinesis_list_stream_consumers] operation to get a list of the descriptions of all the consumers that are currently registered with a given data stream. The description of a consumer contains its name and ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_deregister_stream_consumer/](https://www.paws-r-sdk.com/docs/kinesis_deregister_stream_consumer/) for full documentation.
#'
#' @param StreamARN The ARN of the Kinesis data stream that the consumer is registered with.
#' For more information, see [Amazon Resource Names (ARNs) and Amazon Web
#' Services Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arn-syntax-kinesis-streams).
#' @param ConsumerName The name that you gave to the consumer.
#' @param ConsumerARN The ARN returned by Kinesis Data Streams when you registered the
#' consumer. If you don't know the ARN of the consumer that you want to
#' deregister, you can use the ListStreamConsumers operation to get a list
#' of the descriptions of all the consumers that are currently registered
#' with a given data stream. The description of a consumer contains its
#' ARN.
#'
#' @keywords internal
#'
#' @rdname kinesis_deregister_stream_consumer
kinesis_deregister_stream_consumer <- function(StreamARN = NULL, ConsumerName = NULL, ConsumerARN = NULL) {
  op <- new_operation(
    name = "DeregisterStreamConsumer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$deregister_stream_consumer_input(StreamARN = StreamARN, ConsumerName = ConsumerName, ConsumerARN = ConsumerARN)
  output <- .kinesis$deregister_stream_consumer_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$deregister_stream_consumer <- kinesis_deregister_stream_consumer

#' Describes the shard limits and usage for the account
#'
#' @description
#' Describes the shard limits and usage for the account.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_describe_limits/](https://www.paws-r-sdk.com/docs/kinesis_describe_limits/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname kinesis_describe_limits
kinesis_describe_limits <- function() {
  op <- new_operation(
    name = "DescribeLimits",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$describe_limits_input()
  output <- .kinesis$describe_limits_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$describe_limits <- kinesis_describe_limits

#' Describes the specified Kinesis data stream
#'
#' @description
#' Describes the specified Kinesis data stream.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_describe_stream/](https://www.paws-r-sdk.com/docs/kinesis_describe_stream/) for full documentation.
#'
#' @param StreamName The name of the stream to describe.
#' @param Limit The maximum number of shards to return in a single call. The default
#' value is 100. If you specify a value greater than 100, at most 100
#' results are returned.
#' @param ExclusiveStartShardId The shard ID of the shard to start with.
#' 
#' Specify this parameter to indicate that you want to describe the stream
#' starting with the shard whose ID immediately follows
#' `ExclusiveStartShardId`.
#' 
#' If you don't specify this parameter, the default behavior for
#' [`describe_stream`][kinesis_describe_stream] is to describe the stream
#' starting with the first shard in the stream.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_describe_stream
kinesis_describe_stream <- function(StreamName = NULL, Limit = NULL, ExclusiveStartShardId = NULL, StreamARN = NULL) {
  op <- new_operation(
    name = "DescribeStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "ExclusiveStartShardId", limit_key = "Limit", more_results = "StreamDescription.HasMoreShards", output_token = "StreamDescription.Shards[-1].ShardId", result_key = "StreamDescription.Shards")
  )
  input <- .kinesis$describe_stream_input(StreamName = StreamName, Limit = Limit, ExclusiveStartShardId = ExclusiveStartShardId, StreamARN = StreamARN)
  output <- .kinesis$describe_stream_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$describe_stream <- kinesis_describe_stream

#' To get the description of a registered consumer, provide the ARN of the
#' consumer
#'
#' @description
#' To get the description of a registered consumer, provide the ARN of the consumer. Alternatively, you can provide the ARN of the data stream and the name you gave the consumer when you registered it. You may also provide all three parameters, as long as they don't conflict with each other. If you don't know the name or ARN of the consumer that you want to describe, you can use the [`list_stream_consumers`][kinesis_list_stream_consumers] operation to get a list of the descriptions of all the consumers that are currently registered with a given data stream.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_describe_stream_consumer/](https://www.paws-r-sdk.com/docs/kinesis_describe_stream_consumer/) for full documentation.
#'
#' @param StreamARN The ARN of the Kinesis data stream that the consumer is registered with.
#' For more information, see [Amazon Resource Names (ARNs) and Amazon Web
#' Services Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arn-syntax-kinesis-streams).
#' @param ConsumerName The name that you gave to the consumer.
#' @param ConsumerARN The ARN returned by Kinesis Data Streams when you registered the
#' consumer.
#'
#' @keywords internal
#'
#' @rdname kinesis_describe_stream_consumer
kinesis_describe_stream_consumer <- function(StreamARN = NULL, ConsumerName = NULL, ConsumerARN = NULL) {
  op <- new_operation(
    name = "DescribeStreamConsumer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$describe_stream_consumer_input(StreamARN = StreamARN, ConsumerName = ConsumerName, ConsumerARN = ConsumerARN)
  output <- .kinesis$describe_stream_consumer_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$describe_stream_consumer <- kinesis_describe_stream_consumer

#' Provides a summarized description of the specified Kinesis data stream
#' without the shard list
#'
#' @description
#' Provides a summarized description of the specified Kinesis data stream without the shard list.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_describe_stream_summary/](https://www.paws-r-sdk.com/docs/kinesis_describe_stream_summary/) for full documentation.
#'
#' @param StreamName The name of the stream to describe.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_describe_stream_summary
kinesis_describe_stream_summary <- function(StreamName = NULL, StreamARN = NULL) {
  op <- new_operation(
    name = "DescribeStreamSummary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$describe_stream_summary_input(StreamName = StreamName, StreamARN = StreamARN)
  output <- .kinesis$describe_stream_summary_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$describe_stream_summary <- kinesis_describe_stream_summary

#' Disables enhanced monitoring
#'
#' @description
#' Disables enhanced monitoring.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_disable_enhanced_monitoring/](https://www.paws-r-sdk.com/docs/kinesis_disable_enhanced_monitoring/) for full documentation.
#'
#' @param StreamName The name of the Kinesis data stream for which to disable enhanced
#' monitoring.
#' @param ShardLevelMetrics &#91;required&#93; List of shard-level metrics to disable.
#' 
#' The following are the valid shard-level metrics. The value "`ALL`"
#' disables every metric.
#' 
#' -   `IncomingBytes`
#' 
#' -   `IncomingRecords`
#' 
#' -   `OutgoingBytes`
#' 
#' -   `OutgoingRecords`
#' 
#' -   `WriteProvisionedThroughputExceeded`
#' 
#' -   `ReadProvisionedThroughputExceeded`
#' 
#' -   `IteratorAgeMilliseconds`
#' 
#' -   `ALL`
#' 
#' For more information, see [Monitoring the Amazon Kinesis Data Streams
#' Service with Amazon
#' CloudWatch](https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_disable_enhanced_monitoring
kinesis_disable_enhanced_monitoring <- function(StreamName = NULL, ShardLevelMetrics, StreamARN = NULL) {
  op <- new_operation(
    name = "DisableEnhancedMonitoring",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$disable_enhanced_monitoring_input(StreamName = StreamName, ShardLevelMetrics = ShardLevelMetrics, StreamARN = StreamARN)
  output <- .kinesis$disable_enhanced_monitoring_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$disable_enhanced_monitoring <- kinesis_disable_enhanced_monitoring

#' Enables enhanced Kinesis data stream monitoring for shard-level metrics
#'
#' @description
#' Enables enhanced Kinesis data stream monitoring for shard-level metrics.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_enable_enhanced_monitoring/](https://www.paws-r-sdk.com/docs/kinesis_enable_enhanced_monitoring/) for full documentation.
#'
#' @param StreamName The name of the stream for which to enable enhanced monitoring.
#' @param ShardLevelMetrics &#91;required&#93; List of shard-level metrics to enable.
#' 
#' The following are the valid shard-level metrics. The value "`ALL`"
#' enables every metric.
#' 
#' -   `IncomingBytes`
#' 
#' -   `IncomingRecords`
#' 
#' -   `OutgoingBytes`
#' 
#' -   `OutgoingRecords`
#' 
#' -   `WriteProvisionedThroughputExceeded`
#' 
#' -   `ReadProvisionedThroughputExceeded`
#' 
#' -   `IteratorAgeMilliseconds`
#' 
#' -   `ALL`
#' 
#' For more information, see [Monitoring the Amazon Kinesis Data Streams
#' Service with Amazon
#' CloudWatch](https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html)
#' in the *Amazon Kinesis Data Streams Developer Guide*.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_enable_enhanced_monitoring
kinesis_enable_enhanced_monitoring <- function(StreamName = NULL, ShardLevelMetrics, StreamARN = NULL) {
  op <- new_operation(
    name = "EnableEnhancedMonitoring",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$enable_enhanced_monitoring_input(StreamName = StreamName, ShardLevelMetrics = ShardLevelMetrics, StreamARN = StreamARN)
  output <- .kinesis$enable_enhanced_monitoring_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$enable_enhanced_monitoring <- kinesis_enable_enhanced_monitoring

#' Gets data records from a Kinesis data stream's shard
#'
#' @description
#' Gets data records from a Kinesis data stream's shard.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_get_records/](https://www.paws-r-sdk.com/docs/kinesis_get_records/) for full documentation.
#'
#' @param ShardIterator &#91;required&#93; The position in the shard from which you want to start sequentially
#' reading data records. A shard iterator specifies this position using the
#' sequence number of a data record in the shard.
#' @param Limit The maximum number of records to return. Specify a value of up to
#' 10,000. If you specify a value that is greater than 10,000,
#' [`get_records`][kinesis_get_records] throws `InvalidArgumentException`.
#' The default value is 10,000.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_get_records
kinesis_get_records <- function(ShardIterator, Limit = NULL, StreamARN = NULL) {
  op <- new_operation(
    name = "GetRecords",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$get_records_input(ShardIterator = ShardIterator, Limit = Limit, StreamARN = StreamARN)
  output <- .kinesis$get_records_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$get_records <- kinesis_get_records

#' Returns a policy attached to the specified data stream or consumer
#'
#' @description
#' Returns a policy attached to the specified data stream or consumer. Request patterns can be one of the following:
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_get_resource_policy/](https://www.paws-r-sdk.com/docs/kinesis_get_resource_policy/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the data stream or consumer.
#'
#' @keywords internal
#'
#' @rdname kinesis_get_resource_policy
kinesis_get_resource_policy <- function(ResourceARN) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$get_resource_policy_input(ResourceARN = ResourceARN)
  output <- .kinesis$get_resource_policy_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$get_resource_policy <- kinesis_get_resource_policy

#' Gets an Amazon Kinesis shard iterator
#'
#' @description
#' Gets an Amazon Kinesis shard iterator. A shard iterator expires 5 minutes after it is returned to the requester.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_get_shard_iterator/](https://www.paws-r-sdk.com/docs/kinesis_get_shard_iterator/) for full documentation.
#'
#' @param StreamName The name of the Amazon Kinesis data stream.
#' @param ShardId &#91;required&#93; The shard ID of the Kinesis Data Streams shard to get the iterator for.
#' @param ShardIteratorType &#91;required&#93; Determines how the shard iterator is used to start reading data records
#' from the shard.
#' 
#' The following are the valid Amazon Kinesis shard iterator types:
#' 
#' -   AT_SEQUENCE_NUMBER - Start reading from the position denoted by a
#'     specific sequence number, provided in the value
#'     `StartingSequenceNumber`.
#' 
#' -   AFTER_SEQUENCE_NUMBER - Start reading right after the position
#'     denoted by a specific sequence number, provided in the value
#'     `StartingSequenceNumber`.
#' 
#' -   AT_TIMESTAMP - Start reading from the position denoted by a specific
#'     time stamp, provided in the value `Timestamp`.
#' 
#' -   TRIM_HORIZON - Start reading at the last untrimmed record in the
#'     shard in the system, which is the oldest data record in the shard.
#' 
#' -   LATEST - Start reading just after the most recent record in the
#'     shard, so that you always read the most recent data in the shard.
#' @param StartingSequenceNumber The sequence number of the data record in the shard from which to start
#' reading. Used with shard iterator type AT_SEQUENCE_NUMBER and
#' AFTER_SEQUENCE_NUMBER.
#' @param Timestamp The time stamp of the data record from which to start reading. Used with
#' shard iterator type AT_TIMESTAMP. A time stamp is the Unix epoch date
#' with precision in milliseconds. For example,
#' `2016-04-04T19:58:46.480-00:00` or `1459799926.480`. If a record with
#' this exact time stamp does not exist, the iterator returned is for the
#' next (later) record. If the time stamp is older than the current trim
#' horizon, the iterator returned is for the oldest untrimmed data record
#' (TRIM_HORIZON).
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_get_shard_iterator
kinesis_get_shard_iterator <- function(StreamName = NULL, ShardId, ShardIteratorType, StartingSequenceNumber = NULL, Timestamp = NULL, StreamARN = NULL) {
  op <- new_operation(
    name = "GetShardIterator",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$get_shard_iterator_input(StreamName = StreamName, ShardId = ShardId, ShardIteratorType = ShardIteratorType, StartingSequenceNumber = StartingSequenceNumber, Timestamp = Timestamp, StreamARN = StreamARN)
  output <- .kinesis$get_shard_iterator_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$get_shard_iterator <- kinesis_get_shard_iterator

#' Increases the Kinesis data stream's retention period, which is the
#' length of time data records are accessible after they are added to the
#' stream
#'
#' @description
#' Increases the Kinesis data stream's retention period, which is the length of time data records are accessible after they are added to the stream. The maximum value of a stream's retention period is 8760 hours (365 days).
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_increase_stream_retention_period/](https://www.paws-r-sdk.com/docs/kinesis_increase_stream_retention_period/) for full documentation.
#'
#' @param StreamName The name of the stream to modify.
#' @param RetentionPeriodHours &#91;required&#93; The new retention period of the stream, in hours. Must be more than the
#' current retention period.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_increase_stream_retention_period
kinesis_increase_stream_retention_period <- function(StreamName = NULL, RetentionPeriodHours, StreamARN = NULL) {
  op <- new_operation(
    name = "IncreaseStreamRetentionPeriod",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$increase_stream_retention_period_input(StreamName = StreamName, RetentionPeriodHours = RetentionPeriodHours, StreamARN = StreamARN)
  output <- .kinesis$increase_stream_retention_period_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$increase_stream_retention_period <- kinesis_increase_stream_retention_period

#' Lists the shards in a stream and provides information about each shard
#'
#' @description
#' Lists the shards in a stream and provides information about each shard. This operation has a limit of 1000 transactions per second per data stream.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_list_shards/](https://www.paws-r-sdk.com/docs/kinesis_list_shards/) for full documentation.
#'
#' @param StreamName The name of the data stream whose shards you want to list.
#' 
#' You cannot specify this parameter if you specify the `NextToken`
#' parameter.
#' @param NextToken When the number of shards in the data stream is greater than the default
#' value for the `MaxResults` parameter, or if you explicitly specify a
#' value for `MaxResults` that is less than the number of shards in the
#' data stream, the response includes a pagination token named `NextToken`.
#' You can specify this `NextToken` value in a subsequent call to
#' [`list_shards`][kinesis_list_shards] to list the next set of shards.
#' 
#' Don't specify `StreamName` or `StreamCreationTimestamp` if you specify
#' `NextToken` because the latter unambiguously identifies the stream.
#' 
#' You can optionally specify a value for the `MaxResults` parameter when
#' you specify `NextToken`. If you specify a `MaxResults` value that is
#' less than the number of shards that the operation returns if you don't
#' specify `MaxResults`, the response will contain a new `NextToken` value.
#' You can use the new `NextToken` value in a subsequent call to the
#' [`list_shards`][kinesis_list_shards] operation.
#' 
#' Tokens expire after 300 seconds. When you obtain a value for `NextToken`
#' in the response to a call to [`list_shards`][kinesis_list_shards], you
#' have 300 seconds to use that value. If you specify an expired token in a
#' call to [`list_shards`][kinesis_list_shards], you get
#' `ExpiredNextTokenException`.
#' @param ExclusiveStartShardId Specify this parameter to indicate that you want to list the shards
#' starting with the shard whose ID immediately follows
#' `ExclusiveStartShardId`.
#' 
#' If you don't specify this parameter, the default behavior is for
#' [`list_shards`][kinesis_list_shards] to list the shards starting with
#' the first one in the stream.
#' 
#' You cannot specify this parameter if you specify `NextToken`.
#' @param MaxResults The maximum number of shards to return in a single call to
#' [`list_shards`][kinesis_list_shards]. The maximum number of shards to
#' return in a single call. The default value is 1000. If you specify a
#' value greater than 1000, at most 1000 results are returned.
#' 
#' When the number of shards to be listed is greater than the value of
#' `MaxResults`, the response contains a `NextToken` value that you can use
#' in a subsequent call to [`list_shards`][kinesis_list_shards] to list the
#' next set of shards.
#' @param StreamCreationTimestamp Specify this input parameter to distinguish data streams that have the
#' same name. For example, if you create a data stream and then delete it,
#' and you later create another data stream with the same name, you can use
#' this input parameter to specify which of the two streams you want to
#' list the shards for.
#' 
#' You cannot specify this parameter if you specify the `NextToken`
#' parameter.
#' @param ShardFilter Enables you to filter out the response of the
#' [`list_shards`][kinesis_list_shards] API. You can only specify one
#' filter at a time.
#' 
#' If you use the `ShardFilter` parameter when invoking the ListShards API,
#' the `Type` is the required property and must be specified. If you
#' specify the `AT_TRIM_HORIZON`, `FROM_TRIM_HORIZON`, or `AT_LATEST`
#' types, you do not need to specify either the `ShardId` or the
#' `Timestamp` optional properties.
#' 
#' If you specify the `AFTER_SHARD_ID` type, you must also provide the
#' value for the optional `ShardId` property. The `ShardId` property is
#' identical in fuctionality to the `ExclusiveStartShardId` parameter of
#' the [`list_shards`][kinesis_list_shards] API. When `ShardId` property is
#' specified, the response includes the shards starting with the shard
#' whose ID immediately follows the `ShardId` that you provided.
#' 
#' If you specify the `AT_TIMESTAMP` or `FROM_TIMESTAMP_ID` type, you must
#' also provide the value for the optional `Timestamp` property. If you
#' specify the AT_TIMESTAMP type, then all shards that were open at the
#' provided timestamp are returned. If you specify the FROM_TIMESTAMP type,
#' then all shards starting from the provided timestamp to TIP are
#' returned.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_list_shards
kinesis_list_shards <- function(StreamName = NULL, NextToken = NULL, ExclusiveStartShardId = NULL, MaxResults = NULL, StreamCreationTimestamp = NULL, ShardFilter = NULL, StreamARN = NULL) {
  op <- new_operation(
    name = "ListShards",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$list_shards_input(StreamName = StreamName, NextToken = NextToken, ExclusiveStartShardId = ExclusiveStartShardId, MaxResults = MaxResults, StreamCreationTimestamp = StreamCreationTimestamp, ShardFilter = ShardFilter, StreamARN = StreamARN)
  output <- .kinesis$list_shards_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$list_shards <- kinesis_list_shards

#' Lists the consumers registered to receive data from a stream using
#' enhanced fan-out, and provides information about each consumer
#'
#' @description
#' Lists the consumers registered to receive data from a stream using enhanced fan-out, and provides information about each consumer.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_list_stream_consumers/](https://www.paws-r-sdk.com/docs/kinesis_list_stream_consumers/) for full documentation.
#'
#' @param StreamARN &#91;required&#93; The ARN of the Kinesis data stream for which you want to list the
#' registered consumers. For more information, see [Amazon Resource Names
#' (ARNs) and Amazon Web Services Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arn-syntax-kinesis-streams).
#' @param NextToken When the number of consumers that are registered with the data stream is
#' greater than the default value for the `MaxResults` parameter, or if you
#' explicitly specify a value for `MaxResults` that is less than the number
#' of consumers that are registered with the data stream, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_stream_consumers`][kinesis_list_stream_consumers] to list the
#' next set of registered consumers.
#' 
#' Don't specify `StreamName` or `StreamCreationTimestamp` if you specify
#' `NextToken` because the latter unambiguously identifies the stream.
#' 
#' You can optionally specify a value for the `MaxResults` parameter when
#' you specify `NextToken`. If you specify a `MaxResults` value that is
#' less than the number of consumers that the operation returns if you
#' don't specify `MaxResults`, the response will contain a new `NextToken`
#' value. You can use the new `NextToken` value in a subsequent call to the
#' [`list_stream_consumers`][kinesis_list_stream_consumers] operation to
#' list the next set of consumers.
#' 
#' Tokens expire after 300 seconds. When you obtain a value for `NextToken`
#' in the response to a call to
#' [`list_stream_consumers`][kinesis_list_stream_consumers], you have 300
#' seconds to use that value. If you specify an expired token in a call to
#' [`list_stream_consumers`][kinesis_list_stream_consumers], you get
#' `ExpiredNextTokenException`.
#' @param MaxResults The maximum number of consumers that you want a single call of
#' [`list_stream_consumers`][kinesis_list_stream_consumers] to return. The
#' default value is 100. If you specify a value greater than 100, at most
#' 100 results are returned.
#' @param StreamCreationTimestamp Specify this input parameter to distinguish data streams that have the
#' same name. For example, if you create a data stream and then delete it,
#' and you later create another data stream with the same name, you can use
#' this input parameter to specify which of the two streams you want to
#' list the consumers for.
#' 
#' You can't specify this parameter if you specify the NextToken parameter.
#'
#' @keywords internal
#'
#' @rdname kinesis_list_stream_consumers
kinesis_list_stream_consumers <- function(StreamARN, NextToken = NULL, MaxResults = NULL, StreamCreationTimestamp = NULL) {
  op <- new_operation(
    name = "ListStreamConsumers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .kinesis$list_stream_consumers_input(StreamARN = StreamARN, NextToken = NextToken, MaxResults = MaxResults, StreamCreationTimestamp = StreamCreationTimestamp)
  output <- .kinesis$list_stream_consumers_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$list_stream_consumers <- kinesis_list_stream_consumers

#' Lists your Kinesis data streams
#'
#' @description
#' Lists your Kinesis data streams.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_list_streams/](https://www.paws-r-sdk.com/docs/kinesis_list_streams/) for full documentation.
#'
#' @param Limit The maximum number of streams to list. The default value is 100. If you
#' specify a value greater than 100, at most 100 results are returned.
#' @param ExclusiveStartStreamName The name of the stream to start the list with.
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname kinesis_list_streams
kinesis_list_streams <- function(Limit = NULL, ExclusiveStartStreamName = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListStreams",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "Limit", more_results = "HasMoreStreams", output_token = "NextToken", result_key = list("StreamNames", "StreamSummaries"))
  )
  input <- .kinesis$list_streams_input(Limit = Limit, ExclusiveStartStreamName = ExclusiveStartStreamName, NextToken = NextToken)
  output <- .kinesis$list_streams_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$list_streams <- kinesis_list_streams

#' Lists the tags for the specified Kinesis data stream
#'
#' @description
#' Lists the tags for the specified Kinesis data stream. This operation has a limit of five transactions per second per account.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_list_tags_for_stream/](https://www.paws-r-sdk.com/docs/kinesis_list_tags_for_stream/) for full documentation.
#'
#' @param StreamName The name of the stream.
#' @param ExclusiveStartTagKey The key to use as the starting point for the list of tags. If this
#' parameter is set, [`list_tags_for_stream`][kinesis_list_tags_for_stream]
#' gets all tags that occur after `ExclusiveStartTagKey`.
#' @param Limit The number of tags to return. If this number is less than the total
#' number of tags associated with the stream, `HasMoreTags` is set to
#' `true`. To list additional tags, set `ExclusiveStartTagKey` to the last
#' key in the response.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_list_tags_for_stream
kinesis_list_tags_for_stream <- function(StreamName = NULL, ExclusiveStartTagKey = NULL, Limit = NULL, StreamARN = NULL) {
  op <- new_operation(
    name = "ListTagsForStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$list_tags_for_stream_input(StreamName = StreamName, ExclusiveStartTagKey = ExclusiveStartTagKey, Limit = Limit, StreamARN = StreamARN)
  output <- .kinesis$list_tags_for_stream_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$list_tags_for_stream <- kinesis_list_tags_for_stream

#' Merges two adjacent shards in a Kinesis data stream and combines them
#' into a single shard to reduce the stream's capacity to ingest and
#' transport data
#'
#' @description
#' Merges two adjacent shards in a Kinesis data stream and combines them into a single shard to reduce the stream's capacity to ingest and transport data. This API is only supported for the data streams with the provisioned capacity mode. Two shards are considered adjacent if the union of the hash key ranges for the two shards form a contiguous set with no gaps. For example, if you have two shards, one with a hash key range of 276...381 and the other with a hash key range of 382...454, then you could merge these two shards into a single shard that would have a hash key range of 276...454. After the merge, the single child shard receives data for all hash key values covered by the two parent shards.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_merge_shards/](https://www.paws-r-sdk.com/docs/kinesis_merge_shards/) for full documentation.
#'
#' @param StreamName The name of the stream for the merge.
#' @param ShardToMerge &#91;required&#93; The shard ID of the shard to combine with the adjacent shard for the
#' merge.
#' @param AdjacentShardToMerge &#91;required&#93; The shard ID of the adjacent shard for the merge.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_merge_shards
kinesis_merge_shards <- function(StreamName = NULL, ShardToMerge, AdjacentShardToMerge, StreamARN = NULL) {
  op <- new_operation(
    name = "MergeShards",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$merge_shards_input(StreamName = StreamName, ShardToMerge = ShardToMerge, AdjacentShardToMerge = AdjacentShardToMerge, StreamARN = StreamARN)
  output <- .kinesis$merge_shards_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$merge_shards <- kinesis_merge_shards

#' Writes a single data record into an Amazon Kinesis data stream
#'
#' @description
#' Writes a single data record into an Amazon Kinesis data stream. Call [`put_record`][kinesis_put_record] to send data into the stream for real-time ingestion and subsequent processing, one record at a time. Each shard can support writes up to 1,000 records per second, up to a maximum data write total of 1 MiB per second.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_put_record/](https://www.paws-r-sdk.com/docs/kinesis_put_record/) for full documentation.
#'
#' @param StreamName The name of the stream to put the data record into.
#' @param Data &#91;required&#93; The data blob to put into the record, which is base64-encoded when the
#' blob is serialized. When the data blob (the payload before
#' base64-encoding) is added to the partition key size, the total size must
#' not exceed the maximum record size (1 MiB).
#' @param PartitionKey &#91;required&#93; Determines which shard in the stream the data record is assigned to.
#' Partition keys are Unicode strings with a maximum length limit of 256
#' characters for each key. Amazon Kinesis Data Streams uses the partition
#' key as input to a hash function that maps the partition key and
#' associated data to a specific shard. Specifically, an MD5 hash function
#' is used to map partition keys to 128-bit integer values and to map
#' associated data records to shards. As a result of this hashing
#' mechanism, all data records with the same partition key map to the same
#' shard within the stream.
#' @param ExplicitHashKey The hash value used to explicitly determine the shard the data record is
#' assigned to by overriding the partition key hash.
#' @param SequenceNumberForOrdering Guarantees strictly increasing sequence numbers, for puts from the same
#' client and to the same partition key. Usage: set the
#' `SequenceNumberForOrdering` of record *n* to the sequence number of
#' record *n-1* (as returned in the result when putting record *n-1*). If
#' this parameter is not set, records are coarsely ordered based on arrival
#' time.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_put_record
kinesis_put_record <- function(StreamName = NULL, Data, PartitionKey, ExplicitHashKey = NULL, SequenceNumberForOrdering = NULL, StreamARN = NULL) {
  op <- new_operation(
    name = "PutRecord",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$put_record_input(StreamName = StreamName, Data = Data, PartitionKey = PartitionKey, ExplicitHashKey = ExplicitHashKey, SequenceNumberForOrdering = SequenceNumberForOrdering, StreamARN = StreamARN)
  output <- .kinesis$put_record_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$put_record <- kinesis_put_record

#' Writes multiple data records into a Kinesis data stream in a single call
#' (also referred to as a PutRecords request)
#'
#' @description
#' Writes multiple data records into a Kinesis data stream in a single call (also referred to as a [`put_records`][kinesis_put_records] request). Use this operation to send data into the stream for data ingestion and processing.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_put_records/](https://www.paws-r-sdk.com/docs/kinesis_put_records/) for full documentation.
#'
#' @param Records &#91;required&#93; The records associated with the request.
#' @param StreamName The stream name associated with the request.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_put_records
kinesis_put_records <- function(Records, StreamName = NULL, StreamARN = NULL) {
  op <- new_operation(
    name = "PutRecords",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$put_records_input(Records = Records, StreamName = StreamName, StreamARN = StreamARN)
  output <- .kinesis$put_records_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$put_records <- kinesis_put_records

#' Attaches a resource-based policy to a data stream or registered consumer
#'
#' @description
#' Attaches a resource-based policy to a data stream or registered consumer. If you are using an identity other than the root user of the Amazon Web Services account that owns the resource, the calling identity must have the [`put_resource_policy`][kinesis_put_resource_policy] permissions on the specified Kinesis Data Streams resource and belong to the owner's account in order to use this operation. If you don't have [`put_resource_policy`][kinesis_put_resource_policy] permissions, Amazon Kinesis Data Streams returns a `403 Access Denied error`. If you receive a `ResourceNotFoundException`, check to see if you passed a valid stream or consumer resource.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_put_resource_policy/](https://www.paws-r-sdk.com/docs/kinesis_put_resource_policy/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the data stream or consumer.
#' @param Policy &#91;required&#93; Details of the resource policy. It must include the identity of the
#' principal and the actions allowed on this resource. This is formatted as
#' a JSON string.
#'
#' @keywords internal
#'
#' @rdname kinesis_put_resource_policy
kinesis_put_resource_policy <- function(ResourceARN, Policy) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$put_resource_policy_input(ResourceARN = ResourceARN, Policy = Policy)
  output <- .kinesis$put_resource_policy_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$put_resource_policy <- kinesis_put_resource_policy

#' Registers a consumer with a Kinesis data stream
#'
#' @description
#' Registers a consumer with a Kinesis data stream. When you use this operation, the consumer you register can then call SubscribeToShard to receive data from the stream using enhanced fan-out, at a rate of up to 2 MiB per second for every shard you subscribe to. This rate is unaffected by the total number of consumers that read from the same stream.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_register_stream_consumer/](https://www.paws-r-sdk.com/docs/kinesis_register_stream_consumer/) for full documentation.
#'
#' @param StreamARN &#91;required&#93; The ARN of the Kinesis data stream that you want to register the
#' consumer with. For more info, see [Amazon Resource Names (ARNs) and
#' Amazon Web Services Service
#' Namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arn-syntax-kinesis-streams).
#' @param ConsumerName &#91;required&#93; For a given Kinesis data stream, each consumer must have a unique name.
#' However, consumer names don't have to be unique across data streams.
#'
#' @keywords internal
#'
#' @rdname kinesis_register_stream_consumer
kinesis_register_stream_consumer <- function(StreamARN, ConsumerName) {
  op <- new_operation(
    name = "RegisterStreamConsumer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$register_stream_consumer_input(StreamARN = StreamARN, ConsumerName = ConsumerName)
  output <- .kinesis$register_stream_consumer_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$register_stream_consumer <- kinesis_register_stream_consumer

#' Removes tags from the specified Kinesis data stream
#'
#' @description
#' Removes tags from the specified Kinesis data stream. Removed tags are deleted and cannot be recovered after this operation successfully completes.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_remove_tags_from_stream/](https://www.paws-r-sdk.com/docs/kinesis_remove_tags_from_stream/) for full documentation.
#'
#' @param StreamName The name of the stream.
#' @param TagKeys &#91;required&#93; A list of tag keys. Each corresponding tag is removed from the stream.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_remove_tags_from_stream
kinesis_remove_tags_from_stream <- function(StreamName = NULL, TagKeys, StreamARN = NULL) {
  op <- new_operation(
    name = "RemoveTagsFromStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$remove_tags_from_stream_input(StreamName = StreamName, TagKeys = TagKeys, StreamARN = StreamARN)
  output <- .kinesis$remove_tags_from_stream_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$remove_tags_from_stream <- kinesis_remove_tags_from_stream

#' Splits a shard into two new shards in the Kinesis data stream, to
#' increase the stream's capacity to ingest and transport data
#'
#' @description
#' Splits a shard into two new shards in the Kinesis data stream, to increase the stream's capacity to ingest and transport data. [`split_shard`][kinesis_split_shard] is called when there is a need to increase the overall capacity of a stream because of an expected increase in the volume of data records being ingested. This API is only supported for the data streams with the provisioned capacity mode.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_split_shard/](https://www.paws-r-sdk.com/docs/kinesis_split_shard/) for full documentation.
#'
#' @param StreamName The name of the stream for the shard split.
#' @param ShardToSplit &#91;required&#93; The shard ID of the shard to split.
#' @param NewStartingHashKey &#91;required&#93; A hash key value for the starting hash key of one of the child shards
#' created by the split. The hash key range for a given shard constitutes a
#' set of ordered contiguous positive integers. The value for
#' `NewStartingHashKey` must be in the range of hash keys being mapped into
#' the shard. The `NewStartingHashKey` hash key value and all higher hash
#' key values in hash key range are distributed to one of the child shards.
#' All the lower hash key values in the range are distributed to the other
#' child shard.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_split_shard
kinesis_split_shard <- function(StreamName = NULL, ShardToSplit, NewStartingHashKey, StreamARN = NULL) {
  op <- new_operation(
    name = "SplitShard",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$split_shard_input(StreamName = StreamName, ShardToSplit = ShardToSplit, NewStartingHashKey = NewStartingHashKey, StreamARN = StreamARN)
  output <- .kinesis$split_shard_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$split_shard <- kinesis_split_shard

#' Enables or updates server-side encryption using an Amazon Web Services
#' KMS key for a specified stream
#'
#' @description
#' Enables or updates server-side encryption using an Amazon Web Services KMS key for a specified stream.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_start_stream_encryption/](https://www.paws-r-sdk.com/docs/kinesis_start_stream_encryption/) for full documentation.
#'
#' @param StreamName The name of the stream for which to start encrypting records.
#' @param EncryptionType &#91;required&#93; The encryption type to use. The only valid value is `KMS`.
#' @param KeyId &#91;required&#93; The GUID for the customer-managed Amazon Web Services KMS key to use for
#' encryption. This value can be a globally unique identifier, a fully
#' specified Amazon Resource Name (ARN) to either an alias or a key, or an
#' alias name prefixed by "alias/".You can also use a master key owned by
#' Kinesis Data Streams by specifying the alias `aws/kinesis`.
#' 
#' -   Key ARN example:
#'     `arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012`
#' 
#' -   Alias ARN example:
#'     `arn:aws:kms:us-east-1:123456789012:alias/MyAliasName`
#' 
#' -   Globally unique key ID example:
#'     `12345678-1234-1234-1234-123456789012`
#' 
#' -   Alias name example: `alias/MyAliasName`
#' 
#' -   Master key owned by Kinesis Data Streams: `alias/aws/kinesis`
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_start_stream_encryption
kinesis_start_stream_encryption <- function(StreamName = NULL, EncryptionType, KeyId, StreamARN = NULL) {
  op <- new_operation(
    name = "StartStreamEncryption",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$start_stream_encryption_input(StreamName = StreamName, EncryptionType = EncryptionType, KeyId = KeyId, StreamARN = StreamARN)
  output <- .kinesis$start_stream_encryption_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$start_stream_encryption <- kinesis_start_stream_encryption

#' Disables server-side encryption for a specified stream
#'
#' @description
#' Disables server-side encryption for a specified stream.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_stop_stream_encryption/](https://www.paws-r-sdk.com/docs/kinesis_stop_stream_encryption/) for full documentation.
#'
#' @param StreamName The name of the stream on which to stop encrypting records.
#' @param EncryptionType &#91;required&#93; The encryption type. The only valid value is `KMS`.
#' @param KeyId &#91;required&#93; The GUID for the customer-managed Amazon Web Services KMS key to use for
#' encryption. This value can be a globally unique identifier, a fully
#' specified Amazon Resource Name (ARN) to either an alias or a key, or an
#' alias name prefixed by "alias/".You can also use a master key owned by
#' Kinesis Data Streams by specifying the alias `aws/kinesis`.
#' 
#' -   Key ARN example:
#'     `arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012`
#' 
#' -   Alias ARN example:
#'     `arn:aws:kms:us-east-1:123456789012:alias/MyAliasName`
#' 
#' -   Globally unique key ID example:
#'     `12345678-1234-1234-1234-123456789012`
#' 
#' -   Alias name example: `alias/MyAliasName`
#' 
#' -   Master key owned by Kinesis Data Streams: `alias/aws/kinesis`
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_stop_stream_encryption
kinesis_stop_stream_encryption <- function(StreamName = NULL, EncryptionType, KeyId, StreamARN = NULL) {
  op <- new_operation(
    name = "StopStreamEncryption",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$stop_stream_encryption_input(StreamName = StreamName, EncryptionType = EncryptionType, KeyId = KeyId, StreamARN = StreamARN)
  output <- .kinesis$stop_stream_encryption_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$stop_stream_encryption <- kinesis_stop_stream_encryption

#' Updates the shard count of the specified stream to the specified number
#' of shards
#'
#' @description
#' Updates the shard count of the specified stream to the specified number of shards. This API is only supported for the data streams with the provisioned capacity mode.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_update_shard_count/](https://www.paws-r-sdk.com/docs/kinesis_update_shard_count/) for full documentation.
#'
#' @param StreamName The name of the stream.
#' @param TargetShardCount &#91;required&#93; The new number of shards. This value has the following default limits.
#' By default, you cannot do the following:
#' 
#' -   Set this value to more than double your current shard count for a
#'     stream.
#' 
#' -   Set this value below half your current shard count for a stream.
#' 
#' -   Set this value to more than 10000 shards in a stream (the default
#'     limit for shard count per stream is 10000 per account per region),
#'     unless you request a limit increase.
#' 
#' -   Scale a stream with more than 10000 shards down unless you set this
#'     value to less than 10000 shards.
#' @param ScalingType &#91;required&#93; The scaling type. Uniform scaling creates shards of equal size.
#' @param StreamARN The ARN of the stream.
#'
#' @keywords internal
#'
#' @rdname kinesis_update_shard_count
kinesis_update_shard_count <- function(StreamName = NULL, TargetShardCount, ScalingType, StreamARN = NULL) {
  op <- new_operation(
    name = "UpdateShardCount",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$update_shard_count_input(StreamName = StreamName, TargetShardCount = TargetShardCount, ScalingType = ScalingType, StreamARN = StreamARN)
  output <- .kinesis$update_shard_count_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$update_shard_count <- kinesis_update_shard_count

#' Updates the capacity mode of the data stream
#'
#' @description
#' Updates the capacity mode of the data stream. Currently, in Kinesis Data Streams, you can choose between an **on-demand** capacity mode and a **provisioned** capacity mode for your data stream.
#'
#' See [https://www.paws-r-sdk.com/docs/kinesis_update_stream_mode/](https://www.paws-r-sdk.com/docs/kinesis_update_stream_mode/) for full documentation.
#'
#' @param StreamARN &#91;required&#93; Specifies the ARN of the data stream whose capacity mode you want to
#' update.
#' @param StreamModeDetails &#91;required&#93; Specifies the capacity mode to which you want to set your data stream.
#' Currently, in Kinesis Data Streams, you can choose between an
#' **on-demand** capacity mode and a **provisioned** capacity mode for your
#' data streams.
#'
#' @keywords internal
#'
#' @rdname kinesis_update_stream_mode
kinesis_update_stream_mode <- function(StreamARN, StreamModeDetails) {
  op <- new_operation(
    name = "UpdateStreamMode",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .kinesis$update_stream_mode_input(StreamARN = StreamARN, StreamModeDetails = StreamModeDetails)
  output <- .kinesis$update_stream_mode_output()
  config <- get_config()
  svc <- .kinesis$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesis$operations$update_stream_mode <- kinesis_update_stream_mode
