% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_create_work_group}
\alias{athena_create_work_group}
\title{Creates a workgroup with the specified name}
\usage{
athena_create_work_group(
  Name,
  Configuration = NULL,
  Description = NULL,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The workgroup name.}

\item{Configuration}{Contains configuration information for creating an Athena SQL workgroup
or Spark enabled Athena workgroup. Athena SQL workgroup configuration
includes the location in Amazon S3 where query and calculation results
are stored, the encryption configuration, if any, used for encrypting
query results, whether the Amazon CloudWatch Metrics are enabled for the
workgroup, the limit for the amount of bytes scanned (cutoff) per query,
if it is specified, and whether workgroup's settings (specified with
\code{EnforceWorkGroupConfiguration}) in the \code{WorkGroupConfiguration}
override client-side settings. See
WorkGroupConfiguration$EnforceWorkGroupConfiguration.}

\item{Description}{The workgroup description.}

\item{Tags}{A list of comma separated tags to add to the workgroup that is created.}
}
\description{
Creates a workgroup with the specified name. A workgroup can be an Apache Spark enabled workgroup or an Athena SQL workgroup.

See \url{https://www.paws-r-sdk.com/docs/athena_create_work_group/} for full documentation.
}
\keyword{internal}
