% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivs_operations.R
\name{ivs_create_recording_configuration}
\alias{ivs_create_recording_configuration}
\title{Creates a new recording configuration, used to enable recording to
Amazon S3}
\usage{
ivs_create_recording_configuration(
  name = NULL,
  destinationConfiguration,
  tags = NULL,
  thumbnailConfiguration = NULL,
  recordingReconnectWindowSeconds = NULL,
  renditionConfiguration = NULL
)
}
\arguments{
\item{name}{Recording-configuration name. The value does not need to be unique.}

\item{destinationConfiguration}{[required] A complex type that contains a destination configuration for where
recorded video will be stored.}

\item{tags}{Array of 1-50 maps, each of the form \code{string:string (key:value)}. See
\href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services Resources}
for more information, including restrictions that apply to tags and "Tag
naming limits and requirements"; Amazon IVS has no service-specific
constraints beyond what is documented there.}

\item{thumbnailConfiguration}{A complex type that allows you to enable/disable the recording of
thumbnails for a live session and modify the interval at which
thumbnails are generated for the live session.}

\item{recordingReconnectWindowSeconds}{If a broadcast disconnects and then reconnects within the specified
interval, the multiple streams will be considered a single broadcast and
merged together. Default: 0.}

\item{renditionConfiguration}{Object that describes which renditions should be recorded for a stream.}
}
\description{
Creates a new recording configuration, used to enable recording to Amazon S3.

See \url{https://www.paws-r-sdk.com/docs/ivs_create_recording_configuration/} for full documentation.
}
\keyword{internal}
