% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_lineage_node_history}
\alias{datazone_list_lineage_node_history}
\title{Lists the history of the specified data lineage node}
\usage{
datazone_list_lineage_node_history(
  direction = NULL,
  domainIdentifier,
  eventTimestampGTE = NULL,
  eventTimestampLTE = NULL,
  identifier,
  maxResults = NULL,
  nextToken = NULL,
  sortOrder = NULL
)
}
\arguments{
\item{direction}{The direction of the data lineage node refers to the lineage node having
neighbors in that direction. For example, if direction is \code{UPSTREAM},
the \code{\link[=datazone_list_lineage_node_history]{list_lineage_node_history}}
API responds with historical versions with upstream neighbors only.}

\item{domainIdentifier}{[required] The ID of the domain where you want to list the history of the specified
data lineage node.}

\item{eventTimestampGTE}{Specifies whether the action is to return data lineage node history from
the time after the event timestamp.}

\item{eventTimestampLTE}{Specifies whether the action is to return data lineage node history from
the time prior of the event timestamp.}

\item{identifier}{[required] The ID of the data lineage node whose history you want to list.}

\item{maxResults}{The maximum number of history items to return in a single call to
ListLineageNodeHistory. When the number of memberships to be listed is
greater than the value of MaxResults, the response contains a NextToken
value that you can use in a subsequent call to ListLineageNodeHistory to
list the next set of items.}

\item{nextToken}{When the number of history items is greater than the default value for
the MaxResults parameter, or if you explicitly specify a value for
MaxResults that is less than the number of items, the response includes
a pagination token named NextToken. You can specify this NextToken value
in a subsequent call to ListLineageNodeHistory to list the next set of
items.}

\item{sortOrder}{The order by which you want data lineage node history to be sorted.}
}
\description{
Lists the history of the specified data lineage node.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_lineage_node_history/} for full documentation.
}
\keyword{internal}
