% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_list_qualification_types}
\alias{mturk_list_qualification_types}
\title{The ListQualificationTypes operation returns a list of Qualification
types, filtered by an optional search term}
\usage{
mturk_list_qualification_types(
  Query = NULL,
  MustBeRequestable,
  MustBeOwnedByCaller = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Query}{A text query against all of the searchable attributes of Qualification
types.}

\item{MustBeRequestable}{[required] Specifies that only Qualification types that a user can request through
the Amazon Mechanical Turk web site, such as by taking a Qualification
test, are returned as results of the search. Some Qualification types,
such as those assigned automatically by the system, cannot be requested
directly by users. If false, all Qualification types, including those
managed by the system, are considered. Valid values are True | False.}

\item{MustBeOwnedByCaller}{Specifies that only Qualification types that the Requester created are
returned. If false, the operation returns all Qualification types.}

\item{NextToken}{}

\item{MaxResults}{The maximum number of results to return in a single call.}
}
\description{
The \code{\link[=mturk_list_qualification_types]{list_qualification_types}} operation returns a list of Qualification types, filtered by an optional search term.

See \url{https://www.paws-r-sdk.com/docs/mturk_list_qualification_types/} for full documentation.
}
\keyword{internal}
