% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_set_endpoint_attributes}
\alias{sns_set_endpoint_attributes}
\title{Sets the attributes for an endpoint for a device on one of the supported
push notification services, such as GCM and APNS}
\usage{
sns_set_endpoint_attributes(EndpointArn, Attributes)
}
\arguments{
\item{EndpointArn}{[required] EndpointArn used for SetEndpointAttributes action.}

\item{Attributes}{[required] A map of the endpoint attributes. Attributes in this map include the
following:
\itemize{
\item \code{CustomUserData} -- arbitrary user data to associate with the
endpoint. Amazon SNS does not use this data. The data must be in
UTF-8 format and less than 2KB.
\item \code{Enabled} -- flag that enables/disables delivery to the endpoint.
Amazon SNS will set this to false when a notification service
indicates to Amazon SNS that the endpoint is invalid. Users can set
it back to true, typically after updating Token.
\item \code{Token} -- device token, also referred to as a registration id, for
an app and mobile device. This is returned from the notification
service when an app and mobile device are registered with the
notification service.
}}
}
\description{
Sets the attributes for an endpoint for a device on one of the supported
push notification services, such as GCM and APNS. For more information,
see \href{https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html}{Using Amazon SNS Mobile Push Notifications}.
}
\section{Request syntax}{
\preformatted{svc$set_endpoint_attributes(
  EndpointArn = "string",
  Attributes = list(
    "string"
  )
)
}
}

\keyword{internal}
