% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_create_activity}
\alias{sfn_create_activity}
\title{Creates an activity}
\usage{
sfn_create_activity(name, tags)
}
\arguments{
\item{name}{[required] The name of the activity to create. This name must be unique for your
AWS account and region for 90 days. For more information, see \href{https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions}{Limits Related to State Machine Executions}
in the \emph{AWS Step Functions Developer Guide}.

A name must \emph{not} contain:
\itemize{
\item whitespace
\item brackets \code{&lt; &gt; \{ \} \\[ \\]}
\item wildcard characters \code{? *}
\item special characters \code{\" # \\\% \\ ^ | ~ \` $ &amp; , ; : /}
\item control characters (\code{U+0000-001F}, \code{U+007F-009F})
}}

\item{tags}{The list of tags to add to a resource.}
}
\description{
Creates an activity. An activity is a task that you write in any
programming language and host on any machine that has access to AWS Step
Functions. Activities must poll Step Functions using the
\code{GetActivityTask} API action and respond using \code{SendTask*} API actions.
This function lets Step Functions know the existence of your activity
and returns an identifier for use in a state machine and when polling
from the activity.
}
\details{
This operation is eventually consistent. The results are best effort and
may not reflect very recent updates and changes.
}
\section{Request syntax}{
\preformatted{svc$create_activity(
  name = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
