% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_unsubscribe}
\alias{sns_unsubscribe}
\title{Deletes a subscription}
\usage{
sns_unsubscribe(SubscriptionArn)
}
\arguments{
\item{SubscriptionArn}{[required] The ARN of the subscription to be deleted.}
}
\description{
Deletes a subscription. If the subscription requires authentication for
deletion, only the owner of the subscription or the topic's owner can
unsubscribe, and an AWS signature is required. If the \code{Unsubscribe} call
does not require authentication and the requester is not the
subscription owner, a final cancellation message is delivered to the
endpoint, so that the endpoint owner can easily resubscribe to the topic
if the \code{Unsubscribe} request was unintended.
}
\details{
This action is throttled at 100 transactions per second (TPS).
}
\section{Request syntax}{
\preformatted{svc$unsubscribe(
  SubscriptionArn = "string"
)
}
}

\keyword{internal}
