# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AmazonMQ
#'
#' @description
#' Amazon MQ is a managed message broker service for Apache ActiveMQ and
#' RabbitMQ that makes it easy to set up and operate message brokers in the
#' cloud. A message broker allows software applications and components to
#' communicate using various programming languages, operating systems, and
#' formal messaging protocols.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- mq(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- mq()
#' svc$create_broker(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=mq_create_broker]{create_broker} \tab Creates a broker\cr
#'  \link[=mq_create_configuration]{create_configuration} \tab Creates a new configuration for the specified configuration name\cr
#'  \link[=mq_create_tags]{create_tags} \tab Add a tag to a resource\cr
#'  \link[=mq_create_user]{create_user} \tab Creates an ActiveMQ user\cr
#'  \link[=mq_delete_broker]{delete_broker} \tab Deletes a broker\cr
#'  \link[=mq_delete_tags]{delete_tags} \tab Removes a tag from a resource\cr
#'  \link[=mq_delete_user]{delete_user} \tab Deletes an ActiveMQ user\cr
#'  \link[=mq_describe_broker]{describe_broker} \tab Returns information about the specified broker\cr
#'  \link[=mq_describe_broker_engine_types]{describe_broker_engine_types} \tab Describe available engine types and versions\cr
#'  \link[=mq_describe_broker_instance_options]{describe_broker_instance_options} \tab Describe available broker instance options\cr
#'  \link[=mq_describe_configuration]{describe_configuration} \tab Returns information about the specified configuration\cr
#'  \link[=mq_describe_configuration_revision]{describe_configuration_revision} \tab Returns the specified configuration revision for the specified configuration\cr
#'  \link[=mq_describe_user]{describe_user} \tab Returns information about an ActiveMQ user\cr
#'  \link[=mq_list_brokers]{list_brokers} \tab Returns a list of all brokers\cr
#'  \link[=mq_list_configuration_revisions]{list_configuration_revisions} \tab Returns a list of all revisions for the specified configuration\cr
#'  \link[=mq_list_configurations]{list_configurations} \tab Returns a list of all configurations\cr
#'  \link[=mq_list_tags]{list_tags} \tab Lists tags for a resource\cr
#'  \link[=mq_list_users]{list_users} \tab Returns a list of all ActiveMQ users\cr
#'  \link[=mq_promote]{promote} \tab Promotes a data replication replica broker to the primary broker role\cr
#'  \link[=mq_reboot_broker]{reboot_broker} \tab Reboots a broker\cr
#'  \link[=mq_update_broker]{update_broker} \tab Adds a pending configuration change to a broker\cr
#'  \link[=mq_update_configuration]{update_configuration} \tab Updates the specified configuration\cr
#'  \link[=mq_update_user]{update_user} \tab Updates the information for an ActiveMQ user
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname mq
#' @export
mq <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .mq$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.mq <- list()

.mq$operations <- list()

.mq$metadata <- list(
  service_name = "mq",
  endpoints = list("*" = list(endpoint = "mq.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "mq.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "mq.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "mq.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "mq",
  api_version = "2017-11-27",
  signing_name = "mq",
  json_version = "1.1",
  target_prefix = ""
)

.mq$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.mq$metadata, handlers, config)
}
