# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include locationservice_service.R
NULL

#' Creates an association between a geofence collection and a tracker
#' resource
#'
#' @description
#' Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_associate_tracker_consumer/](https://www.paws-r-sdk.com/docs/locationservice_associate_tracker_consumer/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The name of the tracker resource to be associated with a geofence
#' collection.
#' @param ConsumerArn &#91;required&#93; The Amazon Resource Name (ARN) for the geofence collection to be
#' associated to tracker resource. Used when you need to specify a resource
#' across all Amazon Web Services.
#' 
#' -   Format example:
#'     `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer`
#'
#' @keywords internal
#'
#' @rdname locationservice_associate_tracker_consumer
locationservice_associate_tracker_consumer <- function(TrackerName, ConsumerArn) {
  op <- new_operation(
    name = "AssociateTrackerConsumer",
    http_method = "POST",
    http_path = "/tracking/v0/trackers/{TrackerName}/consumers",
    host_prefix = "cp.tracking.",
    paginator = list()
  )
  input <- .locationservice$associate_tracker_consumer_input(TrackerName = TrackerName, ConsumerArn = ConsumerArn)
  output <- .locationservice$associate_tracker_consumer_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$associate_tracker_consumer <- locationservice_associate_tracker_consumer

#' Deletes the position history of one or more devices from a tracker
#' resource
#'
#' @description
#' Deletes the position history of one or more devices from a tracker resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_batch_delete_device_position_history/](https://www.paws-r-sdk.com/docs/locationservice_batch_delete_device_position_history/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The name of the tracker resource to delete the device position history
#' from.
#' @param DeviceIds &#91;required&#93; Devices whose position history you want to delete.
#' 
#' -   For example, for two devices: `“DeviceIds” : [DeviceId1,DeviceId2]`
#'
#' @keywords internal
#'
#' @rdname locationservice_batch_delete_device_position_history
locationservice_batch_delete_device_position_history <- function(TrackerName, DeviceIds) {
  op <- new_operation(
    name = "BatchDeleteDevicePositionHistory",
    http_method = "POST",
    http_path = "/tracking/v0/trackers/{TrackerName}/delete-positions",
    host_prefix = "tracking.",
    paginator = list()
  )
  input <- .locationservice$batch_delete_device_position_history_input(TrackerName = TrackerName, DeviceIds = DeviceIds)
  output <- .locationservice$batch_delete_device_position_history_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$batch_delete_device_position_history <- locationservice_batch_delete_device_position_history

#' Deletes a batch of geofences from a geofence collection
#'
#' @description
#' Deletes a batch of geofences from a geofence collection.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_batch_delete_geofence/](https://www.paws-r-sdk.com/docs/locationservice_batch_delete_geofence/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; The geofence collection storing the geofences to be deleted.
#' @param GeofenceIds &#91;required&#93; The batch of geofences to be deleted.
#'
#' @keywords internal
#'
#' @rdname locationservice_batch_delete_geofence
locationservice_batch_delete_geofence <- function(CollectionName, GeofenceIds) {
  op <- new_operation(
    name = "BatchDeleteGeofence",
    http_method = "POST",
    http_path = "/geofencing/v0/collections/{CollectionName}/delete-geofences",
    host_prefix = "geofencing.",
    paginator = list()
  )
  input <- .locationservice$batch_delete_geofence_input(CollectionName = CollectionName, GeofenceIds = GeofenceIds)
  output <- .locationservice$batch_delete_geofence_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$batch_delete_geofence <- locationservice_batch_delete_geofence

#' Evaluates device positions against the geofence geometries from a given
#' geofence collection
#'
#' @description
#' Evaluates device positions against the geofence geometries from a given geofence collection.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_batch_evaluate_geofences/](https://www.paws-r-sdk.com/docs/locationservice_batch_evaluate_geofences/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; The geofence collection used in evaluating the position of devices
#' against its geofences.
#' @param DevicePositionUpdates &#91;required&#93; Contains device details for each device to be evaluated against the
#' given geofence collection.
#'
#' @keywords internal
#'
#' @rdname locationservice_batch_evaluate_geofences
locationservice_batch_evaluate_geofences <- function(CollectionName, DevicePositionUpdates) {
  op <- new_operation(
    name = "BatchEvaluateGeofences",
    http_method = "POST",
    http_path = "/geofencing/v0/collections/{CollectionName}/positions",
    host_prefix = "geofencing.",
    paginator = list()
  )
  input <- .locationservice$batch_evaluate_geofences_input(CollectionName = CollectionName, DevicePositionUpdates = DevicePositionUpdates)
  output <- .locationservice$batch_evaluate_geofences_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$batch_evaluate_geofences <- locationservice_batch_evaluate_geofences

#' Lists the latest device positions for requested devices
#'
#' @description
#' Lists the latest device positions for requested devices.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_batch_get_device_position/](https://www.paws-r-sdk.com/docs/locationservice_batch_get_device_position/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The tracker resource retrieving the device position.
#' @param DeviceIds &#91;required&#93; Devices whose position you want to retrieve.
#' 
#' -   For example, for two devices:
#'     `device-ids=DeviceId1&device-ids=DeviceId2`
#'
#' @keywords internal
#'
#' @rdname locationservice_batch_get_device_position
locationservice_batch_get_device_position <- function(TrackerName, DeviceIds) {
  op <- new_operation(
    name = "BatchGetDevicePosition",
    http_method = "POST",
    http_path = "/tracking/v0/trackers/{TrackerName}/get-positions",
    host_prefix = "tracking.",
    paginator = list()
  )
  input <- .locationservice$batch_get_device_position_input(TrackerName = TrackerName, DeviceIds = DeviceIds)
  output <- .locationservice$batch_get_device_position_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$batch_get_device_position <- locationservice_batch_get_device_position

#' A batch request for storing geofence geometries into a given geofence
#' collection, or updates the geometry of an existing geofence if a
#' geofence ID is included in the request
#'
#' @description
#' A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_batch_put_geofence/](https://www.paws-r-sdk.com/docs/locationservice_batch_put_geofence/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; The geofence collection storing the geofences.
#' @param Entries &#91;required&#93; The batch of geofences to be stored in a geofence collection.
#'
#' @keywords internal
#'
#' @rdname locationservice_batch_put_geofence
locationservice_batch_put_geofence <- function(CollectionName, Entries) {
  op <- new_operation(
    name = "BatchPutGeofence",
    http_method = "POST",
    http_path = "/geofencing/v0/collections/{CollectionName}/put-geofences",
    host_prefix = "geofencing.",
    paginator = list()
  )
  input <- .locationservice$batch_put_geofence_input(CollectionName = CollectionName, Entries = Entries)
  output <- .locationservice$batch_put_geofence_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$batch_put_geofence <- locationservice_batch_put_geofence

#' Uploads position update data for one or more devices to a tracker
#' resource (up to 10 devices per batch)
#'
#' @description
#' Uploads position update data for one or more devices to a tracker resource (up to 10 devices per batch). Amazon Location uses the data when it reports the last known device position and position history. Amazon Location retains location data for 30 days.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_batch_update_device_position/](https://www.paws-r-sdk.com/docs/locationservice_batch_update_device_position/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The name of the tracker resource to update.
#' @param Updates &#91;required&#93; Contains the position update details for each device, up to 10 devices.
#'
#' @keywords internal
#'
#' @rdname locationservice_batch_update_device_position
locationservice_batch_update_device_position <- function(TrackerName, Updates) {
  op <- new_operation(
    name = "BatchUpdateDevicePosition",
    http_method = "POST",
    http_path = "/tracking/v0/trackers/{TrackerName}/positions",
    host_prefix = "tracking.",
    paginator = list()
  )
  input <- .locationservice$batch_update_device_position_input(TrackerName = TrackerName, Updates = Updates)
  output <- .locationservice$batch_update_device_position_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$batch_update_device_position <- locationservice_batch_update_device_position

#' Calculates a route given the following required parameters:
#' DeparturePosition and DestinationPosition
#'
#' @description
#' [Calculates a route](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html) given the following required parameters: `DeparturePosition` and `DestinationPosition`. Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location/latest/APIReference/API_CreateRouteCalculator.html).
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_calculate_route/](https://www.paws-r-sdk.com/docs/locationservice_calculate_route/) for full documentation.
#'
#' @param CalculatorName &#91;required&#93; The name of the route calculator resource that you want to use to
#' calculate the route.
#' @param DeparturePosition &#91;required&#93; The start position for the route. Defined in [World Geodetic System (WGS
#' 84)](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84)
#' format: `[longitude, latitude]`.
#' 
#' -   For example, `[-123.115, 49.285]`
#' 
#' If you specify a departure that's not located on a road, Amazon Location
#' [moves the position to the nearest
#' road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
#' If Esri is the provider for your route calculator, specifying a route
#' that is longer than 400 km returns a `400 RoutesValidationException`
#' error.
#' 
#' Valid Values: `[-180 to 180,-90 to 90]`
#' @param DestinationPosition &#91;required&#93; The finish position for the route. Defined in [World Geodetic System
#' (WGS 84)](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84)
#' format: `[longitude, latitude]`.
#' 
#' -   For example, `[-122.339, 47.615]`
#' 
#' If you specify a destination that's not located on a road, Amazon
#' Location [moves the position to the nearest
#' road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
#' 
#' Valid Values: `[-180 to 180,-90 to 90]`
#' @param WaypointPositions Specifies an ordered list of up to 23 intermediate positions to include
#' along a route between the departure position and destination position.
#' 
#' -   For example, from the `DeparturePosition` `[-123.115, 49.285]`, the
#'     route follows the order that the waypoint positions are given
#'     `[[-122.757, 49.0021],[-122.349, 47.620]]`
#' 
#' If you specify a waypoint position that's not located on a road, Amazon
#' Location [moves the position to the nearest
#' road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
#' 
#' Specifying more than 23 waypoints returns a `400 ValidationException`
#' error.
#' 
#' If Esri is the provider for your route calculator, specifying a route
#' that is longer than 400 km returns a `400 RoutesValidationException`
#' error.
#' 
#' Valid Values: `[-180 to 180,-90 to 90]`
#' @param TravelMode Specifies the mode of transport when calculating a route. Used in
#' estimating the speed of travel and road compatibility. You can choose
#' `Car`, `Truck`, `Walking`, `Bicycle` or `Motorcycle` as options for the
#' `TravelMode`.
#' 
#' `Bicycle` and `Motorcycle` are only valid when using Grab as a data
#' provider, and only within Southeast Asia.
#' 
#' `Truck` is not available for Grab.
#' 
#' For more details on the using Grab for routing, including areas of
#' coverage, see
#' [GrabMaps](https://docs.aws.amazon.com/location/latest/developerguide/grab.html)
#' in the *Amazon Location Service Developer Guide*.
#' 
#' The `TravelMode` you specify also determines how you specify route
#' preferences:
#' 
#' -   If traveling by `Car` use the `CarModeOptions` parameter.
#' 
#' -   If traveling by `Truck` use the `TruckModeOptions` parameter.
#' 
#' Default Value: `Car`
#' @param DepartureTime Specifies the desired time of departure. Uses the given time to
#' calculate the route. Otherwise, the best time of day to travel with the
#' best traffic conditions is used to calculate the route.
#' 
#' -   In [ISO
#'     8601](https://www.iso.org/iso-8601-date-and-time-format.html)
#'     format: `YYYY-MM-DDThh:mm:ss.sssZ`. For example,
#'     `2020–07-2T12:15:20.000Z+01:00`
#' @param DepartNow Sets the time of departure as the current time. Uses the current time to
#' calculate a route. Otherwise, the best time of day to travel with the
#' best traffic conditions is used to calculate the route.
#' 
#' Default Value: `false`
#' 
#' Valid Values: `false` | `true`
#' @param DistanceUnit Set the unit system to specify the distance.
#' 
#' Default Value: `Kilometers`
#' @param IncludeLegGeometry Set to include the geometry details in the result for each path between
#' a pair of positions.
#' 
#' Default Value: `false`
#' 
#' Valid Values: `false` | `true`
#' @param CarModeOptions Specifies route preferences when traveling by `Car`, such as avoiding
#' routes that use ferries or tolls.
#' 
#' Requirements: `TravelMode` must be specified as `Car`.
#' @param TruckModeOptions Specifies route preferences when traveling by `Truck`, such as avoiding
#' routes that use ferries or tolls, and truck specifications to consider
#' when choosing an optimal road.
#' 
#' Requirements: `TravelMode` must be specified as `Truck`.
#' @param ArrivalTime Specifies the desired time of arrival. Uses the given time to calculate
#' the route. Otherwise, the best time of day to travel with the best
#' traffic conditions is used to calculate the route.
#' 
#' ArrivalTime is not supported Esri.
#' @param OptimizeFor Specifies the distance to optimize for when calculating a route.
#' @param Key The optional [API
#' key](https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
#' to authorize the request.
#'
#' @keywords internal
#'
#' @rdname locationservice_calculate_route
locationservice_calculate_route <- function(CalculatorName, DeparturePosition, DestinationPosition, WaypointPositions = NULL, TravelMode = NULL, DepartureTime = NULL, DepartNow = NULL, DistanceUnit = NULL, IncludeLegGeometry = NULL, CarModeOptions = NULL, TruckModeOptions = NULL, ArrivalTime = NULL, OptimizeFor = NULL, Key = NULL) {
  op <- new_operation(
    name = "CalculateRoute",
    http_method = "POST",
    http_path = "/routes/v0/calculators/{CalculatorName}/calculate/route",
    host_prefix = "routes.",
    paginator = list()
  )
  input <- .locationservice$calculate_route_input(CalculatorName = CalculatorName, DeparturePosition = DeparturePosition, DestinationPosition = DestinationPosition, WaypointPositions = WaypointPositions, TravelMode = TravelMode, DepartureTime = DepartureTime, DepartNow = DepartNow, DistanceUnit = DistanceUnit, IncludeLegGeometry = IncludeLegGeometry, CarModeOptions = CarModeOptions, TruckModeOptions = TruckModeOptions, ArrivalTime = ArrivalTime, OptimizeFor = OptimizeFor, Key = Key)
  output <- .locationservice$calculate_route_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$calculate_route <- locationservice_calculate_route

#' Calculates a route matrix given the following required parameters:
#' DeparturePositions and DestinationPositions
#'
#' @description
#' [Calculates a route matrix](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html) given the following required parameters: `DeparturePositions` and `DestinationPositions`. [`calculate_route_matrix`][locationservice_calculate_route_matrix] calculates routes and returns the travel time and travel distance from each departure position to each destination position in the request. For example, given departure positions A and B, and destination positions X and Y, [`calculate_route_matrix`][locationservice_calculate_route_matrix] will return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of results returned (and routes calculated) will be the number of `DeparturePositions` times the number of `DestinationPositions`.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_calculate_route_matrix/](https://www.paws-r-sdk.com/docs/locationservice_calculate_route_matrix/) for full documentation.
#'
#' @param CalculatorName &#91;required&#93; The name of the route calculator resource that you want to use to
#' calculate the route matrix.
#' @param DeparturePositions &#91;required&#93; The list of departure (origin) positions for the route matrix. An array
#' of points, each of which is itself a 2-value array defined in [WGS
#' 84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format:
#' `[longitude, latitude]`. For example, `[-123.115, 49.285]`.
#' 
#' Depending on the data provider selected in the route calculator resource
#' there may be additional restrictions on the inputs you can choose. See
#' [Position
#' restrictions](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits)
#' in the *Amazon Location Service Developer Guide*.
#' 
#' For route calculators that use Esri as the data provider, if you specify
#' a departure that's not located on a road, Amazon Location [moves the
#' position to the nearest
#' road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
#' The snapped value is available in the result in
#' `SnappedDeparturePositions`.
#' 
#' Valid Values: `[-180 to 180,-90 to 90]`
#' @param DestinationPositions &#91;required&#93; The list of destination positions for the route matrix. An array of
#' points, each of which is itself a 2-value array defined in [WGS
#' 84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format:
#' `[longitude, latitude]`. For example, `[-122.339, 47.615]`
#' 
#' Depending on the data provider selected in the route calculator resource
#' there may be additional restrictions on the inputs you can choose. See
#' [Position
#' restrictions](https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits)
#' in the *Amazon Location Service Developer Guide*.
#' 
#' For route calculators that use Esri as the data provider, if you specify
#' a destination that's not located on a road, Amazon Location [moves the
#' position to the nearest
#' road](https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
#' The snapped value is available in the result in
#' `SnappedDestinationPositions`.
#' 
#' Valid Values: `[-180 to 180,-90 to 90]`
#' @param TravelMode Specifies the mode of transport when calculating a route. Used in
#' estimating the speed of travel and road compatibility.
#' 
#' The `TravelMode` you specify also determines how you specify route
#' preferences:
#' 
#' -   If traveling by `Car` use the `CarModeOptions` parameter.
#' 
#' -   If traveling by `Truck` use the `TruckModeOptions` parameter.
#' 
#' `Bicycle` or `Motorcycle` are only valid when using `Grab` as a data
#' provider, and only within Southeast Asia.
#' 
#' `Truck` is not available for Grab.
#' 
#' For more information about using Grab as a data provider, see
#' [GrabMaps](https://docs.aws.amazon.com/location/latest/developerguide/grab.html)
#' in the *Amazon Location Service Developer Guide*.
#' 
#' Default Value: `Car`
#' @param DepartureTime Specifies the desired time of departure. Uses the given time to
#' calculate the route matrix. You can't set both `DepartureTime` and
#' `DepartNow`. If neither is set, the best time of day to travel with the
#' best traffic conditions is used to calculate the route matrix.
#' 
#' Setting a departure time in the past returns a `400 ValidationException`
#' error.
#' 
#' -   In [ISO
#'     8601](https://www.iso.org/iso-8601-date-and-time-format.html)
#'     format: `YYYY-MM-DDThh:mm:ss.sssZ`. For example,
#'     `2020–07-2T12:15:20.000Z+01:00`
#' @param DepartNow Sets the time of departure as the current time. Uses the current time to
#' calculate the route matrix. You can't set both `DepartureTime` and
#' `DepartNow`. If neither is set, the best time of day to travel with the
#' best traffic conditions is used to calculate the route matrix.
#' 
#' Default Value: `false`
#' 
#' Valid Values: `false` | `true`
#' @param DistanceUnit Set the unit system to specify the distance.
#' 
#' Default Value: `Kilometers`
#' @param CarModeOptions Specifies route preferences when traveling by `Car`, such as avoiding
#' routes that use ferries or tolls.
#' 
#' Requirements: `TravelMode` must be specified as `Car`.
#' @param TruckModeOptions Specifies route preferences when traveling by `Truck`, such as avoiding
#' routes that use ferries or tolls, and truck specifications to consider
#' when choosing an optimal road.
#' 
#' Requirements: `TravelMode` must be specified as `Truck`.
#' @param Key The optional [API
#' key](https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
#' to authorize the request.
#'
#' @keywords internal
#'
#' @rdname locationservice_calculate_route_matrix
locationservice_calculate_route_matrix <- function(CalculatorName, DeparturePositions, DestinationPositions, TravelMode = NULL, DepartureTime = NULL, DepartNow = NULL, DistanceUnit = NULL, CarModeOptions = NULL, TruckModeOptions = NULL, Key = NULL) {
  op <- new_operation(
    name = "CalculateRouteMatrix",
    http_method = "POST",
    http_path = "/routes/v0/calculators/{CalculatorName}/calculate/route-matrix",
    host_prefix = "routes.",
    paginator = list()
  )
  input <- .locationservice$calculate_route_matrix_input(CalculatorName = CalculatorName, DeparturePositions = DeparturePositions, DestinationPositions = DestinationPositions, TravelMode = TravelMode, DepartureTime = DepartureTime, DepartNow = DepartNow, DistanceUnit = DistanceUnit, CarModeOptions = CarModeOptions, TruckModeOptions = TruckModeOptions, Key = Key)
  output <- .locationservice$calculate_route_matrix_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$calculate_route_matrix <- locationservice_calculate_route_matrix

#' Creates a geofence collection, which manages and stores geofences
#'
#' @description
#' Creates a geofence collection, which manages and stores geofences.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_create_geofence_collection/](https://www.paws-r-sdk.com/docs/locationservice_create_geofence_collection/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; A custom name for the geofence collection.
#' 
#' Requirements:
#' 
#' -   Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-),
#'     periods (.), and underscores (_).
#' 
#' -   Must be a unique geofence collection name.
#' 
#' -   No spaces allowed. For example, `ExampleGeofenceCollection`.
#' @param PricingPlan No longer used. If included, the only allowed value is
#' `RequestBasedUsage`.
#' @param PricingPlanDataSource This parameter is no longer used.
#' @param Description An optional description for the geofence collection.
#' @param Tags Applies one or more tags to the geofence collection. A tag is a
#' key-value pair helps manage, identify, search, and filter your resources
#' by labelling them.
#' 
#' Format: `"key" : "value"`
#' 
#' Restrictions:
#' 
#' -   Maximum 50 tags per resource
#' 
#' -   Each resource tag must be unique with a maximum of one value.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8
#' 
#' -   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Cannot use "aws:" as a prefix for a key.
#' @param KmsKeyId A key identifier for an [Amazon Web Services KMS customer managed
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
#' Enter a key ID, key ARN, alias name, or alias ARN.
#'
#' @keywords internal
#'
#' @rdname locationservice_create_geofence_collection
locationservice_create_geofence_collection <- function(CollectionName, PricingPlan = NULL, PricingPlanDataSource = NULL, Description = NULL, Tags = NULL, KmsKeyId = NULL) {
  op <- new_operation(
    name = "CreateGeofenceCollection",
    http_method = "POST",
    http_path = "/geofencing/v0/collections",
    host_prefix = "cp.geofencing.",
    paginator = list()
  )
  input <- .locationservice$create_geofence_collection_input(CollectionName = CollectionName, PricingPlan = PricingPlan, PricingPlanDataSource = PricingPlanDataSource, Description = Description, Tags = Tags, KmsKeyId = KmsKeyId)
  output <- .locationservice$create_geofence_collection_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$create_geofence_collection <- locationservice_create_geofence_collection

#' Creates an API key resource in your Amazon Web Services account, which
#' lets you grant actions for Amazon Location resources to the API key
#' bearer
#'
#' @description
#' Creates an API key resource in your Amazon Web Services account, which lets you grant actions for Amazon Location resources to the API key bearer.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_create_key/](https://www.paws-r-sdk.com/docs/locationservice_create_key/) for full documentation.
#'
#' @param KeyName &#91;required&#93; A custom name for the API key resource.
#' 
#' Requirements:
#' 
#' -   Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-),
#'     periods (.), and underscores (_).
#' 
#' -   Must be a unique API key name.
#' 
#' -   No spaces allowed. For example, `ExampleAPIKey`.
#' @param Restrictions &#91;required&#93; The API key restrictions for the API key resource.
#' @param Description An optional description for the API key resource.
#' @param ExpireTime The optional timestamp for when the API key resource will expire in [ISO
#' 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format:
#' `YYYY-MM-DDThh:mm:ss.sssZ`. One of `NoExpiry` or `ExpireTime` must be
#' set.
#' @param NoExpiry Optionally set to `true` to set no expiration time for the API key. One
#' of `NoExpiry` or `ExpireTime` must be set.
#' @param Tags Applies one or more tags to the map resource. A tag is a key-value pair
#' that helps manage, identify, search, and filter your resources by
#' labelling them.
#' 
#' Format: `"key" : "value"`
#' 
#' Restrictions:
#' 
#' -   Maximum 50 tags per resource
#' 
#' -   Each resource tag must be unique with a maximum of one value.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8
#' 
#' -   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Cannot use "aws:" as a prefix for a key.
#'
#' @keywords internal
#'
#' @rdname locationservice_create_key
locationservice_create_key <- function(KeyName, Restrictions, Description = NULL, ExpireTime = NULL, NoExpiry = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateKey",
    http_method = "POST",
    http_path = "/metadata/v0/keys",
    host_prefix = "cp.metadata.",
    paginator = list()
  )
  input <- .locationservice$create_key_input(KeyName = KeyName, Restrictions = Restrictions, Description = Description, ExpireTime = ExpireTime, NoExpiry = NoExpiry, Tags = Tags)
  output <- .locationservice$create_key_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$create_key <- locationservice_create_key

#' Creates a map resource in your Amazon Web Services account, which
#' provides map tiles of different styles sourced from global location data
#' providers
#'
#' @description
#' Creates a map resource in your Amazon Web Services account, which provides map tiles of different styles sourced from global location data providers.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_create_map/](https://www.paws-r-sdk.com/docs/locationservice_create_map/) for full documentation.
#'
#' @param MapName &#91;required&#93; The name for the map resource.
#' 
#' Requirements:
#' 
#' -   Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens
#'     (-), periods (.), and underscores (_).
#' 
#' -   Must be a unique map resource name.
#' 
#' -   No spaces allowed. For example, `ExampleMap`.
#' @param Configuration &#91;required&#93; Specifies the `MapConfiguration`, including the map style, for the map
#' resource that you create. The map style defines the look of maps and the
#' data provider for your map resource.
#' @param PricingPlan No longer used. If included, the only allowed value is
#' `RequestBasedUsage`.
#' @param Description An optional description for the map resource.
#' @param Tags Applies one or more tags to the map resource. A tag is a key-value pair
#' helps manage, identify, search, and filter your resources by labelling
#' them.
#' 
#' Format: `"key" : "value"`
#' 
#' Restrictions:
#' 
#' -   Maximum 50 tags per resource
#' 
#' -   Each resource tag must be unique with a maximum of one value.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8
#' 
#' -   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Cannot use "aws:" as a prefix for a key.
#'
#' @keywords internal
#'
#' @rdname locationservice_create_map
locationservice_create_map <- function(MapName, Configuration, PricingPlan = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateMap",
    http_method = "POST",
    http_path = "/maps/v0/maps",
    host_prefix = "cp.maps.",
    paginator = list()
  )
  input <- .locationservice$create_map_input(MapName = MapName, Configuration = Configuration, PricingPlan = PricingPlan, Description = Description, Tags = Tags)
  output <- .locationservice$create_map_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$create_map <- locationservice_create_map

#' Creates a place index resource in your Amazon Web Services account
#'
#' @description
#' Creates a place index resource in your Amazon Web Services account. Use a place index resource to geocode addresses and other text queries by using the [`search_place_index_for_text`][locationservice_search_place_index_for_text] operation, and reverse geocode coordinates by using the [`search_place_index_for_position`][locationservice_search_place_index_for_position] operation, and enable autosuggestions by using the [`search_place_index_for_suggestions`][locationservice_search_place_index_for_suggestions] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_create_place_index/](https://www.paws-r-sdk.com/docs/locationservice_create_place_index/) for full documentation.
#'
#' @param IndexName &#91;required&#93; The name of the place index resource.
#' 
#' Requirements:
#' 
#' -   Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-),
#'     periods (.), and underscores (_).
#' 
#' -   Must be a unique place index resource name.
#' 
#' -   No spaces allowed. For example, `ExamplePlaceIndex`.
#' @param DataSource &#91;required&#93; Specifies the geospatial data provider for the new place index.
#' 
#' This field is case-sensitive. Enter the valid values as shown. For
#' example, entering `HERE` returns an error.
#' 
#' Valid values include:
#' 
#' -   `Esri` – For additional information about
#'     [Esri](https://docs.aws.amazon.com/location/latest/developerguide/esri.html)'s
#'     coverage in your region of interest, see [Esri details on geocoding
#'     coverage](https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm).
#' 
#' -   `Grab` – Grab provides place index functionality for Southeast Asia.
#'     For additional information about
#'     [GrabMaps](https://docs.aws.amazon.com/location/latest/developerguide/grab.html)'
#'     coverage, see [GrabMaps countries and areas
#'     covered](https://docs.aws.amazon.com/location/latest/developerguide/grab.html#grab-coverage-area).
#' 
#' -   `Here` – For additional information about [HERE
#'     Technologies](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)'
#'     coverage in your region of interest, see HERE details on goecoding
#'     coverage.
#' 
#'     If you specify HERE Technologies (`Here`) as the data provider, you
#'     may not [store
#'     results](https://docs.aws.amazon.com/location/latest/APIReference/API_DataSourceConfiguration.html)
#'     for locations in Japan. For more information, see the [Amazon Web
#'     Services Service Terms](https://aws.amazon.com/service-terms/) for
#'     Amazon Location Service.
#' 
#' For additional information , see [Data
#' providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html)
#' on the *Amazon Location Service Developer Guide*.
#' @param PricingPlan No longer used. If included, the only allowed value is
#' `RequestBasedUsage`.
#' @param Description The optional description for the place index resource.
#' @param DataSourceConfiguration Specifies the data storage option requesting Places.
#' @param Tags Applies one or more tags to the place index resource. A tag is a
#' key-value pair that helps you manage, identify, search, and filter your
#' resources.
#' 
#' Format: `"key" : "value"`
#' 
#' Restrictions:
#' 
#' -   Maximum 50 tags per resource.
#' 
#' -   Each tag key must be unique and must have exactly one associated
#'     value.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8.
#' 
#' -   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
#'     characters: + - = . _ : / @@
#' 
#' -   Cannot use "aws:" as a prefix for a key.
#'
#' @keywords internal
#'
#' @rdname locationservice_create_place_index
locationservice_create_place_index <- function(IndexName, DataSource, PricingPlan = NULL, Description = NULL, DataSourceConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePlaceIndex",
    http_method = "POST",
    http_path = "/places/v0/indexes",
    host_prefix = "cp.places.",
    paginator = list()
  )
  input <- .locationservice$create_place_index_input(IndexName = IndexName, DataSource = DataSource, PricingPlan = PricingPlan, Description = Description, DataSourceConfiguration = DataSourceConfiguration, Tags = Tags)
  output <- .locationservice$create_place_index_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$create_place_index <- locationservice_create_place_index

#' Creates a route calculator resource in your Amazon Web Services account
#'
#' @description
#' Creates a route calculator resource in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_create_route_calculator/](https://www.paws-r-sdk.com/docs/locationservice_create_route_calculator/) for full documentation.
#'
#' @param CalculatorName &#91;required&#93; The name of the route calculator resource.
#' 
#' Requirements:
#' 
#' -   Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-),
#'     periods (.), and underscores (_).
#' 
#' -   Must be a unique Route calculator resource name.
#' 
#' -   No spaces allowed. For example, `ExampleRouteCalculator`.
#' @param DataSource &#91;required&#93; Specifies the data provider of traffic and road network data.
#' 
#' This field is case-sensitive. Enter the valid values as shown. For
#' example, entering `HERE` returns an error.
#' 
#' Valid values include:
#' 
#' -   `Esri` – For additional information about
#'     [Esri](https://docs.aws.amazon.com/location/latest/developerguide/esri.html)'s
#'     coverage in your region of interest, see [Esri details on street
#'     networks and traffic
#'     coverage](https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm).
#' 
#'     Route calculators that use Esri as a data source only calculate
#'     routes that are shorter than 400 km.
#' 
#' -   `Grab` – Grab provides routing functionality for Southeast Asia. For
#'     additional information about
#'     [GrabMaps](https://docs.aws.amazon.com/location/latest/developerguide/grab.html)'
#'     coverage, see [GrabMaps countries and areas
#'     covered](https://docs.aws.amazon.com/location/latest/developerguide/grab.html#grab-coverage-area).
#' 
#' -   `Here` – For additional information about [HERE
#'     Technologies](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)'
#'     coverage in your region of interest, see HERE car routing coverage
#'     and HERE truck routing coverage.
#' 
#' For additional information , see [Data
#' providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html)
#' on the *Amazon Location Service Developer Guide*.
#' @param PricingPlan No longer used. If included, the only allowed value is
#' `RequestBasedUsage`.
#' @param Description The optional description for the route calculator resource.
#' @param Tags Applies one or more tags to the route calculator resource. A tag is a
#' key-value pair helps manage, identify, search, and filter your resources
#' by labelling them.
#' 
#' -   For example: \{ `"tag1" : "value1"`, `"tag2" : "value2"`\}
#' 
#' Format: `"key" : "value"`
#' 
#' Restrictions:
#' 
#' -   Maximum 50 tags per resource
#' 
#' -   Each resource tag must be unique with a maximum of one value.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8
#' 
#' -   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Cannot use "aws:" as a prefix for a key.
#'
#' @keywords internal
#'
#' @rdname locationservice_create_route_calculator
locationservice_create_route_calculator <- function(CalculatorName, DataSource, PricingPlan = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateRouteCalculator",
    http_method = "POST",
    http_path = "/routes/v0/calculators",
    host_prefix = "cp.routes.",
    paginator = list()
  )
  input <- .locationservice$create_route_calculator_input(CalculatorName = CalculatorName, DataSource = DataSource, PricingPlan = PricingPlan, Description = Description, Tags = Tags)
  output <- .locationservice$create_route_calculator_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$create_route_calculator <- locationservice_create_route_calculator

#' Creates a tracker resource in your Amazon Web Services account, which
#' lets you retrieve current and historical location of devices
#'
#' @description
#' Creates a tracker resource in your Amazon Web Services account, which lets you retrieve current and historical location of devices.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_create_tracker/](https://www.paws-r-sdk.com/docs/locationservice_create_tracker/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The name for the tracker resource.
#' 
#' Requirements:
#' 
#' -   Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-),
#'     periods (.), and underscores (_).
#' 
#' -   Must be a unique tracker resource name.
#' 
#' -   No spaces allowed. For example, `ExampleTracker`.
#' @param PricingPlan No longer used. If included, the only allowed value is
#' `RequestBasedUsage`.
#' @param KmsKeyId A key identifier for an [Amazon Web Services KMS customer managed
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
#' Enter a key ID, key ARN, alias name, or alias ARN.
#' @param PricingPlanDataSource This parameter is no longer used.
#' @param Description An optional description for the tracker resource.
#' @param Tags Applies one or more tags to the tracker resource. A tag is a key-value
#' pair helps manage, identify, search, and filter your resources by
#' labelling them.
#' 
#' Format: `"key" : "value"`
#' 
#' Restrictions:
#' 
#' -   Maximum 50 tags per resource
#' 
#' -   Each resource tag must be unique with a maximum of one value.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8
#' 
#' -   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Cannot use "aws:" as a prefix for a key.
#' @param PositionFiltering Specifies the position filtering for the tracker resource.
#' 
#' Valid values:
#' 
#' -   `TimeBased` - Location updates are evaluated against linked geofence
#'     collections, but not every location update is stored. If your update
#'     frequency is more often than 30 seconds, only one update per 30
#'     seconds is stored for each unique device ID.
#' 
#' -   `DistanceBased` - If the device has moved less than 30 m (98.4 ft),
#'     location updates are ignored. Location updates within this area are
#'     neither evaluated against linked geofence collections, nor stored.
#'     This helps control costs by reducing the number of geofence
#'     evaluations and historical device positions to paginate through.
#'     Distance-based filtering can also reduce the effects of GPS noise
#'     when displaying device trajectories on a map.
#' 
#' -   `AccuracyBased` - If the device has moved less than the measured
#'     accuracy, location updates are ignored. For example, if two
#'     consecutive updates from a device have a horizontal accuracy of 5 m
#'     and 10 m, the second update is ignored if the device has moved less
#'     than 15 m. Ignored location updates are neither evaluated against
#'     linked geofence collections, nor stored. This can reduce the effects
#'     of GPS noise when displaying device trajectories on a map, and can
#'     help control your costs by reducing the number of geofence
#'     evaluations.
#' 
#' This field is optional. If not specified, the default value is
#' `TimeBased`.
#' @param EventBridgeEnabled Whether to enable position `UPDATE` events from this tracker to be sent
#' to EventBridge.
#' 
#' You do not need enable this feature to get `ENTER` and `EXIT` events for
#' geofences with this tracker. Those events are always sent to
#' EventBridge.
#' @param KmsKeyEnableGeospatialQueries Enables `GeospatialQueries` for a tracker that uses a [Amazon Web
#' Services KMS customer managed
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
#' 
#' This parameter is only used if you are using a KMS customer managed key.
#' 
#' If you wish to encrypt your data using your own KMS customer managed
#' key, then the Bounding Polygon Queries feature will be disabled by
#' default. This is because by using this feature, a representation of your
#' device positions will not be encrypted using the your KMS managed key.
#' The exact device position, however; is still encrypted using your
#' managed key.
#' 
#' You can choose to opt-in to the Bounding Polygon Quseries feature. This
#' is done by setting the `KmsKeyEnableGeospatialQueries` parameter to true
#' when creating or updating a Tracker.
#'
#' @keywords internal
#'
#' @rdname locationservice_create_tracker
locationservice_create_tracker <- function(TrackerName, PricingPlan = NULL, KmsKeyId = NULL, PricingPlanDataSource = NULL, Description = NULL, Tags = NULL, PositionFiltering = NULL, EventBridgeEnabled = NULL, KmsKeyEnableGeospatialQueries = NULL) {
  op <- new_operation(
    name = "CreateTracker",
    http_method = "POST",
    http_path = "/tracking/v0/trackers",
    host_prefix = "cp.tracking.",
    paginator = list()
  )
  input <- .locationservice$create_tracker_input(TrackerName = TrackerName, PricingPlan = PricingPlan, KmsKeyId = KmsKeyId, PricingPlanDataSource = PricingPlanDataSource, Description = Description, Tags = Tags, PositionFiltering = PositionFiltering, EventBridgeEnabled = EventBridgeEnabled, KmsKeyEnableGeospatialQueries = KmsKeyEnableGeospatialQueries)
  output <- .locationservice$create_tracker_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$create_tracker <- locationservice_create_tracker

#' Deletes a geofence collection from your Amazon Web Services account
#'
#' @description
#' Deletes a geofence collection from your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_delete_geofence_collection/](https://www.paws-r-sdk.com/docs/locationservice_delete_geofence_collection/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; The name of the geofence collection to be deleted.
#'
#' @keywords internal
#'
#' @rdname locationservice_delete_geofence_collection
locationservice_delete_geofence_collection <- function(CollectionName) {
  op <- new_operation(
    name = "DeleteGeofenceCollection",
    http_method = "DELETE",
    http_path = "/geofencing/v0/collections/{CollectionName}",
    host_prefix = "cp.geofencing.",
    paginator = list()
  )
  input <- .locationservice$delete_geofence_collection_input(CollectionName = CollectionName)
  output <- .locationservice$delete_geofence_collection_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$delete_geofence_collection <- locationservice_delete_geofence_collection

#' Deletes the specified API key
#'
#' @description
#' Deletes the specified API key. The API key must have been deactivated more than 90 days previously.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_delete_key/](https://www.paws-r-sdk.com/docs/locationservice_delete_key/) for full documentation.
#'
#' @param KeyName &#91;required&#93; The name of the API key to delete.
#' @param ForceDelete ForceDelete bypasses an API key's expiry conditions and deletes the key.
#' Set the parameter `true` to delete the key or to `false` to not
#' preemptively delete the API key.
#' 
#' Valid values: `true`, or `false`.
#' 
#' Required: No
#' 
#' This action is irreversible. Only use ForceDelete if you are certain the
#' key is no longer in use.
#'
#' @keywords internal
#'
#' @rdname locationservice_delete_key
locationservice_delete_key <- function(KeyName, ForceDelete = NULL) {
  op <- new_operation(
    name = "DeleteKey",
    http_method = "DELETE",
    http_path = "/metadata/v0/keys/{KeyName}",
    host_prefix = "cp.metadata.",
    paginator = list()
  )
  input <- .locationservice$delete_key_input(KeyName = KeyName, ForceDelete = ForceDelete)
  output <- .locationservice$delete_key_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$delete_key <- locationservice_delete_key

#' Deletes a map resource from your Amazon Web Services account
#'
#' @description
#' Deletes a map resource from your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_delete_map/](https://www.paws-r-sdk.com/docs/locationservice_delete_map/) for full documentation.
#'
#' @param MapName &#91;required&#93; The name of the map resource to be deleted.
#'
#' @keywords internal
#'
#' @rdname locationservice_delete_map
locationservice_delete_map <- function(MapName) {
  op <- new_operation(
    name = "DeleteMap",
    http_method = "DELETE",
    http_path = "/maps/v0/maps/{MapName}",
    host_prefix = "cp.maps.",
    paginator = list()
  )
  input <- .locationservice$delete_map_input(MapName = MapName)
  output <- .locationservice$delete_map_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$delete_map <- locationservice_delete_map

#' Deletes a place index resource from your Amazon Web Services account
#'
#' @description
#' Deletes a place index resource from your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_delete_place_index/](https://www.paws-r-sdk.com/docs/locationservice_delete_place_index/) for full documentation.
#'
#' @param IndexName &#91;required&#93; The name of the place index resource to be deleted.
#'
#' @keywords internal
#'
#' @rdname locationservice_delete_place_index
locationservice_delete_place_index <- function(IndexName) {
  op <- new_operation(
    name = "DeletePlaceIndex",
    http_method = "DELETE",
    http_path = "/places/v0/indexes/{IndexName}",
    host_prefix = "cp.places.",
    paginator = list()
  )
  input <- .locationservice$delete_place_index_input(IndexName = IndexName)
  output <- .locationservice$delete_place_index_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$delete_place_index <- locationservice_delete_place_index

#' Deletes a route calculator resource from your Amazon Web Services
#' account
#'
#' @description
#' Deletes a route calculator resource from your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_delete_route_calculator/](https://www.paws-r-sdk.com/docs/locationservice_delete_route_calculator/) for full documentation.
#'
#' @param CalculatorName &#91;required&#93; The name of the route calculator resource to be deleted.
#'
#' @keywords internal
#'
#' @rdname locationservice_delete_route_calculator
locationservice_delete_route_calculator <- function(CalculatorName) {
  op <- new_operation(
    name = "DeleteRouteCalculator",
    http_method = "DELETE",
    http_path = "/routes/v0/calculators/{CalculatorName}",
    host_prefix = "cp.routes.",
    paginator = list()
  )
  input <- .locationservice$delete_route_calculator_input(CalculatorName = CalculatorName)
  output <- .locationservice$delete_route_calculator_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$delete_route_calculator <- locationservice_delete_route_calculator

#' Deletes a tracker resource from your Amazon Web Services account
#'
#' @description
#' Deletes a tracker resource from your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_delete_tracker/](https://www.paws-r-sdk.com/docs/locationservice_delete_tracker/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The name of the tracker resource to be deleted.
#'
#' @keywords internal
#'
#' @rdname locationservice_delete_tracker
locationservice_delete_tracker <- function(TrackerName) {
  op <- new_operation(
    name = "DeleteTracker",
    http_method = "DELETE",
    http_path = "/tracking/v0/trackers/{TrackerName}",
    host_prefix = "cp.tracking.",
    paginator = list()
  )
  input <- .locationservice$delete_tracker_input(TrackerName = TrackerName)
  output <- .locationservice$delete_tracker_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$delete_tracker <- locationservice_delete_tracker

#' Retrieves the geofence collection details
#'
#' @description
#' Retrieves the geofence collection details.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_describe_geofence_collection/](https://www.paws-r-sdk.com/docs/locationservice_describe_geofence_collection/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; The name of the geofence collection.
#'
#' @keywords internal
#'
#' @rdname locationservice_describe_geofence_collection
locationservice_describe_geofence_collection <- function(CollectionName) {
  op <- new_operation(
    name = "DescribeGeofenceCollection",
    http_method = "GET",
    http_path = "/geofencing/v0/collections/{CollectionName}",
    host_prefix = "cp.geofencing.",
    paginator = list()
  )
  input <- .locationservice$describe_geofence_collection_input(CollectionName = CollectionName)
  output <- .locationservice$describe_geofence_collection_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$describe_geofence_collection <- locationservice_describe_geofence_collection

#' Retrieves the API key resource details
#'
#' @description
#' Retrieves the API key resource details.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_describe_key/](https://www.paws-r-sdk.com/docs/locationservice_describe_key/) for full documentation.
#'
#' @param KeyName &#91;required&#93; The name of the API key resource.
#'
#' @keywords internal
#'
#' @rdname locationservice_describe_key
locationservice_describe_key <- function(KeyName) {
  op <- new_operation(
    name = "DescribeKey",
    http_method = "GET",
    http_path = "/metadata/v0/keys/{KeyName}",
    host_prefix = "cp.metadata.",
    paginator = list()
  )
  input <- .locationservice$describe_key_input(KeyName = KeyName)
  output <- .locationservice$describe_key_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$describe_key <- locationservice_describe_key

#' Retrieves the map resource details
#'
#' @description
#' Retrieves the map resource details.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_describe_map/](https://www.paws-r-sdk.com/docs/locationservice_describe_map/) for full documentation.
#'
#' @param MapName &#91;required&#93; The name of the map resource.
#'
#' @keywords internal
#'
#' @rdname locationservice_describe_map
locationservice_describe_map <- function(MapName) {
  op <- new_operation(
    name = "DescribeMap",
    http_method = "GET",
    http_path = "/maps/v0/maps/{MapName}",
    host_prefix = "cp.maps.",
    paginator = list()
  )
  input <- .locationservice$describe_map_input(MapName = MapName)
  output <- .locationservice$describe_map_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$describe_map <- locationservice_describe_map

#' Retrieves the place index resource details
#'
#' @description
#' Retrieves the place index resource details.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_describe_place_index/](https://www.paws-r-sdk.com/docs/locationservice_describe_place_index/) for full documentation.
#'
#' @param IndexName &#91;required&#93; The name of the place index resource.
#'
#' @keywords internal
#'
#' @rdname locationservice_describe_place_index
locationservice_describe_place_index <- function(IndexName) {
  op <- new_operation(
    name = "DescribePlaceIndex",
    http_method = "GET",
    http_path = "/places/v0/indexes/{IndexName}",
    host_prefix = "cp.places.",
    paginator = list()
  )
  input <- .locationservice$describe_place_index_input(IndexName = IndexName)
  output <- .locationservice$describe_place_index_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$describe_place_index <- locationservice_describe_place_index

#' Retrieves the route calculator resource details
#'
#' @description
#' Retrieves the route calculator resource details.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_describe_route_calculator/](https://www.paws-r-sdk.com/docs/locationservice_describe_route_calculator/) for full documentation.
#'
#' @param CalculatorName &#91;required&#93; The name of the route calculator resource.
#'
#' @keywords internal
#'
#' @rdname locationservice_describe_route_calculator
locationservice_describe_route_calculator <- function(CalculatorName) {
  op <- new_operation(
    name = "DescribeRouteCalculator",
    http_method = "GET",
    http_path = "/routes/v0/calculators/{CalculatorName}",
    host_prefix = "cp.routes.",
    paginator = list()
  )
  input <- .locationservice$describe_route_calculator_input(CalculatorName = CalculatorName)
  output <- .locationservice$describe_route_calculator_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$describe_route_calculator <- locationservice_describe_route_calculator

#' Retrieves the tracker resource details
#'
#' @description
#' Retrieves the tracker resource details.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_describe_tracker/](https://www.paws-r-sdk.com/docs/locationservice_describe_tracker/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The name of the tracker resource.
#'
#' @keywords internal
#'
#' @rdname locationservice_describe_tracker
locationservice_describe_tracker <- function(TrackerName) {
  op <- new_operation(
    name = "DescribeTracker",
    http_method = "GET",
    http_path = "/tracking/v0/trackers/{TrackerName}",
    host_prefix = "cp.tracking.",
    paginator = list()
  )
  input <- .locationservice$describe_tracker_input(TrackerName = TrackerName)
  output <- .locationservice$describe_tracker_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$describe_tracker <- locationservice_describe_tracker

#' Removes the association between a tracker resource and a geofence
#' collection
#'
#' @description
#' Removes the association between a tracker resource and a geofence collection.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_disassociate_tracker_consumer/](https://www.paws-r-sdk.com/docs/locationservice_disassociate_tracker_consumer/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The name of the tracker resource to be dissociated from the consumer.
#' @param ConsumerArn &#91;required&#93; The Amazon Resource Name (ARN) for the geofence collection to be
#' disassociated from the tracker resource. Used when you need to specify a
#' resource across all Amazon Web Services.
#' 
#' -   Format example:
#'     `arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer`
#'
#' @keywords internal
#'
#' @rdname locationservice_disassociate_tracker_consumer
locationservice_disassociate_tracker_consumer <- function(TrackerName, ConsumerArn) {
  op <- new_operation(
    name = "DisassociateTrackerConsumer",
    http_method = "DELETE",
    http_path = "/tracking/v0/trackers/{TrackerName}/consumers/{ConsumerArn}",
    host_prefix = "cp.tracking.",
    paginator = list()
  )
  input <- .locationservice$disassociate_tracker_consumer_input(TrackerName = TrackerName, ConsumerArn = ConsumerArn)
  output <- .locationservice$disassociate_tracker_consumer_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$disassociate_tracker_consumer <- locationservice_disassociate_tracker_consumer

#' Evaluates device positions against geofence geometries from a given
#' geofence collection
#'
#' @description
#' Evaluates device positions against geofence geometries from a given geofence collection. The event forecasts three states for which a device can be in relative to a geofence:
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_forecast_geofence_events/](https://www.paws-r-sdk.com/docs/locationservice_forecast_geofence_events/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; The name of the geofence collection.
#' @param DeviceState &#91;required&#93; The device's state, including current position and speed.
#' @param TimeHorizonMinutes Specifies the time horizon in minutes for the forecasted events.
#' @param DistanceUnit The distance unit used for the `NearestDistance` property returned in a
#' forecasted event. The measurement system must match for `DistanceUnit`
#' and `SpeedUnit`; if `Kilometers` is specified for `DistanceUnit`, then
#' `SpeedUnit` must be `KilometersPerHour`.
#' 
#' Default Value: `Kilometers`
#' @param SpeedUnit The speed unit for the device captured by the device state. The
#' measurement system must match for `DistanceUnit` and `SpeedUnit`; if
#' `Kilometers` is specified for `DistanceUnit`, then `SpeedUnit` must be
#' `KilometersPerHour`.
#' 
#' Default Value: `KilometersPerHour`.
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default value: `null`
#' @param MaxResults An optional limit for the number of resources returned in a single call.
#' 
#' Default value: `20`
#'
#' @keywords internal
#'
#' @rdname locationservice_forecast_geofence_events
locationservice_forecast_geofence_events <- function(CollectionName, DeviceState, TimeHorizonMinutes = NULL, DistanceUnit = NULL, SpeedUnit = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ForecastGeofenceEvents",
    http_method = "POST",
    http_path = "/geofencing/v0/collections/{CollectionName}/forecast-geofence-events",
    host_prefix = "geofencing.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ForecastedEvents")
  )
  input <- .locationservice$forecast_geofence_events_input(CollectionName = CollectionName, DeviceState = DeviceState, TimeHorizonMinutes = TimeHorizonMinutes, DistanceUnit = DistanceUnit, SpeedUnit = SpeedUnit, NextToken = NextToken, MaxResults = MaxResults)
  output <- .locationservice$forecast_geofence_events_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$forecast_geofence_events <- locationservice_forecast_geofence_events

#' Retrieves a device's most recent position according to its sample time
#'
#' @description
#' Retrieves a device's most recent position according to its sample time.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_get_device_position/](https://www.paws-r-sdk.com/docs/locationservice_get_device_position/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The tracker resource receiving the position update.
#' @param DeviceId &#91;required&#93; The device whose position you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname locationservice_get_device_position
locationservice_get_device_position <- function(TrackerName, DeviceId) {
  op <- new_operation(
    name = "GetDevicePosition",
    http_method = "GET",
    http_path = "/tracking/v0/trackers/{TrackerName}/devices/{DeviceId}/positions/latest",
    host_prefix = "tracking.",
    paginator = list()
  )
  input <- .locationservice$get_device_position_input(TrackerName = TrackerName, DeviceId = DeviceId)
  output <- .locationservice$get_device_position_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$get_device_position <- locationservice_get_device_position

#' Retrieves the device position history from a tracker resource within a
#' specified range of time
#'
#' @description
#' Retrieves the device position history from a tracker resource within a specified range of time.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_get_device_position_history/](https://www.paws-r-sdk.com/docs/locationservice_get_device_position_history/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The tracker resource receiving the request for the device position
#' history.
#' @param DeviceId &#91;required&#93; The device whose position history you want to retrieve.
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default value: `null`
#' @param StartTimeInclusive Specify the start time for the position history in [ISO
#' 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format:
#' `YYYY-MM-DDThh:mm:ss.sssZ`. By default, the value will be 24 hours prior
#' to the time that the request is made.
#' 
#' Requirement:
#' 
#' -   The time specified for `StartTimeInclusive` must be before
#'     `EndTimeExclusive`.
#' @param EndTimeExclusive Specify the end time for the position history in [ISO
#' 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format:
#' `YYYY-MM-DDThh:mm:ss.sssZ`. By default, the value will be the time that
#' the request is made.
#' 
#' Requirement:
#' 
#' -   The time specified for `EndTimeExclusive` must be after the time for
#'     `StartTimeInclusive`.
#' @param MaxResults An optional limit for the number of device positions returned in a
#' single call.
#' 
#' Default value: `100`
#'
#' @keywords internal
#'
#' @rdname locationservice_get_device_position_history
locationservice_get_device_position_history <- function(TrackerName, DeviceId, NextToken = NULL, StartTimeInclusive = NULL, EndTimeExclusive = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetDevicePositionHistory",
    http_method = "POST",
    http_path = "/tracking/v0/trackers/{TrackerName}/devices/{DeviceId}/list-positions",
    host_prefix = "tracking.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "DevicePositions")
  )
  input <- .locationservice$get_device_position_history_input(TrackerName = TrackerName, DeviceId = DeviceId, NextToken = NextToken, StartTimeInclusive = StartTimeInclusive, EndTimeExclusive = EndTimeExclusive, MaxResults = MaxResults)
  output <- .locationservice$get_device_position_history_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$get_device_position_history <- locationservice_get_device_position_history

#' Retrieves the geofence details from a geofence collection
#'
#' @description
#' Retrieves the geofence details from a geofence collection.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_get_geofence/](https://www.paws-r-sdk.com/docs/locationservice_get_geofence/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; The geofence collection storing the target geofence.
#' @param GeofenceId &#91;required&#93; The geofence you're retrieving details for.
#'
#' @keywords internal
#'
#' @rdname locationservice_get_geofence
locationservice_get_geofence <- function(CollectionName, GeofenceId) {
  op <- new_operation(
    name = "GetGeofence",
    http_method = "GET",
    http_path = "/geofencing/v0/collections/{CollectionName}/geofences/{GeofenceId}",
    host_prefix = "geofencing.",
    paginator = list()
  )
  input <- .locationservice$get_geofence_input(CollectionName = CollectionName, GeofenceId = GeofenceId)
  output <- .locationservice$get_geofence_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$get_geofence <- locationservice_get_geofence

#' Retrieves glyphs used to display labels on a map
#'
#' @description
#' Retrieves glyphs used to display labels on a map.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_get_map_glyphs/](https://www.paws-r-sdk.com/docs/locationservice_get_map_glyphs/) for full documentation.
#'
#' @param MapName &#91;required&#93; The map resource associated with the glyph file.
#' @param FontStack &#91;required&#93; A comma-separated list of fonts to load glyphs from in order of
#' preference. For example, `Noto Sans Regular, Arial Unicode`.
#' 
#' Valid font stacks for
#' [Esri](https://docs.aws.amazon.com/location/latest/developerguide/esri.html)
#' styles:
#' 
#' -   VectorEsriDarkGrayCanvas – `Ubuntu Medium Italic` | `Ubuntu Medium`
#'     | `Ubuntu Italic` | `Ubuntu Regular` | `Ubuntu Bold`
#' 
#' -   VectorEsriLightGrayCanvas – `Ubuntu Italic` | `Ubuntu Regular` |
#'     `Ubuntu Light` | `Ubuntu Bold`
#' 
#' -   VectorEsriTopographic – `Noto Sans Italic` | `Noto Sans Regular` |
#'     `Noto Sans Bold` | `Noto Serif Regular` |
#'     `Roboto Condensed Light Italic`
#' 
#' -   VectorEsriStreets – `Arial Regular` | `Arial Italic` | `Arial Bold`
#' 
#' -   VectorEsriNavigation – `Arial Regular` | `Arial Italic` |
#'     `Arial Bold`
#' 
#' Valid font stacks for [HERE
#' Technologies](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html)
#' styles:
#' 
#' -   VectorHereContrast – `Fira GO Regular` | `Fira GO Bold`
#' 
#' -   VectorHereExplore, VectorHereExploreTruck,
#'     HybridHereExploreSatellite – `Fira GO Italic` | `Fira GO Map` |
#'     `Fira GO Map Bold` | `Noto Sans CJK JP Bold` |
#'     `Noto Sans CJK JP Light` | `Noto Sans CJK JP Regular`
#' 
#' Valid font stacks for
#' [GrabMaps](https://docs.aws.amazon.com/location/latest/developerguide/grab.html)
#' styles:
#' 
#' -   VectorGrabStandardLight, VectorGrabStandardDark –
#'     `Noto Sans Regular` | `Noto Sans Medium` | `Noto Sans Bold`
#' 
#' Valid font stacks for [Open
#' Data](https://docs.aws.amazon.com/location/latest/developerguide/open-data.html)
#' styles:
#' 
#' -   VectorOpenDataStandardLight, VectorOpenDataStandardDark,
#'     VectorOpenDataVisualizationLight, VectorOpenDataVisualizationDark –
#'     `Amazon Ember Regular,Noto Sans Regular` |
#'     `Amazon Ember Bold,Noto Sans Bold` |
#'     `Amazon Ember Medium,Noto Sans Medium` |
#'     `Amazon Ember Regular Italic,Noto Sans Italic` |
#'     `Amazon Ember Condensed RC Regular,Noto Sans Regular` |
#'     `Amazon Ember Condensed RC Bold,Noto Sans Bold` |
#'     `Amazon Ember Regular,Noto Sans Regular,Noto Sans Arabic Regular` |
#'     `Amazon Ember Condensed RC Bold,Noto Sans Bold,Noto Sans Arabic Condensed Bold`
#'     | `Amazon Ember Bold,Noto Sans Bold,Noto Sans Arabic Bold` |
#'     `Amazon Ember Regular Italic,Noto Sans Italic,Noto Sans Arabic Regular`
#'     |
#'     `Amazon Ember Condensed RC Regular,Noto Sans Regular,Noto Sans Arabic Condensed Regular`
#'     | `Amazon Ember Medium,Noto Sans Medium,Noto Sans Arabic Medium`
#' 
#' The fonts used by the Open Data map styles are combined fonts that use
#' `Amazon Ember` for most glyphs but `Noto Sans` for glyphs unsupported by
#' `Amazon Ember`.
#' @param FontUnicodeRange &#91;required&#93; A Unicode range of characters to download glyphs for. Each response will
#' contain 256 characters. For example, 0–255 includes all characters from
#' range `U+0000` to `00FF`. Must be aligned to multiples of 256.
#' @param Key The optional [API
#' key](https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
#' to authorize the request.
#'
#' @keywords internal
#'
#' @rdname locationservice_get_map_glyphs
locationservice_get_map_glyphs <- function(MapName, FontStack, FontUnicodeRange, Key = NULL) {
  op <- new_operation(
    name = "GetMapGlyphs",
    http_method = "GET",
    http_path = "/maps/v0/maps/{MapName}/glyphs/{FontStack}/{FontUnicodeRange}",
    host_prefix = "maps.",
    paginator = list()
  )
  input <- .locationservice$get_map_glyphs_input(MapName = MapName, FontStack = FontStack, FontUnicodeRange = FontUnicodeRange, Key = Key)
  output <- .locationservice$get_map_glyphs_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$get_map_glyphs <- locationservice_get_map_glyphs

#' Retrieves the sprite sheet corresponding to a map resource
#'
#' @description
#' Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON document describing the offsets of individual icons that will be displayed on a rendered map.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_get_map_sprites/](https://www.paws-r-sdk.com/docs/locationservice_get_map_sprites/) for full documentation.
#'
#' @param MapName &#91;required&#93; The map resource associated with the sprite file.
#' @param FileName &#91;required&#93; The name of the sprite file. Use the following file names for the sprite
#' sheet:
#' 
#' -   `sprites.png`
#' 
#' -   `sprites@@2x.png` for high pixel density displays
#' 
#' For the JSON document containing image offsets. Use the following file
#' names:
#' 
#' -   `sprites.json`
#' 
#' -   `sprites@@2x.json` for high pixel density displays
#' @param Key The optional [API
#' key](https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
#' to authorize the request.
#'
#' @keywords internal
#'
#' @rdname locationservice_get_map_sprites
locationservice_get_map_sprites <- function(MapName, FileName, Key = NULL) {
  op <- new_operation(
    name = "GetMapSprites",
    http_method = "GET",
    http_path = "/maps/v0/maps/{MapName}/sprites/{FileName}",
    host_prefix = "maps.",
    paginator = list()
  )
  input <- .locationservice$get_map_sprites_input(MapName = MapName, FileName = FileName, Key = Key)
  output <- .locationservice$get_map_sprites_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$get_map_sprites <- locationservice_get_map_sprites

#' Retrieves the map style descriptor from a map resource
#'
#' @description
#' Retrieves the map style descriptor from a map resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_get_map_style_descriptor/](https://www.paws-r-sdk.com/docs/locationservice_get_map_style_descriptor/) for full documentation.
#'
#' @param MapName &#91;required&#93; The map resource to retrieve the style descriptor from.
#' @param Key The optional [API
#' key](https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
#' to authorize the request.
#'
#' @keywords internal
#'
#' @rdname locationservice_get_map_style_descriptor
locationservice_get_map_style_descriptor <- function(MapName, Key = NULL) {
  op <- new_operation(
    name = "GetMapStyleDescriptor",
    http_method = "GET",
    http_path = "/maps/v0/maps/{MapName}/style-descriptor",
    host_prefix = "maps.",
    paginator = list()
  )
  input <- .locationservice$get_map_style_descriptor_input(MapName = MapName, Key = Key)
  output <- .locationservice$get_map_style_descriptor_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$get_map_style_descriptor <- locationservice_get_map_style_descriptor

#' Retrieves a vector data tile from the map resource
#'
#' @description
#' Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_get_map_tile/](https://www.paws-r-sdk.com/docs/locationservice_get_map_tile/) for full documentation.
#'
#' @param MapName &#91;required&#93; The map resource to retrieve the map tiles from.
#' @param Z &#91;required&#93; The zoom value for the map tile.
#' @param X &#91;required&#93; The X axis value for the map tile.
#' @param Y &#91;required&#93; The Y axis value for the map tile.
#' @param Key The optional [API
#' key](https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
#' to authorize the request.
#'
#' @keywords internal
#'
#' @rdname locationservice_get_map_tile
locationservice_get_map_tile <- function(MapName, Z, X, Y, Key = NULL) {
  op <- new_operation(
    name = "GetMapTile",
    http_method = "GET",
    http_path = "/maps/v0/maps/{MapName}/tiles/{Z}/{X}/{Y}",
    host_prefix = "maps.",
    paginator = list()
  )
  input <- .locationservice$get_map_tile_input(MapName = MapName, Z = Z, X = X, Y = Y, Key = Key)
  output <- .locationservice$get_map_tile_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$get_map_tile <- locationservice_get_map_tile

#' Finds a place by its unique ID
#'
#' @description
#' Finds a place by its unique ID. A `PlaceId` is returned by other search operations.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_get_place/](https://www.paws-r-sdk.com/docs/locationservice_get_place/) for full documentation.
#'
#' @param IndexName &#91;required&#93; The name of the place index resource that you want to use for the
#' search.
#' @param PlaceId &#91;required&#93; The identifier of the place to find.
#' @param Language The preferred language used to return results. The value must be a valid
#' BCP 47 language tag, for example, `en` for English.
#' 
#' This setting affects the languages used in the results, but not the
#' results themselves. If no language is specified, or not supported for a
#' particular result, the partner automatically chooses a language for the
#' result.
#' 
#' For an example, we'll use the Greek language. You search for a location
#' around Athens, Greece, with the `language` parameter set to `en`. The
#' `city` in the results will most likely be returned as `Athens`.
#' 
#' If you set the `language` parameter to `el`, for Greek, then the `city`
#' in the results will more likely be returned as \eqn{A\Theta\eta\nu\alpha}.
#' 
#' If the data provider does not have a value for Greek, the result will be
#' in a language that the provider does support.
#' @param Key The optional [API
#' key](https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
#' to authorize the request.
#'
#' @keywords internal
#'
#' @rdname locationservice_get_place
locationservice_get_place <- function(IndexName, PlaceId, Language = NULL, Key = NULL) {
  op <- new_operation(
    name = "GetPlace",
    http_method = "GET",
    http_path = "/places/v0/indexes/{IndexName}/places/{PlaceId}",
    host_prefix = "places.",
    paginator = list()
  )
  input <- .locationservice$get_place_input(IndexName = IndexName, PlaceId = PlaceId, Language = Language, Key = Key)
  output <- .locationservice$get_place_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$get_place <- locationservice_get_place

#' A batch request to retrieve all device positions
#'
#' @description
#' A batch request to retrieve all device positions.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_list_device_positions/](https://www.paws-r-sdk.com/docs/locationservice_list_device_positions/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The tracker resource containing the requested devices.
#' @param MaxResults An optional limit for the number of entries returned in a single call.
#' 
#' Default value: `100`
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default value: `null`
#' @param FilterGeometry The geometry used to filter device positions.
#'
#' @keywords internal
#'
#' @rdname locationservice_list_device_positions
locationservice_list_device_positions <- function(TrackerName, MaxResults = NULL, NextToken = NULL, FilterGeometry = NULL) {
  op <- new_operation(
    name = "ListDevicePositions",
    http_method = "POST",
    http_path = "/tracking/v0/trackers/{TrackerName}/list-positions",
    host_prefix = "tracking.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Entries")
  )
  input <- .locationservice$list_device_positions_input(TrackerName = TrackerName, MaxResults = MaxResults, NextToken = NextToken, FilterGeometry = FilterGeometry)
  output <- .locationservice$list_device_positions_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$list_device_positions <- locationservice_list_device_positions

#' Lists geofence collections in your Amazon Web Services account
#'
#' @description
#' Lists geofence collections in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_list_geofence_collections/](https://www.paws-r-sdk.com/docs/locationservice_list_geofence_collections/) for full documentation.
#'
#' @param MaxResults An optional limit for the number of resources returned in a single call.
#' 
#' Default value: `100`
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default value: `null`
#'
#' @keywords internal
#'
#' @rdname locationservice_list_geofence_collections
locationservice_list_geofence_collections <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListGeofenceCollections",
    http_method = "POST",
    http_path = "/geofencing/v0/list-collections",
    host_prefix = "cp.geofencing.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Entries")
  )
  input <- .locationservice$list_geofence_collections_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .locationservice$list_geofence_collections_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$list_geofence_collections <- locationservice_list_geofence_collections

#' Lists geofences stored in a given geofence collection
#'
#' @description
#' Lists geofences stored in a given geofence collection.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_list_geofences/](https://www.paws-r-sdk.com/docs/locationservice_list_geofences/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; The name of the geofence collection storing the list of geofences.
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default value: `null`
#' @param MaxResults An optional limit for the number of geofences returned in a single call.
#' 
#' Default value: `100`
#'
#' @keywords internal
#'
#' @rdname locationservice_list_geofences
locationservice_list_geofences <- function(CollectionName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListGeofences",
    http_method = "POST",
    http_path = "/geofencing/v0/collections/{CollectionName}/list-geofences",
    host_prefix = "geofencing.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Entries")
  )
  input <- .locationservice$list_geofences_input(CollectionName = CollectionName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .locationservice$list_geofences_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$list_geofences <- locationservice_list_geofences

#' Lists API key resources in your Amazon Web Services account
#'
#' @description
#' Lists API key resources in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_list_keys/](https://www.paws-r-sdk.com/docs/locationservice_list_keys/) for full documentation.
#'
#' @param MaxResults An optional limit for the number of resources returned in a single call.
#' 
#' Default value: `100`
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default value: `null`
#' @param Filter Optionally filter the list to only `Active` or `Expired` API keys.
#'
#' @keywords internal
#'
#' @rdname locationservice_list_keys
locationservice_list_keys <- function(MaxResults = NULL, NextToken = NULL, Filter = NULL) {
  op <- new_operation(
    name = "ListKeys",
    http_method = "POST",
    http_path = "/metadata/v0/list-keys",
    host_prefix = "cp.metadata.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Entries")
  )
  input <- .locationservice$list_keys_input(MaxResults = MaxResults, NextToken = NextToken, Filter = Filter)
  output <- .locationservice$list_keys_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$list_keys <- locationservice_list_keys

#' Lists map resources in your Amazon Web Services account
#'
#' @description
#' Lists map resources in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_list_maps/](https://www.paws-r-sdk.com/docs/locationservice_list_maps/) for full documentation.
#'
#' @param MaxResults An optional limit for the number of resources returned in a single call.
#' 
#' Default value: `100`
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default value: `null`
#'
#' @keywords internal
#'
#' @rdname locationservice_list_maps
locationservice_list_maps <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListMaps",
    http_method = "POST",
    http_path = "/maps/v0/list-maps",
    host_prefix = "cp.maps.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Entries")
  )
  input <- .locationservice$list_maps_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .locationservice$list_maps_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$list_maps <- locationservice_list_maps

#' Lists place index resources in your Amazon Web Services account
#'
#' @description
#' Lists place index resources in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_list_place_indexes/](https://www.paws-r-sdk.com/docs/locationservice_list_place_indexes/) for full documentation.
#'
#' @param MaxResults An optional limit for the maximum number of results returned in a single
#' call.
#' 
#' Default value: `100`
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default value: `null`
#'
#' @keywords internal
#'
#' @rdname locationservice_list_place_indexes
locationservice_list_place_indexes <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPlaceIndexes",
    http_method = "POST",
    http_path = "/places/v0/list-indexes",
    host_prefix = "cp.places.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Entries")
  )
  input <- .locationservice$list_place_indexes_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .locationservice$list_place_indexes_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$list_place_indexes <- locationservice_list_place_indexes

#' Lists route calculator resources in your Amazon Web Services account
#'
#' @description
#' Lists route calculator resources in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_list_route_calculators/](https://www.paws-r-sdk.com/docs/locationservice_list_route_calculators/) for full documentation.
#'
#' @param MaxResults An optional maximum number of results returned in a single call.
#' 
#' Default Value: `100`
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default Value: `null`
#'
#' @keywords internal
#'
#' @rdname locationservice_list_route_calculators
locationservice_list_route_calculators <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRouteCalculators",
    http_method = "POST",
    http_path = "/routes/v0/list-calculators",
    host_prefix = "cp.routes.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Entries")
  )
  input <- .locationservice$list_route_calculators_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .locationservice$list_route_calculators_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$list_route_calculators <- locationservice_list_route_calculators

#' Returns a list of tags that are applied to the specified Amazon Location
#' resource
#'
#' @description
#' Returns a list of tags that are applied to the specified Amazon Location resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/locationservice_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' retrieve.
#' 
#' -   Format example:
#'     `arn:aws:geo:region:account-id:resourcetype/ExampleResource`
#'
#' @keywords internal
#'
#' @rdname locationservice_list_tags_for_resource
locationservice_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "cp.metadata.",
    paginator = list()
  )
  input <- .locationservice$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .locationservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$list_tags_for_resource <- locationservice_list_tags_for_resource

#' Lists geofence collections currently associated to the given tracker
#' resource
#'
#' @description
#' Lists geofence collections currently associated to the given tracker resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_list_tracker_consumers/](https://www.paws-r-sdk.com/docs/locationservice_list_tracker_consumers/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The tracker resource whose associated geofence collections you want to
#' list.
#' @param MaxResults An optional limit for the number of resources returned in a single call.
#' 
#' Default value: `100`
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default value: `null`
#'
#' @keywords internal
#'
#' @rdname locationservice_list_tracker_consumers
locationservice_list_tracker_consumers <- function(TrackerName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTrackerConsumers",
    http_method = "POST",
    http_path = "/tracking/v0/trackers/{TrackerName}/list-consumers",
    host_prefix = "cp.tracking.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ConsumerArns")
  )
  input <- .locationservice$list_tracker_consumers_input(TrackerName = TrackerName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .locationservice$list_tracker_consumers_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$list_tracker_consumers <- locationservice_list_tracker_consumers

#' Lists tracker resources in your Amazon Web Services account
#'
#' @description
#' Lists tracker resources in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_list_trackers/](https://www.paws-r-sdk.com/docs/locationservice_list_trackers/) for full documentation.
#'
#' @param MaxResults An optional limit for the number of resources returned in a single call.
#' 
#' Default value: `100`
#' @param NextToken The pagination token specifying which page of results to return in the
#' response. If no token is provided, the default page is the first page.
#' 
#' Default value: `null`
#'
#' @keywords internal
#'
#' @rdname locationservice_list_trackers
locationservice_list_trackers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTrackers",
    http_method = "POST",
    http_path = "/tracking/v0/list-trackers",
    host_prefix = "cp.tracking.",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Entries")
  )
  input <- .locationservice$list_trackers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .locationservice$list_trackers_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$list_trackers <- locationservice_list_trackers

#' Stores a geofence geometry in a given geofence collection, or updates
#' the geometry of an existing geofence if a geofence ID is included in the
#' request
#'
#' @description
#' Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_put_geofence/](https://www.paws-r-sdk.com/docs/locationservice_put_geofence/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; The geofence collection to store the geofence in.
#' @param GeofenceId &#91;required&#93; An identifier for the geofence. For example, `ExampleGeofence-1`.
#' @param Geometry &#91;required&#93; Contains the details to specify the position of the geofence. Can be a
#' polygon, a circle or a polygon encoded in Geobuf format. Including
#' multiple selections will return a validation error.
#' 
#' The [geofence
#' polygon](https://docs.aws.amazon.com/location/latest/APIReference/API_GeofenceGeometry.html)
#' format supports a maximum of 1,000 vertices. The [Geofence
#' Geobuf](https://docs.aws.amazon.com/location/latest/APIReference/API_GeofenceGeometry.html)
#' format supports a maximum of 100,000 vertices.
#' @param GeofenceProperties Associates one of more properties with the geofence. A property is a
#' key-value pair stored with the geofence and added to any geofence event
#' triggered with that geofence.
#' 
#' Format: `"key" : "value"`
#'
#' @keywords internal
#'
#' @rdname locationservice_put_geofence
locationservice_put_geofence <- function(CollectionName, GeofenceId, Geometry, GeofenceProperties = NULL) {
  op <- new_operation(
    name = "PutGeofence",
    http_method = "PUT",
    http_path = "/geofencing/v0/collections/{CollectionName}/geofences/{GeofenceId}",
    host_prefix = "geofencing.",
    paginator = list()
  )
  input <- .locationservice$put_geofence_input(CollectionName = CollectionName, GeofenceId = GeofenceId, Geometry = Geometry, GeofenceProperties = GeofenceProperties)
  output <- .locationservice$put_geofence_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$put_geofence <- locationservice_put_geofence

#' Reverse geocodes a given coordinate and returns a legible address
#'
#' @description
#' Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of interest near a given position.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_search_place_index_for_position/](https://www.paws-r-sdk.com/docs/locationservice_search_place_index_for_position/) for full documentation.
#'
#' @param IndexName &#91;required&#93; The name of the place index resource you want to use for the search.
#' @param Position &#91;required&#93; Specifies the longitude and latitude of the position to query.
#' 
#' This parameter must contain a pair of numbers. The first number
#' represents the X coordinate, or longitude; the second number represents
#' the Y coordinate, or latitude.
#' 
#' For example, `[-123.1174, 49.2847]` represents a position with longitude
#' `-123.1174` and latitude `49.2847`.
#' @param MaxResults An optional parameter. The maximum number of results returned per
#' request.
#' 
#' Default value: `50`
#' @param Language The preferred language used to return results. The value must be a valid
#' BCP 47 language tag, for example, `en` for English.
#' 
#' This setting affects the languages used in the results, but not the
#' results themselves. If no language is specified, or not supported for a
#' particular result, the partner automatically chooses a language for the
#' result.
#' 
#' For an example, we'll use the Greek language. You search for a location
#' around Athens, Greece, with the `language` parameter set to `en`. The
#' `city` in the results will most likely be returned as `Athens`.
#' 
#' If you set the `language` parameter to `el`, for Greek, then the `city`
#' in the results will more likely be returned as \eqn{A\Theta\eta\nu\alpha}.
#' 
#' If the data provider does not have a value for Greek, the result will be
#' in a language that the provider does support.
#' @param Key The optional [API
#' key](https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
#' to authorize the request.
#'
#' @keywords internal
#'
#' @rdname locationservice_search_place_index_for_position
locationservice_search_place_index_for_position <- function(IndexName, Position, MaxResults = NULL, Language = NULL, Key = NULL) {
  op <- new_operation(
    name = "SearchPlaceIndexForPosition",
    http_method = "POST",
    http_path = "/places/v0/indexes/{IndexName}/search/position",
    host_prefix = "places.",
    paginator = list()
  )
  input <- .locationservice$search_place_index_for_position_input(IndexName = IndexName, Position = Position, MaxResults = MaxResults, Language = Language, Key = Key)
  output <- .locationservice$search_place_index_for_position_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$search_place_index_for_position <- locationservice_search_place_index_for_position

#' Generates suggestions for addresses and points of interest based on
#' partial or misspelled free-form text
#'
#' @description
#' Generates suggestions for addresses and points of interest based on partial or misspelled free-form text. This operation is also known as autocomplete, autosuggest, or fuzzy matching.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_search_place_index_for_suggestions/](https://www.paws-r-sdk.com/docs/locationservice_search_place_index_for_suggestions/) for full documentation.
#'
#' @param IndexName &#91;required&#93; The name of the place index resource you want to use for the search.
#' @param Text &#91;required&#93; The free-form partial text to use to generate place suggestions. For
#' example, `eiffel tow`.
#' @param BiasPosition An optional parameter that indicates a preference for place suggestions
#' that are closer to a specified position.
#' 
#' If provided, this parameter must contain a pair of numbers. The first
#' number represents the X coordinate, or longitude; the second number
#' represents the Y coordinate, or latitude.
#' 
#' For example, `[-123.1174, 49.2847]` represents the position with
#' longitude `-123.1174` and latitude `49.2847`.
#' 
#' `BiasPosition` and `FilterBBox` are mutually exclusive. Specifying both
#' options results in an error.
#' @param FilterBBox An optional parameter that limits the search results by returning only
#' suggestions within a specified bounding box.
#' 
#' If provided, this parameter must contain a total of four consecutive
#' numbers in two pairs. The first pair of numbers represents the X and Y
#' coordinates (longitude and latitude, respectively) of the southwest
#' corner of the bounding box; the second pair of numbers represents the X
#' and Y coordinates (longitude and latitude, respectively) of the
#' northeast corner of the bounding box.
#' 
#' For example, `[-12.7935, -37.4835, -12.0684, -36.9542]` represents a
#' bounding box where the southwest corner has longitude `-12.7935` and
#' latitude `-37.4835`, and the northeast corner has longitude `-12.0684`
#' and latitude `-36.9542`.
#' 
#' `FilterBBox` and `BiasPosition` are mutually exclusive. Specifying both
#' options results in an error.
#' @param FilterCountries An optional parameter that limits the search results by returning only
#' suggestions within the provided list of countries.
#' 
#' -   Use the [ISO 3166](https://www.iso.org/iso-3166-country-codes.html)
#'     3-digit country code. For example, Australia uses three upper-case
#'     characters: `AUS`.
#' @param MaxResults An optional parameter. The maximum number of results returned per
#' request.
#' 
#' The default: `5`
#' @param Language The preferred language used to return results. The value must be a valid
#' BCP 47 language tag, for example, `en` for English.
#' 
#' This setting affects the languages used in the results. If no language
#' is specified, or not supported for a particular result, the partner
#' automatically chooses a language for the result.
#' 
#' For an example, we'll use the Greek language. You search for
#' `Athens, Gr` to get suggestions with the `language` parameter set to
#' `en`. The results found will most likely be returned as
#' `Athens, Greece`.
#' 
#' If you set the `language` parameter to `el`, for Greek, then the result
#' found will more likely be returned as \eqn{A\Theta\eta\nu\sigma, E\lambda\lambda\alpha\delta}.
#' 
#' If the data provider does not have a value for Greek, the result will be
#' in a language that the provider does support.
#' @param FilterCategories A list of one or more Amazon Location categories to filter the returned
#' places. If you include more than one category, the results will include
#' results that match *any* of the categories listed.
#' 
#' For more information about using categories, including a list of Amazon
#' Location categories, see [Categories and
#' filtering](https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html),
#' in the *Amazon Location Service Developer Guide*.
#' @param Key The optional [API
#' key](https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
#' to authorize the request.
#'
#' @keywords internal
#'
#' @rdname locationservice_search_place_index_for_suggestions
locationservice_search_place_index_for_suggestions <- function(IndexName, Text, BiasPosition = NULL, FilterBBox = NULL, FilterCountries = NULL, MaxResults = NULL, Language = NULL, FilterCategories = NULL, Key = NULL) {
  op <- new_operation(
    name = "SearchPlaceIndexForSuggestions",
    http_method = "POST",
    http_path = "/places/v0/indexes/{IndexName}/search/suggestions",
    host_prefix = "places.",
    paginator = list()
  )
  input <- .locationservice$search_place_index_for_suggestions_input(IndexName = IndexName, Text = Text, BiasPosition = BiasPosition, FilterBBox = FilterBBox, FilterCountries = FilterCountries, MaxResults = MaxResults, Language = Language, FilterCategories = FilterCategories, Key = Key)
  output <- .locationservice$search_place_index_for_suggestions_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$search_place_index_for_suggestions <- locationservice_search_place_index_for_suggestions

#' Geocodes free-form text, such as an address, name, city, or region to
#' allow you to search for Places or points of interest
#'
#' @description
#' Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of interest.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_search_place_index_for_text/](https://www.paws-r-sdk.com/docs/locationservice_search_place_index_for_text/) for full documentation.
#'
#' @param IndexName &#91;required&#93; The name of the place index resource you want to use for the search.
#' @param Text &#91;required&#93; The address, name, city, or region to be used in the search in free-form
#' text format. For example, `123 Any Street`.
#' @param BiasPosition An optional parameter that indicates a preference for places that are
#' closer to a specified position.
#' 
#' If provided, this parameter must contain a pair of numbers. The first
#' number represents the X coordinate, or longitude; the second number
#' represents the Y coordinate, or latitude.
#' 
#' For example, `[-123.1174, 49.2847]` represents the position with
#' longitude `-123.1174` and latitude `49.2847`.
#' 
#' `BiasPosition` and `FilterBBox` are mutually exclusive. Specifying both
#' options results in an error.
#' @param FilterBBox An optional parameter that limits the search results by returning only
#' places that are within the provided bounding box.
#' 
#' If provided, this parameter must contain a total of four consecutive
#' numbers in two pairs. The first pair of numbers represents the X and Y
#' coordinates (longitude and latitude, respectively) of the southwest
#' corner of the bounding box; the second pair of numbers represents the X
#' and Y coordinates (longitude and latitude, respectively) of the
#' northeast corner of the bounding box.
#' 
#' For example, `[-12.7935, -37.4835, -12.0684, -36.9542]` represents a
#' bounding box where the southwest corner has longitude `-12.7935` and
#' latitude `-37.4835`, and the northeast corner has longitude `-12.0684`
#' and latitude `-36.9542`.
#' 
#' `FilterBBox` and `BiasPosition` are mutually exclusive. Specifying both
#' options results in an error.
#' @param FilterCountries An optional parameter that limits the search results by returning only
#' places that are in a specified list of countries.
#' 
#' -   Valid values include [ISO
#'     3166](https://www.iso.org/iso-3166-country-codes.html) 3-digit
#'     country codes. For example, Australia uses three upper-case
#'     characters: `AUS`.
#' @param MaxResults An optional parameter. The maximum number of results returned per
#' request.
#' 
#' The default: `50`
#' @param Language The preferred language used to return results. The value must be a valid
#' BCP 47 language tag, for example, `en` for English.
#' 
#' This setting affects the languages used in the results, but not the
#' results themselves. If no language is specified, or not supported for a
#' particular result, the partner automatically chooses a language for the
#' result.
#' 
#' For an example, we'll use the Greek language. You search for
#' `Athens, Greece`, with the `language` parameter set to `en`. The result
#' found will most likely be returned as `Athens`.
#' 
#' If you set the `language` parameter to `el`, for Greek, then the result
#' found will more likely be returned as \eqn{A\Theta\eta\nu\alpha}.
#' 
#' If the data provider does not have a value for Greek, the result will be
#' in a language that the provider does support.
#' @param FilterCategories A list of one or more Amazon Location categories to filter the returned
#' places. If you include more than one category, the results will include
#' results that match *any* of the categories listed.
#' 
#' For more information about using categories, including a list of Amazon
#' Location categories, see [Categories and
#' filtering](https://docs.aws.amazon.com/location/latest/developerguide/category-filtering.html),
#' in the *Amazon Location Service Developer Guide*.
#' @param Key The optional [API
#' key](https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html)
#' to authorize the request.
#'
#' @keywords internal
#'
#' @rdname locationservice_search_place_index_for_text
locationservice_search_place_index_for_text <- function(IndexName, Text, BiasPosition = NULL, FilterBBox = NULL, FilterCountries = NULL, MaxResults = NULL, Language = NULL, FilterCategories = NULL, Key = NULL) {
  op <- new_operation(
    name = "SearchPlaceIndexForText",
    http_method = "POST",
    http_path = "/places/v0/indexes/{IndexName}/search/text",
    host_prefix = "places.",
    paginator = list()
  )
  input <- .locationservice$search_place_index_for_text_input(IndexName = IndexName, Text = Text, BiasPosition = BiasPosition, FilterBBox = FilterBBox, FilterCountries = FilterCountries, MaxResults = MaxResults, Language = Language, FilterCategories = FilterCategories, Key = Key)
  output <- .locationservice$search_place_index_for_text_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$search_place_index_for_text <- locationservice_search_place_index_for_text

#' Assigns one or more tags (key-value pairs) to the specified Amazon
#' Location Service resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_tag_resource/](https://www.paws-r-sdk.com/docs/locationservice_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' update.
#' 
#' -   Format example:
#'     `arn:aws:geo:region:account-id:resourcetype/ExampleResource`
#' @param Tags &#91;required&#93; Applies one or more tags to specific resource. A tag is a key-value pair
#' that helps you manage, identify, search, and filter your resources.
#' 
#' Format: `"key" : "value"`
#' 
#' Restrictions:
#' 
#' -   Maximum 50 tags per resource.
#' 
#' -   Each tag key must be unique and must have exactly one associated
#'     value.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8.
#' 
#' -   Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
#'     characters: + - = . _ : / @@
#' 
#' -   Cannot use "aws:" as a prefix for a key.
#'
#' @keywords internal
#'
#' @rdname locationservice_tag_resource
locationservice_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "cp.metadata.",
    paginator = list()
  )
  input <- .locationservice$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .locationservice$tag_resource_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$tag_resource <- locationservice_tag_resource

#' Removes one or more tags from the specified Amazon Location resource
#'
#' @description
#' Removes one or more tags from the specified Amazon Location resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_untag_resource/](https://www.paws-r-sdk.com/docs/locationservice_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which you want to
#' remove tags.
#' 
#' -   Format example:
#'     `arn:aws:geo:region:account-id:resourcetype/ExampleResource`
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the specified resource.
#'
#' @keywords internal
#'
#' @rdname locationservice_untag_resource
locationservice_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "cp.metadata.",
    paginator = list()
  )
  input <- .locationservice$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .locationservice$untag_resource_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$untag_resource <- locationservice_untag_resource

#' Updates the specified properties of a given geofence collection
#'
#' @description
#' Updates the specified properties of a given geofence collection.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_update_geofence_collection/](https://www.paws-r-sdk.com/docs/locationservice_update_geofence_collection/) for full documentation.
#'
#' @param CollectionName &#91;required&#93; The name of the geofence collection to update.
#' @param PricingPlan No longer used. If included, the only allowed value is
#' `RequestBasedUsage`.
#' @param PricingPlanDataSource This parameter is no longer used.
#' @param Description Updates the description for the geofence collection.
#'
#' @keywords internal
#'
#' @rdname locationservice_update_geofence_collection
locationservice_update_geofence_collection <- function(CollectionName, PricingPlan = NULL, PricingPlanDataSource = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateGeofenceCollection",
    http_method = "PATCH",
    http_path = "/geofencing/v0/collections/{CollectionName}",
    host_prefix = "cp.geofencing.",
    paginator = list()
  )
  input <- .locationservice$update_geofence_collection_input(CollectionName = CollectionName, PricingPlan = PricingPlan, PricingPlanDataSource = PricingPlanDataSource, Description = Description)
  output <- .locationservice$update_geofence_collection_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$update_geofence_collection <- locationservice_update_geofence_collection

#' Updates the specified properties of a given API key resource
#'
#' @description
#' Updates the specified properties of a given API key resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_update_key/](https://www.paws-r-sdk.com/docs/locationservice_update_key/) for full documentation.
#'
#' @param KeyName &#91;required&#93; The name of the API key resource to update.
#' @param Description Updates the description for the API key resource.
#' @param ExpireTime Updates the timestamp for when the API key resource will expire in [ISO
#' 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format:
#' `YYYY-MM-DDThh:mm:ss.sssZ`.
#' @param NoExpiry Whether the API key should expire. Set to `true` to set the API key to
#' have no expiration time.
#' @param ForceUpdate The boolean flag to be included for updating `ExpireTime` or
#' `Restrictions` details.
#' 
#' Must be set to `true` to update an API key resource that has been used
#' in the past 7 days.
#' 
#' `False` if force update is not preferred
#' 
#' Default value: `False`
#' @param Restrictions Updates the API key restrictions for the API key resource.
#'
#' @keywords internal
#'
#' @rdname locationservice_update_key
locationservice_update_key <- function(KeyName, Description = NULL, ExpireTime = NULL, NoExpiry = NULL, ForceUpdate = NULL, Restrictions = NULL) {
  op <- new_operation(
    name = "UpdateKey",
    http_method = "PATCH",
    http_path = "/metadata/v0/keys/{KeyName}",
    host_prefix = "cp.metadata.",
    paginator = list()
  )
  input <- .locationservice$update_key_input(KeyName = KeyName, Description = Description, ExpireTime = ExpireTime, NoExpiry = NoExpiry, ForceUpdate = ForceUpdate, Restrictions = Restrictions)
  output <- .locationservice$update_key_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$update_key <- locationservice_update_key

#' Updates the specified properties of a given map resource
#'
#' @description
#' Updates the specified properties of a given map resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_update_map/](https://www.paws-r-sdk.com/docs/locationservice_update_map/) for full documentation.
#'
#' @param MapName &#91;required&#93; The name of the map resource to update.
#' @param PricingPlan No longer used. If included, the only allowed value is
#' `RequestBasedUsage`.
#' @param Description Updates the description for the map resource.
#' @param ConfigurationUpdate Updates the parts of the map configuration that can be updated,
#' including the political view.
#'
#' @keywords internal
#'
#' @rdname locationservice_update_map
locationservice_update_map <- function(MapName, PricingPlan = NULL, Description = NULL, ConfigurationUpdate = NULL) {
  op <- new_operation(
    name = "UpdateMap",
    http_method = "PATCH",
    http_path = "/maps/v0/maps/{MapName}",
    host_prefix = "cp.maps.",
    paginator = list()
  )
  input <- .locationservice$update_map_input(MapName = MapName, PricingPlan = PricingPlan, Description = Description, ConfigurationUpdate = ConfigurationUpdate)
  output <- .locationservice$update_map_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$update_map <- locationservice_update_map

#' Updates the specified properties of a given place index resource
#'
#' @description
#' Updates the specified properties of a given place index resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_update_place_index/](https://www.paws-r-sdk.com/docs/locationservice_update_place_index/) for full documentation.
#'
#' @param IndexName &#91;required&#93; The name of the place index resource to update.
#' @param PricingPlan No longer used. If included, the only allowed value is
#' `RequestBasedUsage`.
#' @param Description Updates the description for the place index resource.
#' @param DataSourceConfiguration Updates the data storage option for the place index resource.
#'
#' @keywords internal
#'
#' @rdname locationservice_update_place_index
locationservice_update_place_index <- function(IndexName, PricingPlan = NULL, Description = NULL, DataSourceConfiguration = NULL) {
  op <- new_operation(
    name = "UpdatePlaceIndex",
    http_method = "PATCH",
    http_path = "/places/v0/indexes/{IndexName}",
    host_prefix = "cp.places.",
    paginator = list()
  )
  input <- .locationservice$update_place_index_input(IndexName = IndexName, PricingPlan = PricingPlan, Description = Description, DataSourceConfiguration = DataSourceConfiguration)
  output <- .locationservice$update_place_index_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$update_place_index <- locationservice_update_place_index

#' Updates the specified properties for a given route calculator resource
#'
#' @description
#' Updates the specified properties for a given route calculator resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_update_route_calculator/](https://www.paws-r-sdk.com/docs/locationservice_update_route_calculator/) for full documentation.
#'
#' @param CalculatorName &#91;required&#93; The name of the route calculator resource to update.
#' @param PricingPlan No longer used. If included, the only allowed value is
#' `RequestBasedUsage`.
#' @param Description Updates the description for the route calculator resource.
#'
#' @keywords internal
#'
#' @rdname locationservice_update_route_calculator
locationservice_update_route_calculator <- function(CalculatorName, PricingPlan = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateRouteCalculator",
    http_method = "PATCH",
    http_path = "/routes/v0/calculators/{CalculatorName}",
    host_prefix = "cp.routes.",
    paginator = list()
  )
  input <- .locationservice$update_route_calculator_input(CalculatorName = CalculatorName, PricingPlan = PricingPlan, Description = Description)
  output <- .locationservice$update_route_calculator_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$update_route_calculator <- locationservice_update_route_calculator

#' Updates the specified properties of a given tracker resource
#'
#' @description
#' Updates the specified properties of a given tracker resource.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_update_tracker/](https://www.paws-r-sdk.com/docs/locationservice_update_tracker/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The name of the tracker resource to update.
#' @param PricingPlan No longer used. If included, the only allowed value is
#' `RequestBasedUsage`.
#' @param PricingPlanDataSource This parameter is no longer used.
#' @param Description Updates the description for the tracker resource.
#' @param PositionFiltering Updates the position filtering for the tracker resource.
#' 
#' Valid values:
#' 
#' -   `TimeBased` - Location updates are evaluated against linked geofence
#'     collections, but not every location update is stored. If your update
#'     frequency is more often than 30 seconds, only one update per 30
#'     seconds is stored for each unique device ID.
#' 
#' -   `DistanceBased` - If the device has moved less than 30 m (98.4 ft),
#'     location updates are ignored. Location updates within this distance
#'     are neither evaluated against linked geofence collections, nor
#'     stored. This helps control costs by reducing the number of geofence
#'     evaluations and historical device positions to paginate through.
#'     Distance-based filtering can also reduce the effects of GPS noise
#'     when displaying device trajectories on a map.
#' 
#' -   `AccuracyBased` - If the device has moved less than the measured
#'     accuracy, location updates are ignored. For example, if two
#'     consecutive updates from a device have a horizontal accuracy of 5 m
#'     and 10 m, the second update is ignored if the device has moved less
#'     than 15 m. Ignored location updates are neither evaluated against
#'     linked geofence collections, nor stored. This helps educe the
#'     effects of GPS noise when displaying device trajectories on a map,
#'     and can help control costs by reducing the number of geofence
#'     evaluations.
#' @param EventBridgeEnabled Whether to enable position `UPDATE` events from this tracker to be sent
#' to EventBridge.
#' 
#' You do not need enable this feature to get `ENTER` and `EXIT` events for
#' geofences with this tracker. Those events are always sent to
#' EventBridge.
#' @param KmsKeyEnableGeospatialQueries Enables `GeospatialQueries` for a tracker that uses a [Amazon Web
#' Services KMS customer managed
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
#' 
#' This parameter is only used if you are using a KMS customer managed key.
#'
#' @keywords internal
#'
#' @rdname locationservice_update_tracker
locationservice_update_tracker <- function(TrackerName, PricingPlan = NULL, PricingPlanDataSource = NULL, Description = NULL, PositionFiltering = NULL, EventBridgeEnabled = NULL, KmsKeyEnableGeospatialQueries = NULL) {
  op <- new_operation(
    name = "UpdateTracker",
    http_method = "PATCH",
    http_path = "/tracking/v0/trackers/{TrackerName}",
    host_prefix = "cp.tracking.",
    paginator = list()
  )
  input <- .locationservice$update_tracker_input(TrackerName = TrackerName, PricingPlan = PricingPlan, PricingPlanDataSource = PricingPlanDataSource, Description = Description, PositionFiltering = PositionFiltering, EventBridgeEnabled = EventBridgeEnabled, KmsKeyEnableGeospatialQueries = KmsKeyEnableGeospatialQueries)
  output <- .locationservice$update_tracker_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$update_tracker <- locationservice_update_tracker

#' Verifies the integrity of the device's position by determining if it was
#' reported behind a proxy, and by comparing it to an inferred position
#' estimated based on the device's state
#'
#' @description
#' Verifies the integrity of the device's position by determining if it was reported behind a proxy, and by comparing it to an inferred position estimated based on the device's state.
#'
#' See [https://www.paws-r-sdk.com/docs/locationservice_verify_device_position/](https://www.paws-r-sdk.com/docs/locationservice_verify_device_position/) for full documentation.
#'
#' @param TrackerName &#91;required&#93; The name of the tracker resource to be associated with verification
#' request.
#' @param DeviceState &#91;required&#93; The device's state, including position, IP address, cell signals and
#' Wi-Fi access points.
#' @param DistanceUnit The distance unit for the verification request.
#' 
#' Default Value: `Kilometers`
#'
#' @keywords internal
#'
#' @rdname locationservice_verify_device_position
locationservice_verify_device_position <- function(TrackerName, DeviceState, DistanceUnit = NULL) {
  op <- new_operation(
    name = "VerifyDevicePosition",
    http_method = "POST",
    http_path = "/tracking/v0/trackers/{TrackerName}/positions/verify",
    host_prefix = "tracking.",
    paginator = list()
  )
  input <- .locationservice$verify_device_position_input(TrackerName = TrackerName, DeviceState = DeviceState, DistanceUnit = DistanceUnit)
  output <- .locationservice$verify_device_position_output()
  config <- get_config()
  svc <- .locationservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.locationservice$operations$verify_device_position <- locationservice_verify_device_position
