% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{tags}
\alias{tags}
\alias{tag_get}
\alias{tag_has}
\alias{tag_add}
\alias{tag_del}
\alias{type}
\title{Get, set, and delete object tags}
\usage{
tag_get(object, tag)

tag_has(object, tag)

tag_add(object, tags)

tag_del(object, tags = NULL)

type(object)
}
\arguments{
\item{object}{An object.}

\item{tag}{A tag name.}

\item{tags}{A list of tags.
\itemize{
\item \code{tag_add}: A named vector with tag names and their values.
\item \code{tag_del}: A character vector of tags to delete.
}}
}
\description{
Tags are metadata stored in an object's attributes, used to store types and
names needed to make AWS API requests.

\code{tag_get} returns the value of the given \code{tag}, or \code{""} if the tag doesn't
exist.

\code{tag_has} returns whether the object has the given \code{tag}.

\code{tag_add} returns the object after adding the given list of tags and values.

\code{tag_del} returns the object after recursively deleting tags in \code{tags}, or
all tags if \code{NULL}.

\code{type} returns broadly what type an object is, based on its \code{type} tag.
}
\examples{
foo <- list()
foo <- tag_add(foo, list(tag_name = "tag_value"))
tag_has(foo, "tag_name") # TRUE
tag_get(foo, "tag_name") # "tag_value"
tag_get(foo, "not_exist") # ""
foo <- tag_del(foo)
tag_has(foo, "tag_name") # FALSE

}
