% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_transit_gateway}
\alias{ec2_create_transit_gateway}
\title{Creates a transit gateway}
\usage{
ec2_create_transit_gateway(Description, Options, TagSpecifications,
  DryRun)
}
\arguments{
\item{Description}{A description of the transit gateway.}

\item{Options}{The transit gateway options.}

\item{TagSpecifications}{The tags to apply to the transit gateway.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a transit gateway.
}
\details{
You can use a transit gateway to interconnect your virtual private
clouds (VPC) and on-premises networks. After the transit gateway enters
the \code{available} state, you can attach your VPCs and VPN connections to
the transit gateway.

To attach your VPCs, use CreateTransitGatewayVpcAttachment.

To attach a VPN connection, use CreateCustomerGateway to create a
customer gateway and specify the ID of the customer gateway and the ID
of the transit gateway in a call to CreateVpnConnection.

When you create a transit gateway, we create a default transit gateway
route table and use it as the default association route table and the
default propagation route table. You can use
CreateTransitGatewayRouteTable to create additional transit gateway
route tables. If you disable automatic route propagation, we do not
create a default transit gateway route table. You can use
EnableTransitGatewayRouteTablePropagation to propagate routes from a
resource attachment to a transit gateway route table. If you disable
automatic associations, you can use AssociateTransitGatewayRouteTable to
associate a resource attachment with a transit gateway route table.
}
\section{Request syntax}{
\preformatted{svc$create_transit_gateway(
  Description = "string",
  Options = list(
    AmazonSideAsn = 123,
    AutoAcceptSharedAttachments = "enable"|"disable",
    DefaultRouteTableAssociation = "enable"|"disable",
    DefaultRouteTablePropagation = "enable"|"disable",
    VpnEcmpSupport = "enable"|"disable",
    DnsSupport = "enable"|"disable"
  ),
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-instances-request"|"subnet"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
