% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_reset_snapshot_attribute}
\alias{ec2_reset_snapshot_attribute}
\title{Resets permission settings for the specified snapshot}
\usage{
ec2_reset_snapshot_attribute(Attribute, SnapshotId, DryRun)
}
\arguments{
\item{Attribute}{[required] The attribute to reset. Currently, only the attribute for permission to
create volumes can be reset.}

\item{SnapshotId}{[required] The ID of the snapshot.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Resets permission settings for the specified snapshot.
}
\details{
For more information about modifying snapshot permissions, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html}{Sharing Snapshots}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$reset_snapshot_attribute(
  Attribute = "productCodes"|"createVolumePermission",
  SnapshotId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example resets the create volume permissions for snapshot
# ``snap-1234567890abcdef0``. If the command succeeds, no output is
# returned.
\donttest{svc$reset_snapshot_attribute(
  Attribute = "createVolumePermission",
  SnapshotId = "snap-1234567890abcdef0"
)}

}
\keyword{internal}
