% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_create_environment}
\alias{elasticbeanstalk_create_environment}
\title{Launches an environment for the specified application using the
specified configuration}
\usage{
elasticbeanstalk_create_environment(ApplicationName, EnvironmentName,
  GroupName, Description, CNAMEPrefix, Tier, Tags, VersionLabel,
  TemplateName, SolutionStackName, PlatformArn, OptionSettings,
  OptionsToRemove)
}
\arguments{
\item{ApplicationName}{[required] The name of the application that contains the version to be deployed.

If no application is found with this name, \code{CreateEnvironment} returns
an \code{InvalidParameterValue} error.}

\item{EnvironmentName}{A unique name for the deployment environment. Used in the application
URL.

Constraint: Must be from 4 to 40 characters in length. The name can
contain only letters, numbers, and hyphens. It cannot start or end with
a hyphen. This name must be unique within a region in your account. If
the specified name already exists in the region, AWS Elastic Beanstalk
returns an \code{InvalidParameterValue} error.

Default: If the CNAME parameter is not specified, the environment name
becomes part of the CNAME, and therefore part of the visible URL for
your application.}

\item{GroupName}{The name of the group to which the target environment belongs. Specify a
group name only if the environment's name is specified in an
environment manifest and not with the environment name parameter. See
\href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html}{Environment Manifest (env.yaml)}
for details.}

\item{Description}{Describes this environment.}

\item{CNAMEPrefix}{If specified, the environment attempts to use this value as the prefix
for the CNAME. If not specified, the CNAME is generated automatically by
appending a random alphanumeric string to the environment name.}

\item{Tier}{This specifies the tier to use for creating this environment.}

\item{Tags}{Specifies the tags applied to resources in the environment.}

\item{VersionLabel}{The name of the application version to deploy.

If the specified application has no associated application versions, AWS
Elastic Beanstalk \code{UpdateEnvironment} returns an \code{InvalidParameterValue}
error.

Default: If not specified, AWS Elastic Beanstalk attempts to launch the
sample application in the container.}

\item{TemplateName}{The name of the configuration template to use in deployment. If no
configuration template is found with this name, AWS Elastic Beanstalk
returns an \code{InvalidParameterValue} error.}

\item{SolutionStackName}{This is an alternative to specifying a template name. If specified, AWS
Elastic Beanstalk sets the configuration values to the default values
associated with the specified solution stack.

For a list of current solution stacks, see \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html}{Elastic Beanstalk Supported Platforms}.}

\item{PlatformArn}{The ARN of the platform.}

\item{OptionSettings}{If specified, AWS Elastic Beanstalk sets the specified configuration
options to the requested value in the configuration set for the new
environment. These override the values obtained from the solution stack
or the configuration template.}

\item{OptionsToRemove}{A list of custom user-defined configuration options to remove from the
configuration set for this new environment.}
}
\description{
Launches an environment for the specified application using the
specified configuration.
}
\section{Request syntax}{
\preformatted{svc$create_environment(
  ApplicationName = "string",
  EnvironmentName = "string",
  GroupName = "string",
  Description = "string",
  CNAMEPrefix = "string",
  Tier = list(
    Name = "string",
    Type = "string",
    Version = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  VersionLabel = "string",
  TemplateName = "string",
  SolutionStackName = "string",
  PlatformArn = "string",
  OptionSettings = list(
    list(
      ResourceName = "string",
      Namespace = "string",
      OptionName = "string",
      Value = "string"
    )
  ),
  OptionsToRemove = list(
    list(
      ResourceName = "string",
      Namespace = "string",
      OptionName = "string"
    )
  )
)
}
}

\examples{
# The following operation creates a new environment for version v1 of a
# java application named my-app:
\donttest{svc$create_environment(
  ApplicationName = "my-app",
  CNAMEPrefix = "my-app",
  EnvironmentName = "my-env",
  SolutionStackName = "64bit Amazon Linux 2015.03 v2.0.0 running Tomcat 8 Java 8",
  VersionLabel = "v1"
)}

}
\keyword{internal}
