% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_put_function_event_invoke_config}
\alias{lambda_put_function_event_invoke_config}
\title{Configures options for asynchronous invocation on a function, version,
or alias}
\usage{
lambda_put_function_event_invoke_config(FunctionName, Qualifier,
  MaximumRetryAttempts, MaximumEventAgeInSeconds, DestinationConfig)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function, version, or alias.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function} (name-only), \verb{my-function:v1}
(with alias).
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

You can append a version number or alias to any of the formats. The
length constraint applies only to the full ARN. If you specify only the
function name, it is limited to 64 characters in length.}

\item{Qualifier}{A version number or alias name.}

\item{MaximumRetryAttempts}{The maximum number of times to retry when the function returns an error.}

\item{MaximumEventAgeInSeconds}{The maximum age of a request that Lambda sends to a function for
processing.}

\item{DestinationConfig}{A destination for events after they have been sent to a function for
processing.

\strong{Destinations}
\itemize{
\item \strong{Function} - The Amazon Resource Name (ARN) of a Lambda function.
\item \strong{Queue} - The ARN of an SQS queue.
\item \strong{Topic} - The ARN of an SNS topic.
\item \strong{Event Bus} - The ARN of an Amazon EventBridge event bus.
}}
}
\description{
Configures options for \href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html}{asynchronous invocation}
on a function, version, or alias. If a configuration already exists for
a function, version, or alias, this operation overwrites it. If you
exclude any settings, they are removed. To set one option without
affecting existing settings for other options, use
UpdateFunctionEventInvokeConfig.

By default, Lambda retries an asynchronous invocation twice if the
function returns an error. It retains events in a queue for up to six
hours. When an event fails all processing attempts or stays in the
asynchronous invocation queue for too long, Lambda discards it. To
retain discarded events, configure a dead-letter queue with
UpdateFunctionConfiguration.

To send an invocation record to a queue, topic, function, or event bus,
specify a
\href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations}{destination}.
You can configure separate destinations for successful invocations
(on-success) and events that fail all processing attempts (on-failure).
You can configure destinations in addition to or instead of a
dead-letter queue.
}
\section{Request syntax}{
\preformatted{svc$put_function_event_invoke_config(
  FunctionName = "string",
  Qualifier = "string",
  MaximumRetryAttempts = 123,
  MaximumEventAgeInSeconds = 123,
  DestinationConfig = list(
    OnSuccess = list(
      Destination = "string"
    ),
    OnFailure = list(
      Destination = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# The following example sets a maximum event age of one hour and disables
# retries for the specified function.
svc$put_function_event_invoke_config(
  FunctionName = "my-function",
  MaximumEventAgeInSeconds = 3600L,
  MaximumRetryAttempts = 0L
)
}

}
\keyword{internal}
