% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_associate_transit_gateway_multicast_domain}
\alias{ec2_associate_transit_gateway_multicast_domain}
\title{Associates the specified subnets and transit gateway attachments with
the specified transit gateway multicast domain}
\usage{
ec2_associate_transit_gateway_multicast_domain(
  TransitGatewayMulticastDomainId, TransitGatewayAttachmentId, SubnetIds,
  DryRun)
}
\arguments{
\item{TransitGatewayMulticastDomainId}{The ID of the transit gateway multicast domain.}

\item{TransitGatewayAttachmentId}{The ID of the transit gateway attachment to associate with the transit
gateway multicast domain.}

\item{SubnetIds}{The IDs of the subnets to associate with the transit gateway multicast
domain.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Associations = list(
    TransitGatewayMulticastDomainId = "string",
    TransitGatewayAttachmentId = "string",
    ResourceId = "string",
    ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering",
    ResourceOwnerId = "string",
    Subnets = list(
      list(
        SubnetId = "string",
        State = "pendingAcceptance"|"associating"|"associated"|"disassociating"|"disassociated"|"rejected"|"failed"
      )
    )
  )
)
}
}
\description{
Associates the specified subnets and transit gateway attachments with
the specified transit gateway multicast domain.

The transit gateway attachment must be in the available state before you
can add a resource. Use
\code{\link[=ec2_describe_transit_gateway_attachments]{describe_transit_gateway_attachments}}
to see the state of the attachment.
}
\section{Request syntax}{
\preformatted{svc$associate_transit_gateway_multicast_domain(
  TransitGatewayMulticastDomainId = "string",
  TransitGatewayAttachmentId = "string",
  SubnetIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
