% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_vpn_connection}
\alias{ec2_modify_vpn_connection}
\title{Modifies the customer gateway or the target gateway of an AWS
Site-to-Site VPN connection}
\usage{
ec2_modify_vpn_connection(VpnConnectionId, TransitGatewayId,
  CustomerGatewayId, VpnGatewayId, DryRun)
}
\arguments{
\item{VpnConnectionId}{[required] The ID of the VPN connection.}

\item{TransitGatewayId}{The ID of the transit gateway.}

\item{CustomerGatewayId}{The ID of the customer gateway at your end of the VPN connection.}

\item{VpnGatewayId}{The ID of the virtual private gateway at the AWS side of the VPN
connection.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  VpnConnection = list(
    CustomerGatewayConfiguration = "string",
    CustomerGatewayId = "string",
    Category = "string",
    State = "pending"|"available"|"deleting"|"deleted",
    Type = "ipsec.1",
    VpnConnectionId = "string",
    VpnGatewayId = "string",
    TransitGatewayId = "string",
    Options = list(
      EnableAcceleration = TRUE|FALSE,
      StaticRoutesOnly = TRUE|FALSE,
      LocalIpv4NetworkCidr = "string",
      RemoteIpv4NetworkCidr = "string",
      LocalIpv6NetworkCidr = "string",
      RemoteIpv6NetworkCidr = "string",
      TunnelInsideIpVersion = "ipv4"|"ipv6",
      TunnelOptions = list(
        list(
          OutsideIpAddress = "string",
          TunnelInsideCidr = "string",
          TunnelInsideIpv6Cidr = "string",
          PreSharedKey = "string",
          Phase1LifetimeSeconds = 123,
          Phase2LifetimeSeconds = 123,
          RekeyMarginTimeSeconds = 123,
          RekeyFuzzPercentage = 123,
          ReplayWindowSize = 123,
          DpdTimeoutSeconds = 123,
          DpdTimeoutAction = "string",
          Phase1EncryptionAlgorithms = list(
            list(
              Value = "string"
            )
          ),
          Phase2EncryptionAlgorithms = list(
            list(
              Value = "string"
            )
          ),
          Phase1IntegrityAlgorithms = list(
            list(
              Value = "string"
            )
          ),
          Phase2IntegrityAlgorithms = list(
            list(
              Value = "string"
            )
          ),
          Phase1DHGroupNumbers = list(
            list(
              Value = 123
            )
          ),
          Phase2DHGroupNumbers = list(
            list(
              Value = 123
            )
          ),
          IkeVersions = list(
            list(
              Value = "string"
            )
          ),
          StartupAction = "string"
        )
      )
    ),
    Routes = list(
      list(
        DestinationCidrBlock = "string",
        Source = "Static",
        State = "pending"|"available"|"deleting"|"deleted"
      )
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    VgwTelemetry = list(
      list(
        AcceptedRouteCount = 123,
        LastStatusChange = as.POSIXct(
          "2015-01-01"
        ),
        OutsideIpAddress = "string",
        Status = "UP"|"DOWN",
        StatusMessage = "string",
        CertificateArn = "string"
      )
    )
  )
)
}
}
\description{
Modifies the customer gateway or the target gateway of an AWS
Site-to-Site VPN connection. To modify the target gateway, the following
migration options are available:
\itemize{
\item An existing virtual private gateway to a new virtual private gateway
\item An existing virtual private gateway to a transit gateway
\item An existing transit gateway to a new transit gateway
\item An existing transit gateway to a virtual private gateway
}

Before you perform the migration to the new gateway, you must configure
the new gateway. Use \code{\link[=ec2_create_vpn_gateway]{create_vpn_gateway}} to
create a virtual private gateway, or
\code{\link[=ec2_create_transit_gateway]{create_transit_gateway}} to create a
transit gateway.

This step is required when you migrate from a virtual private gateway
with static routes to a transit gateway.

You must delete the static routes before you migrate to the new gateway.

Keep a copy of the static route before you delete it. You will need to
add back these routes to the transit gateway after the VPN connection
migration is complete.

After you migrate to the new gateway, you might need to modify your VPC
route table. Use \code{\link[=ec2_create_route]{create_route}} and
\code{\link[=ec2_delete_route]{delete_route}} to make the changes described in \href{https://docs.aws.amazon.com/vpn/latest/s2svpn/modify-vpn-target.html#step-update-routing}{VPN Gateway Target Modification Required VPC Route Table Updates}
in the \emph{AWS Site-to-Site VPN User Guide}.

When the new gateway is a transit gateway, modify the transit gateway
route table to allow traffic between the VPC and the AWS Site-to-Site
VPN connection. Use
\code{\link[=ec2_create_transit_gateway_route]{create_transit_gateway_route}} to
add the routes.

If you deleted VPN static routes, you must add the static routes to the
transit gateway route table.

After you perform this operation, the AWS VPN endpoint's IP addresses on
the AWS side and the tunnel options remain intact. Your AWS Site-to-Site
VPN connection will be temporarily unavailable for a brief period while
we provision the new endpoints.
}
\section{Request syntax}{
\preformatted{svc$modify_vpn_connection(
  VpnConnectionId = "string",
  TransitGatewayId = "string",
  CustomerGatewayId = "string",
  VpnGatewayId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
