% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_get_function_concurrency}
\alias{lambda_get_function_concurrency}
\title{Returns details about the reserved concurrency configuration for a
function}
\usage{
lambda_get_function_concurrency(FunctionName)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}
}
\value{
A list with the following syntax:\preformatted{list(
  ReservedConcurrentExecutions = 123
)
}
}
\description{
Returns details about the reserved concurrency configuration for a
function. To set a concurrency limit for a function, use
\code{\link[=lambda_put_function_concurrency]{put_function_concurrency}}.
}
\section{Request syntax}{
\preformatted{svc$get_function_concurrency(
  FunctionName = "string"
)
}
}

\examples{
\dontrun{
# The following example returns the reserved concurrency setting for a
# function named my-function.
svc$get_function_concurrency(
  FunctionName = "my-function"
)
}

}
\keyword{internal}
