% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_tags}
\alias{lambda_list_tags}
\title{Returns a function's tags}
\usage{
lambda_list_tags(Resource)
}
\arguments{
\item{Resource}{[required] The function's Amazon Resource Name (ARN).}
}
\value{
A list with the following syntax:\preformatted{list(
  Tags = list(
    "string"
  )
)
}
}
\description{
Returns a function's
\href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-tags.html}{tags}.
You can also view tags with \code{\link[=lambda_get_function]{get_function}}.
}
\section{Request syntax}{
\preformatted{svc$list_tags(
  Resource = "string"
)
}
}

\examples{
\dontrun{
# The following example displays the tags attached to the my-function
# Lambda function.
svc$list_tags(
  Resource = "arn:aws:lambda:us-west-2:123456789012:function:my-function"
)
}

}
\keyword{internal}
