% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_instance_attribute}
\alias{ec2_describe_instance_attribute}
\title{Describes the specified attribute of the specified instance}
\usage{
ec2_describe_instance_attribute(Attribute, DryRun, InstanceId)
}
\arguments{
\item{Attribute}{[required] The instance attribute.

Note: The \code{enaSupport} attribute is not supported at this time.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceId}{[required] The ID of the instance.}
}
\value{
A list with the following syntax:\preformatted{list(
  Groups = list(
    list(
      GroupName = "string",
      GroupId = "string"
    )
  ),
  BlockDeviceMappings = list(
    list(
      DeviceName = "string",
      Ebs = list(
        AttachTime = as.POSIXct(
          "2015-01-01"
        ),
        DeleteOnTermination = TRUE|FALSE,
        Status = "attaching"|"attached"|"detaching"|"detached",
        VolumeId = "string"
      )
    )
  ),
  DisableApiTermination = list(
    Value = TRUE|FALSE
  ),
  EnaSupport = list(
    Value = TRUE|FALSE
  ),
  EnclaveOptions = list(
    Enabled = TRUE|FALSE
  ),
  EbsOptimized = list(
    Value = TRUE|FALSE
  ),
  InstanceId = "string",
  InstanceInitiatedShutdownBehavior = list(
    Value = "string"
  ),
  InstanceType = list(
    Value = "string"
  ),
  KernelId = list(
    Value = "string"
  ),
  ProductCodes = list(
    list(
      ProductCodeId = "string",
      ProductCodeType = "devpay"|"marketplace"
    )
  ),
  RamdiskId = list(
    Value = "string"
  ),
  RootDeviceName = list(
    Value = "string"
  ),
  SourceDestCheck = list(
    Value = TRUE|FALSE
  ),
  SriovNetSupport = list(
    Value = "string"
  ),
  UserData = list(
    Value = "string"
  )
)
}
}
\description{
Describes the specified attribute of the specified instance. You can
specify only one attribute at a time. Valid attribute values are:
\code{instanceType} | \code{kernel} | \code{ramdisk} | \code{userData} |
\code{disableApiTermination} | \code{instanceInitiatedShutdownBehavior} |
\code{rootDeviceName} | \code{blockDeviceMapping} | \code{productCodes} |
\code{sourceDestCheck} | \code{groupSet} | \code{ebsOptimized} | \code{sriovNetSupport}
}
\section{Request syntax}{
\preformatted{svc$describe_instance_attribute(
  Attribute = "instanceType"|"kernel"|"ramdisk"|"userData"|"disableApiTermination"|"instanceInitiatedShutdownBehavior"|"rootDeviceName"|"blockDeviceMapping"|"productCodes"|"sourceDestCheck"|"groupSet"|"ebsOptimized"|"sriovNetSupport"|"enaSupport"|"enclaveOptions",
  DryRun = TRUE|FALSE,
  InstanceId = "string"
)
}
}

\examples{
\dontrun{
# This example describes the instance type of the specified instance.
# 
svc$describe_instance_attribute(
  Attribute = "instanceType",
  InstanceId = "i-1234567890abcdef0"
)

# This example describes the `disableApiTermination` attribute of the
# specified instance.
# 
svc$describe_instance_attribute(
  Attribute = "disableApiTermination",
  InstanceId = "i-1234567890abcdef0"
)

# This example describes the `blockDeviceMapping` attribute of the
# specified instance.
# 
svc$describe_instance_attribute(
  Attribute = "blockDeviceMapping",
  InstanceId = "i-1234567890abcdef0"
)
}

}
\keyword{internal}
