% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_volume}
\alias{ec2_modify_volume}
\title{You can modify several parameters of an existing EBS volume, including
volume size, volume type, and IOPS capacity}
\usage{
ec2_modify_volume(DryRun, VolumeId, Size, VolumeType, Iops)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VolumeId}{[required] The ID of the volume.}

\item{Size}{The target size of the volume, in GiB. The target volume size must be
greater than or equal to than the existing size of the volume. For
information about available EBS volume sizes, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html}{Amazon EBS Volume Types}.

Default: If no size is specified, the existing size is retained.}

\item{VolumeType}{The target EBS volume type of the volume.

Default: If no type is specified, the existing type is retained.}

\item{Iops}{The target IOPS rate of the volume.

This is only valid for Provisioned IOPS SSD (\code{io1}) volumes. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops}{Provisioned IOPS SSD (io1) Volumes}.

Default: If no IOPS value is specified, the existing value is retained.}
}
\description{
You can modify several parameters of an existing EBS volume, including
volume size, volume type, and IOPS capacity. If your EBS volume is
attached to a current-generation EC2 instance type, you may be able to
apply these changes without stopping the instance or detaching the
volume from it. For more information about modifying an EBS volume
running Linux, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html}{Modifying the Size, IOPS, or Type of an EBS Volume on Linux}.
For more information about modifying an EBS volume running Windows, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html}{Modifying the Size, IOPS, or Type of an EBS Volume on Windows}.
}
\details{
When you complete a resize operation on your volume, you need to extend
the volume's file-system size to take advantage of the new storage
capacity. For information about extending a Linux file system, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#recognize-expanded-volume-linux}{Extending a Linux File System}.
For information about extending a Windows file system, see \href{https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html#recognize-expanded-volume-windows}{Extending a Windows File System}.

You can use CloudWatch Events to check the status of a modification to
an EBS volume. For information about CloudWatch Events, see the \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/}{Amazon CloudWatch Events User Guide}. You
can also track the status of a modification using
DescribeVolumesModifications. For information about tracking status
changes using either method, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#monitoring_mods}{Monitoring Volume Modifications}.

With previous-generation instance types, resizing an EBS volume may
require detaching and reattaching the volume or stopping and restarting
the instance. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html}{Modifying the Size, IOPS, or Type of an EBS Volume on Linux}
and \href{https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html}{Modifying the Size, IOPS, or Type of an EBS Volume on Windows}.

If you reach the maximum volume modification rate per volume limit, you
will need to wait at least six hours before applying further
modifications to the affected EBS volume.
}
\section{Request syntax}{
\preformatted{svc$modify_volume(
  DryRun = TRUE|FALSE,
  VolumeId = "string",
  Size = 123,
  VolumeType = "standard"|"io1"|"gp2"|"sc1"|"st1",
  Iops = 123
)
}
}

\keyword{internal}
