% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_security_group_references}
\alias{ec2_describe_security_group_references}
\title{[VPC only] Describes the VPCs on the other side of a VPC peering
connection that are referencing the security groups you've specified in
this request}
\usage{
ec2_describe_security_group_references(DryRun, GroupId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{GroupId}{[required] The IDs of the security groups in your account.}
}
\description{
[VPC only] Describes the VPCs on the other side of a VPC peering
connection that are referencing the security groups you\'ve specified in
this request.
}
\section{Request syntax}{
\preformatted{svc$describe_security_group_references(
  DryRun = TRUE|FALSE,
  GroupId = list(
    "string"
  )
)
}
}

\examples{
# This example describes the security group references for the specified
# security group.
\donttest{svc$describe_security_group_references(
  GroupId = list(
    "sg-903004f8"
  )
)}

}
\keyword{internal}
