% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_spot_fleet_request}
\alias{ec2_modify_spot_fleet_request}
\title{Modifies the specified Spot Fleet request}
\usage{
ec2_modify_spot_fleet_request(ExcessCapacityTerminationPolicy,
  SpotFleetRequestId, TargetCapacity, OnDemandTargetCapacity)
}
\arguments{
\item{ExcessCapacityTerminationPolicy}{Indicates whether running Spot Instances should be terminated if the
target capacity of the Spot Fleet request is decreased below the current
size of the Spot Fleet.}

\item{SpotFleetRequestId}{[required] The ID of the Spot Fleet request.}

\item{TargetCapacity}{The size of the fleet.}

\item{OnDemandTargetCapacity}{The number of On-Demand Instances in the fleet.}
}
\description{
Modifies the specified Spot Fleet request.
}
\details{
You can only modify a Spot Fleet request of type \code{maintain}.

While the Spot Fleet request is being modified, it is in the \code{modifying}
state.

To scale up your Spot Fleet, increase its target capacity. The Spot
Fleet launches the additional Spot Instances according to the allocation
strategy for the Spot Fleet request. If the allocation strategy is
\code{lowestPrice}, the Spot Fleet launches instances using the Spot Instance
pool with the lowest price. If the allocation strategy is \code{diversified},
the Spot Fleet distributes the instances across the Spot Instance pools.
If the allocation strategy is \code{capacityOptimized}, Spot Fleet launches
instances from Spot Instance pools with optimal capacity for the number
of instances that are launching.

To scale down your Spot Fleet, decrease its target capacity. First, the
Spot Fleet cancels any open requests that exceed the new target
capacity. You can request that the Spot Fleet terminate Spot Instances
until the size of the fleet no longer exceeds the new target capacity.
If the allocation strategy is \code{lowestPrice}, the Spot Fleet terminates
the instances with the highest price per unit. If the allocation
strategy is \code{capacityOptimized}, the Spot Fleet terminates the instances
in the Spot Instance pools that have the least available Spot Instance
capacity. If the allocation strategy is \code{diversified}, the Spot Fleet
terminates instances across the Spot Instance pools. Alternatively, you
can request that the Spot Fleet keep the fleet at its current size, but
not replace any Spot Instances that are interrupted or that you
terminate manually.

If you are finished with your Spot Fleet for now, but will use it again
later, you can set the target capacity to 0.
}
\section{Request syntax}{
\preformatted{svc$modify_spot_fleet_request(
  ExcessCapacityTerminationPolicy = "noTermination"|"default",
  SpotFleetRequestId = "string",
  TargetCapacity = 123,
  OnDemandTargetCapacity = 123
)
}
}

\examples{
# This example increases the target capacity of the specified Spot fleet
# request.
\donttest{svc$modify_spot_fleet_request(
  SpotFleetRequestId = "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE",
  TargetCapacity = 20L
)}

# This example decreases the target capacity of the specified Spot fleet
# request without terminating any Spot Instances as a result.
\donttest{svc$modify_spot_fleet_request(
  ExcessCapacityTerminationPolicy = "NoTermination ",
  SpotFleetRequestId = "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE",
  TargetCapacity = 10L
)}

}
\keyword{internal}
