% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_unassign_private_ip_addresses}
\alias{ec2_unassign_private_ip_addresses}
\title{Unassigns one or more secondary private IP addresses from a network
interface}
\usage{
ec2_unassign_private_ip_addresses(NetworkInterfaceId,
  PrivateIpAddresses)
}
\arguments{
\item{NetworkInterfaceId}{[required] The ID of the network interface.}

\item{PrivateIpAddresses}{[required] The secondary private IP addresses to unassign from the network
interface. You can specify this option multiple times to unassign more
than one IP address.}
}
\description{
Unassigns one or more secondary private IP addresses from a network
interface.
}
\section{Request syntax}{
\preformatted{svc$unassign_private_ip_addresses(
  NetworkInterfaceId = "string",
  PrivateIpAddresses = list(
    "string"
  )
)
}
}

\examples{
# This example unassigns the specified private IP address from the
# specified network interface.
\donttest{svc$unassign_private_ip_addresses(
  NetworkInterfaceId = "eni-e5aa89a3",
  PrivateIpAddresses = list(
    "10.0.0.82"
  )
)}

}
\keyword{internal}
