% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_update_nodegroup_version}
\alias{eks_update_nodegroup_version}
\title{Updates the Kubernetes version or AMI version of an Amazon EKS managed
node group}
\usage{
eks_update_nodegroup_version(clusterName, nodegroupName, version,
  releaseVersion, force, clientRequestToken)
}
\arguments{
\item{clusterName}{[required] The name of the Amazon EKS cluster that is associated with the managed
node group to update.}

\item{nodegroupName}{[required] The name of the managed node group to update.}

\item{version}{The Kubernetes version to update to. If no version is specified, then
the Kubernetes version of the node group does not change. You can
specify the Kubernetes version of the cluster to update the node group
to the latest AMI version of the cluster\'s Kubernetes version.}

\item{releaseVersion}{The AMI version of the Amazon EKS-optimized AMI to use for the update.
By default, the latest available AMI version for the node group\'s
Kubernetes version is used. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html}{Amazon EKS-Optimized Linux AMI Versions}
in the \emph{Amazon EKS User Guide}.}

\item{force}{Force the update if the existing node group\'s pods are unable to be
drained due to a pod disruption budget issue. If an update fails because
pods could not be drained, you can force the update after it fails to
terminate the old node whether or not any pods are running on the node.}

\item{clientRequestToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Updates the Kubernetes version or AMI version of an Amazon EKS managed
node group.
}
\details{
You can update to the latest available AMI version of a node group\'s
current Kubernetes version by not specifying a Kubernetes version in the
request. You can update to the latest AMI version of your cluster\'s
current Kubernetes version by specifying your cluster\'s Kubernetes
version in the request. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html}{Amazon EKS-Optimized Linux AMI Versions}
in the \emph{Amazon EKS User Guide}.

You cannot roll back a node group to an earlier Kubernetes version or
AMI version.

When a node in a managed node group is terminated due to a scaling
action or update, the pods in that node are drained first. Amazon EKS
attempts to drain the nodes gracefully and will fail if it is unable to
do so. You can \code{force} the update if Amazon EKS is unable to drain the
nodes as a result of a pod disruption budget issue.
}
\section{Request syntax}{
\preformatted{svc$update_nodegroup_version(
  clusterName = "string",
  nodegroupName = "string",
  version = "string",
  releaseVersion = "string",
  force = TRUE|FALSE,
  clientRequestToken = "string"
)
}
}

\keyword{internal}
