# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include serverlessapplicationrepository_service.R
NULL

#' Creates an application, optionally including an AWS SAM file to create
#' the first application version in the same call
#'
#' Creates an application, optionally including an AWS SAM file to create
#' the first application version in the same call.
#'
#' @usage
#' serverlessapplicationrepository_create_application(Author, Description,
#'   HomePageUrl, Labels, LicenseBody, LicenseUrl, Name, ReadmeBody,
#'   ReadmeUrl, SemanticVersion, SourceCodeArchiveUrl, SourceCodeUrl,
#'   SpdxLicenseId, TemplateBody, TemplateUrl)
#'
#' @param Author &#91;required&#93; The name of the author publishing the app.
#' 
#' Minimum length=1. Maximum length=127.
#' 
#' Pattern \"\\^\[a-z0-9\]((\[a-z0-9\]\\|-(?!-))*\[a-z0-9\])?\\$\";
#' @param Description &#91;required&#93; The description of the application.
#' 
#' Minimum length=1. Maximum length=256
#' @param HomePageUrl A URL with more information about the application, for example the
#' location of your GitHub repository for the application.
#' @param Labels Labels to improve discovery of apps in search results.
#' 
#' Minimum length=1. Maximum length=127. Maximum number of labels: 10
#' 
#' Pattern: \"\\^\[a-zA-Z0-9+\\\\-\\_:\\\\/@@\]+\\$\";
#' @param LicenseBody A local text file that contains the license of the app that matches the
#' spdxLicenseID value of your application. The file has the format
#' file://\\<path\\>/\\<filename\\>.
#' 
#' Maximum size 5 MB
#' 
#' You can specify only one of licenseBody and licenseUrl; otherwise, an
#' error results.
#' @param LicenseUrl A link to the S3 object that contains the license of the app that
#' matches the spdxLicenseID value of your application.
#' 
#' Maximum size 5 MB
#' 
#' You can specify only one of licenseBody and licenseUrl; otherwise, an
#' error results.
#' @param Name &#91;required&#93; The name of the application that you want to publish.
#' 
#' Minimum length=1. Maximum length=140
#' 
#' Pattern: \"\[a-zA-Z0-9\\\\-\]+\";
#' @param ReadmeBody A local text readme file in Markdown language that contains a more
#' detailed description of the application and how it works. The file has
#' the format file://\\<path\\>/\\<filename\\>.
#' 
#' Maximum size 5 MB
#' 
#' You can specify only one of readmeBody and readmeUrl; otherwise, an
#' error results.
#' @param ReadmeUrl A link to the S3 object in Markdown language that contains a more
#' detailed description of the application and how it works.
#' 
#' Maximum size 5 MB
#' 
#' You can specify only one of readmeBody and readmeUrl; otherwise, an
#' error results.
#' @param SemanticVersion The semantic version of the application:
#' 
#' <https://semver.org/>
#' @param SourceCodeArchiveUrl A link to the S3 object that contains the ZIP archive of the source code
#' for this version of your application.
#' 
#' Maximum size 50 MB
#' @param SourceCodeUrl A link to a public repository for the source code of your application,
#' for example the URL of a specific GitHub commit.
#' @param SpdxLicenseId A valid identifier from <https://spdx.org/licenses/>.
#' @param TemplateBody The local raw packaged AWS SAM template file of your application. The
#' file has the format file://\\<path\\>/\\<filename\\>.
#' 
#' You can specify only one of templateBody and templateUrl; otherwise an
#' error results.
#' @param TemplateUrl A link to the S3 object containing the packaged AWS SAM template of your
#' application.
#' 
#' You can specify only one of templateBody and templateUrl; otherwise an
#' error results.
#'
#' @section Request syntax:
#' ```
#' svc$create_application(
#'   Author = "string",
#'   Description = "string",
#'   HomePageUrl = "string",
#'   Labels = list(
#'     "string"
#'   ),
#'   LicenseBody = "string",
#'   LicenseUrl = "string",
#'   Name = "string",
#'   ReadmeBody = "string",
#'   ReadmeUrl = "string",
#'   SemanticVersion = "string",
#'   SourceCodeArchiveUrl = "string",
#'   SourceCodeUrl = "string",
#'   SpdxLicenseId = "string",
#'   TemplateBody = "string",
#'   TemplateUrl = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_create_application
serverlessapplicationrepository_create_application <- function(Author, Description, HomePageUrl = NULL, Labels = NULL, LicenseBody = NULL, LicenseUrl = NULL, Name, ReadmeBody = NULL, ReadmeUrl = NULL, SemanticVersion = NULL, SourceCodeArchiveUrl = NULL, SourceCodeUrl = NULL, SpdxLicenseId = NULL, TemplateBody = NULL, TemplateUrl = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/applications",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$create_application_input(Author = Author, Description = Description, HomePageUrl = HomePageUrl, Labels = Labels, LicenseBody = LicenseBody, LicenseUrl = LicenseUrl, Name = Name, ReadmeBody = ReadmeBody, ReadmeUrl = ReadmeUrl, SemanticVersion = SemanticVersion, SourceCodeArchiveUrl = SourceCodeArchiveUrl, SourceCodeUrl = SourceCodeUrl, SpdxLicenseId = SpdxLicenseId, TemplateBody = TemplateBody, TemplateUrl = TemplateUrl)
  output <- .serverlessapplicationrepository$create_application_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$create_application <- serverlessapplicationrepository_create_application

#' Creates an application version
#'
#' Creates an application version.
#'
#' @usage
#' serverlessapplicationrepository_create_application_version(
#'   ApplicationId, SemanticVersion, SourceCodeArchiveUrl, SourceCodeUrl,
#'   TemplateBody, TemplateUrl)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param SemanticVersion &#91;required&#93; The semantic version of the new version.
#' @param SourceCodeArchiveUrl A link to the S3 object that contains the ZIP archive of the source code
#' for this version of your application.
#' 
#' Maximum size 50 MB
#' @param SourceCodeUrl A link to a public repository for the source code of your application,
#' for example the URL of a specific GitHub commit.
#' @param TemplateBody The raw packaged AWS SAM template of your application.
#' @param TemplateUrl A link to the packaged AWS SAM template of your application.
#'
#' @section Request syntax:
#' ```
#' svc$create_application_version(
#'   ApplicationId = "string",
#'   SemanticVersion = "string",
#'   SourceCodeArchiveUrl = "string",
#'   SourceCodeUrl = "string",
#'   TemplateBody = "string",
#'   TemplateUrl = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_create_application_version
serverlessapplicationrepository_create_application_version <- function(ApplicationId, SemanticVersion, SourceCodeArchiveUrl = NULL, SourceCodeUrl = NULL, TemplateBody = NULL, TemplateUrl = NULL) {
  op <- new_operation(
    name = "CreateApplicationVersion",
    http_method = "PUT",
    http_path = "/applications/{applicationId}/versions/{semanticVersion}",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$create_application_version_input(ApplicationId = ApplicationId, SemanticVersion = SemanticVersion, SourceCodeArchiveUrl = SourceCodeArchiveUrl, SourceCodeUrl = SourceCodeUrl, TemplateBody = TemplateBody, TemplateUrl = TemplateUrl)
  output <- .serverlessapplicationrepository$create_application_version_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$create_application_version <- serverlessapplicationrepository_create_application_version

#' Creates an AWS CloudFormation change set for the given application
#'
#' Creates an AWS CloudFormation change set for the given application.
#'
#' @usage
#' serverlessapplicationrepository_create_cloud_formation_change_set(
#'   ApplicationId, Capabilities, ChangeSetName, ClientToken, Description,
#'   NotificationArns, ParameterOverrides, ResourceTypes,
#'   RollbackConfiguration, SemanticVersion, StackName, Tags, TemplateId)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param Capabilities A list of values that you must specify before you can deploy certain
#' applications. Some applications might include resources that can affect
#' permissions in your AWS account, for example, by creating new AWS
#' Identity and Access Management (IAM) users. For those applications, you
#' must explicitly acknowledge their capabilities by specifying this
#' parameter.
#' 
#' The only valid values are CAPABILITY\\_IAM, CAPABILITY\\_NAMED\\_IAM,
#' CAPABILITY\\_RESOURCE\\_POLICY, and CAPABILITY\\_AUTO\\_EXPAND.
#' 
#' The following resources require you to specify CAPABILITY\\_IAM or
#' CAPABILITY\\_NAMED\\_IAM:
#' [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
#' [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
#' [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html),
#' and
#' [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html).
#' If the application contains IAM resources, you can specify either
#' CAPABILITY\\_IAM or CAPABILITY\\_NAMED\\_IAM. If the application contains
#' IAM resources with custom names, you must specify
#' CAPABILITY\\_NAMED\\_IAM.
#' 
#' The following resources require you to specify
#' CAPABILITY\\_RESOURCE\\_POLICY:
#' [AWS::Lambda::Permission](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html),
#' [AWS::IAM:Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html),
#' [AWS::ApplicationAutoScaling::ScalingPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html),
#' [AWS::S3::BucketPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html),
#' [AWS::SQS::QueuePolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html),
#' and
#' [AWS::SNS:TopicPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html).
#' 
#' Applications that contain one or more nested applications require you to
#' specify CAPABILITY\\_AUTO\\_EXPAND.
#' 
#' If your application template contains any of the above resources, we
#' recommend that you review all permissions associated with the
#' application before deploying. If you don\'t specify this parameter for
#' an application that requires capabilities, the call will fail.
#' @param ChangeSetName This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation
#' [CreateChangeSet](https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet)*
#' API.
#' @param ClientToken This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation
#' [CreateChangeSet](https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet)*
#' API.
#' @param Description This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation
#' [CreateChangeSet](https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet)*
#' API.
#' @param NotificationArns This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation
#' [CreateChangeSet](https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet)*
#' API.
#' @param ParameterOverrides A list of parameter values for the parameters of the application.
#' @param ResourceTypes This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation
#' [CreateChangeSet](https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet)*
#' API.
#' @param RollbackConfiguration This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation
#' [CreateChangeSet](https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet)*
#' API.
#' @param SemanticVersion The semantic version of the application:
#' 
#' <https://semver.org/>
#' @param StackName &#91;required&#93; This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation
#' [CreateChangeSet](https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet)*
#' API.
#' @param Tags This property corresponds to the parameter of the same name for the *AWS
#' CloudFormation
#' [CreateChangeSet](https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet)*
#' API.
#' @param TemplateId The UUID returned by CreateCloudFormationTemplate.
#' 
#' Pattern:
#' \[0-9a-fA-F\]\{8\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{12\}
#'
#' @section Request syntax:
#' ```
#' svc$create_cloud_formation_change_set(
#'   ApplicationId = "string",
#'   Capabilities = list(
#'     "string"
#'   ),
#'   ChangeSetName = "string",
#'   ClientToken = "string",
#'   Description = "string",
#'   NotificationArns = list(
#'     "string"
#'   ),
#'   ParameterOverrides = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ResourceTypes = list(
#'     "string"
#'   ),
#'   RollbackConfiguration = list(
#'     MonitoringTimeInMinutes = 123,
#'     RollbackTriggers = list(
#'       list(
#'         Arn = "string",
#'         Type = "string"
#'       )
#'     )
#'   ),
#'   SemanticVersion = "string",
#'   StackName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   TemplateId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_create_cloud_formation_change_set
serverlessapplicationrepository_create_cloud_formation_change_set <- function(ApplicationId, Capabilities = NULL, ChangeSetName = NULL, ClientToken = NULL, Description = NULL, NotificationArns = NULL, ParameterOverrides = NULL, ResourceTypes = NULL, RollbackConfiguration = NULL, SemanticVersion = NULL, StackName, Tags = NULL, TemplateId = NULL) {
  op <- new_operation(
    name = "CreateCloudFormationChangeSet",
    http_method = "POST",
    http_path = "/applications/{applicationId}/changesets",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$create_cloud_formation_change_set_input(ApplicationId = ApplicationId, Capabilities = Capabilities, ChangeSetName = ChangeSetName, ClientToken = ClientToken, Description = Description, NotificationArns = NotificationArns, ParameterOverrides = ParameterOverrides, ResourceTypes = ResourceTypes, RollbackConfiguration = RollbackConfiguration, SemanticVersion = SemanticVersion, StackName = StackName, Tags = Tags, TemplateId = TemplateId)
  output <- .serverlessapplicationrepository$create_cloud_formation_change_set_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$create_cloud_formation_change_set <- serverlessapplicationrepository_create_cloud_formation_change_set

#' Creates an AWS CloudFormation template
#'
#' Creates an AWS CloudFormation template.
#'
#' @usage
#' serverlessapplicationrepository_create_cloud_formation_template(
#'   ApplicationId, SemanticVersion)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param SemanticVersion The semantic version of the application:
#' 
#' <https://semver.org/>
#'
#' @section Request syntax:
#' ```
#' svc$create_cloud_formation_template(
#'   ApplicationId = "string",
#'   SemanticVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_create_cloud_formation_template
serverlessapplicationrepository_create_cloud_formation_template <- function(ApplicationId, SemanticVersion = NULL) {
  op <- new_operation(
    name = "CreateCloudFormationTemplate",
    http_method = "POST",
    http_path = "/applications/{applicationId}/templates",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$create_cloud_formation_template_input(ApplicationId = ApplicationId, SemanticVersion = SemanticVersion)
  output <- .serverlessapplicationrepository$create_cloud_formation_template_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$create_cloud_formation_template <- serverlessapplicationrepository_create_cloud_formation_template

#' Deletes the specified application
#'
#' Deletes the specified application.
#'
#' @usage
#' serverlessapplicationrepository_delete_application(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_delete_application
serverlessapplicationrepository_delete_application <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "DELETE",
    http_path = "/applications/{applicationId}",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$delete_application_input(ApplicationId = ApplicationId)
  output <- .serverlessapplicationrepository$delete_application_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$delete_application <- serverlessapplicationrepository_delete_application

#' Gets the specified application
#'
#' Gets the specified application.
#'
#' @usage
#' serverlessapplicationrepository_get_application(ApplicationId,
#'   SemanticVersion)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param SemanticVersion The semantic version of the application to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_application(
#'   ApplicationId = "string",
#'   SemanticVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_get_application
serverlessapplicationrepository_get_application <- function(ApplicationId, SemanticVersion = NULL) {
  op <- new_operation(
    name = "GetApplication",
    http_method = "GET",
    http_path = "/applications/{applicationId}",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$get_application_input(ApplicationId = ApplicationId, SemanticVersion = SemanticVersion)
  output <- .serverlessapplicationrepository$get_application_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$get_application <- serverlessapplicationrepository_get_application

#' Retrieves the policy for the application
#'
#' Retrieves the policy for the application.
#'
#' @usage
#' serverlessapplicationrepository_get_application_policy(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#'
#' @section Request syntax:
#' ```
#' svc$get_application_policy(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_get_application_policy
serverlessapplicationrepository_get_application_policy <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApplicationPolicy",
    http_method = "GET",
    http_path = "/applications/{applicationId}/policy",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$get_application_policy_input(ApplicationId = ApplicationId)
  output <- .serverlessapplicationrepository$get_application_policy_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$get_application_policy <- serverlessapplicationrepository_get_application_policy

#' Gets the specified AWS CloudFormation template
#'
#' Gets the specified AWS CloudFormation template.
#'
#' @usage
#' serverlessapplicationrepository_get_cloud_formation_template(
#'   ApplicationId, TemplateId)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param TemplateId &#91;required&#93; The UUID returned by CreateCloudFormationTemplate.
#' 
#' Pattern:
#' \[0-9a-fA-F\]\{8\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{4\}\\-\[0-9a-fA-F\]\{12\}
#'
#' @section Request syntax:
#' ```
#' svc$get_cloud_formation_template(
#'   ApplicationId = "string",
#'   TemplateId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_get_cloud_formation_template
serverlessapplicationrepository_get_cloud_formation_template <- function(ApplicationId, TemplateId) {
  op <- new_operation(
    name = "GetCloudFormationTemplate",
    http_method = "GET",
    http_path = "/applications/{applicationId}/templates/{templateId}",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$get_cloud_formation_template_input(ApplicationId = ApplicationId, TemplateId = TemplateId)
  output <- .serverlessapplicationrepository$get_cloud_formation_template_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$get_cloud_formation_template <- serverlessapplicationrepository_get_cloud_formation_template

#' Retrieves the list of applications nested in the containing application
#'
#' Retrieves the list of applications nested in the containing application.
#'
#' @usage
#' serverlessapplicationrepository_list_application_dependencies(
#'   ApplicationId, MaxItems, NextToken, SemanticVersion)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param MaxItems The total number of items to return.
#' @param NextToken A token to specify where to start paginating.
#' @param SemanticVersion The semantic version of the application to get.
#'
#' @section Request syntax:
#' ```
#' svc$list_application_dependencies(
#'   ApplicationId = "string",
#'   MaxItems = 123,
#'   NextToken = "string",
#'   SemanticVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_list_application_dependencies
serverlessapplicationrepository_list_application_dependencies <- function(ApplicationId, MaxItems = NULL, NextToken = NULL, SemanticVersion = NULL) {
  op <- new_operation(
    name = "ListApplicationDependencies",
    http_method = "GET",
    http_path = "/applications/{applicationId}/dependencies",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$list_application_dependencies_input(ApplicationId = ApplicationId, MaxItems = MaxItems, NextToken = NextToken, SemanticVersion = SemanticVersion)
  output <- .serverlessapplicationrepository$list_application_dependencies_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$list_application_dependencies <- serverlessapplicationrepository_list_application_dependencies

#' Lists versions for the specified application
#'
#' Lists versions for the specified application.
#'
#' @usage
#' serverlessapplicationrepository_list_application_versions(ApplicationId,
#'   MaxItems, NextToken)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param MaxItems The total number of items to return.
#' @param NextToken A token to specify where to start paginating.
#'
#' @section Request syntax:
#' ```
#' svc$list_application_versions(
#'   ApplicationId = "string",
#'   MaxItems = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_list_application_versions
serverlessapplicationrepository_list_application_versions <- function(ApplicationId, MaxItems = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplicationVersions",
    http_method = "GET",
    http_path = "/applications/{applicationId}/versions",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$list_application_versions_input(ApplicationId = ApplicationId, MaxItems = MaxItems, NextToken = NextToken)
  output <- .serverlessapplicationrepository$list_application_versions_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$list_application_versions <- serverlessapplicationrepository_list_application_versions

#' Lists applications owned by the requester
#'
#' Lists applications owned by the requester.
#'
#' @usage
#' serverlessapplicationrepository_list_applications(MaxItems, NextToken)
#'
#' @param MaxItems The total number of items to return.
#' @param NextToken A token to specify where to start paginating.
#'
#' @section Request syntax:
#' ```
#' svc$list_applications(
#'   MaxItems = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_list_applications
serverlessapplicationrepository_list_applications <- function(MaxItems = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "GET",
    http_path = "/applications",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$list_applications_input(MaxItems = MaxItems, NextToken = NextToken)
  output <- .serverlessapplicationrepository$list_applications_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$list_applications <- serverlessapplicationrepository_list_applications

#' Sets the permission policy for an application
#'
#' Sets the permission policy for an application. For the list of actions
#' supported for this operation, see [Application
#' Permissions](https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions)
#' .
#'
#' @usage
#' serverlessapplicationrepository_put_application_policy(ApplicationId,
#'   Statements)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param Statements &#91;required&#93; An array of policy statements applied to the application.
#'
#' @section Request syntax:
#' ```
#' svc$put_application_policy(
#'   ApplicationId = "string",
#'   Statements = list(
#'     list(
#'       Actions = list(
#'         "string"
#'       ),
#'       PrincipalOrgIDs = list(
#'         "string"
#'       ),
#'       Principals = list(
#'         "string"
#'       ),
#'       StatementId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_put_application_policy
serverlessapplicationrepository_put_application_policy <- function(ApplicationId, Statements) {
  op <- new_operation(
    name = "PutApplicationPolicy",
    http_method = "PUT",
    http_path = "/applications/{applicationId}/policy",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$put_application_policy_input(ApplicationId = ApplicationId, Statements = Statements)
  output <- .serverlessapplicationrepository$put_application_policy_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$put_application_policy <- serverlessapplicationrepository_put_application_policy

#' Unshares an application from an AWS Organization
#'
#' Unshares an application from an AWS Organization.
#' 
#' This operation can be called only from the organization\'s master
#' account.
#'
#' @usage
#' serverlessapplicationrepository_unshare_application(ApplicationId,
#'   OrganizationId)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param OrganizationId &#91;required&#93; The AWS Organization ID to unshare the application from.
#'
#' @section Request syntax:
#' ```
#' svc$unshare_application(
#'   ApplicationId = "string",
#'   OrganizationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_unshare_application
serverlessapplicationrepository_unshare_application <- function(ApplicationId, OrganizationId) {
  op <- new_operation(
    name = "UnshareApplication",
    http_method = "POST",
    http_path = "/applications/{applicationId}/unshare",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$unshare_application_input(ApplicationId = ApplicationId, OrganizationId = OrganizationId)
  output <- .serverlessapplicationrepository$unshare_application_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$unshare_application <- serverlessapplicationrepository_unshare_application

#' Updates the specified application
#'
#' Updates the specified application.
#'
#' @usage
#' serverlessapplicationrepository_update_application(ApplicationId,
#'   Author, Description, HomePageUrl, Labels, ReadmeBody, ReadmeUrl)
#'
#' @param ApplicationId &#91;required&#93; The Amazon Resource Name (ARN) of the application.
#' @param Author The name of the author publishing the app.
#' 
#' Minimum length=1. Maximum length=127.
#' 
#' Pattern \"\\^\[a-z0-9\]((\[a-z0-9\]\\|-(?!-))*\[a-z0-9\])?\\$\";
#' @param Description The description of the application.
#' 
#' Minimum length=1. Maximum length=256
#' @param HomePageUrl A URL with more information about the application, for example the
#' location of your GitHub repository for the application.
#' @param Labels Labels to improve discovery of apps in search results.
#' 
#' Minimum length=1. Maximum length=127. Maximum number of labels: 10
#' 
#' Pattern: \"\\^\[a-zA-Z0-9+\\\\-\\_:\\\\/@@\]+\\$\";
#' @param ReadmeBody A text readme file in Markdown language that contains a more detailed
#' description of the application and how it works.
#' 
#' Maximum size 5 MB
#' @param ReadmeUrl A link to the readme file in Markdown language that contains a more
#' detailed description of the application and how it works.
#' 
#' Maximum size 5 MB
#'
#' @section Request syntax:
#' ```
#' svc$update_application(
#'   ApplicationId = "string",
#'   Author = "string",
#'   Description = "string",
#'   HomePageUrl = "string",
#'   Labels = list(
#'     "string"
#'   ),
#'   ReadmeBody = "string",
#'   ReadmeUrl = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname serverlessapplicationrepository_update_application
serverlessapplicationrepository_update_application <- function(ApplicationId, Author = NULL, Description = NULL, HomePageUrl = NULL, Labels = NULL, ReadmeBody = NULL, ReadmeUrl = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "PATCH",
    http_path = "/applications/{applicationId}",
    paginator = list()
  )
  input <- .serverlessapplicationrepository$update_application_input(ApplicationId = ApplicationId, Author = Author, Description = Description, HomePageUrl = HomePageUrl, Labels = Labels, ReadmeBody = ReadmeBody, ReadmeUrl = ReadmeUrl)
  output <- .serverlessapplicationrepository$update_application_output()
  config <- get_config()
  svc <- .serverlessapplicationrepository$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.serverlessapplicationrepository$operations$update_application <- serverlessapplicationrepository_update_application
