# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ecrpublic_service.R
NULL

#' Checks the availability of one or more image layers within a repository
#' in a public registry
#'
#' @description
#' Checks the availability of one or more image layers within a repository in a public registry. When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has been uploaded, then the image layer is skipped.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/batch_check_layer_availability.html](https://paws-r.github.io/docs/ecrpublic/batch_check_layer_availability.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the public registry that contains the
#' image layers to check. If you do not specify a registry, the default
#' public registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that is associated with the image layers to
#' check.
#' @param layerDigests &#91;required&#93; The digests of the image layers to check.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_batch_check_layer_availability
ecrpublic_batch_check_layer_availability <- function(registryId = NULL, repositoryName, layerDigests) {
  op <- new_operation(
    name = "BatchCheckLayerAvailability",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$batch_check_layer_availability_input(registryId = registryId, repositoryName = repositoryName, layerDigests = layerDigests)
  output <- .ecrpublic$batch_check_layer_availability_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$batch_check_layer_availability <- ecrpublic_batch_check_layer_availability

#' Deletes a list of specified images within a repository in a public
#' registry
#'
#' @description
#' Deletes a list of specified images within a repository in a public registry. Images are specified with either an `imageTag` or `imageDigest`.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/batch_delete_image.html](https://paws-r.github.io/docs/ecrpublic/batch_delete_image.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the registry that contains the image
#' to delete. If you do not specify a registry, the default public registry
#' is assumed.
#' @param repositoryName &#91;required&#93; The repository in a public registry that contains the image to delete.
#' @param imageIds &#91;required&#93; A list of image ID references that correspond to images to delete. The
#' format of the `imageIds` reference is `imageTag=tag` or
#' `imageDigest=digest`.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_batch_delete_image
ecrpublic_batch_delete_image <- function(registryId = NULL, repositoryName, imageIds) {
  op <- new_operation(
    name = "BatchDeleteImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$batch_delete_image_input(registryId = registryId, repositoryName = repositoryName, imageIds = imageIds)
  output <- .ecrpublic$batch_delete_image_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$batch_delete_image <- ecrpublic_batch_delete_image

#' Informs Amazon ECR that the image layer upload has completed for a
#' specified public registry, repository name, and upload ID
#'
#' @description
#' Informs Amazon ECR that the image layer upload has completed for a specified public registry, repository name, and upload ID. You can optionally provide a `sha256` digest of the image layer for data validation purposes.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/complete_layer_upload.html](https://paws-r.github.io/docs/ecrpublic/complete_layer_upload.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the registry to which to upload
#' layers. If you do not specify a registry, the default public registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository in a public registry to associate with the
#' image layer.
#' @param uploadId &#91;required&#93; The upload ID from a previous
#' [`initiate_layer_upload`][ecrpublic_initiate_layer_upload] operation to
#' associate with the image layer.
#' @param layerDigests &#91;required&#93; The `sha256` digest of the image layer.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_complete_layer_upload
ecrpublic_complete_layer_upload <- function(registryId = NULL, repositoryName, uploadId, layerDigests) {
  op <- new_operation(
    name = "CompleteLayerUpload",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$complete_layer_upload_input(registryId = registryId, repositoryName = repositoryName, uploadId = uploadId, layerDigests = layerDigests)
  output <- .ecrpublic$complete_layer_upload_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$complete_layer_upload <- ecrpublic_complete_layer_upload

#' Creates a repository in a public registry
#'
#' @description
#' Creates a repository in a public registry. For more information, see [Amazon ECR repositories](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html) in the *Amazon Elastic Container Registry User Guide*.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/create_repository.html](https://paws-r.github.io/docs/ecrpublic/create_repository.html) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name to use for the repository. This appears publicly in the Amazon
#' ECR Public Gallery. The repository name may be specified on its own
#' (such as `nginx-web-app`) or it can be prepended with a namespace to
#' group the repository into a category (such as
#' `project-a/nginx-web-app`).
#' @param catalogData The details about the repository that are publicly visible in the Amazon
#' ECR Public Gallery.
#' @param tags The metadata that you apply to the repository to help you categorize and
#' organize them. Each tag consists of a key and an optional value, both of
#' which you define. Tag keys can have a maximum character length of 128
#' characters, and tag values can have a maximum length of 256 characters.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_create_repository
ecrpublic_create_repository <- function(repositoryName, catalogData = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$create_repository_input(repositoryName = repositoryName, catalogData = catalogData, tags = tags)
  output <- .ecrpublic$create_repository_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$create_repository <- ecrpublic_create_repository

#' Deletes a repository in a public registry
#'
#' @description
#' Deletes a repository in a public registry. If the repository contains images, you must either delete all images in the repository or use the `force` option which deletes all images on your behalf before deleting the repository.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/delete_repository.html](https://paws-r.github.io/docs/ecrpublic/delete_repository.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the public registry that contains the
#' repository to delete. If you do not specify a registry, the default
#' public registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to delete.
#' @param force If a repository contains images, forces the deletion.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_delete_repository
ecrpublic_delete_repository <- function(registryId = NULL, repositoryName, force = NULL) {
  op <- new_operation(
    name = "DeleteRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$delete_repository_input(registryId = registryId, repositoryName = repositoryName, force = force)
  output <- .ecrpublic$delete_repository_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$delete_repository <- ecrpublic_delete_repository

#' Deletes the repository policy associated with the specified repository
#'
#' @description
#' Deletes the repository policy associated with the specified repository.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/delete_repository_policy.html](https://paws-r.github.io/docs/ecrpublic/delete_repository_policy.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the public registry that contains the
#' repository policy to delete. If you do not specify a registry, the
#' default public registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that is associated with the repository policy
#' to delete.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_delete_repository_policy
ecrpublic_delete_repository_policy <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "DeleteRepositoryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$delete_repository_policy_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecrpublic$delete_repository_policy_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$delete_repository_policy <- ecrpublic_delete_repository_policy

#' Returns the image tag details for a repository in a public registry
#'
#' @description
#' Returns the image tag details for a repository in a public registry.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/describe_image_tags.html](https://paws-r.github.io/docs/ecrpublic/describe_image_tags.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the public registry that contains the
#' repository in which to describe images. If you do not specify a
#' registry, the default public registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that contains the image tag details to
#' describe.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_image_tags`][ecrpublic_describe_image_tags] request where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is `null` when there are
#' no more results to return. This option cannot be used when you specify
#' images with `imageIds`.
#' @param maxResults The maximum number of repository results returned by
#' [`describe_image_tags`][ecrpublic_describe_image_tags] in paginated
#' output. When this parameter is used,
#' [`describe_image_tags`][ecrpublic_describe_image_tags] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`describe_image_tags`][ecrpublic_describe_image_tags]
#' request with the returned `nextToken` value. This value can be between 1
#' and 1000. If this parameter is not used, then
#' [`describe_image_tags`][ecrpublic_describe_image_tags] returns up to 100
#' results and a `nextToken` value, if applicable. This option cannot be
#' used when you specify images with `imageIds`.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_describe_image_tags
ecrpublic_describe_image_tags <- function(registryId = NULL, repositoryName, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeImageTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$describe_image_tags_input(registryId = registryId, repositoryName = repositoryName, nextToken = nextToken, maxResults = maxResults)
  output <- .ecrpublic$describe_image_tags_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$describe_image_tags <- ecrpublic_describe_image_tags

#' Returns metadata about the images in a repository in a public registry
#'
#' @description
#' Returns metadata about the images in a repository in a public registry.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/describe_images.html](https://paws-r.github.io/docs/ecrpublic/describe_images.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the public registry that contains the
#' repository in which to describe images. If you do not specify a
#' registry, the default public registry is assumed.
#' @param repositoryName &#91;required&#93; The repository that contains the images to describe.
#' @param imageIds The list of image IDs for the requested repository.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_images`][ecrpublic_describe_images] request where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is `null` when there are
#' no more results to return. This option cannot be used when you specify
#' images with `imageIds`.
#' @param maxResults The maximum number of repository results returned by
#' [`describe_images`][ecrpublic_describe_images] in paginated output. When
#' this parameter is used, [`describe_images`][ecrpublic_describe_images]
#' only returns `maxResults` results in a single page along with a
#' `nextToken` response element. The remaining results of the initial
#' request can be seen by sending another
#' [`describe_images`][ecrpublic_describe_images] request with the returned
#' `nextToken` value. This value can be between 1 and 1000. If this
#' parameter is not used, then
#' [`describe_images`][ecrpublic_describe_images] returns up to 100 results
#' and a `nextToken` value, if applicable. This option cannot be used when
#' you specify images with `imageIds`.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_describe_images
ecrpublic_describe_images <- function(registryId = NULL, repositoryName, imageIds = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$describe_images_input(registryId = registryId, repositoryName = repositoryName, imageIds = imageIds, nextToken = nextToken, maxResults = maxResults)
  output <- .ecrpublic$describe_images_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$describe_images <- ecrpublic_describe_images

#' Returns details for a public registry
#'
#' @description
#' Returns details for a public registry.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/describe_registries.html](https://paws-r.github.io/docs/ecrpublic/describe_registries.html) for full documentation.
#'
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_registries`][ecrpublic_describe_registries] request where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is `null` when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of repository results returned by
#' [`describe_registries`][ecrpublic_describe_registries] in paginated
#' output. When this parameter is used,
#' [`describe_registries`][ecrpublic_describe_registries] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`describe_registries`][ecrpublic_describe_registries]
#' request with the returned `nextToken` value. This value can be between 1
#' and 1000. If this parameter is not used, then
#' [`describe_registries`][ecrpublic_describe_registries] returns up to 100
#' results and a `nextToken` value, if applicable.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_describe_registries
ecrpublic_describe_registries <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeRegistries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$describe_registries_input(nextToken = nextToken, maxResults = maxResults)
  output <- .ecrpublic$describe_registries_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$describe_registries <- ecrpublic_describe_registries

#' Describes repositories in a public registry
#'
#' @description
#' Describes repositories in a public registry.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/describe_repositories.html](https://paws-r.github.io/docs/ecrpublic/describe_repositories.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repositories to be described. If you do not specify a registry, the
#' default public registry is assumed.
#' @param repositoryNames A list of repositories to describe. If this parameter is omitted, then
#' all repositories in a registry are described.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_repositories`][ecrpublic_describe_repositories] request where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is `null` when there are
#' no more results to return. This option cannot be used when you specify
#' repositories with `repositoryNames`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of repository results returned by
#' [`describe_repositories`][ecrpublic_describe_repositories] in paginated
#' output. When this parameter is used,
#' [`describe_repositories`][ecrpublic_describe_repositories] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another
#' [`describe_repositories`][ecrpublic_describe_repositories] request with
#' the returned `nextToken` value. This value can be between 1 and 1000. If
#' this parameter is not used, then
#' [`describe_repositories`][ecrpublic_describe_repositories] returns up to
#' 100 results and a `nextToken` value, if applicable. This option cannot
#' be used when you specify repositories with `repositoryNames`.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_describe_repositories
ecrpublic_describe_repositories <- function(registryId = NULL, repositoryNames = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeRepositories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$describe_repositories_input(registryId = registryId, repositoryNames = repositoryNames, nextToken = nextToken, maxResults = maxResults)
  output <- .ecrpublic$describe_repositories_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$describe_repositories <- ecrpublic_describe_repositories

#' Retrieves an authorization token
#'
#' @description
#' Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours. This API requires the `ecr-public:GetAuthorizationToken` and `sts:GetServiceBearerToken` permissions.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/get_authorization_token.html](https://paws-r.github.io/docs/ecrpublic/get_authorization_token.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_get_authorization_token
ecrpublic_get_authorization_token <- function() {
  op <- new_operation(
    name = "GetAuthorizationToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$get_authorization_token_input()
  output <- .ecrpublic$get_authorization_token_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$get_authorization_token <- ecrpublic_get_authorization_token

#' Retrieves catalog metadata for a public registry
#'
#' @description
#' Retrieves catalog metadata for a public registry.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/get_registry_catalog_data.html](https://paws-r.github.io/docs/ecrpublic/get_registry_catalog_data.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_get_registry_catalog_data
ecrpublic_get_registry_catalog_data <- function() {
  op <- new_operation(
    name = "GetRegistryCatalogData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$get_registry_catalog_data_input()
  output <- .ecrpublic$get_registry_catalog_data_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$get_registry_catalog_data <- ecrpublic_get_registry_catalog_data

#' Retrieve catalog metadata for a repository in a public registry
#'
#' @description
#' Retrieve catalog metadata for a repository in a public registry. This metadata is displayed publicly in the Amazon ECR Public Gallery.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/get_repository_catalog_data.html](https://paws-r.github.io/docs/ecrpublic/get_repository_catalog_data.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repositories to be described. If you do not specify a registry, the
#' default public registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to retrieve the catalog metadata for.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_get_repository_catalog_data
ecrpublic_get_repository_catalog_data <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "GetRepositoryCatalogData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$get_repository_catalog_data_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecrpublic$get_repository_catalog_data_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$get_repository_catalog_data <- ecrpublic_get_repository_catalog_data

#' Retrieves the repository policy for the specified repository
#'
#' @description
#' Retrieves the repository policy for the specified repository.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/get_repository_policy.html](https://paws-r.github.io/docs/ecrpublic/get_repository_policy.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the public registry that contains the
#' repository. If you do not specify a registry, the default public
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository with the policy to retrieve.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_get_repository_policy
ecrpublic_get_repository_policy <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "GetRepositoryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$get_repository_policy_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecrpublic$get_repository_policy_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$get_repository_policy <- ecrpublic_get_repository_policy

#' Notifies Amazon ECR that you intend to upload an image layer
#'
#' @description
#' Notifies Amazon ECR that you intend to upload an image layer.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/initiate_layer_upload.html](https://paws-r.github.io/docs/ecrpublic/initiate_layer_upload.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the registry to which you intend to
#' upload layers. If you do not specify a registry, the default public
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to which you intend to upload layers.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_initiate_layer_upload
ecrpublic_initiate_layer_upload <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "InitiateLayerUpload",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$initiate_layer_upload_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecrpublic$initiate_layer_upload_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$initiate_layer_upload <- ecrpublic_initiate_layer_upload

#' List the tags for an Amazon ECR Public resource
#'
#' @description
#' List the tags for an Amazon ECR Public resource.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/list_tags_for_resource.html](https://paws-r.github.io/docs/ecrpublic/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the supported resource is an Amazon ECR Public
#' repository.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_list_tags_for_resource
ecrpublic_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .ecrpublic$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$list_tags_for_resource <- ecrpublic_list_tags_for_resource

#' Creates or updates the image manifest and tags associated with an image
#'
#' @description
#' Creates or updates the image manifest and tags associated with an image.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/put_image.html](https://paws-r.github.io/docs/ecrpublic/put_image.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the public registry that contains the
#' repository in which to put the image. If you do not specify a registry,
#' the default public registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository in which to put the image.
#' @param imageManifest &#91;required&#93; The image manifest corresponding to the image to be uploaded.
#' @param imageManifestMediaType The media type of the image manifest. If you push an image manifest that
#' does not contain the `mediaType` field, you must specify the
#' `imageManifestMediaType` in the request.
#' @param imageTag The tag to associate with the image. This parameter is required for
#' images that use the Docker Image Manifest V2 Schema 2 or Open Container
#' Initiative (OCI) formats.
#' @param imageDigest The image digest of the image manifest corresponding to the image.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_put_image
ecrpublic_put_image <- function(registryId = NULL, repositoryName, imageManifest, imageManifestMediaType = NULL, imageTag = NULL, imageDigest = NULL) {
  op <- new_operation(
    name = "PutImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$put_image_input(registryId = registryId, repositoryName = repositoryName, imageManifest = imageManifest, imageManifestMediaType = imageManifestMediaType, imageTag = imageTag, imageDigest = imageDigest)
  output <- .ecrpublic$put_image_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$put_image <- ecrpublic_put_image

#' Create or updates the catalog data for a public registry
#'
#' @description
#' Create or updates the catalog data for a public registry.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/put_registry_catalog_data.html](https://paws-r.github.io/docs/ecrpublic/put_registry_catalog_data.html) for full documentation.
#'
#' @param displayName The display name for a public registry. The display name is shown as the
#' repository author in the Amazon ECR Public Gallery.
#' 
#' The registry display name is only publicly visible in the Amazon ECR
#' Public Gallery for verified accounts.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_put_registry_catalog_data
ecrpublic_put_registry_catalog_data <- function(displayName = NULL) {
  op <- new_operation(
    name = "PutRegistryCatalogData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$put_registry_catalog_data_input(displayName = displayName)
  output <- .ecrpublic$put_registry_catalog_data_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$put_registry_catalog_data <- ecrpublic_put_registry_catalog_data

#' Creates or updates the catalog data for a repository in a public
#' registry
#'
#' @description
#' Creates or updates the catalog data for a repository in a public registry.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/put_repository_catalog_data.html](https://paws-r.github.io/docs/ecrpublic/put_repository_catalog_data.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the public registry the repository is
#' in. If you do not specify a registry, the default public registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to create or update the catalog data for.
#' @param catalogData &#91;required&#93; An object containing the catalog data for a repository. This data is
#' publicly visible in the Amazon ECR Public Gallery.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_put_repository_catalog_data
ecrpublic_put_repository_catalog_data <- function(registryId = NULL, repositoryName, catalogData) {
  op <- new_operation(
    name = "PutRepositoryCatalogData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$put_repository_catalog_data_input(registryId = registryId, repositoryName = repositoryName, catalogData = catalogData)
  output <- .ecrpublic$put_repository_catalog_data_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$put_repository_catalog_data <- ecrpublic_put_repository_catalog_data

#' Applies a repository policy to the specified public repository to
#' control access permissions
#'
#' @description
#' Applies a repository policy to the specified public repository to control access permissions. For more information, see [Amazon ECR Repository Policies](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html) in the *Amazon Elastic Container Registry User Guide*.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/set_repository_policy.html](https://paws-r.github.io/docs/ecrpublic/set_repository_policy.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository. If you do not specify a registry, the default public
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to receive the policy.
#' @param policyText &#91;required&#93; The JSON repository policy text to apply to the repository. For more
#' information, see [Amazon ECR Repository
#' Policies](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#' @param force If the policy you are attempting to set on a repository policy would
#' prevent you from setting another policy in the future, you must force
#' the [`set_repository_policy`][ecrpublic_set_repository_policy]
#' operation. This is intended to prevent accidental repository lock outs.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_set_repository_policy
ecrpublic_set_repository_policy <- function(registryId = NULL, repositoryName, policyText, force = NULL) {
  op <- new_operation(
    name = "SetRepositoryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$set_repository_policy_input(registryId = registryId, repositoryName = repositoryName, policyText = policyText, force = force)
  output <- .ecrpublic$set_repository_policy_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$set_repository_policy <- ecrpublic_set_repository_policy

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' @description
#' Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/tag_resource.html](https://paws-r.github.io/docs/ecrpublic/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which to add tags.
#' Currently, the supported resource is an Amazon ECR Public repository.
#' @param tags &#91;required&#93; The tags to add to the resource. A tag is an array of key-value pairs.
#' Tag keys can have a maximum character length of 128 characters, and tag
#' values can have a maximum length of 256 characters.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_tag_resource
ecrpublic_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .ecrpublic$tag_resource_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$tag_resource <- ecrpublic_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/untag_resource.html](https://paws-r.github.io/docs/ecrpublic/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which to delete
#' tags. Currently, the supported resource is an Amazon ECR Public
#' repository.
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_untag_resource
ecrpublic_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .ecrpublic$untag_resource_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$untag_resource <- ecrpublic_untag_resource

#' Uploads an image layer part to Amazon ECR
#'
#' @description
#' Uploads an image layer part to Amazon ECR.
#'
#' See [https://paws-r.github.io/docs/ecrpublic/upload_layer_part.html](https://paws-r.github.io/docs/ecrpublic/upload_layer_part.html) for full documentation.
#'
#' @param registryId The AWS account ID associated with the registry to which you are
#' uploading layer parts. If you do not specify a registry, the default
#' public registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to which you are uploading layer parts.
#' @param uploadId &#91;required&#93; The upload ID from a previous
#' [`initiate_layer_upload`][ecrpublic_initiate_layer_upload] operation to
#' associate with the layer part upload.
#' @param partFirstByte &#91;required&#93; The position of the first byte of the layer part witin the overall image
#' layer.
#' @param partLastByte &#91;required&#93; The position of the last byte of the layer part within the overall image
#' layer.
#' @param layerPartBlob &#91;required&#93; The base64-encoded layer part payload.
#'
#' @keywords internal
#'
#' @rdname ecrpublic_upload_layer_part
ecrpublic_upload_layer_part <- function(registryId = NULL, repositoryName, uploadId, partFirstByte, partLastByte, layerPartBlob) {
  op <- new_operation(
    name = "UploadLayerPart",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecrpublic$upload_layer_part_input(registryId = registryId, repositoryName = repositoryName, uploadId = uploadId, partFirstByte = partFirstByte, partLastByte = partLastByte, layerPartBlob = layerPartBlob)
  output <- .ecrpublic$upload_layer_part_output()
  config <- get_config()
  svc <- .ecrpublic$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecrpublic$operations$upload_layer_part <- ecrpublic_upload_layer_part
