% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_spot_datafeed_subscription}
\alias{ec2_create_spot_datafeed_subscription}
\title{Creates a data feed for Spot Instances, enabling you to view Spot
Instance usage logs}
\usage{
ec2_create_spot_datafeed_subscription(Bucket, DryRun = NULL, Prefix = NULL)
}
\arguments{
\item{Bucket}{[required] The name of the Amazon S3 bucket in which to store the Spot Instance
data feed. For more information about bucket names, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules}{Rules for bucket naming}
in the \emph{Amazon S3 Developer Guide}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Prefix}{The prefix for the data feed file names.}
}
\description{
Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data feed per Amazon Web Services account. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html}{Spot Instance data feed} in the \emph{Amazon EC2 User Guide for Linux Instances}.

See \url{https://paws-r.github.io/docs/ec2/create_spot_datafeed_subscription.html} for full documentation.
}
\keyword{internal}
