% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_coip_pools}
\alias{ec2_describe_coip_pools}
\title{Describes the specified customer-owned address pools or all of your
customer-owned address pools}
\usage{
ec2_describe_coip_pools(
  PoolIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL
)
}
\arguments{
\item{PoolIds}{The IDs of the address pools.}

\item{Filters}{One or more filters.
\itemize{
\item \code{coip-pool.local-gateway-route-table-id} - The ID of the local
gateway route table.
\item \code{coip-pool.pool-id} - The ID of the address pool.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the specified customer-owned address pools or all of your customer-owned address pools.

See \url{https://paws-r.github.io/docs/ec2/describe_coip_pools.html} for full documentation.
}
\keyword{internal}
