% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_internet_gateways}
\alias{ec2_describe_internet_gateways}
\title{Describes one or more of your internet gateways}
\usage{
ec2_describe_internet_gateways(
  Filters = NULL,
  DryRun = NULL,
  InternetGatewayIds = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{attachment.state} - The current state of the attachment between the
gateway and the VPC (\code{available}). Present only if a VPC is
attached.
\item \code{attachment.vpc-id} - The ID of an attached VPC.
\item \code{internet-gateway-id} - The ID of the Internet gateway.
\item \code{owner-id} - The ID of the Amazon Web Services account that owns the
internet gateway.
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InternetGatewayIds}{One or more internet gateway IDs.

Default: Describes all your internet gateways.}

\item{NextToken}{The token for the next page of results.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\description{
Describes one or more of your internet gateways.

See \url{https://paws-r.github.io/docs/ec2/describe_internet_gateways.html} for full documentation.
}
\keyword{internal}
