% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_snapshots}
\alias{ec2_describe_snapshots}
\title{Describes the specified EBS snapshots available to you or all of the EBS
snapshots available to you}
\usage{
ec2_describe_snapshots(
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  OwnerIds = NULL,
  RestorableByUserIds = NULL,
  SnapshotIds = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Filters}{The filters.
\itemize{
\item \code{description} - A description of the snapshot.
\item \code{encrypted} - Indicates whether the snapshot is encrypted (\code{true} |
\code{false})
\item \code{owner-alias} - The owner alias, from an Amazon-maintained list
(\code{amazon}). This is not the user-configured Amazon Web Services
account alias set using the IAM console. We recommend that you use
the related parameter instead of this filter.
\item \code{owner-id} - The Amazon Web Services account ID of the owner. We
recommend that you use the related parameter instead of this filter.
\item \code{progress} - The progress of the snapshot, as a percentage (for
example, 80\%).
\item \code{snapshot-id} - The snapshot ID.
\item \code{start-time} - The time stamp when the snapshot was initiated.
\item \code{status} - The status of the snapshot (\code{pending} | \code{completed} |
\code{error}).
\item \code{storage-tier} - The storage tier of the snapshot (\code{archive} |
\code{standard}).
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{volume-id} - The ID of the volume the snapshot is for.
\item \code{volume-size} - The size of the volume, in GiB.
}}

\item{MaxResults}{The maximum number of snapshot results returned by
\code{\link[=ec2_describe_snapshots]{describe_snapshots}} in paginated output. When
this parameter is used, \code{\link[=ec2_describe_snapshots]{describe_snapshots}}
only returns \code{MaxResults} results in a single page along with a
\code{NextToken} response element. The remaining results of the initial
request can be seen by sending another
\code{\link[=ec2_describe_snapshots]{describe_snapshots}} request with the returned
\code{NextToken} value. This value can be between 5 and 1,000; if
\code{MaxResults} is given a value larger than 1,000, only 1,000 results are
returned. If this parameter is not used, then
\code{\link[=ec2_describe_snapshots]{describe_snapshots}} returns all results. You
cannot specify this parameter and the snapshot IDs parameter in the same
request.}

\item{NextToken}{The \code{NextToken} value returned from a previous paginated
\code{\link[=ec2_describe_snapshots]{describe_snapshots}} request where
\code{MaxResults} was used and the results exceeded the value of that
parameter. Pagination continues from the end of the previous results
that returned the \code{NextToken} value. This value is \code{null} when there are
no more results to return.}

\item{OwnerIds}{Scopes the results to snapshots with the specified owners. You can
specify a combination of Amazon Web Services account IDs, \code{self}, and
\code{amazon}.}

\item{RestorableByUserIds}{The IDs of the Amazon Web Services accounts that can create volumes from
the snapshot.}

\item{SnapshotIds}{The snapshot IDs.

Default: Describes the snapshots for which you have create volume
permissions.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the specified EBS snapshots available to you or all of the EBS snapshots available to you.

See \url{https://paws-r.github.io/docs/ec2/describe_snapshots.html} for full documentation.
}
\keyword{internal}
