% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_subnet_cidr_reservations}
\alias{ec2_get_subnet_cidr_reservations}
\title{Gets information about the subnet CIDR reservations}
\usage{
ec2_get_subnet_cidr_reservations(
  Filters = NULL,
  SubnetId,
  DryRun = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{reservationType} - The type of reservation (\code{prefix} | \code{explicit}).
\item \code{subnet-id} - The ID of the subnet.
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}}

\item{SubnetId}{[required] The ID of the subnet.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token for the next page of results.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\description{
Gets information about the subnet CIDR reservations.

See \url{https://paws-r.github.io/docs/ec2/get_subnet_cidr_reservations.html} for full documentation.
}
\keyword{internal}
