% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_metadata_options}
\alias{ec2_modify_instance_metadata_options}
\title{Modify the instance metadata parameters on a running or stopped instance}
\usage{
ec2_modify_instance_metadata_options(
  InstanceId,
  HttpTokens = NULL,
  HttpPutResponseHopLimit = NULL,
  HttpEndpoint = NULL,
  DryRun = NULL,
  HttpProtocolIpv6 = NULL,
  InstanceMetadataTags = NULL
)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance.}

\item{HttpTokens}{The state of token usage for your instance metadata requests. If the
parameter is not specified in the request, the default state is
\code{optional}.

If the state is \code{optional}, you can choose to retrieve instance metadata
with or without a signed token header on your request. If you retrieve
the IAM role credentials without a token, the version 1.0 role
credentials are returned. If you retrieve the IAM role credentials using
a valid signed token, the version 2.0 role credentials are returned.

If the state is \code{required}, you must send a signed token header with any
instance metadata retrieval requests. In this state, retrieving the IAM
role credential always returns the version 2.0 credentials; the version
1.0 credentials are not available.}

\item{HttpPutResponseHopLimit}{The desired HTTP PUT response hop limit for instance metadata requests.
The larger the number, the further instance metadata requests can
travel. If no parameter is specified, the existing state is maintained.

Possible values: Integers from 1 to 64}

\item{HttpEndpoint}{Enables or disables the HTTP metadata endpoint on your instances. If
this parameter is not specified, the existing state is maintained.

If you specify a value of \code{disabled}, you cannot access your instance
metadata.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{HttpProtocolIpv6}{Enables or disables the IPv6 endpoint for the instance metadata service.
This setting applies only if you have enabled the HTTP metadata
endpoint.}

\item{InstanceMetadataTags}{Set to \code{enabled} to allow access to instance tags from the instance
metadata. Set to \code{disabled} to turn off access to instance tags from the
instance metadata. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS}{Work with instance tags using the instance metadata}.

Default: \code{disabled}}
}
\description{
Modify the instance metadata parameters on a running or stopped instance. When you modify the parameters on a stopped instance, they are applied when the instance is started. When you modify the parameters on a running instance, the API responds with a state of “pending”. After the parameter modifications are successfully applied to the instance, the state of the modifications changes from “pending” to “applied” in subsequent describe-instances API calls. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html}{Instance metadata and user data} in the \emph{Amazon EC2 User Guide}.

See \url{https://paws-r.github.io/docs/ec2/modify_instance_metadata_options.html} for full documentation.
}
\keyword{internal}
