% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_placement}
\alias{ec2_modify_instance_placement}
\title{Modifies the placement attributes for a specified instance}
\usage{
ec2_modify_instance_placement(
  Affinity = NULL,
  GroupName = NULL,
  HostId = NULL,
  InstanceId,
  Tenancy = NULL,
  PartitionNumber = NULL,
  HostResourceGroupArn = NULL
)
}
\arguments{
\item{Affinity}{The affinity setting for the instance.}

\item{GroupName}{The name of the placement group in which to place the instance. For
spread placement groups, the instance must have a tenancy of \code{default}.
For cluster and partition placement groups, the instance must have a
tenancy of \code{default} or \code{dedicated}.

To remove an instance from a placement group, specify an empty string
("").}

\item{HostId}{The ID of the Dedicated Host with which to associate the instance.}

\item{InstanceId}{[required] The ID of the instance that you are modifying.}

\item{Tenancy}{The tenancy for the instance.

For T3 instances, you can't change the tenancy from \code{dedicated} to
\code{host}, or from \code{host} to \code{dedicated}. Attempting to make one of these
unsupported tenancy changes results in the \code{InvalidTenancy} error code.}

\item{PartitionNumber}{The number of the partition in which to place the instance. Valid only
if the placement group strategy is set to \code{partition}.}

\item{HostResourceGroupArn}{The ARN of the host resource group in which to place the instance.}
}
\description{
Modifies the placement attributes for a specified instance. You can do the following:

See \url{https://paws-r.github.io/docs/ec2/modify_instance_placement.html} for full documentation.
}
\keyword{internal}
