% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_vpn_connection}
\alias{ec2_modify_vpn_connection}
\title{Modifies the customer gateway or the target gateway of an Amazon Web
Services Site-to-Site VPN connection}
\usage{
ec2_modify_vpn_connection(
  VpnConnectionId,
  TransitGatewayId = NULL,
  CustomerGatewayId = NULL,
  VpnGatewayId = NULL,
  DryRun = NULL
)
}
\arguments{
\item{VpnConnectionId}{[required] The ID of the VPN connection.}

\item{TransitGatewayId}{The ID of the transit gateway.}

\item{CustomerGatewayId}{The ID of the customer gateway at your end of the VPN connection.}

\item{VpnGatewayId}{The ID of the virtual private gateway at the Amazon Web Services side of
the VPN connection.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies the customer gateway or the target gateway of an Amazon Web Services Site-to-Site VPN connection. To modify the target gateway, the following migration options are available:

See \url{https://paws-r.github.io/docs/ec2/modify_vpn_connection.html} for full documentation.
}
\keyword{internal}
